/*
 * Decompiled with CFR 0.152.
 */
package org.bounce;

import java.io.File;
import javax.swing.filechooser.FileFilter;

public class DefaultFileFilter
extends FileFilter {
    private String description = null;
    private String extension = null;

    public DefaultFileFilter(String extension, String description) {
        this.extension = extension;
        this.description = description + " (*." + extension + ")";
    }

    public boolean accept(File file) {
        boolean result = false;
        if (file != null) {
            if (file.isFile()) {
                String ext = this.getExtension(file);
                if (ext != null && ext.equals(this.extension)) {
                    result = true;
                }
            } else if (file.isDirectory()) {
                result = true;
            }
        }
        return result;
    }

    public String getDescription() {
        return this.description;
    }

    private String getExtension(File file) {
        String filename;
        int i;
        if (file != null && (i = (filename = file.getName()).lastIndexOf(46)) > 0 && i < filename.length() - 1) {
            return filename.substring(i + 1).toLowerCase();
        }
        return null;
    }
}

