/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.xa;

import java.sql.Connection;
import java.sql.SQLException;
import javax.sql.XAConnection;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import oracle.jdbc.pool.OraclePooledConnection;
import oracle.jdbc.xa.OracleXAResource;

public abstract class OracleXAConnection
extends OraclePooledConnection
implements XAConnection {
    protected XAResource xaResource = null;
    private static final String _Copyright_2004_Oracle_All_Rights_Reserved_ = null;
    public static final boolean TRACE = false;
    public static final boolean PRIVATE_TRACE = false;
    public static final String BUILD_DATE = "Wed_Jun_22_18:54:38_PDT_2005";

    public OracleXAConnection() throws XAException {
        this((Connection)null);
    }

    public OracleXAConnection(Connection connection) throws XAException {
        super(connection);
    }

    public abstract XAResource getXAResource();

    public synchronized Connection getConnection() throws SQLException {
        Connection connection = super.getConnection();
        if (this.xaResource != null) {
            ((OracleXAResource)this.xaResource).setLogicalConnection(connection);
        }
        return connection;
    }

    boolean getAutoCommit() throws SQLException {
        return this.autoCommit;
    }

    void setAutoCommit(boolean bl) throws SQLException {
        this.autoCommit = bl;
    }
}

