/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.flamingo.internal.utils;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.font.LineMetrics;
import java.awt.geom.GeneralPath;
import java.util.Collection;
import org.pushingpixels.flamingo.api.common.AbstractCommandButton;
import org.pushingpixels.flamingo.api.common.CommandButtonLayoutManager;
import org.pushingpixels.flamingo.api.common.JCommandButton;
import org.pushingpixels.flamingo.api.common.model.CommandButtonPresentationModel;
import org.pushingpixels.flamingo.internal.utils.KeyTipManager;
import org.pushingpixels.neon.api.NeonCortex;
import org.pushingpixels.substance.api.ComponentState;
import org.pushingpixels.substance.api.SubstanceCortex;
import org.pushingpixels.substance.api.SubstanceSlices;
import org.pushingpixels.substance.api.colorscheme.SubstanceColorScheme;
import org.pushingpixels.substance.api.painter.border.SubstanceBorderPainter;
import org.pushingpixels.substance.api.painter.fill.SubstanceFillPainter;
import org.pushingpixels.substance.internal.utils.SubstanceColorSchemeUtilities;
import org.pushingpixels.substance.internal.utils.SubstanceCoreUtilities;
import org.pushingpixels.substance.internal.utils.SubstanceOutlineUtilities;
import org.pushingpixels.substance.internal.utils.SubstanceSizeUtils;
import org.pushingpixels.substance.internal.utils.WidgetUtilities;

public class KeyTipRenderingUtilities {
    public static Dimension getPrefSize(FontMetrics fm, String keyTip) {
        int INSETS = 3;
        int prefWidth = fm.stringWidth(keyTip) + 2 * INSETS + 1;
        int prefHeight = fm.getHeight() + INSETS - 1;
        return new Dimension(prefWidth, prefHeight);
    }

    public static void renderKeyTip(Graphics g, Container c, Rectangle rect, String keyTip, boolean toPaintEnabled) {
        SubstanceFillPainter fillPainter = SubstanceCoreUtilities.getFillPainter((Component)c);
        SubstanceBorderPainter borderPainter = SubstanceCoreUtilities.getBorderPainter((Component)c);
        ComponentState state = toPaintEnabled ? ComponentState.ENABLED : ComponentState.DISABLED_UNSELECTED;
        float alpha = SubstanceColorSchemeUtilities.getAlpha((Component)c, (ComponentState)state);
        SubstanceColorScheme fillScheme = SubstanceColorSchemeUtilities.getColorScheme((Component)c, (ComponentState)state);
        SubstanceColorScheme borderScheme = SubstanceColorSchemeUtilities.getColorScheme((Component)c, (SubstanceSlices.ColorSchemeAssociationKind)SubstanceSlices.ColorSchemeAssociationKind.BORDER, (ComponentState)state);
        float radius = SubstanceSizeUtils.getClassicButtonCornerRadius((int)SubstanceSizeUtils.getComponentFontSize((Component)c));
        float borderDelta = SubstanceSizeUtils.getBorderStrokeWidth() / 2.0f;
        Graphics2D g2d = (Graphics2D)g.create();
        g2d.setComposite(WidgetUtilities.getAlphaComposite((Component)c, (float)alpha, (Graphics)g));
        g2d.translate(rect.x, rect.y);
        GeneralPath contour = SubstanceOutlineUtilities.getBaseOutline((float)rect.width, (float)rect.height, (float)radius, null, (float)borderDelta);
        fillPainter.paintContourBackground((Graphics)g2d, (Component)c, (float)rect.width, (float)rect.height, (Shape)contour, false, fillScheme, true);
        float borderThickness = SubstanceSizeUtils.getBorderStrokeWidth();
        GeneralPath contourInner = SubstanceOutlineUtilities.getBaseOutline((float)rect.width, (float)rect.height, (float)radius, null, (float)(borderDelta + borderThickness));
        borderPainter.paintBorder((Graphics)g2d, (Component)c, (float)rect.width, (float)rect.height, (Shape)contour, (Shape)contourInner, borderScheme);
        g2d.setColor(SubstanceColorSchemeUtilities.getColorScheme((Component)c, (ComponentState)state).getForegroundColor());
        Font font = SubstanceCortex.GlobalScope.getFontPolicy().getFontSet().getControlFont();
        font = font.deriveFont((float)font.getSize() + 1.0f);
        g2d.setFont(font);
        int strWidth = g2d.getFontMetrics().stringWidth(keyTip);
        LineMetrics lineMetrics = g2d.getFontMetrics().getLineMetrics(keyTip, g2d);
        int strHeight = (int)lineMetrics.getHeight();
        NeonCortex.installDesktopHints((Graphics2D)g2d, (Font)font);
        g2d.drawString(keyTip, (rect.width - strWidth) / 2, (rect.height + strHeight) / 2 - g2d.getFontMetrics().getDescent());
        g2d.dispose();
    }

    public static void renderButtonKeyTips(Graphics g, AbstractCommandButton button, CommandButtonLayoutManager layoutManager) {
        Collection<KeyTipManager.KeyTipLink> currLinks = KeyTipManager.defaultManager().getCurrentlyShownKeyTips();
        if (currLinks == null) {
            return;
        }
        boolean found = false;
        for (KeyTipManager.KeyTipLink link : currLinks) {
            found = link.comp == button;
            if (!found) continue;
            break;
        }
        if (!found) {
            return;
        }
        CommandButtonLayoutManager.CommandButtonLayoutInfo layoutInfo = layoutManager.getLayoutInfo(button);
        String actionKeyTip = button.getActionKeyTip();
        if (layoutInfo.actionClickArea.width > 0 && actionKeyTip != null) {
            Point actionPrefCenter = button.getUI().getActionKeyTipAnchorCenterPoint();
            Dimension pref = KeyTipRenderingUtilities.getPrefSize(g.getFontMetrics(), actionKeyTip);
            KeyTipRenderingUtilities.renderKeyTip(g, button, new Rectangle(actionPrefCenter.x - pref.width / 2, Math.min(actionPrefCenter.y - pref.height / 2, layoutInfo.actionClickArea.y + layoutInfo.actionClickArea.height - pref.height), pref.width, pref.height), actionKeyTip, button.getActionModel().isEnabled());
        }
        if (button instanceof JCommandButton) {
            JCommandButton commandButton = (JCommandButton)button;
            String popupKeyTip = commandButton.getPopupKeyTip();
            if (layoutInfo.popupClickArea.width > 0 && popupKeyTip != null) {
                Point popupPrefCenter = button.getUI().getPopupKeyTipAnchorCenterPoint();
                Dimension pref = KeyTipRenderingUtilities.getPrefSize(g.getFontMetrics(), popupKeyTip);
                if (commandButton.getPopupOrientationKind() == CommandButtonPresentationModel.PopupOrientationKind.SIDEWARD) {
                    if (commandButton.getCommandButtonKind() != JCommandButton.CommandButtonKind.POPUP_ONLY) {
                        KeyTipRenderingUtilities.renderKeyTip(g, button, new Rectangle(layoutInfo.popupClickArea.x + layoutInfo.popupClickArea.width - pref.width - 4, Math.min(popupPrefCenter.y - pref.height / 2, layoutInfo.actionClickArea.y + layoutInfo.actionClickArea.height - pref.height), pref.width, pref.height), popupKeyTip, commandButton.getPopupModel().isEnabled());
                    } else {
                        KeyTipRenderingUtilities.renderKeyTip(g, button, new Rectangle(popupPrefCenter.x - pref.width / 2, Math.min(popupPrefCenter.y - pref.height / 2, layoutInfo.popupClickArea.y + layoutInfo.popupClickArea.height - pref.height), pref.width, pref.height), popupKeyTip, commandButton.getPopupModel().isEnabled());
                    }
                } else {
                    KeyTipRenderingUtilities.renderKeyTip(g, button, new Rectangle((layoutInfo.popupClickArea.x + layoutInfo.popupClickArea.width - pref.width) / 2, layoutInfo.popupClickArea.y + layoutInfo.popupClickArea.height - pref.height, pref.width, pref.height), popupKeyTip, commandButton.getPopupModel().isEnabled());
                }
            }
        }
    }
}

