/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.flamingo.internal.ui.common.popup;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.geom.Rectangle2D;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.ButtonModel;
import javax.swing.DefaultButtonModel;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeListener;
import org.pushingpixels.flamingo.api.common.popup.JPopupPanel;
import org.pushingpixels.flamingo.api.common.popup.PopupPanelManager;
import org.pushingpixels.flamingo.internal.ui.common.popup.ColorSelectorComponentUI;
import org.pushingpixels.flamingo.internal.ui.common.popup.JColorSelectorComponent;
import org.pushingpixels.neon.api.NeonCortex;
import org.pushingpixels.trident.api.Timeline;
import org.pushingpixels.trident.api.callback.TimelineCallback;
import org.pushingpixels.trident.api.swing.SwingRepaintCallback;

public abstract class BasicColorSelectorComponentUI
extends ColorSelectorComponentUI {
    protected JColorSelectorComponent colorSelectorComponent;
    protected ButtonModel buttonModel = new DefaultButtonModel();
    private MouseListener mouseListener;
    private ChangeListener modelChangeListener;
    private ActionListener actionListener;
    private Timeline rolloverTimeline;
    protected float rollover;
    private FocusListener focusListener;

    protected BasicColorSelectorComponentUI() {
    }

    @Override
    public void installUI(JComponent c) {
        this.colorSelectorComponent = (JColorSelectorComponent)c;
        this.installDefaults();
        this.installComponents();
        this.installKeyboardActions();
        this.installListeners();
    }

    @Override
    public void uninstallUI(JComponent c) {
        this.uninstallListeners();
        this.uninstallKeyboardActions();
        this.uninstallComponents();
        this.uninstallDefaults();
        c.setLayout(null);
        this.colorSelectorComponent = null;
    }

    protected void installListeners() {
        this.mouseListener = new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                if (!BasicColorSelectorComponentUI.this.buttonModel.isRollover()) {
                    BasicColorSelectorComponentUI.this.colorSelectorComponent.onColorPreviewActivated(BasicColorSelectorComponentUI.this.colorSelectorComponent.getColor());
                    BasicColorSelectorComponentUI.this.rolloverTimeline.play();
                }
                BasicColorSelectorComponentUI.this.buttonModel.setRollover(true);
            }

            @Override
            public void mouseExited(MouseEvent e) {
                if (BasicColorSelectorComponentUI.this.buttonModel.isRollover()) {
                    BasicColorSelectorComponentUI.this.colorSelectorComponent.onColorPreviewCanceled();
                    BasicColorSelectorComponentUI.this.rolloverTimeline.playReverse();
                }
                BasicColorSelectorComponentUI.this.buttonModel.setRollover(false);
            }

            @Override
            public void mousePressed(MouseEvent e) {
                BasicColorSelectorComponentUI.this.buttonModel.setArmed(true);
                BasicColorSelectorComponentUI.this.buttonModel.setPressed(true);
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                BasicColorSelectorComponentUI.this.buttonModel.setPressed(false);
                BasicColorSelectorComponentUI.this.buttonModel.setArmed(false);
            }
        };
        this.colorSelectorComponent.addMouseListener(this.mouseListener);
        this.modelChangeListener = e -> this.colorSelectorComponent.repaint();
        this.buttonModel.addChangeListener(this.modelChangeListener);
        this.actionListener = e -> {
            this.colorSelectorComponent.onColorActivated(this.colorSelectorComponent.getColor());
            PopupPanelManager.defaultManager().hidePopups(null);
        };
        this.buttonModel.addActionListener(this.actionListener);
        this.focusListener = new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
                BasicColorSelectorComponentUI.this.colorSelectorComponent.onColorPreviewActivated(BasicColorSelectorComponentUI.this.colorSelectorComponent.getColor());
                BasicColorSelectorComponentUI.this.colorSelectorComponent.repaint();
            }

            @Override
            public void focusLost(FocusEvent e) {
                BasicColorSelectorComponentUI.this.colorSelectorComponent.onColorPreviewCanceled();
                BasicColorSelectorComponentUI.this.colorSelectorComponent.repaint();
            }
        };
        this.colorSelectorComponent.addFocusListener(this.focusListener);
    }

    protected void uninstallListeners() {
        this.buttonModel.removeActionListener(this.actionListener);
        this.actionListener = null;
        this.buttonModel.removeChangeListener(this.modelChangeListener);
        this.modelChangeListener = null;
        this.colorSelectorComponent.removeMouseListener(this.mouseListener);
        this.mouseListener = null;
        this.colorSelectorComponent.removeFocusListener(this.focusListener);
        this.focusListener = null;
    }

    protected void installDefaults() {
        this.rolloverTimeline = ((Timeline.Builder)((Timeline.Builder)((Timeline.Builder)Timeline.builder((Object)this).addPropertyToInterpolate("rollover", (Object)Float.valueOf(0.0f), (Object)Float.valueOf(1.0f))).addCallback((TimelineCallback)new SwingRepaintCallback((Component)this.colorSelectorComponent))).setDuration(150L)).build();
    }

    protected void uninstallDefaults() {
    }

    protected void installComponents() {
    }

    protected void uninstallComponents() {
    }

    private void installKeyboardActions() {
        ActionMap actionMap = new ActionMap();
        actionMap.put("press", new PressAction(this.colorSelectorComponent));
        actionMap.put("release", new ReleaseAction(this.colorSelectorComponent));
        actionMap.put("popupDismiss", new PopupDismissAction(this.colorSelectorComponent));
        actionMap.put("focusUp", new FocusUpAction(this.colorSelectorComponent));
        actionMap.put("focusDown", new FocusDownAction(this.colorSelectorComponent));
        actionMap.put("focusRight", new FocusRightAction(this.colorSelectorComponent));
        actionMap.put("focusLeft", new FocusLeftAction(this.colorSelectorComponent));
        SwingUtilities.replaceUIActionMap(this.colorSelectorComponent, actionMap);
        InputMap focusedInputMap = LookAndFeel.makeInputMap(new Object[]{"SPACE", "press", "released SPACE", "release", "ENTER", "press", "released ENTER", "release", "ESCAPE", "popupDismiss", "DOWN", "focusDown", "KP_DOWN", "focusDown", "UP", "focusUp", "KP_UP", "focusUp", "LEFT", "focusLeft", "KP_LEFT", "focusLeft", "RIGHT", "focusRight", "KP_RIGHT", "focusRight"});
        SwingUtilities.replaceUIInputMap(this.colorSelectorComponent, 0, focusedInputMap);
    }

    private void uninstallKeyboardActions() {
        SwingUtilities.replaceUIInputMap(this.colorSelectorComponent, 0, null);
        SwingUtilities.replaceUIActionMap(this.colorSelectorComponent, null);
    }

    public void setRollover(float rollover) {
        this.rollover = rollover;
    }

    @Override
    public void update(Graphics g, JComponent c) {
        int w = this.colorSelectorComponent.getWidth();
        int h = this.colorSelectorComponent.getHeight();
        Graphics2D g2d = (Graphics2D)g.create();
        Color fillColor = this.colorSelectorComponent.getColor();
        g2d.setColor(fillColor);
        g2d.fillRect(0, 0, w, h);
        float[] hsb = new float[3];
        Color.RGBtoHSB(fillColor.getRed(), fillColor.getGreen(), fillColor.getBlue(), hsb);
        float brightness = hsb[2] * 0.7f;
        g2d.setColor(new Color(brightness, brightness, brightness));
        float borderThickness = 1.0f / (float)NeonCortex.getScaleFactor();
        float ty = this.colorSelectorComponent.isTopOpen() ? borderThickness : 0.0f;
        float by = this.colorSelectorComponent.isBottomOpen() ? borderThickness : 0.0f;
        g2d.setStroke(new BasicStroke(borderThickness, 1, 1));
        g2d.draw(new Rectangle2D.Double(0.0, -ty, (float)w - borderThickness, (float)h - borderThickness + ty + by));
        if (this.rollover > 0.0f) {
            this.paintRolloverIndication(g2d);
        }
        if (this.colorSelectorComponent.hasFocus()) {
            this.paintFocus(g2d);
        }
        g2d.dispose();
    }

    protected abstract void paintRolloverIndication(Graphics var1);

    protected abstract void paintFocus(Graphics var1);

    private class FocusLeftAction
    extends FocusTraversalAction {
        private static final String FOCUS_LEFT = "focusLeft";

        FocusLeftAction(JColorSelectorComponent colorSelectorComponent) {
            super(FOCUS_LEFT, colorSelectorComponent);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JPopupPanel popupPanel = this.getPopup();
            if (popupPanel != null) {
                popupPanel.getUI().focusLeft();
            }
        }
    }

    private class FocusRightAction
    extends FocusTraversalAction {
        private static final String FOCUS_RIGHT = "focusRight";

        FocusRightAction(JColorSelectorComponent colorSelectorComponent) {
            super(FOCUS_RIGHT, colorSelectorComponent);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JPopupPanel popupPanel = this.getPopup();
            if (popupPanel != null) {
                popupPanel.getUI().focusRight();
            }
        }
    }

    private class FocusDownAction
    extends FocusTraversalAction {
        private static final String FOCUS_DOWN = "focusDown";

        FocusDownAction(JColorSelectorComponent colorSelectorComponent) {
            super(FOCUS_DOWN, colorSelectorComponent);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JPopupPanel popupPanel = this.getPopup();
            if (popupPanel != null) {
                popupPanel.getUI().focusDown();
            }
        }
    }

    private class FocusUpAction
    extends FocusTraversalAction {
        private static final String FOCUS_UP = "focusUp";

        FocusUpAction(JColorSelectorComponent colorSelectorComponent) {
            super(FOCUS_UP, colorSelectorComponent);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JPopupPanel popupPanel = this.getPopup();
            if (popupPanel != null) {
                popupPanel.getUI().focusUp();
            }
        }
    }

    private abstract class FocusTraversalAction
    extends ColorSelectorComponentAction {
        FocusTraversalAction(String actionName, JColorSelectorComponent colorSelectorComponent) {
            super(actionName, colorSelectorComponent);
        }

        protected JPopupPanel getPopup() {
            JPopupPanel popupPanel = (JPopupPanel)SwingUtilities.getAncestorOfClass(JPopupPanel.class, this.colorSelectorComponent);
            if (popupPanel != null) {
                return popupPanel;
            }
            PopupPanelManager popupPanelManager = PopupPanelManager.defaultManager();
            for (PopupPanelManager.PopupInfo popupInfo : popupPanelManager.getShownPath()) {
                if (popupInfo.getPopupOriginator() != this.colorSelectorComponent) continue;
                return popupInfo.getPopupPanel();
            }
            return null;
        }
    }

    private class PopupDismissAction
    extends ColorSelectorComponentAction {
        private static final String DISMISS = "popupDismiss";

        PopupDismissAction(JColorSelectorComponent colorSelectorComponent) {
            super(DISMISS, colorSelectorComponent);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            PopupPanelManager.defaultManager().hidePopups(null);
        }
    }

    private class ReleaseAction
    extends ColorSelectorComponentAction {
        private static final String RELEASE = "release";

        ReleaseAction(JColorSelectorComponent colorSelectorComponent) {
            super(RELEASE, colorSelectorComponent);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            BasicColorSelectorComponentUI.this.buttonModel.setPressed(false);
            BasicColorSelectorComponentUI.this.buttonModel.setArmed(false);
        }
    }

    private class PressAction
    extends ColorSelectorComponentAction {
        private static final String PRESS = "press";

        PressAction(JColorSelectorComponent colorSelectorComponent) {
            super(PRESS, colorSelectorComponent);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            BasicColorSelectorComponentUI.this.buttonModel.setArmed(true);
            BasicColorSelectorComponentUI.this.buttonModel.setPressed(true);
            if (!this.colorSelectorComponent.hasFocus()) {
                this.colorSelectorComponent.requestFocus();
            }
        }
    }

    private static abstract class ColorSelectorComponentAction
    extends AbstractAction {
        protected final JColorSelectorComponent colorSelectorComponent;

        ColorSelectorComponentAction(String actionName, JColorSelectorComponent colorSelectorComponent) {
            super(actionName);
            this.colorSelectorComponent = colorSelectorComponent;
        }
    }
}

