/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.flamingo.internal.substance.ribbon.ui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import javax.swing.JComponent;
import javax.swing.plaf.ComponentUI;
import org.pushingpixels.flamingo.api.common.AbstractCommandButton;
import org.pushingpixels.flamingo.internal.substance.common.TransitionAwareResizableIcon;
import org.pushingpixels.flamingo.internal.substance.common.ui.ActionPopupTransitionAwareUI;
import org.pushingpixels.flamingo.internal.ui.ribbon.BasicRibbonGalleryUI;
import org.pushingpixels.substance.api.ComponentState;
import org.pushingpixels.substance.api.SubstanceCortex;
import org.pushingpixels.substance.api.SubstanceSlices;
import org.pushingpixels.substance.api.colorscheme.SubstanceColorScheme;
import org.pushingpixels.substance.internal.utils.SubstanceColorSchemeUtilities;
import org.pushingpixels.substance.internal.utils.SubstanceCoreUtilities;
import org.pushingpixels.substance.internal.utils.SubstanceImageCreator;
import org.pushingpixels.substance.internal.utils.SubstanceSizeUtils;
import org.pushingpixels.substance.internal.widget.animation.effects.GhostPaintingUtils;

public class SubstanceRibbonGalleryUI
extends BasicRibbonGalleryUI {
    public static ComponentUI createUI(JComponent comp) {
        SubstanceCoreUtilities.testComponentCreationThreadingViolation((Component)comp);
        return new SubstanceRibbonGalleryUI();
    }

    private SubstanceRibbonGalleryUI() {
    }

    @Override
    protected void paintRibbonGalleryBorder(Graphics graphics) {
        Graphics2D g2d = (Graphics2D)graphics;
        SubstanceColorScheme borderColorScheme = SubstanceColorSchemeUtilities.getColorScheme((Component)this.ribbonGallery, (SubstanceSlices.ColorSchemeAssociationKind)SubstanceSlices.ColorSchemeAssociationKind.BORDER, (ComponentState)ComponentState.ENABLED);
        SubstanceImageCreator.paintBorder((Component)this.ribbonGallery, (Graphics2D)g2d, (int)this.margin.left, (float)this.margin.top, (float)(this.ribbonGallery.getWidth() - this.margin.left - this.margin.right), (float)(this.ribbonGallery.getHeight() - this.margin.top - this.margin.bottom), (float)SubstanceSizeUtils.getClassicButtonCornerRadius((int)SubstanceSizeUtils.getComponentFontSize((Component)this.ribbonGallery)), (SubstanceColorScheme)borderColorScheme);
        g2d.dispose();
    }

    @Override
    protected void configureExpandButton(AbstractCommandButton button) {
        int fontSize = SubstanceSizeUtils.getComponentFontSize((Component)button);
        int arrowIconHeight = (int)SubstanceSizeUtils.getSmallDoubleArrowIconHeight((int)fontSize);
        int arrowIconWidth = (int)SubstanceSizeUtils.getSmallArrowIconWidth((int)fontSize);
        TransitionAwareResizableIcon arrowIcon = new TransitionAwareResizableIcon(button, () -> ((ActionPopupTransitionAwareUI)((Object)button.getUI())).getActionTransitionTracker(), (scheme, width, height) -> SubstanceImageCreator.getDoubleArrowIcon((float)width, (float)height, (float)SubstanceSizeUtils.getSmallDoubleArrowGap((int)fontSize), (float)SubstanceSizeUtils.getDoubleArrowStrokeWidth((int)fontSize), (int)5, (SubstanceColorScheme)scheme), new Dimension(arrowIconWidth, arrowIconHeight));
        button.setIcon(arrowIcon);
        SubstanceCortex.ComponentScope.setButtonStraightSide((JComponent)button, (SubstanceSlices.Side)(this.ribbonGallery.getComponentOrientation().isLeftToRight() ? SubstanceSlices.Side.LEFT : SubstanceSlices.Side.RIGHT));
    }

    @Override
    protected void configureScrollDownButton(AbstractCommandButton button) {
        int fontSize = SubstanceSizeUtils.getComponentFontSize((Component)button);
        int arrowIconHeight = (int)SubstanceSizeUtils.getSmallArrowIconHeight((int)fontSize);
        int arrowIconWidth = (int)SubstanceSizeUtils.getSmallArrowIconWidth((int)fontSize);
        TransitionAwareResizableIcon arrowIcon = new TransitionAwareResizableIcon(button, () -> ((ActionPopupTransitionAwareUI)((Object)button.getUI())).getActionTransitionTracker(), (scheme, width, height) -> SubstanceImageCreator.getArrowIcon((float)width, (float)height, (float)SubstanceSizeUtils.getDoubleArrowStrokeWidth((int)fontSize), (int)5, (SubstanceColorScheme)scheme), new Dimension(arrowIconWidth, arrowIconHeight));
        button.setIcon(arrowIcon);
        SubstanceCortex.ComponentScope.setButtonStraightSide((JComponent)button, (SubstanceSlices.Side)(this.ribbonGallery.getComponentOrientation().isLeftToRight() ? SubstanceSlices.Side.LEFT : SubstanceSlices.Side.RIGHT));
    }

    @Override
    protected void configureScrollUpButton(AbstractCommandButton button) {
        int fontSize = SubstanceSizeUtils.getComponentFontSize((Component)button);
        int arrowIconHeight = (int)SubstanceSizeUtils.getSmallArrowIconHeight((int)fontSize);
        int arrowIconWidth = (int)SubstanceSizeUtils.getSmallArrowIconWidth((int)fontSize);
        TransitionAwareResizableIcon arrowIcon = new TransitionAwareResizableIcon(button, () -> ((ActionPopupTransitionAwareUI)((Object)button.getUI())).getActionTransitionTracker(), (scheme, width, height) -> SubstanceImageCreator.getArrowIcon((float)width, (float)height, (float)SubstanceSizeUtils.getDoubleArrowStrokeWidth((int)fontSize), (int)1, (SubstanceColorScheme)scheme), new Dimension(arrowIconWidth, arrowIconHeight));
        button.setIcon(arrowIcon);
        SubstanceCortex.ComponentScope.setButtonStraightSide((JComponent)button, (SubstanceSlices.Side)(this.ribbonGallery.getComponentOrientation().isLeftToRight() ? SubstanceSlices.Side.LEFT : SubstanceSlices.Side.RIGHT));
    }

    @Override
    public void update(Graphics g, JComponent c) {
        super.update(g, c);
        GhostPaintingUtils.paintGhostImages((Component)c, (Graphics)g);
    }
}

