/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.flamingo.api.ribbon.synapse.model;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.Date;
import javax.swing.SpinnerDateModel;
import org.pushingpixels.flamingo.api.common.RichTooltip;
import org.pushingpixels.flamingo.api.ribbon.synapse.model.RibbonSpinnerContentModel;
import org.pushingpixels.neon.api.icon.ResizableIcon;

public class RibbonSpinnerDateContentModel
extends SpinnerDateModel
implements RibbonSpinnerContentModel {
    private boolean isEnabled;
    private ResizableIcon.Factory iconFactory;
    private String caption;
    private RibbonSpinnerContentModel.SpinnerSelectionChangeListener selectionChangeListener;
    private RichTooltip richTooltip;
    private final PropertyChangeSupport pcs = new PropertyChangeSupport(this);

    public static Builder builder() {
        return new Builder();
    }

    public RibbonSpinnerDateContentModel() {
    }

    public RibbonSpinnerDateContentModel(Date value, Comparable<Date> start, Comparable<Date> end, int calendarField) {
        super(value, start, end, calendarField);
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener pcl) {
        this.pcs.addPropertyChangeListener(pcl);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener pcl) {
        this.pcs.removePropertyChangeListener(pcl);
    }

    @Override
    public boolean isEnabled() {
        return this.isEnabled;
    }

    @Override
    public void setEnabled(boolean enabled) {
        if (this.isEnabled != enabled) {
            this.isEnabled = enabled;
            this.pcs.firePropertyChange("enabled", !this.isEnabled, this.isEnabled);
        }
    }

    @Override
    public ResizableIcon.Factory getIconFactory() {
        return this.iconFactory;
    }

    @Override
    public String getCaption() {
        return this.caption;
    }

    @Override
    public RibbonSpinnerContentModel.SpinnerSelectionChangeListener getSelectionChangeListener() {
        return this.selectionChangeListener;
    }

    @Override
    public RichTooltip getRichTooltip() {
        return this.richTooltip;
    }

    public static class Builder {
        private boolean isEnabled = true;
        private Date value;
        private Comparable<Date> start;
        private Comparable<Date> end;
        private int calendarField;
        private ResizableIcon.Factory iconFactory;
        private String caption;
        private RibbonSpinnerContentModel.SpinnerSelectionChangeListener selectionChangeListener;
        private RichTooltip richTooltip;

        public Builder setValues(Date value, Comparable<Date> start, Comparable<Date> end, int calendarField) {
            this.value = value;
            this.start = start;
            this.end = end;
            this.calendarField = calendarField;
            return this;
        }

        public Builder setEnabled(boolean enabled) {
            this.isEnabled = enabled;
            return this;
        }

        public Builder setIconFactory(ResizableIcon.Factory iconFactory) {
            this.iconFactory = iconFactory;
            return this;
        }

        public Builder setCaption(String caption) {
            this.caption = caption;
            return this;
        }

        public Builder setSelectionChangeListener(RibbonSpinnerContentModel.SpinnerSelectionChangeListener selectionChangeListener) {
            this.selectionChangeListener = selectionChangeListener;
            return this;
        }

        public Builder setRichTooltip(RichTooltip richTooltip) {
            this.richTooltip = richTooltip;
            return this;
        }

        public RibbonSpinnerDateContentModel build() {
            RibbonSpinnerDateContentModel model = this.value == null ? new RibbonSpinnerDateContentModel() : new RibbonSpinnerDateContentModel(this.value, this.start, this.end, this.calendarField);
            model.isEnabled = this.isEnabled;
            model.iconFactory = this.iconFactory;
            model.caption = this.caption;
            if (this.selectionChangeListener != null) {
                model.selectionChangeListener = new RibbonSpinnerContentModel.SpinnerSelectionChangeListener(){
                    private Object lastSelection = null;

                    @Override
                    public void onSelectionChanged(Object oldSelection, Object newSelection) {
                        if (this.lastSelection == newSelection) {
                            return;
                        }
                        selectionChangeListener.onSelectionChanged(oldSelection, newSelection);
                        this.lastSelection = newSelection;
                    }
                };
            }
            model.richTooltip = this.richTooltip;
            return model;
        }
    }
}

