/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.flamingo.api.common.popup.model;

import java.awt.Color;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EventListener;
import java.util.List;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.EventListenerList;
import org.pushingpixels.flamingo.api.common.model.ContentModel;
import org.pushingpixels.flamingo.api.common.popup.model.ColorSelectorPopupMenuGroupModel;

public class ColorSelectorPopupMenuContentModel
implements ContentModel {
    private List<ColorSelectorPopupMenuGroupModel> menuGroups;
    private ColorPreviewListener colorPreviewListener;
    private ColorActivationListener colorActivationListener;
    private EventListenerList listenerList = new EventListenerList();
    private ChangeListener menuGroupChangeListener;

    public ColorSelectorPopupMenuContentModel(List<ColorSelectorPopupMenuGroupModel> menuGroups) {
        this.menuGroups = new ArrayList<ColorSelectorPopupMenuGroupModel>(menuGroups);
        this.menuGroupChangeListener = event -> this.fireStateChanged();
        for (ColorSelectorPopupMenuGroupModel menuGroup : this.menuGroups) {
            menuGroup.addChangeListener(this.menuGroupChangeListener);
        }
    }

    public List<ColorSelectorPopupMenuGroupModel> getMenuGroups() {
        return Collections.unmodifiableList(this.menuGroups);
    }

    public ColorPreviewListener getColorPreviewListener() {
        return this.colorPreviewListener;
    }

    public void setColorPreviewListener(ColorPreviewListener colorPreviewListener) {
        this.colorPreviewListener = colorPreviewListener;
    }

    public ColorActivationListener getColorActivationListener() {
        return this.colorActivationListener;
    }

    public void setColorActivationListener(ColorActivationListener colorActivationListener) {
        this.colorActivationListener = colorActivationListener;
    }

    public void addMenuGroup(ColorSelectorPopupMenuGroupModel menuGroupModel) {
        this.menuGroups.add(menuGroupModel);
        menuGroupModel.addChangeListener(this.menuGroupChangeListener);
        this.fireStateChanged();
    }

    public void removeMenuGroup(ColorSelectorPopupMenuGroupModel menuGroupModel) {
        this.menuGroups.remove(menuGroupModel);
        menuGroupModel.removeChangeListener(this.menuGroupChangeListener);
        this.fireStateChanged();
    }

    public void removeAllMenuGroups() {
        for (ColorSelectorPopupMenuGroupModel menuGroup : this.menuGroups) {
            menuGroup.removeChangeListener(this.menuGroupChangeListener);
        }
        this.menuGroups.clear();
        this.fireStateChanged();
    }

    public void addChangeListener(ChangeListener l) {
        this.listenerList.add(ChangeListener.class, l);
    }

    public void removeChangeListener(ChangeListener l) {
        this.listenerList.remove(ChangeListener.class, l);
    }

    private void fireStateChanged() {
        Object[] listeners = this.listenerList.getListenerList();
        ChangeEvent event = new ChangeEvent(this);
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != ChangeListener.class) continue;
            ((ChangeListener)listeners[i + 1]).stateChanged(event);
        }
    }

    public static interface ColorActivationListener
    extends EventListener {
        public void onColorActivated(Color var1);
    }

    public static interface ColorPreviewListener
    extends EventListener {
        public void onColorPreviewActivated(Color var1);

        public void onColorPreviewCanceled();
    }
}

