/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.flamingo.api.common.popup;

import java.util.List;
import org.pushingpixels.flamingo.api.common.AbstractCommandButton;
import org.pushingpixels.flamingo.api.common.JCommandButton;
import org.pushingpixels.flamingo.api.common.JCommandButtonPanel;
import org.pushingpixels.flamingo.api.common.model.Command;
import org.pushingpixels.flamingo.api.common.model.CommandButtonPresentationModel;
import org.pushingpixels.flamingo.api.common.model.CommandGroup;
import org.pushingpixels.flamingo.api.common.model.CommandMenuContentModel;
import org.pushingpixels.flamingo.api.common.model.CommandPanelContentModel;
import org.pushingpixels.flamingo.api.common.model.CommandPanelPresentationModel;
import org.pushingpixels.flamingo.api.common.popup.AbstractPopupMenu;
import org.pushingpixels.flamingo.api.common.popup.model.CommandPopupMenuPresentationModel;
import org.pushingpixels.flamingo.api.common.projection.CommandButtonProjection;
import org.pushingpixels.flamingo.api.common.projection.CommandPanelProjection;
import org.pushingpixels.flamingo.api.common.projection.Projection;
import org.pushingpixels.flamingo.internal.substance.common.ui.SubstanceCommandPopupMenuUI;
import org.pushingpixels.flamingo.internal.ui.common.popup.ScrollableHost;

public class JCommandPopupMenu
extends AbstractPopupMenu
implements ScrollableHost {
    public static final String uiClassID = "CommandPopupMenuUI";
    private Projection<JCommandPopupMenu, CommandMenuContentModel, CommandPopupMenuPresentationModel> projection;
    private CommandMenuContentModel popupMenuContentModel;
    private CommandPopupMenuPresentationModel popupMenuPresentationModel;
    private CommandPanelContentModel popupMenuPanelContentModel;
    private JCommandButtonPanel mainButtonPanel;

    public JCommandPopupMenu(Projection<JCommandPopupMenu, CommandMenuContentModel, CommandPopupMenuPresentationModel> projection) {
        this.projection = projection;
        this.popupMenuContentModel = (CommandMenuContentModel)projection.getContentModel();
        this.popupMenuPresentationModel = (CommandPopupMenuPresentationModel)projection.getPresentationModel();
        this.popupMenuPanelContentModel = this.popupMenuContentModel != null ? this.popupMenuContentModel.getPanelContentModel() : null;
        CommandPanelPresentationModel popupMenuPanelPresentationModel = this.popupMenuPresentationModel != null ? this.popupMenuPresentationModel.getPanelPresentationModel() : null;
        this.populateContent();
        this.popupMenuContentModel.addChangeListener(event -> this.populateContent());
        this.updateUI();
    }

    private void populateContent() {
        if (this.popupMenuPanelContentModel != null) {
            this.mainButtonPanel = (JCommandButtonPanel)new CommandPanelProjection(this.popupMenuPanelContentModel, this.popupMenuPresentationModel.getPanelPresentationModel()).buildComponent();
        }
        CommandButtonPresentationModel presentation = CommandButtonPresentationModel.builder().setPresentationState(this.popupMenuPresentationModel.getMenuPresentationState()).setMenu(true).build();
        List<CommandGroup> commandGroups = this.popupMenuContentModel.getCommandGroups();
        for (int i = 0; i < commandGroups.size(); ++i) {
            for (Command command : commandGroups.get(i).getCommands()) {
                CommandButtonPresentationModel.Overlay overlay = this.projection.getCommandOverlays().get(command);
                CommandButtonProjection<Command> commandProjection = overlay != null ? command.project(presentation.overlayWith(overlay)) : command.project(presentation);
                AbstractCommandButton commandButton = (AbstractCommandButton)commandProjection.buildComponent();
                Command highlightedCommand = this.popupMenuContentModel.getHighlightedCommand();
                if (command == highlightedCommand) {
                    commandButton.setFont(commandButton.getFont().deriveFont(1));
                }
                if (!(commandButton instanceof JCommandButton)) continue;
                JCommandButton menuButton = (JCommandButton)commandButton;
                menuButton.setPopupOrientationKind(this.popupMenuPresentationModel.getPopupOrientationKind());
                this.addMenuButton(menuButton);
            }
            if (i >= commandGroups.size() - 1) continue;
            this.addMenuSeparator();
        }
    }

    public Projection<JCommandPopupMenu, CommandMenuContentModel, CommandPopupMenuPresentationModel> getProjection() {
        return this.projection;
    }

    public boolean hasCommandButtonPanel() {
        return this.mainButtonPanel != null;
    }

    public JCommandButtonPanel getMainButtonPanel() {
        return this.mainButtonPanel;
    }

    @Override
    public String getUIClassID() {
        return uiClassID;
    }

    @Override
    public void updateUI() {
        this.setUI(SubstanceCommandPopupMenuUI.createUI(this));
    }
}

