/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.flamingo.api.common.model;

import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.EventListenerList;
import org.pushingpixels.flamingo.api.common.CommandButtonPresentationState;
import org.pushingpixels.flamingo.api.common.model.CommandButtonPresentationModel;
import org.pushingpixels.flamingo.api.common.model.MutablePresentationModel;

public class CommandPanelPresentationModel
implements MutablePresentationModel {
    private EventListenerList listenerList = new EventListenerList();
    private int maxColumns = -1;
    private int maxRows = -1;
    private boolean toShowGroupLabels = true;
    private LayoutKind layoutKind = LayoutKind.ROW_FILL;
    private CommandButtonPresentationState commandPresentationState;
    private Integer commandIconDimension;
    private int commandHorizontalAlignment;
    private boolean isMenu;
    private CommandButtonPresentationModel.PopupOrientationKind popupOrientationKind;

    private CommandPanelPresentationModel() {
    }

    public static Builder builder() {
        return new Builder();
    }

    public CommandButtonPresentationState getCommandPresentationState() {
        return this.commandPresentationState;
    }

    public void setCommandPresentationState(CommandButtonPresentationState commandPresentationState) {
        if (this.commandPresentationState != commandPresentationState) {
            this.commandPresentationState = commandPresentationState;
            if (this.commandPresentationState != CommandButtonPresentationState.FIT_TO_ICON) {
                this.commandIconDimension = -1;
            }
            this.fireStateChanged();
        }
    }

    public Integer getCommandIconDimension() {
        return this.commandIconDimension;
    }

    public void setCommandIconDimension(Integer commandIconDimension) {
        if (this.commandIconDimension != commandIconDimension) {
            this.commandIconDimension = commandIconDimension;
            if (this.commandIconDimension != -1) {
                this.commandPresentationState = CommandButtonPresentationState.FIT_TO_ICON;
            }
            this.fireStateChanged();
        }
    }

    public int getMaxColumns() {
        return this.maxColumns;
    }

    public void setMaxColumns(int maxColumns) {
        if (this.maxColumns != maxColumns) {
            this.maxColumns = maxColumns;
            this.fireStateChanged();
        }
    }

    public int getMaxRows() {
        return this.maxRows;
    }

    public void setMaxRows(int maxRows) {
        if (this.maxRows != maxRows) {
            this.maxRows = maxRows;
            this.fireStateChanged();
        }
    }

    public LayoutKind getLayoutKind() {
        return this.layoutKind;
    }

    public void setLayoutKind(LayoutKind layoutKind) {
        if (layoutKind == null) {
            throw new IllegalArgumentException("Layout kind cannot be null");
        }
        if (layoutKind == LayoutKind.COLUMN_FILL && this.isToShowGroupLabels()) {
            throw new IllegalArgumentException("Column fill layout is not supported when group labels are shown");
        }
        if (this.layoutKind != layoutKind) {
            this.layoutKind = layoutKind;
            this.fireStateChanged();
        }
    }

    public boolean isToShowGroupLabels() {
        return this.toShowGroupLabels;
    }

    public void setToShowGroupLabels(boolean toShowGroupLabels) {
        if (this.getLayoutKind() == LayoutKind.COLUMN_FILL && toShowGroupLabels) {
            throw new IllegalArgumentException("Column fill layout is not supported when group labels are shown");
        }
        if (this.toShowGroupLabels != toShowGroupLabels) {
            this.toShowGroupLabels = toShowGroupLabels;
            this.fireStateChanged();
        }
    }

    public int getCommandHorizontalAlignment() {
        return this.commandHorizontalAlignment;
    }

    public boolean isMenu() {
        return this.isMenu;
    }

    public CommandButtonPresentationModel.PopupOrientationKind getPopupOrientationKind() {
        return this.popupOrientationKind;
    }

    public void addChangeListener(ChangeListener l) {
        this.listenerList.add(ChangeListener.class, l);
    }

    public void removeChangeListener(ChangeListener l) {
        this.listenerList.remove(ChangeListener.class, l);
    }

    private void fireStateChanged() {
        Object[] listeners = this.listenerList.getListenerList();
        ChangeEvent event = new ChangeEvent(this);
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != ChangeListener.class) continue;
            ((ChangeListener)listeners[i + 1]).stateChanged(event);
        }
    }

    public static class Builder {
        private int maxColumns = -1;
        private int maxRows = -1;
        private boolean toShowGroupLabels = true;
        private LayoutKind layoutKind = LayoutKind.ROW_FILL;
        private CommandButtonPresentationState commandPresentationState;
        private Integer commandIconDimension = -1;
        private int commandHorizontalAlignment = 0;
        private boolean isMenu = false;
        private CommandButtonPresentationModel.PopupOrientationKind popupOrientationKind = CommandButtonPresentationModel.PopupOrientationKind.DOWNWARD;

        public Builder setMaxColumns(int maxColumns) {
            this.maxColumns = maxColumns;
            return this;
        }

        public Builder setMaxRows(int maxRows) {
            this.maxRows = maxRows;
            return this;
        }

        public Builder setToShowGroupLabels(boolean toShowGroupLabels) {
            this.toShowGroupLabels = toShowGroupLabels;
            return this;
        }

        public Builder setLayoutKind(LayoutKind layoutKind) {
            this.layoutKind = layoutKind;
            return this;
        }

        public Builder setCommandPresentationState(CommandButtonPresentationState commandPresentationState) {
            this.commandPresentationState = commandPresentationState;
            return this;
        }

        public Builder setCommandIconDimension(Integer commandIconDimension) {
            this.commandIconDimension = commandIconDimension;
            return this;
        }

        public Builder setCommandHorizontalAlignment(int commandHorizontalAlignment) {
            this.commandHorizontalAlignment = commandHorizontalAlignment;
            return this;
        }

        public Builder setPopupOrientationKind(CommandButtonPresentationModel.PopupOrientationKind popupOrientationKind) {
            this.popupOrientationKind = popupOrientationKind;
            return this;
        }

        public Builder setMenu(boolean isMenu) {
            this.isMenu = isMenu;
            return this;
        }

        public CommandPanelPresentationModel build() {
            CommandPanelPresentationModel presentationModel = new CommandPanelPresentationModel();
            presentationModel.maxColumns = this.maxColumns;
            presentationModel.maxRows = this.maxRows;
            presentationModel.layoutKind = this.layoutKind;
            presentationModel.toShowGroupLabels = this.toShowGroupLabels;
            presentationModel.commandIconDimension = this.commandIconDimension;
            presentationModel.commandPresentationState = this.commandPresentationState;
            presentationModel.commandHorizontalAlignment = this.commandHorizontalAlignment;
            presentationModel.isMenu = this.isMenu;
            presentationModel.popupOrientationKind = this.popupOrientationKind;
            return presentationModel;
        }
    }

    public static enum LayoutKind {
        ROW_FILL,
        COLUMN_FILL;

    }
}

