/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.flamingo.api.common.model;

import java.awt.AWTEvent;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.InputEvent;
import java.awt.event.ItemEvent;
import javax.swing.DefaultButtonModel;
import javax.swing.Timer;
import org.pushingpixels.flamingo.api.common.CommandActionEvent;
import org.pushingpixels.flamingo.api.common.JCommandButton;
import org.pushingpixels.flamingo.api.common.model.ActionButtonModel;
import org.pushingpixels.flamingo.api.common.model.Command;
import org.pushingpixels.flamingo.api.common.model.CommandToggleGroupModel;

public class ActionRepeatableButtonModel
extends DefaultButtonModel
implements ActionButtonModel {
    private JCommandButton commandButton;
    private Timer autoRepeatTimer;
    private boolean toFireActionOnPress;

    public ActionRepeatableButtonModel(JCommandButton commandButton) {
        this.commandButton = commandButton;
        this.toFireActionOnPress = false;
        this.setEnabled(commandButton.isEnabled());
    }

    @Override
    public boolean isSelected() {
        return (this.stateMask & 2) != 0;
    }

    @Override
    public void setSelected(boolean b) {
        Command command = (Command)this.commandButton.getProjection().getContentModel();
        CommandToggleGroupModel groupModel = command.getToggleGroupModel();
        if (groupModel != null) {
            groupModel.setSelected(command, b);
            b = groupModel.getSelected() == command;
        } else if (command.isToggle()) {
            command.setToggleSelected(b);
        }
        if (this.isSelected() == b) {
            return;
        }
        this.stateMask = b ? (this.stateMask |= 2) : (this.stateMask &= 0xFFFFFFFD);
        this.fireStateChanged();
        this.fireItemStateChanged(new ItemEvent(this, 701, this, this.isSelected() ? 1 : 2));
    }

    @Override
    public void setPressed(boolean b) {
        if (this.isPressed() == b || !this.isEnabled()) {
            return;
        }
        this.stateMask = b ? (this.stateMask |= 4) : (this.stateMask &= 0xFFFFFFFB);
        Command command = (Command)this.commandButton.getProjection().getContentModel();
        if (command.isToggle() && this.isArmed()) {
            if (!this.isFireActionOnPress()) {
                if (!b) {
                    this.setSelected(!this.isSelected());
                }
            } else if (b) {
                this.setSelected(!this.isSelected());
            }
        }
        boolean toFireFirstAction = this.isArmed();
        if (this.commandButton.isAutoRepeatAction() || this.isFireActionOnPress()) {
            toFireFirstAction = this.isPressed() && toFireFirstAction;
        } else {
            boolean bl = toFireFirstAction = !this.isPressed() && toFireFirstAction;
        }
        if (this.commandButton.getCommandButtonKind() == JCommandButton.CommandButtonKind.POPUP_ONLY) {
            toFireFirstAction = false;
        }
        if (this.commandButton.isFireActionOnRollover()) {
            toFireFirstAction = false;
        }
        int modifiers = 0;
        AWTEvent currentEvent = EventQueue.getCurrentEvent();
        if (currentEvent instanceof InputEvent) {
            modifiers = ((InputEvent)currentEvent).getModifiersEx();
        } else if (currentEvent instanceof ActionEvent) {
            modifiers = ((ActionEvent)currentEvent).getModifiers();
        }
        if (toFireFirstAction) {
            this.commandButton.getUI().setInnerFocusOnAction(true);
            this.fireActionPerformed(new CommandActionEvent(this.commandButton, 1001, (Command)this.commandButton.getProjection().getContentModel(), this.getActionCommand(), EventQueue.getMostRecentEventTime(), modifiers));
            if (this.commandButton.isAutoRepeatAction()) {
                this.startActionTimer(modifiers);
            }
        }
        if (!this.commandButton.isFireActionOnRollover() && this.commandButton.isAutoRepeatAction() && !b) {
            this.stopActionTimer();
        }
        this.fireStateChanged();
    }

    @Override
    public void setRollover(boolean b) {
        if (this.isRollover() == b || !this.isEnabled()) {
            return;
        }
        this.stateMask = b ? (this.stateMask |= 0x10) : (this.stateMask &= 0xFFFFFFEF);
        if (this.commandButton.isFireActionOnRollover()) {
            if (b && !this.isActionTimerRunning() && this.commandButton.getCommandButtonKind() != JCommandButton.CommandButtonKind.POPUP_ONLY) {
                int modifiers = 0;
                AWTEvent currentEvent = EventQueue.getCurrentEvent();
                if (currentEvent instanceof InputEvent) {
                    modifiers = ((InputEvent)currentEvent).getModifiersEx();
                } else if (currentEvent instanceof ActionEvent) {
                    modifiers = ((ActionEvent)currentEvent).getModifiers();
                }
                this.commandButton.getUI().setInnerFocusOnAction(true);
                this.fireActionPerformed(new CommandActionEvent(this.commandButton, 1001, (Command)this.commandButton.getProjection().getContentModel(), this.getActionCommand(), EventQueue.getMostRecentEventTime(), modifiers));
                if (this.commandButton.isAutoRepeatAction()) {
                    this.startActionTimer(modifiers);
                }
            }
            if (!b) {
                this.stopActionTimer();
            }
        }
        this.fireStateChanged();
    }

    private void stopActionTimer() {
        if (this.autoRepeatTimer != null) {
            this.autoRepeatTimer.stop();
        }
    }

    private boolean isActionTimerRunning() {
        if (this.autoRepeatTimer == null) {
            return false;
        }
        return this.autoRepeatTimer.isRunning();
    }

    private void startActionTimer(int modifiers) {
        this.autoRepeatTimer = new Timer(this.commandButton.getAutoRepeatSubsequentInterval(), e -> {
            if (!(this.isEnabled() && this.commandButton.isVisible() && this.commandButton.isDisplayable())) {
                this.autoRepeatTimer.stop();
                return;
            }
            this.fireActionPerformed(new CommandActionEvent(this.commandButton, 1001, (Command)this.commandButton.getProjection().getContentModel(), this.getActionCommand(), EventQueue.getMostRecentEventTime(), modifiers));
        });
        this.autoRepeatTimer.setInitialDelay(this.commandButton.getAutoRepeatInitialInterval());
        this.autoRepeatTimer.start();
    }

    @Override
    public boolean isFireActionOnPress() {
        return this.toFireActionOnPress;
    }

    @Override
    public void setFireActionOnPress(boolean toFireActionOnPress) {
        this.toFireActionOnPress = toFireActionOnPress;
    }
}

