/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.flamingo.api.bcb;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.JComponent;
import org.pushingpixels.flamingo.api.bcb.BreadcrumbBarCallBack;
import org.pushingpixels.flamingo.api.bcb.BreadcrumbBarExceptionHandler;
import org.pushingpixels.flamingo.api.bcb.BreadcrumbBarModel;
import org.pushingpixels.flamingo.api.bcb.BreadcrumbItem;
import org.pushingpixels.flamingo.internal.substance.bcb.ui.SubstanceBreadcrumbBarUI;
import org.pushingpixels.flamingo.internal.ui.bcb.BreadcrumbBarUI;

public class JBreadcrumbBar<T>
extends JComponent {
    protected BreadcrumbBarModel<T> model = new BreadcrumbBarModel();
    protected BreadcrumbBarCallBack<T> callback;
    private List<BreadcrumbBarExceptionHandler> exceptionHandlers;
    public static final String uiClassID = "BreadcrumbBarUI";

    public JBreadcrumbBar(BreadcrumbBarCallBack<T> callback) {
        this.callback = callback;
        if (this.callback != null) {
            this.callback.setup();
        }
        this.exceptionHandlers = new ArrayList<BreadcrumbBarExceptionHandler>();
        this.updateUI();
    }

    public void setPath(List<BreadcrumbItem<T>> newPath) {
        this.getModel().replace(newPath);
    }

    public BreadcrumbBarCallBack<T> getCallback() {
        return this.callback;
    }

    public void setUI(BreadcrumbBarUI ui) {
        super.setUI(ui);
    }

    @Override
    public void updateUI() {
        this.setUI(SubstanceBreadcrumbBarUI.createUI(this));
    }

    @Override
    public BreadcrumbBarUI getUI() {
        return (BreadcrumbBarUI)this.ui;
    }

    @Override
    public String getUIClassID() {
        return uiClassID;
    }

    public void addExceptionHandler(BreadcrumbBarExceptionHandler handler) {
        this.exceptionHandlers.add(handler);
    }

    public void removeExceptionHandler(BreadcrumbBarExceptionHandler handler) {
        this.exceptionHandlers.remove(handler);
    }

    public List<BreadcrumbBarExceptionHandler> getExceptionHandlers() {
        return Collections.unmodifiableList(this.exceptionHandlers);
    }

    public void setThrowsExceptions(boolean throwsExceptions) {
        if (this.callback != null) {
            this.callback.setThrowsExceptions(throwsExceptions);
        }
    }

    public BreadcrumbBarModel<T> getModel() {
        return this.model;
    }
}

