/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.ssl;

import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.security.GeneralSecurityException;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLServerSocket;
import javax.net.ssl.SSLServerSocketFactory;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import org.apache.commons.ssl.HostnameVerifier;
import org.apache.commons.ssl.JavaImpl;
import org.apache.commons.ssl.KeyMaterial;
import org.apache.commons.ssl.SSLWrapperFactory;
import org.apache.commons.ssl.TrustChain;
import org.apache.commons.ssl.TrustMaterial;

public class SSL {
    private static final String[] KNOWN_PROTOCOLS = new String[]{"TLSv1", "SSLv3", "SSLv2", "SSLv2Hello"};
    private static final String[] SUPPORTED_CIPHERS;
    public static final SortedSet KNOWN_PROTOCOLS_SET;
    public static final SortedSet SUPPORTED_CIPHERS_SET;
    public static final String SSL_RSA_WITH_RC4_128_SHA = "SSL_RSA_WITH_RC4_128_SHA";
    public static final String SSL_RSA_WITH_3DES_EDE_CBC_SHA = "SSL_RSA_WITH_3DES_EDE_CBC_SHA";
    public static final String SSL_DHE_RSA_WITH_3DES_EDE_CBC_SHA = "SSL_DHE_RSA_WITH_3DES_EDE_CBC_SHA";
    public static final String SSL_DHE_DSS_WITH_3DES_EDE_CBC_SHA = "SSL_DHE_DSS_WITH_3DES_EDE_CBC_SHA";
    public static final String TLS_RSA_WITH_AES_128_CBC_SHA = "TLS_RSA_WITH_AES_128_CBC_SHA";
    public static final String TLS_DHE_RSA_WITH_AES_128_CBC_SHA = "TLS_DHE_RSA_WITH_AES_128_CBC_SHA";
    public static final String TLS_DHE_DSS_WITH_AES_128_CBC_SHA = "TLS_DHE_DSS_WITH_AES_128_CBC_SHA";
    public static final String TLS_RSA_WITH_AES_256_CBC_SHA = "TLS_RSA_WITH_AES_256_CBC_SHA";
    public static final String TLS_DHE_RSA_WITH_AES_256_CBC_SHA = "TLS_DHE_RSA_WITH_AES_256_CBC_SHA";
    public static final String TLS_DHE_DSS_WITH_AES_256_CBC_SHA = "TLS_DHE_DSS_WITH_AES_256_CBC_SHA";
    private Object sslContext = null;
    private int initCount = 0;
    private SSLSocketFactory socketFactory = null;
    private SSLServerSocketFactory serverSocketFactory = null;
    private HostnameVerifier hostnameVerifier = HostnameVerifier.DEFAULT;
    private boolean checkHostname = true;
    private final ArrayList allowedNames = new ArrayList();
    private boolean checkCRL = true;
    private boolean checkExpiry = true;
    private boolean useClientMode = false;
    private boolean useClientModeDefault = true;
    private int soTimeout = 86400000;
    private int connectTimeout = 3600000;
    private TrustChain trustChain = null;
    private KeyMaterial keyMaterial = null;
    private String[] enabledCiphers = null;
    private String[] enabledProtocols = null;
    private String defaultProtocol = "TLS";
    private X509Certificate[] currentServerChain;
    private X509Certificate[] currentClientChain;
    private boolean wantClientAuth = true;
    private boolean needClientAuth = false;
    private SSLWrapperFactory sslWrapperFactory = SSLWrapperFactory.NO_WRAP;
    protected final boolean usingSystemProperties;

    public SSL() throws GeneralSecurityException, IOException {
        boolean usingSysProps = false;
        Properties props = System.getProperties();
        boolean ksSet = props.containsKey("javax.net.ssl.keyStore");
        boolean tsSet = props.containsKey("javax.net.ssl.trustStore");
        if (ksSet) {
            String path = System.getProperty("javax.net.ssl.keyStore");
            String pwd = System.getProperty("javax.net.ssl.keyStorePassword");
            pwd = pwd != null ? pwd : "";
            File f = new File(path);
            if (f.exists()) {
                KeyMaterial km = new KeyMaterial(path, pwd.toCharArray());
                this.setKeyMaterial(km);
                usingSysProps = true;
            }
        }
        boolean trustMaterialSet = false;
        if (tsSet) {
            String path = System.getProperty("javax.net.ssl.trustStore");
            String pwd = System.getProperty("javax.net.ssl.trustStorePassword");
            boolean pwdWasNull = pwd == null;
            pwd = pwdWasNull ? "" : pwd;
            File f = new File(path);
            if (f.exists()) {
                TrustMaterial tm;
                try {
                    tm = new TrustMaterial(path, pwd.toCharArray());
                }
                catch (GeneralSecurityException gse) {
                    if (pwdWasNull) {
                        tm = new TrustMaterial(path);
                    }
                    throw gse;
                }
                this.setTrustMaterial(tm);
                usingSysProps = true;
                trustMaterialSet = true;
            }
        }
        if (!trustMaterialSet) {
            this.setTrustMaterial(TrustMaterial.DEFAULT);
        }
        this.usingSystemProperties = usingSysProps;
        this.useStrongCiphers();
        this.dirtyAndReloadIfYoung();
    }

    private void dirty() {
        this.sslContext = null;
        this.socketFactory = null;
        this.serverSocketFactory = null;
    }

    private void dirtyAndReloadIfYoung() throws NoSuchAlgorithmException, KeyStoreException, KeyManagementException, IOException, CertificateException {
        this.dirty();
        if (this.initCount >= 0 && this.initCount <= 5) {
            this.init();
        }
    }

    public SSLContext getSSLContext() throws GeneralSecurityException, IOException {
        Object obj = this.getSSLContextAsObject();
        if (JavaImpl.isJava13()) {
            try {
                return (SSLContext)obj;
            }
            catch (ClassCastException cce) {
                throw new ClassCastException("When using Java13 SSL, you must call SSL.getSSLContextAsObject() - " + cce);
            }
        }
        return (SSLContext)obj;
    }

    public Object getSSLContextAsObject() throws GeneralSecurityException, IOException {
        if (this.sslContext == null) {
            this.init();
        }
        return this.sslContext;
    }

    public void addTrustMaterial(TrustChain trustChain) throws NoSuchAlgorithmException, KeyStoreException, KeyManagementException, IOException, CertificateException {
        if (this.trustChain == null || trustChain == TrustMaterial.TRUST_ALL) {
            this.trustChain = trustChain;
        } else {
            this.trustChain.addTrustMaterial(trustChain);
        }
        this.dirtyAndReloadIfYoung();
    }

    public void setTrustMaterial(TrustChain trustChain) throws NoSuchAlgorithmException, KeyStoreException, KeyManagementException, IOException, CertificateException {
        this.trustChain = trustChain;
        this.dirtyAndReloadIfYoung();
    }

    public void setKeyMaterial(KeyMaterial keyMaterial) throws NoSuchAlgorithmException, KeyStoreException, KeyManagementException, IOException, CertificateException {
        this.keyMaterial = keyMaterial;
        this.dirtyAndReloadIfYoung();
    }

    public X509Certificate[] getAssociatedCertificateChain() {
        if (this.keyMaterial != null) {
            List list = this.keyMaterial.getAssociatedCertificateChains();
            return (X509Certificate[])list.get(0);
        }
        return null;
    }

    public String[] getEnabledCiphers() {
        return this.enabledCiphers != null ? this.enabledCiphers : this.getDefaultCipherSuites();
    }

    public void useDefaultJavaCiphers() {
        this.enabledCiphers = null;
    }

    public void useStrongCiphers() {
        LinkedList list = new LinkedList();
        SSL.addCipher(list, SSL_DHE_DSS_WITH_3DES_EDE_CBC_SHA, false);
        SSL.addCipher(list, SSL_DHE_RSA_WITH_3DES_EDE_CBC_SHA, false);
        SSL.addCipher(list, SSL_RSA_WITH_3DES_EDE_CBC_SHA, false);
        SSL.addCipher(list, SSL_RSA_WITH_RC4_128_SHA, false);
        SSL.addCipher(list, TLS_DHE_DSS_WITH_AES_128_CBC_SHA, false);
        SSL.addCipher(list, TLS_DHE_DSS_WITH_AES_256_CBC_SHA, false);
        SSL.addCipher(list, TLS_DHE_RSA_WITH_AES_128_CBC_SHA, false);
        SSL.addCipher(list, TLS_DHE_RSA_WITH_AES_256_CBC_SHA, false);
        SSL.addCipher(list, TLS_RSA_WITH_AES_128_CBC_SHA, false);
        SSL.addCipher(list, TLS_RSA_WITH_AES_256_CBC_SHA, false);
        Object[] strongCiphers = new String[list.size()];
        list.toArray(strongCiphers);
        Object[] currentCiphers = this.getEnabledCiphers();
        if (currentCiphers == null) {
            this.setEnabledCiphers((String[])strongCiphers);
        }
        Arrays.sort(strongCiphers);
        Arrays.sort(currentCiphers);
        if (!Arrays.equals(strongCiphers, currentCiphers)) {
            this.setEnabledCiphers((String[])strongCiphers);
        }
    }

    public void setEnabledCiphers(String[] ciphers) {
        HashSet<String> desired = new HashSet<String>(Arrays.asList(ciphers));
        desired.removeAll(SUPPORTED_CIPHERS_SET);
        if (!desired.isEmpty()) {
            throw new IllegalArgumentException("following ciphers not supported: " + desired);
        }
        this.enabledCiphers = ciphers;
    }

    public String[] getEnabledProtocols() {
        return this.enabledProtocols != null ? this.enabledProtocols : KNOWN_PROTOCOLS;
    }

    public void setEnabledProtocols(String[] protocols) {
        HashSet<String> desired = new HashSet<String>(Arrays.asList(protocols));
        desired.removeAll(KNOWN_PROTOCOLS_SET);
        if (!desired.isEmpty()) {
            throw new IllegalArgumentException("following protocols not supported: " + desired);
        }
        this.enabledProtocols = protocols;
    }

    public String getDefaultProtocol() {
        return this.defaultProtocol;
    }

    public void setDefaultProtocol(String protocol) {
        this.defaultProtocol = protocol;
        this.dirty();
    }

    public boolean getCheckHostname() {
        return this.checkHostname;
    }

    public List getAllowedNames() {
        return Collections.unmodifiableList(this.allowedNames);
    }

    public void addAllowedNames(Collection allowedNames) {
        this.allowedNames.addAll(allowedNames);
    }

    public void addAllowedName(String allowedName) {
        this.allowedNames.add(allowedName);
    }

    public void clearAllowedNames() {
        this.allowedNames.clear();
    }

    public void setCheckHostname(boolean checkHostname) {
        this.checkHostname = checkHostname;
    }

    public void setHostnameVerifier(HostnameVerifier verifier) {
        if (verifier == null) {
            verifier = HostnameVerifier.DEFAULT;
        }
        this.hostnameVerifier = verifier;
    }

    public HostnameVerifier getHostnameVerifier() {
        return this.hostnameVerifier;
    }

    public boolean getCheckCRL() {
        return this.checkCRL;
    }

    public void setCheckCRL(boolean checkCRL) {
        this.checkCRL = checkCRL;
    }

    public boolean getCheckExpiry() {
        return this.checkExpiry;
    }

    public void setCheckExpiry(boolean checkExpiry) {
        this.checkExpiry = checkExpiry;
    }

    public void setSoTimeout(int soTimeout) {
        if (soTimeout < 0) {
            throw new IllegalArgumentException("soTimeout must not be negative");
        }
        this.soTimeout = soTimeout;
    }

    public int getSoTimeout() {
        return this.soTimeout;
    }

    public void setConnectTimeout(int connectTimeout) {
        if (connectTimeout < 0) {
            throw new IllegalArgumentException("connectTimeout must not be negative");
        }
        this.connectTimeout = connectTimeout;
    }

    public void setUseClientMode(boolean useClientMode) {
        this.useClientModeDefault = false;
        this.useClientMode = useClientMode;
    }

    public boolean getUseClientModeDefault() {
        return this.useClientModeDefault;
    }

    public boolean getUseClientMode() {
        return this.useClientMode;
    }

    public void setWantClientAuth(boolean wantClientAuth) {
        this.wantClientAuth = wantClientAuth;
    }

    public void setNeedClientAuth(boolean needClientAuth) {
        this.needClientAuth = needClientAuth;
    }

    public boolean getWantClientAuth() {
        return this.wantClientAuth;
    }

    public boolean getNeedClientAuth() {
        return this.needClientAuth;
    }

    public SSLWrapperFactory getSSLWrapperFactory() {
        return this.sslWrapperFactory;
    }

    public void setSSLWrapperFactory(SSLWrapperFactory wf) {
        this.sslWrapperFactory = wf;
    }

    private void initThrowRuntime() {
        try {
            this.init();
        }
        catch (GeneralSecurityException gse) {
            throw JavaImpl.newRuntimeException(gse);
        }
        catch (IOException ioe) {
            throw JavaImpl.newRuntimeException(ioe);
        }
    }

    private void init() throws NoSuchAlgorithmException, KeyStoreException, KeyManagementException, IOException, CertificateException {
        this.socketFactory = null;
        this.serverSocketFactory = null;
        this.sslContext = JavaImpl.init(this, this.trustChain, this.keyMaterial);
        ++this.initCount;
    }

    public void doPreConnectSocketStuff(SSLSocket s) throws IOException {
        if (!this.useClientModeDefault) {
            s.setUseClientMode(this.useClientMode);
        }
        if (this.soTimeout > 0) {
            s.setSoTimeout(this.soTimeout);
        }
        if (this.enabledProtocols != null) {
            JavaImpl.setEnabledProtocols(s, this.enabledProtocols);
        }
        if (this.enabledCiphers != null) {
            s.setEnabledCipherSuites(this.enabledCiphers);
        }
    }

    public void doPostConnectSocketStuff(SSLSocket s, String host) throws IOException {
        if (this.checkHostname) {
            int size = this.allowedNames.size() + 1;
            String[] hosts = new String[size];
            hosts[0] = host;
            int i = 1;
            Iterator it = this.allowedNames.iterator();
            while (it.hasNext()) {
                hosts[i] = (String)it.next();
                ++i;
            }
            this.hostnameVerifier.check(hosts, s);
        }
    }

    public SSLSocket createSocket() throws IOException {
        return this.sslWrapperFactory.wrap(JavaImpl.createSocket(this));
    }

    public Socket createSocket(String remoteHost, int remotePort, InetAddress localHost, int localPort, int timeout) throws IOException {
        int factoryTimeout = this.getConnectTimeout();
        int connectTimeout = timeout == 0 ? factoryTimeout : timeout;
        SSLSocket s = JavaImpl.createSocket(this, remoteHost, remotePort, localHost, localPort, connectTimeout);
        return this.sslWrapperFactory.wrap(s);
    }

    public Socket createSocket(Socket s, String remoteHost, int remotePort, boolean autoClose) throws IOException {
        SSLSocketFactory sf = this.getSSLSocketFactory();
        s = sf.createSocket(s, remoteHost, remotePort, autoClose);
        this.doPreConnectSocketStuff((SSLSocket)s);
        this.doPostConnectSocketStuff((SSLSocket)s, remoteHost);
        return this.sslWrapperFactory.wrap((SSLSocket)s);
    }

    public ServerSocket createServerSocket() throws IOException {
        SSLServerSocket ss = JavaImpl.createServerSocket(this);
        return this.getSSLWrapperFactory().wrap(ss, this);
    }

    public ServerSocket createServerSocket(int port, int backlog, InetAddress localHost) throws IOException {
        SSLServerSocketFactory f = this.getSSLServerSocketFactory();
        ServerSocket ss = f.createServerSocket(port, backlog, localHost);
        SSLServerSocket s = (SSLServerSocket)ss;
        this.doPreConnectServerSocketStuff(s);
        return this.getSSLWrapperFactory().wrap(s, this);
    }

    public void doPreConnectServerSocketStuff(SSLServerSocket s) throws IOException {
        if (this.soTimeout > 0) {
            s.setSoTimeout(this.soTimeout);
        }
        if (this.enabledProtocols != null) {
            JavaImpl.setEnabledProtocols(s, this.enabledProtocols);
        }
        if (this.enabledCiphers != null) {
            s.setEnabledCipherSuites(this.enabledCiphers);
        }
        if (!this.wantClientAuth) {
            JavaImpl.setWantClientAuth(s, this.wantClientAuth);
        }
        if (!this.needClientAuth) {
            s.setNeedClientAuth(this.needClientAuth);
        }
        if (this.wantClientAuth) {
            JavaImpl.setWantClientAuth(s, this.wantClientAuth);
        }
        if (this.needClientAuth) {
            s.setNeedClientAuth(this.needClientAuth);
        }
    }

    public SSLSocketFactory getSSLSocketFactory() {
        if (this.sslContext == null) {
            this.initThrowRuntime();
        }
        if (this.socketFactory == null) {
            this.socketFactory = JavaImpl.getSSLSocketFactory(this.sslContext);
        }
        return this.socketFactory;
    }

    public SSLServerSocketFactory getSSLServerSocketFactory() {
        if (this.sslContext == null) {
            this.initThrowRuntime();
        }
        if (this.serverSocketFactory == null) {
            this.serverSocketFactory = JavaImpl.getSSLServerSocketFactory(this.sslContext);
        }
        return this.serverSocketFactory;
    }

    public int getConnectTimeout() {
        return this.connectTimeout;
    }

    public String[] getDefaultCipherSuites() {
        return this.getSSLSocketFactory().getDefaultCipherSuites();
    }

    public String[] getSupportedCipherSuites() {
        String[] s = new String[SUPPORTED_CIPHERS.length];
        System.arraycopy(SUPPORTED_CIPHERS, 0, s, 0, s.length);
        return s;
    }

    public TrustChain getTrustChain() {
        return this.trustChain;
    }

    public void setCurrentServerChain(X509Certificate[] chain) {
        this.currentServerChain = chain;
    }

    public void setCurrentClientChain(X509Certificate[] chain) {
        this.currentClientChain = chain;
    }

    public X509Certificate[] getCurrentServerChain() {
        return this.currentServerChain;
    }

    public X509Certificate[] getCurrentClientChain() {
        return this.currentClientChain;
    }

    public static void main(String[] args) {
        for (int i = 0; i < SUPPORTED_CIPHERS.length; ++i) {
            System.out.println(SUPPORTED_CIPHERS[i]);
        }
        System.out.println();
        System.out.println("----------------------------------------------");
        SSL.addCipher(null, SSL_DHE_DSS_WITH_3DES_EDE_CBC_SHA, true);
        SSL.addCipher(null, SSL_DHE_RSA_WITH_3DES_EDE_CBC_SHA, true);
        SSL.addCipher(null, SSL_RSA_WITH_3DES_EDE_CBC_SHA, true);
        SSL.addCipher(null, SSL_RSA_WITH_RC4_128_SHA, true);
        SSL.addCipher(null, TLS_DHE_DSS_WITH_AES_128_CBC_SHA, true);
        SSL.addCipher(null, TLS_DHE_DSS_WITH_AES_256_CBC_SHA, true);
        SSL.addCipher(null, TLS_DHE_RSA_WITH_AES_128_CBC_SHA, true);
        SSL.addCipher(null, TLS_DHE_RSA_WITH_AES_256_CBC_SHA, true);
        SSL.addCipher(null, TLS_RSA_WITH_AES_128_CBC_SHA, true);
        SSL.addCipher(null, TLS_RSA_WITH_AES_256_CBC_SHA, true);
    }

    private static void addCipher(List l, String c, boolean printOnStandardOut) {
        boolean supported = false;
        if (c != null && SUPPORTED_CIPHERS_SET.contains(c)) {
            if (l != null) {
                l.add(c);
            }
            supported = true;
        }
        if (printOnStandardOut) {
            System.out.println(c + ":\t" + supported);
        }
    }

    static {
        TreeSet<Object> ts = new TreeSet(Collections.reverseOrder());
        ts.addAll(Arrays.asList(KNOWN_PROTOCOLS));
        KNOWN_PROTOCOLS_SET = Collections.unmodifiableSortedSet(ts);
        SSLSocketFactory s = (SSLSocketFactory)SSLSocketFactory.getDefault();
        ts = new TreeSet();
        SUPPORTED_CIPHERS = s.getSupportedCipherSuites();
        Arrays.sort(SUPPORTED_CIPHERS);
        ts.addAll(Arrays.asList(SUPPORTED_CIPHERS));
        SUPPORTED_CIPHERS_SET = Collections.unmodifiableSortedSet(ts);
    }
}

