/*
 * Decompiled with CFR 0.152.
 */
package org.jgraph.layout;

import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Random;
import org.jgraph.JGraph;
import org.jgraph.graph.AttributeMap;
import org.jgraph.graph.CellView;
import org.jgraph.graph.EdgeView;
import org.jgraph.graph.GraphConstants;
import org.jgraph.graph.GraphLayoutCache;
import org.jgraph.graph.GraphModel;
import org.jgraph.graph.PortView;
import org.jgraph.graph.VertexView;
import org.jgraph.layout.JGraphLayoutAlgorithm;

public class SpringEmbeddedLayoutAlgorithm
extends JGraphLayoutAlgorithm {
    public static final String SPRING_EMBEDDED_DISP = "SpringEmbeddedDisp";
    public static final String SPRING_EMBEDDED_POS = "SpringEmbeddedPos";
    private Rectangle myFrame = null;
    private int myMaxIterations = -1;

    public SpringEmbeddedLayoutAlgorithm() {
        this.myFrame = new Rectangle(0, 0, 500, 500);
        this.myMaxIterations = 30;
    }

    public SpringEmbeddedLayoutAlgorithm(Rectangle rectangle, int n) {
        if (rectangle == null) {
            throw new IllegalArgumentException("frame may not be null");
        }
        if (rectangle.width <= 0) {
            throw new IllegalArgumentException("frame width must be positive");
        }
        if (rectangle.height <= 0) {
            throw new IllegalArgumentException("frame height must be positive");
        }
        this.myFrame = rectangle;
        if (n < 0) {
            throw new IllegalArgumentException("maxIterations must be a positive integer");
        }
        this.myMaxIterations = n;
    }

    public void setFrame(Rectangle rectangle) {
        if (rectangle == null) {
            throw new IllegalArgumentException("Frame may not be null");
        }
        if (rectangle.width <= 0) {
            throw new IllegalArgumentException("frame width must be positive");
        }
        if (rectangle.height <= 0) {
            throw new IllegalArgumentException("frame height must be positive");
        }
        this.myFrame = rectangle;
    }

    public String toString() {
        return "Spring Embedded";
    }

    public void setMaxIterations(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("maxIterations must be a positive integer");
        }
        this.myMaxIterations = n;
    }

    private void replaceInsideFrame(List list, Rectangle2D rectangle2D) {
        for (int i = 0; i < list.size(); ++i) {
            VertexView vertexView = (VertexView)list.get(i);
            Rectangle2D rectangle2D2 = this.getVertexPosition((CellView)vertexView, SPRING_EMBEDDED_POS);
            Rectangle2D.Double double_ = new Rectangle2D.Double(rectangle2D2.getX() - rectangle2D.getX(), rectangle2D2.getY() - rectangle2D.getY(), rectangle2D2.getWidth(), rectangle2D2.getHeight());
            this.updateVertexPosition((CellView)vertexView, SPRING_EMBEDDED_POS, double_);
        }
    }

    public void run(JGraph jGraph, Object[] objectArray, Object[] objectArray2) {
        GraphLayoutCache graphLayoutCache = jGraph.getGraphLayoutCache();
        ArrayList arrayList = new ArrayList();
        ArrayList arrayList2 = new ArrayList();
        List list = new ArrayList();
        CellView[] cellViewArray = graphLayoutCache.getMapping(objectArray, false);
        this.partitionCells(cellViewArray, arrayList, arrayList2);
        double d = this.myFrame.getWidth();
        double d2 = this.myFrame.getHeight();
        double d3 = d * d2;
        this.randomizeVertexPositions(arrayList);
        double d4 = Math.sqrt(d3 / (double)arrayList.size());
        list = this.findVertexWithoutEdges(arrayList2, arrayList);
        for (int i = 0; i < this.myMaxIterations; ++i) {
            this.calculateRepulsiveForces(arrayList, d4);
            this.calculateAttractiveForces(arrayList2, list, d4);
            this.calculateNewPositions(arrayList, i);
        }
        Rectangle2D rectangle2D = this.calculateNewFrame(arrayList);
        this.replaceInsideFrame(arrayList, rectangle2D);
        rectangle2D.setFrame(0.0, 0.0, 900.0, 900.0);
        double d5 = (double)this.myFrame.width / rectangle2D.getWidth();
        double d6 = (double)this.myFrame.height / rectangle2D.getHeight();
        int n = (int)((double)this.myFrame.x - rectangle2D.getX());
        int n2 = (int)((double)this.myFrame.y - rectangle2D.getY());
        Map map = this.drawGraph(graphLayoutCache.getMapping(objectArray, false), jGraph.getModel(), n, d5, n2, d6);
        graphLayoutCache.edit(map, null, null, null);
    }

    private void partitionCells(CellView[] cellViewArray, List list, List list2) {
        for (int i = 0; i < cellViewArray.length; ++i) {
            EdgeView edgeView;
            CellView cellView = cellViewArray[i];
            if (cellView == null) continue;
            if (cellView instanceof EdgeView) {
                edgeView = (EdgeView)cellView;
                list2.add(edgeView);
                continue;
            }
            if (!(cellView instanceof VertexView)) continue;
            edgeView = (VertexView)cellView;
            list.add(edgeView);
        }
    }

    private void randomizeVertexPositions(List list) {
        int n = 0;
        Rectangle rectangle = null;
        Random random = new Random();
        for (int i = 0; i < list.size(); ++i) {
            VertexView vertexView = (VertexView)list.get(i);
            int n2 = (int)vertexView.getBounds().getWidth();
            int n3 = (int)vertexView.getBounds().getHeight();
            int n4 = this.myFrame.width;
            int n5 = this.myFrame.height;
            int n6 = random.nextInt(n4);
            while (n6 < 0) {
                n6 = random.nextInt(n4);
            }
            n = random.nextInt(n5);
            while (n < 0) {
                n = random.nextInt(n4);
            }
            rectangle = new Rectangle(n6, n, n2, n3);
            this.updateVertexPosition((CellView)vertexView, SPRING_EMBEDDED_POS, rectangle);
        }
    }

    private void calculateRepulsiveForces(List list, double d) {
        for (int i = 0; i < list.size(); ++i) {
            VertexView vertexView = (VertexView)list.get(i);
            Rectangle2D rectangle2D = this.getVertexPosition((CellView)vertexView, SPRING_EMBEDDED_POS);
            Rectangle rectangle = new Rectangle(0, 0);
            for (int j = 0; j < list.size(); ++j) {
                VertexView vertexView2 = (VertexView)list.get(j);
                if (vertexView2 == vertexView) continue;
                Rectangle2D rectangle2D2 = this.getVertexPosition((CellView)vertexView2, SPRING_EMBEDDED_POS);
                Rectangle rectangle2 = new Rectangle();
                rectangle2.x = (int)(rectangle2D.getX() - rectangle2D2.getX());
                rectangle2.y = (int)(rectangle2D.getY() - rectangle2D2.getY());
                double d2 = this.fr(this.norm(rectangle2), d);
                double d3 = (double)rectangle2.x / this.norm(rectangle2);
                double d4 = d3 * d2;
                double d5 = (double)rectangle2.y / this.norm(rectangle2);
                double d6 = d5 * d2;
                rectangle.x += (int)d4;
                rectangle.y += (int)d6;
            }
            this.updateVertexPosition((CellView)vertexView, SPRING_EMBEDDED_DISP, rectangle);
        }
    }

    private void calculateAttractiveForces(List list, List list2, double d) {
        Object object;
        Rectangle2D rectangle2D;
        VertexView vertexView;
        int n;
        double d2 = 0.0;
        double d3 = 0.0;
        EdgeView edgeView = null;
        if (list.size() == 0) {
            return;
        }
        for (n = 0; n < list.size(); ++n) {
            CellView cellView;
            edgeView = (EdgeView)list.get(n);
            if (edgeView.getSource() == null || edgeView.getTarget() == null || edgeView.getSource() == edgeView.getTarget() || (vertexView = ((PortView)edgeView.getSource()).getParentView()) == (cellView = ((PortView)edgeView.getTarget()).getParentView())) continue;
            Rectangle2D rectangle2D2 = this.getVertexPosition((CellView)vertexView, SPRING_EMBEDDED_POS);
            rectangle2D = this.getVertexPosition(cellView, SPRING_EMBEDDED_POS);
            if (rectangle2D2 == null || rectangle2D == null) continue;
            object = this.getVertexPosition((CellView)vertexView, SPRING_EMBEDDED_DISP);
            Rectangle2D rectangle2D3 = this.getVertexPosition(cellView, SPRING_EMBEDDED_DISP);
            if (object == null || rectangle2D3 == null) continue;
            Rectangle rectangle = new Rectangle();
            rectangle.x = (int)(rectangle2D2.getX() - rectangle2D.getX());
            rectangle.y = (int)(rectangle2D2.getY() - rectangle2D.getY());
            double d4 = this.fa(this.norm(rectangle), d);
            double d5 = (double)rectangle.x / this.norm(rectangle);
            double d6 = (double)rectangle.y / this.norm(rectangle);
            d2 = d5 * d4;
            d3 = d6 * d4;
            ((Rectangle2D)object).setFrame(((RectangularShape)object).getX() - d2, ((RectangularShape)object).getY() - d3, ((RectangularShape)object).getWidth(), ((RectangularShape)object).getHeight());
            rectangle2D3.setFrame(rectangle2D3.getX() + d2, rectangle2D3.getY() + d3, rectangle2D3.getWidth(), rectangle2D3.getHeight());
            this.updateVertexPosition((CellView)vertexView, SPRING_EMBEDDED_DISP, (Rectangle2D)object);
            this.updateVertexPosition(cellView, SPRING_EMBEDDED_DISP, rectangle2D3);
        }
        for (n = 0; n < list2.size(); ++n) {
            vertexView = (VertexView)list2.get(n);
            int n2 = (int)vertexView.getBounds().getWidth();
            int n3 = (int)vertexView.getBounds().getHeight();
            rectangle2D = null;
            object = new Random();
            int n4 = ((Random)object).nextInt(500);
            while (n4 < 0) {
                n4 = ((Random)object).nextInt((int)vertexView.getBounds().getCenterX());
            }
            int n5 = ((Random)object).nextInt(500);
            while (n5 < 0) {
                n5 = ((Random)object).nextInt((int)vertexView.getBounds().getCenterY());
            }
            rectangle2D = new Rectangle(n4, n5, n2, n3);
            this.updateVertexPosition((CellView)vertexView, SPRING_EMBEDDED_POS, rectangle2D);
        }
    }

    private List findVertexWithoutEdges(List list, List list2) {
        int n;
        ArrayList arrayList = new ArrayList();
        for (n = 0; n < list2.size(); ++n) {
            arrayList.add(list2.get(n));
        }
        for (n = 0; n < list.size(); ++n) {
            EdgeView edgeView = (EdgeView)list.get(n);
            CellView cellView = edgeView.getSource().getParentView();
            CellView cellView2 = edgeView.getTarget().getParentView();
            arrayList.remove(cellView);
            arrayList.remove(cellView2);
        }
        return arrayList;
    }

    private void calculateNewPositions(List list, int n) {
        double d = Math.sqrt(Math.pow(this.myFrame.width, 2.0) + Math.pow(this.myFrame.height, 2.0)) * ((double)this.myMaxIterations / (double)(n + 1) / (double)this.myMaxIterations);
        for (int i = 0; i < list.size(); ++i) {
            VertexView vertexView = (VertexView)list.get(i);
            Rectangle2D rectangle2D = this.getVertexPosition((CellView)vertexView, SPRING_EMBEDDED_DISP);
            Rectangle2D rectangle2D2 = this.getVertexPosition((CellView)vertexView, SPRING_EMBEDDED_POS);
            double d2 = rectangle2D.getX() / this.norm(rectangle2D);
            double d3 = Math.min(Math.abs(rectangle2D.getX()), d);
            double d4 = rectangle2D.getY() / this.norm(rectangle2D);
            double d5 = Math.min(Math.abs(rectangle2D.getY()), d);
            rectangle2D2.setFrame(rectangle2D2.getX() + d2 * d3, rectangle2D2.getY() + d4 * d5, rectangle2D2.getWidth(), rectangle2D2.getHeight());
            this.updateVertexPosition((CellView)vertexView, SPRING_EMBEDDED_POS, rectangle2D2);
        }
    }

    private Rectangle2D calculateNewFrame(List list) {
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        Rectangle2D.Double double_ = new Rectangle2D.Double();
        for (int i = 0; i < list.size(); ++i) {
            double d5;
            double d6;
            VertexView vertexView = (VertexView)list.get(i);
            Rectangle2D rectangle2D = this.getVertexPosition((CellView)vertexView, SPRING_EMBEDDED_POS);
            d = ((RectangularShape)double_).getX();
            d2 = ((RectangularShape)double_).getY();
            d3 = ((RectangularShape)double_).getWidth();
            d4 = ((RectangularShape)double_).getHeight();
            if (rectangle2D.getX() < ((RectangularShape)double_).getX()) {
                d = rectangle2D.getX();
            }
            if (rectangle2D.getY() < ((RectangularShape)double_).getY()) {
                d2 = rectangle2D.getY();
            }
            if ((d6 = rectangle2D.getX() - ((RectangularShape)double_).getX()) > ((RectangularShape)double_).getWidth()) {
                d3 = d6;
            }
            if ((d5 = rectangle2D.getY() - ((RectangularShape)double_).getY()) > ((RectangularShape)double_).getHeight()) {
                d4 = d5;
            }
            double_.setFrame(d, d2, d3, d4);
        }
        return double_;
    }

    private Map drawGraph(CellView[] cellViewArray, GraphModel graphModel, int n, double d, int n2, double d2) {
        Hashtable<CellView, AttributeMap> hashtable = new Hashtable<CellView, AttributeMap>();
        for (int i = 0; i < cellViewArray.length; ++i) {
            CellView cellView = cellViewArray[i];
            if (cellView == null) continue;
            if (cellView instanceof EdgeView) {
                cellView.update();
                continue;
            }
            if (!(cellView instanceof VertexView)) continue;
            VertexView vertexView = (VertexView)cellView;
            Rectangle2D rectangle2D = this.removeVertexPosition((CellView)vertexView, SPRING_EMBEDDED_POS);
            this.removeVertexPosition((CellView)vertexView, SPRING_EMBEDDED_DISP);
            rectangle2D.setFrame((rectangle2D.getX() + (double)n) * d, (rectangle2D.getY() + (double)n2) * d2, rectangle2D.getWidth(), rectangle2D.getHeight());
            AttributeMap attributeMap = new AttributeMap();
            GraphConstants.setBounds((Map)attributeMap, (Rectangle2D)rectangle2D);
            vertexView.changeAttributes((Map)attributeMap);
            hashtable.put(cellViewArray[i], attributeMap);
        }
        return hashtable;
    }

    private void updateVertexPosition(CellView cellView, String string, Rectangle2D rectangle2D) {
        AttributeMap attributeMap = cellView.getAllAttributes();
        attributeMap.put((Object)string, (Object)rectangle2D);
        cellView.changeAttributes((Map)attributeMap);
    }

    private Rectangle2D getVertexPosition(CellView cellView, String string) {
        AttributeMap attributeMap = cellView.getAllAttributes();
        Rectangle2D rectangle2D = (Rectangle2D)attributeMap.get((Object)string);
        return rectangle2D;
    }

    private Rectangle2D removeVertexPosition(CellView cellView, String string) {
        AttributeMap attributeMap = cellView.getAllAttributes();
        Rectangle2D rectangle2D = (Rectangle2D)attributeMap.remove((Object)string);
        cellView.changeAttributes((Map)attributeMap);
        return rectangle2D;
    }

    protected double fa(double d, double d2) {
        double d3 = d * d / d2;
        return d3;
    }

    protected double fr(double d, double d2) {
        double d3 = d2 * d2 / d;
        return d3;
    }

    protected double norm(Rectangle2D rectangle2D) {
        double d = rectangle2D.getX();
        double d2 = rectangle2D.getY();
        double d3 = Math.sqrt(d * d + d2 * d2);
        return d3;
    }
}

