/*
 * Decompiled with CFR 0.152.
 */
package org.jgraph.cellview;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.plaf.basic.BasicLabelUI;
import org.jgraph.JGraph;
import org.jgraph.graph.AttributeMap;
import org.jgraph.graph.CellView;
import org.jgraph.graph.CellViewRenderer;
import org.jgraph.graph.GraphConstants;
import org.jgraph.graph.VertexView;

public class JGraphSwimlaneView
extends VertexView {
    public static transient JSwimlaneRenderer renderer = new JSwimlaneRenderer();
    private static final transient int LABEL_SIZE = 25;

    public JGraphSwimlaneView(Object object) {
        super(object);
    }

    public CellViewRenderer getRenderer() {
        return renderer;
    }

    public static int getLabelSize() {
        return 25;
    }

    protected void scale(double d, double d2, Point2D point2D) {
        this.getAttributes().scale(d, d2, point2D);
    }

    public static class JSwimlaneRenderer
    extends JPanel
    implements CellViewRenderer {
        protected transient JGraph graph = null;
        private static transient JLabel label = new JLabel();
        private static transient JLabel container = new JLabel();
        private transient Rectangle2D rect;
        protected transient Color gradientColor = null;
        protected transient boolean hasFocus;
        protected transient boolean selected;
        protected transient boolean preview;

        public JSwimlaneRenderer() {
            super(new BorderLayout());
            label.setUI(new SwimlaneLabelUI(false));
            label.setPreferredSize(new Dimension(25, 100));
            label.setHorizontalAlignment(0);
            this.add((Component)label, "Before");
            this.add((Component)container, "Center");
        }

        public Component getRendererComponent(JGraph jGraph, CellView cellView, boolean bl, boolean bl2, boolean bl3) {
            label.setText(cellView.getCell().toString());
            this.graph = jGraph;
            this.selected = bl;
            this.preview = bl3;
            this.hasFocus = bl2;
            AttributeMap attributeMap = cellView.getAllAttributes();
            this.installAttributes(jGraph, (Map)attributeMap);
            return this;
        }

        public void paint(Graphics graphics) {
            try {
                if (this.gradientColor != null && !this.preview) {
                    this.setOpaque(false);
                    Graphics2D graphics2D = (Graphics2D)graphics;
                    graphics2D.setPaint(new GradientPaint(0.0f, 0.0f, this.getBackground(), this.getWidth(), this.getHeight(), this.gradientColor, true));
                    graphics2D.fillRect(0, 0, this.getWidth(), this.getHeight());
                }
                super.paint(graphics);
                this.paintSelectionBorder(graphics);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }

        protected void paintSelectionBorder(Graphics graphics) {
            ((Graphics2D)graphics).setStroke(GraphConstants.SELECTION_STROKE);
            if (this.hasFocus && this.selected) {
                graphics.setColor(this.graph.getLockedHandleColor());
            } else if (this.selected) {
                graphics.setColor(this.graph.getHighlightColor());
            }
            if (this.selected) {
                Dimension dimension = this.getSize();
                graphics.drawRect(0, 0, dimension.width - 1, dimension.height - 1);
            }
        }

        protected void installAttributes(JGraph jGraph, Map map) {
            this.setOpaque(GraphConstants.isOpaque((Map)map));
            Color color = GraphConstants.getForeground((Map)map);
            this.setForeground(color != null ? color : jGraph.getForeground());
            Color color2 = GraphConstants.getBackground((Map)map);
            this.setBackground(color2 != null ? color2 : jGraph.getBackground());
            Font font = GraphConstants.getFont((Map)map);
            label.setFont(font != null ? font : jGraph.getFont());
            this.rect = GraphConstants.getBounds((Map)map);
            this.setBounds((int)this.rect.getX(), (int)this.rect.getY(), (int)this.rect.getWidth(), (int)this.rect.getHeight());
            Border border = GraphConstants.getBorder((Map)map);
            Color color3 = GraphConstants.getBorderColor((Map)map);
            if (border != null) {
                label.setBorder(border);
                container.setBorder(border);
            } else if (color3 != null) {
                int n = Math.max(1, Math.round(GraphConstants.getLineWidth((Map)map)));
                label.setBorder(BorderFactory.createLineBorder(color3, n));
                container.setBorder(BorderFactory.createLineBorder(color3, n));
            }
            this.gradientColor = GraphConstants.getGradientColor((Map)map);
        }
    }

    static class SwimlaneLabelUI
    extends BasicLabelUI {
        protected boolean clockwise;
        private static Rectangle paintIconR = new Rectangle();
        private static Rectangle paintTextR = new Rectangle();
        private static Rectangle paintViewR = new Rectangle();
        private static Insets paintViewInsets = new Insets(0, 0, 0, 0);

        SwimlaneLabelUI(boolean bl) {
            this.clockwise = bl;
        }

        public Dimension getPreferredSize(JComponent jComponent) {
            Dimension dimension = super.getPreferredSize(jComponent);
            return new Dimension(dimension.height, dimension.width);
        }

        public void paint(Graphics graphics, JComponent jComponent) {
            Icon icon;
            JLabel jLabel = (JLabel)jComponent;
            String string = jLabel.getText();
            Icon icon2 = icon = jLabel.isEnabled() ? jLabel.getIcon() : jLabel.getDisabledIcon();
            if (icon == null && string == null) {
                return;
            }
            FontMetrics fontMetrics = graphics.getFontMetrics();
            paintViewInsets = jComponent.getInsets(paintViewInsets);
            SwimlaneLabelUI.paintViewR.x = SwimlaneLabelUI.paintViewInsets.left;
            SwimlaneLabelUI.paintViewR.y = SwimlaneLabelUI.paintViewInsets.top;
            SwimlaneLabelUI.paintViewR.height = jComponent.getWidth() - (SwimlaneLabelUI.paintViewInsets.left + SwimlaneLabelUI.paintViewInsets.right);
            SwimlaneLabelUI.paintViewR.width = jComponent.getHeight() - (SwimlaneLabelUI.paintViewInsets.top + SwimlaneLabelUI.paintViewInsets.bottom);
            SwimlaneLabelUI.paintIconR.height = 0;
            SwimlaneLabelUI.paintIconR.width = 0;
            SwimlaneLabelUI.paintIconR.y = 0;
            SwimlaneLabelUI.paintIconR.x = 0;
            SwimlaneLabelUI.paintTextR.height = 0;
            SwimlaneLabelUI.paintTextR.width = 0;
            SwimlaneLabelUI.paintTextR.y = 0;
            SwimlaneLabelUI.paintTextR.x = 0;
            String string2 = this.layoutCL(jLabel, fontMetrics, string, icon, paintViewR, paintIconR, paintTextR);
            Graphics2D graphics2D = (Graphics2D)graphics;
            AffineTransform affineTransform = graphics2D.getTransform();
            if (this.clockwise) {
                graphics2D.rotate(1.5707963267948966);
                graphics2D.translate(0, -jComponent.getWidth());
            } else {
                graphics2D.rotate(-1.5707963267948966);
                graphics2D.translate(-jComponent.getHeight(), 0);
            }
            if (icon != null) {
                icon.paintIcon(jComponent, graphics, SwimlaneLabelUI.paintIconR.x, SwimlaneLabelUI.paintIconR.y);
            }
            if (string != null) {
                int n = SwimlaneLabelUI.paintTextR.x;
                int n2 = SwimlaneLabelUI.paintTextR.y + fontMetrics.getAscent();
                if (jLabel.isEnabled()) {
                    this.paintEnabledText(jLabel, graphics, string2, n, n2);
                } else {
                    this.paintDisabledText(jLabel, graphics, string2, n, n2);
                }
            }
            graphics2D.setTransform(affineTransform);
        }
    }
}

