/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.binding.adapter;

import com.jgoodies.binding.BindingUtils;
import com.jgoodies.binding.value.ValueModel;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.UndoableEditListener;
import javax.swing.text.AbstractDocument;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.PlainDocument;
import javax.swing.text.Position;
import javax.swing.text.Segment;

public final class DocumentAdapter
implements Document,
DocumentListener {
    private final ValueModel subject;
    private final Document delegate;
    private final SubjectValueChangeHandler subjectValueChangeHandler;

    public DocumentAdapter(ValueModel subject) {
        this(subject, new PlainDocument(), false);
    }

    public DocumentAdapter(ValueModel subject, boolean filterNewlines) {
        this(subject, new PlainDocument(), filterNewlines);
    }

    public DocumentAdapter(ValueModel subject, Document document) {
        this(subject, document, false);
    }

    public DocumentAdapter(ValueModel subject, Document document, boolean filterNewlines) {
        if (subject == null) {
            throw new NullPointerException("The subject must not be null.");
        }
        if (document == null) {
            throw new NullPointerException("The document must not be null.");
        }
        this.subject = subject;
        this.delegate = document;
        document.putProperty("filterNewlines", filterNewlines);
        this.subjectValueChangeHandler = new SubjectValueChangeHandler();
        document.addDocumentListener(this);
        subject.addValueChangeListener(this.subjectValueChangeHandler);
        this.setDocumentTextSilently(this.getSubjectText());
    }

    private void updateSubject() {
        this.setSubjectText(this.getDocumentText());
    }

    private String getDocumentText() {
        int length = this.delegate.getLength();
        try {
            return this.delegate.getText(0, length);
        }
        catch (BadLocationException e) {
            e.printStackTrace();
            return "";
        }
    }

    private void setDocumentTextSilently(String newText) {
        this.delegate.removeDocumentListener(this);
        try {
            if (this.delegate instanceof AbstractDocument) {
                ((AbstractDocument)this.delegate).replace(0, this.delegate.getLength(), newText, null);
            } else {
                this.delegate.remove(0, this.delegate.getLength());
                this.delegate.insertString(0, newText, null);
            }
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
        this.delegate.addDocumentListener(this);
    }

    private String getSubjectText() {
        String str = (String)this.subject.getValue();
        return str == null ? "" : str;
    }

    private void setSubjectText(String newText) {
        this.subjectValueChangeHandler.setUpdateLater(true);
        this.subject.setValue(newText);
        this.subjectValueChangeHandler.setUpdateLater(false);
    }

    public void insertUpdate(DocumentEvent e) {
        this.updateSubject();
    }

    public void removeUpdate(DocumentEvent e) {
        this.updateSubject();
    }

    public void changedUpdate(DocumentEvent e) {
    }

    public int getLength() {
        return this.delegate.getLength();
    }

    public void addDocumentListener(DocumentListener listener) {
        this.delegate.addDocumentListener(listener);
    }

    public void removeDocumentListener(DocumentListener listener) {
        this.delegate.removeDocumentListener(listener);
    }

    public void addUndoableEditListener(UndoableEditListener listener) {
        this.delegate.addUndoableEditListener(listener);
    }

    public void removeUndoableEditListener(UndoableEditListener listener) {
        this.delegate.removeUndoableEditListener(listener);
    }

    public Object getProperty(Object key) {
        return this.delegate.getProperty(key);
    }

    public void putProperty(Object key, Object value) {
        this.delegate.putProperty(key, value);
    }

    public void remove(int offs, int len) throws BadLocationException {
        this.delegate.remove(offs, len);
    }

    public void insertString(int offset, String str, AttributeSet a) throws BadLocationException {
        this.delegate.insertString(offset, str, a);
    }

    public String getText(int offset, int length) throws BadLocationException {
        return this.delegate.getText(offset, length);
    }

    public void getText(int offset, int length, Segment txt) throws BadLocationException {
        this.delegate.getText(offset, length, txt);
    }

    public Position getStartPosition() {
        return this.delegate.getStartPosition();
    }

    public Position getEndPosition() {
        return this.delegate.getEndPosition();
    }

    public Position createPosition(int offs) throws BadLocationException {
        return this.delegate.createPosition(offs);
    }

    public Element[] getRootElements() {
        return this.delegate.getRootElements();
    }

    public Element getDefaultRootElement() {
        return this.delegate.getDefaultRootElement();
    }

    public void render(Runnable r) {
        this.delegate.render(r);
    }

    private class SubjectValueChangeHandler
    implements PropertyChangeListener {
        private boolean updateLater;

        private SubjectValueChangeHandler() {
        }

        void setUpdateLater(boolean updateLater) {
            this.updateLater = updateLater;
        }

        public void propertyChange(PropertyChangeEvent evt) {
            String newText;
            String oldText = DocumentAdapter.this.getDocumentText();
            Object newValue = evt.getNewValue();
            String string = newText = newValue == null ? DocumentAdapter.this.getSubjectText() : (String)newValue;
            if (BindingUtils.equals(oldText, newText)) {
                return;
            }
            if (this.updateLater) {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        DocumentAdapter.this.setDocumentTextSilently(newText);
                    }
                });
            } else {
                DocumentAdapter.this.setDocumentTextSilently(newText);
            }
        }
    }
}

