/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.ui;

import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.IOException;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.NoSuchElementException;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.openide.WizardDescriptor;
import org.openide.cookies.InstanceCookie;
import org.openide.loaders.DataFolder;
import org.openide.loaders.FolderInstance;
import org.openide.util.HelpCtx;
import org.openide.util.Mutex;
import org.openide.util.Task;

public class WizardFolder
extends FolderInstance {
    private static final String PROP_CONTENT_SELECTED_INDEX = "WizardPanel_contentSelectedIndex";
    private static final String PROP_CONTENT_DATA = "WizardPanel_contentData";
    private WizardDescriptor.Iterator iterator;

    public WizardFolder(DataFolder theFolder) {
        super(theFolder);
        this.run();
    }

    public WizardDescriptor.Iterator getIterator() {
        return this.iterator;
    }

    protected InstanceCookie acceptCookie(InstanceCookie cookie) throws IOException, ClassNotFoundException {
        if (Component.class.isAssignableFrom(cookie.instanceClass())) {
            return cookie;
        }
        if (WizardDescriptor.Iterator.class.isAssignableFrom(cookie.instanceClass())) {
            return cookie;
        }
        if (WizardDescriptor.Panel.class.isAssignableFrom(cookie.instanceClass())) {
            return cookie;
        }
        return null;
    }

    protected Object createInstance(InstanceCookie[] cookies) throws IOException, ClassNotFoundException {
        WizardDescriptor.Iterator[] arr = new WizardDescriptor.Iterator[cookies.length];
        for (int i = 0; i < cookies.length; ++i) {
            if ((class$org$openide$WizardDescriptor$Iterator == null ? WizardFolder.class$("org.openide.WizardDescriptor$Iterator") : class$org$openide$WizardDescriptor$Iterator).isAssignableFrom(cookies[i].instanceClass())) {
                arr[i] = (WizardDescriptor.Iterator)cookies[i].instanceCreate();
                continue;
            }
            if ((class$org$openide$WizardDescriptor$Panel == null ? WizardFolder.class$("org.openide.WizardDescriptor$Panel") : class$org$openide$WizardDescriptor$Panel).isAssignableFrom(cookies[i].instanceClass())) {
                WizardDescriptor.Panel p = (WizardDescriptor.Panel)cookies[i].instanceCreate();
                arr[i] = new PanelWrapper(p, cookies[i].instanceName());
                continue;
            }
            if (!(class$java$awt$Component == null ? WizardFolder.class$("java.awt.Component") : class$java$awt$Component).isAssignableFrom(cookies[i].instanceClass())) continue;
            Component c = (Component)cookies[i].instanceCreate();
            arr[i] = new PanelWrapper(c, cookies[i].instanceName());
        }
        if (arr.length > 0) {
            this.iterator = new CompoundIterator(arr);
        }
        return this;
    }

    protected Task postCreationTask(Runnable run) {
        return new AWTTask(run);
    }

    private static class ComponentPanel
    implements WizardDescriptor.FinishPanel {
        private Component component;

        public ComponentPanel(Component c) {
            this.component = c;
        }

        public Component getComponent() {
            return this.component;
        }

        public HelpCtx getHelp() {
            return null;
        }

        public void readSettings(Object settings) {
        }

        public void storeSettings(Object settings) {
        }

        public boolean isValid() {
            return true;
        }

        public void addChangeListener(ChangeListener l) {
        }

        public void removeChangeListener(ChangeListener l) {
        }
    }

    protected static class PanelWrapper
    implements WizardDescriptor.Iterator {
        private WizardDescriptor.Panel panel;
        private String name;

        public PanelWrapper(WizardDescriptor.Panel p, String name) {
            this.panel = p;
            this.name = name;
        }

        public PanelWrapper(Component c, String name) {
            this.panel = new ComponentPanel(c);
            this.name = name;
        }

        public void addChangeListener(ChangeListener l) {
        }

        public WizardDescriptor.Panel current() {
            return this.panel;
        }

        public boolean hasNext() {
            return false;
        }

        public boolean hasPrevious() {
            return false;
        }

        public String name() {
            return this.name;
        }

        public void nextPanel() {
            throw new NoSuchElementException();
        }

        public void previousPanel() {
            throw new NoSuchElementException();
        }

        public void removeChangeListener(ChangeListener l) {
        }
    }

    protected static class CompoundIterator
    implements WizardDescriptor.Iterator,
    PropertyChangeListener {
        private WizardDescriptor.Iterator[] array;
        private int active = 0;
        private ChangeListener listener = null;
        private HashMap contentMap = new HashMap();
        private PropertyChangeSupport propertyChangeSupport;

        public CompoundIterator(LinkedList iterators) {
            this(iterators.toArray(new WizardDescriptor.Iterator[iterators.size()]));
        }

        public CompoundIterator(WizardDescriptor.Iterator[] arr) {
            this.array = arr;
            this.propertyChangeSupport = new PropertyChangeSupport(this);
        }

        public void setIterators(LinkedList iterators) {
            if (!iterators.contains(this.array[this.active])) {
                return;
            }
            this.active = iterators.indexOf(this.array[this.active]);
            this.array = iterators.toArray(new WizardDescriptor.Iterator[iterators.size()]);
            if (this.listener != null) {
                this.listener.stateChanged(new ChangeEvent(this));
            }
        }

        public void addChangeListener(ChangeListener l) {
            this.listener = l;
            for (int i = 0; i < this.array.length; ++i) {
                this.array[i].addChangeListener(l);
            }
        }

        public WizardDescriptor.Panel current() {
            return this.array[this.active].current();
        }

        public boolean hasNext() {
            if (this.active != this.array.length - 1) {
                return true;
            }
            return this.array[this.active].hasNext();
        }

        public boolean hasPrevious() {
            if (this.active != 0) {
                return true;
            }
            return this.array[this.active].hasPrevious();
        }

        public String name() {
            return this.array[this.active].name();
        }

        public void nextPanel() {
            this.stopListening();
            if (this.array[this.active].hasNext()) {
                this.array[this.active].nextPanel();
                this.startListening();
                this.propertyChangeSupport.firePropertyChange(WizardFolder.PROP_CONTENT_SELECTED_INDEX, null, null);
                return;
            }
            if (this.active < this.array.length - 1) {
                ++this.active;
                this.startListening();
                this.propertyChangeSupport.firePropertyChange(WizardFolder.PROP_CONTENT_SELECTED_INDEX, null, null);
                return;
            }
            throw new NoSuchElementException();
        }

        public void previousPanel() {
            this.stopListening();
            if (this.array[this.active].hasPrevious()) {
                this.array[this.active].previousPanel();
                this.startListening();
                this.propertyChangeSupport.firePropertyChange(WizardFolder.PROP_CONTENT_SELECTED_INDEX, null, null);
                return;
            }
            if (this.active > 0) {
                --this.active;
                this.startListening();
                this.propertyChangeSupport.firePropertyChange(WizardFolder.PROP_CONTENT_SELECTED_INDEX, null, null);
                return;
            }
            throw new NoSuchElementException();
        }

        public void removeChangeListener(ChangeListener l) {
            this.listener = null;
            for (int i = 0; i < this.array.length; ++i) {
                this.array[i].removeChangeListener(l);
            }
        }

        private String[] getContentDataAt(int i) {
            String[] cd = null;
            if (this.array[i] instanceof CompoundIterator) {
                cd = ((CompoundIterator)this.array[i]).getContentData();
                if (cd == null) {
                    cd = (String[])this.contentMap.get(this.array[i]);
                }
                if (cd == null) {
                    cd = new String[]{};
                }
            } else {
                Object property;
                Component c = this.array[i].current().getComponent();
                if (c instanceof JComponent && (property = ((JComponent)c).getClientProperty(WizardFolder.PROP_CONTENT_DATA)) instanceof String[]) {
                    cd = (String[])property;
                }
                if (cd == null) {
                    cd = (String[])this.contentMap.get(this.array[i]);
                }
                if (cd == null) {
                    cd = new String[]{};
                }
            }
            this.contentMap.put(this.array[i], cd);
            return cd;
        }

        public Object setIteratorAt(int position, WizardDescriptor.Iterator it) {
            if (position == this.active) {
                return null;
            }
            if (it == null) {
                this.contentMap.remove(this.array[position]);
                WizardDescriptor.Iterator[] buf = new WizardDescriptor.Iterator[this.array.length - 1];
                System.arraycopy(this.array, 0, buf, 0, this.array.length - 1);
                this.array = buf;
                return it;
            }
            this.array[position] = it;
            this.contentMap.put(it, this.getContentDataAt(position));
            return it;
        }

        public void addIterator(WizardDescriptor.Iterator it) {
            if (it != null) {
                WizardDescriptor.Iterator[] buf = new WizardDescriptor.Iterator[this.array.length + 1];
                System.arraycopy(this.array, 0, buf, 0, this.array.length);
                buf[this.array.length] = it;
                this.array = buf;
                this.contentMap.put(it, this.getContentDataAt(this.array.length - 1));
            }
        }

        public boolean removeIterator(WizardDescriptor.Iterator it) {
            if (it == null) {
                return false;
            }
            for (int i = 0; i < this.array.length; ++i) {
                boolean ret;
                if (it == this.array[i] && this.active != i) {
                    WizardDescriptor.Iterator[] buf = new WizardDescriptor.Iterator[this.array.length - 1];
                    System.arraycopy(this.array, 0, buf, 0, i);
                    System.arraycopy(this.array, i + 1, buf, i, buf.length - i);
                    this.array = buf;
                    this.contentMap.remove(it);
                    return true;
                }
                if (!(this.array[i] instanceof CompoundIterator) || !(ret = ((CompoundIterator)this.array[i]).removeIterator(it))) continue;
                return true;
            }
            return false;
        }

        public int size() {
            return this.array.length;
        }

        public String[] getContentData() {
            String[] cData = new String[]{};
            for (int i = 0; i < this.array.length; ++i) {
                String[] cd = this.getContentDataAt(i);
                String[] buf = new String[cData.length + cd.length];
                System.arraycopy(cData, 0, buf, 0, cData.length);
                System.arraycopy(cd, 0, buf, cData.length, cd.length);
                cData = buf;
            }
            return cData;
        }

        public int getContentSelectedIndex() {
            int seg = 0;
            for (int i = 0; i < this.active; ++i) {
                seg += this.getContentDataAt(i).length;
            }
            if (this.array[this.active] instanceof CompoundIterator) {
                return seg + ((CompoundIterator)this.array[this.active]).getContentSelectedIndex();
            }
            Component c = this.array[this.active].current().getComponent();
            if (c instanceof JComponent) {
                int off;
                Object property = ((JComponent)c).getClientProperty(WizardFolder.PROP_CONTENT_SELECTED_INDEX);
                if (property instanceof Integer && (off = ((Integer)property).intValue()) >= 0 && off < this.getContentDataAt(this.active).length) {
                    return seg + off;
                }
                return -1;
            }
            return seg;
        }

        public void addPropertyChangeListener(PropertyChangeListener pcl) {
            this.propertyChangeSupport.addPropertyChangeListener(pcl);
        }

        public void removePropertyChangeListener(PropertyChangeListener pcl) {
            this.propertyChangeSupport.removePropertyChangeListener(pcl);
        }

        private void startListening() {
            if (this.array[this.active] instanceof CompoundIterator) {
                ((CompoundIterator)this.array[this.active]).addPropertyChangeListener(this);
            } else if (this.array[this.active].current().getComponent() instanceof JComponent) {
                ((JComponent)this.array[this.active].current().getComponent()).addPropertyChangeListener(this);
            }
        }

        private void stopListening() {
            if (this.array[this.active] instanceof CompoundIterator) {
                ((CompoundIterator)this.array[this.active]).removePropertyChangeListener(this);
            } else if (this.array[this.active].current().getComponent() instanceof JComponent) {
                ((JComponent)this.array[this.active].current().getComponent()).removePropertyChangeListener(this);
            }
        }

        public void propertyChange(PropertyChangeEvent ev) {
            this.propertyChangeSupport.firePropertyChange(ev.getPropertyName(), null, null);
        }
    }

    private static class AWTTask
    extends Task {
        private boolean executed;

        public AWTTask(Runnable r) {
            super(r);
            Mutex.EVENT.readAccess((Runnable)((Object)this));
        }

        public void run() {
            if (!this.executed) {
                super.run();
                this.executed = true;
            }
        }

        public void waitFinished() {
            if (SwingUtilities.isEventDispatchThread()) {
                this.run();
            } else {
                super.waitFinished();
            }
        }
    }
}

