/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyEditor;
import java.beans.PropertyEditorManager;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.UIManager;
import org.netbeans.core.IDESettings;
import org.openide.ErrorManager;
import org.openide.WizardDescriptor;
import org.openide.awt.HtmlBrowser;
import org.openide.awt.Mnemonics;
import org.openide.util.AsyncGUIJob;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

class IDESettingsPanel
extends JPanel
implements PropertyChangeListener {
    private static final String PROP_CONTENT_SELECTED_INDEX = "WizardPanel_contentSelectedIndex";
    private static final String PROP_CONTENT_DATA = "WizardPanel_contentData";
    private ResourceBundle bundle = NbBundle.getBundle((Class)IDESettingsPanel.class);
    private IDESettings settings = null;
    private InitData initData;
    private static final String detectedProxy;
    private Dimension prefSize = null;
    private JRadioButton autoDetectProxy;
    private JComboBox browserComboBox;
    private JLabel browserLabel;
    private JRadioButton directConnection;
    private JTextArea helpTextArea;
    private JLabel hostLabel;
    private JTextField hostTextField;
    private JTextArea jTextArea1;
    private JTextArea jTextArea2;
    private JRadioButton manualProxy;
    private JLabel mdiIcon;
    private JRadioButton mdiRadioButton;
    private JLabel portLabel;
    private JTextField portTextField;
    private ButtonGroup proxyChoiceButtons;
    private JLabel proxyLabel;
    private JPanel proxySettingPanel;
    private JLabel sdiIcon;
    private JRadioButton sdiRadioButton;
    private JLabel windowLabel;
    private int uiMode;
    private PropertyEditor editor;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$org$openide$awt$HtmlBrowser$Factory;

    public IDESettingsPanel() {
        this.initComponents();
        String string = this.bundle.getString("LBL_UseProxyServer");
        string = this.bundle.getString("LBL_SDI");
        this.sdiRadioButton.setText(new StringBuffer(string.length() + 1).append(' ').append(string).toString());
        string = this.bundle.getString("LBL_MDI");
        this.mdiRadioButton.setText(new StringBuffer(string.length() + 1).append(' ').append(string).toString());
        this.sdiRadioButton.setMnemonic(this.bundle.getString("LBL_SDI_Mnemonic").charAt(0));
        this.mdiRadioButton.setMnemonic(this.bundle.getString("LBL_MDI_Mnemonic").charAt(0));
        ButtonGroup bg = new ButtonGroup();
        bg.add(this.mdiRadioButton);
        bg.add(this.sdiRadioButton);
        this.putClientProperty(PROP_CONTENT_SELECTED_INDEX, new Integer(0));
        this.putClientProperty(PROP_CONTENT_DATA, new String[]{this.getName()});
        this.initAccessibility();
        Utilities.attachInitJob((Component)this, (AsyncGUIJob)new AsyncGUIJobImpl());
    }

    private static Font fetchFont(String key) {
        Font f = UIManager.getFont(key);
        if (f == null && (f = UIManager.getFont("controlFont")) == null) {
            f = new Font("Dialog", 0, 11);
        }
        return f;
    }

    private static Color fetchColor(String key, Color fallback) {
        Color result = UIManager.getColor(key);
        if (result == null) {
            result = fallback;
        }
        return result;
    }

    public Dimension getPreferredSize() {
        if (this.prefSize == null) {
            this.prefSize = new Dimension(super.getPreferredSize());
            this.prefSize.width += 100;
            this.prefSize.height += 50;
        }
        return this.prefSize;
    }

    private void initComponents() {
        this.proxyChoiceButtons = new ButtonGroup();
        this.sdiRadioButton = new JRadioButton();
        this.mdiRadioButton = new JRadioButton();
        this.windowLabel = new JLabel();
        this.browserLabel = new JLabel();
        this.browserComboBox = new JComboBox();
        this.helpTextArea = new JTextArea();
        this.sdiIcon = new JLabel();
        this.mdiIcon = new JLabel();
        this.jTextArea1 = new JTextArea();
        this.proxyLabel = new JLabel();
        this.jTextArea2 = new JTextArea();
        this.proxySettingPanel = new JPanel();
        this.hostLabel = new JLabel();
        this.portLabel = new JLabel();
        this.portTextField = new JTextField();
        this.hostTextField = new JTextField();
        this.directConnection = new JRadioButton();
        this.autoDetectProxy = new JRadioButton();
        this.manualProxy = new JRadioButton();
        this.proxyChoiceButtons.add(this.directConnection);
        this.proxyChoiceButtons.add(this.autoDetectProxy);
        this.proxyChoiceButtons.add(this.manualProxy);
        this.setLayout(new GridBagLayout());
        this.setName(this.bundle.getString("LBL_IDEPanelName"));
        this.sdiRadioButton.setMargin(new Insets(0, 2, 0, 2));
        this.sdiRadioButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                IDESettingsPanel.this.changeWindowMode(evt);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 72, 6, 0);
        this.add((Component)this.sdiRadioButton, gridBagConstraints);
        this.mdiRadioButton.setMargin(new Insets(0, 2, 0, 2));
        this.mdiRadioButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                IDESettingsPanel.this.changeWindowMode(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 12, 6, 0);
        this.add((Component)this.mdiRadioButton, gridBagConstraints);
        Mnemonics.setLocalizedText((JLabel)this.windowLabel, (String)this.bundle.getString("LBL_WindowMode"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        this.add((Component)this.windowLabel, gridBagConstraints);
        this.browserLabel.setLabelFor(this.browserComboBox);
        Mnemonics.setLocalizedText((JLabel)this.browserLabel, (String)NbBundle.getMessage((Class)IDESettingsPanel.class, (String)"CTL_BrowserLabel"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 5, 12);
        this.add((Component)this.browserLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 5, 160);
        this.add((Component)this.browserComboBox, gridBagConstraints);
        this.helpTextArea.setBackground(IDESettingsPanel.fetchColor("Panel.background", this.getBackground()));
        this.helpTextArea.setColumns(53);
        this.helpTextArea.setEditable(false);
        this.helpTextArea.setFont(IDESettingsPanel.fetchFont("Label.font"));
        this.helpTextArea.setLineWrap(true);
        this.helpTextArea.setRows(4);
        this.helpTextArea.setText(NbBundle.getMessage((Class)IDESettingsPanel.class, (String)"CTL_HelpTextArea"));
        this.helpTextArea.setWrapStyleWord(true);
        this.helpTextArea.setDisabledTextColor(IDESettingsPanel.fetchColor("textText", Color.BLACK));
        this.helpTextArea.setEnabled(false);
        this.helpTextArea.setOpaque(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(0, 12, 24, 0);
        this.add((Component)this.helpTextArea, gridBagConstraints);
        this.sdiIcon.setLabelFor(this.sdiRadioButton);
        this.sdiIcon.setMinimumSize(new Dimension(99, 77));
        this.sdiIcon.setPreferredSize(new Dimension(99, 77));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 96, 24, 0);
        this.add((Component)this.sdiIcon, gridBagConstraints);
        this.mdiIcon.setLabelFor(this.mdiRadioButton);
        this.mdiIcon.setMinimumSize(new Dimension(99, 77));
        this.mdiIcon.setPreferredSize(new Dimension(99, 77));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 36, 24, 0);
        this.add((Component)this.mdiIcon, gridBagConstraints);
        this.jTextArea1.setBackground(IDESettingsPanel.fetchColor("Panel.background", this.getBackground()));
        this.jTextArea1.setColumns(30);
        this.jTextArea1.setEditable(false);
        this.jTextArea1.setFont(IDESettingsPanel.fetchFont("Label.font"));
        this.jTextArea1.setLineWrap(true);
        this.jTextArea1.setRows(1);
        this.jTextArea1.setText(NbBundle.getMessage((Class)IDESettingsPanel.class, (String)"LBL_Head"));
        this.jTextArea1.setWrapStyleWord(true);
        this.jTextArea1.setDisabledTextColor(IDESettingsPanel.fetchColor("textText", Color.BLACK));
        this.jTextArea1.setEnabled(false);
        this.jTextArea1.setOpaque(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 0, 12, 0);
        this.add((Component)this.jTextArea1, gridBagConstraints);
        Mnemonics.setLocalizedText((JLabel)this.proxyLabel, (String)this.bundle.getString("LBL_WebProxy"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        this.add((Component)this.proxyLabel, gridBagConstraints);
        this.jTextArea2.setBackground(IDESettingsPanel.fetchColor("Panel.background", this.getBackground()));
        this.jTextArea2.setColumns(53);
        this.jTextArea2.setEditable(false);
        this.jTextArea2.setFont(IDESettingsPanel.fetchFont("Label.font"));
        this.jTextArea2.setLineWrap(true);
        this.jTextArea2.setRows(3);
        this.jTextArea2.setText(NbBundle.getMessage((Class)IDESettingsPanel.class, (String)"LBL_ProxyDesc"));
        this.jTextArea2.setWrapStyleWord(true);
        this.jTextArea2.setDisabledTextColor(IDESettingsPanel.fetchColor("textText", Color.BLACK));
        this.jTextArea2.setEnabled(false);
        this.jTextArea2.setOpaque(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 11;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(0, 8, 2, 0);
        this.add((Component)this.jTextArea2, gridBagConstraints);
        this.proxySettingPanel.setLayout(new GridBagLayout());
        this.hostLabel.setLabelFor(this.hostTextField);
        Mnemonics.setLocalizedText((JLabel)this.hostLabel, (String)NbBundle.getBundle((Class)IDESettingsPanel.class).getString("LBL_Server_Name"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 8, 0);
        this.proxySettingPanel.add((Component)this.hostLabel, gridBagConstraints);
        this.hostLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle((Class)IDESettingsPanel.class).getString("ACD_hostLabel"));
        this.portLabel.setLabelFor(this.portTextField);
        Mnemonics.setLocalizedText((JLabel)this.portLabel, (String)NbBundle.getBundle((Class)IDESettingsPanel.class).getString("LBL_Port"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.anchor = 17;
        this.proxySettingPanel.add((Component)this.portLabel, gridBagConstraints);
        this.portLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle((Class)IDESettingsPanel.class).getString("ACD_portLabel"));
        this.portTextField.addFocusListener(new FocusAdapter(){

            public void focusGained(FocusEvent evt) {
                IDESettingsPanel.this.portTextFieldFocusGained(evt);
            }

            public void focusLost(FocusEvent evt) {
                IDESettingsPanel.this.portTextFieldFocusLost(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.ipadx = 50;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 8, 0, 0);
        this.proxySettingPanel.add((Component)this.portTextField, gridBagConstraints);
        this.hostTextField.addFocusListener(new FocusAdapter(){

            public void focusGained(FocusEvent evt) {
                IDESettingsPanel.this.hostTextFieldFocusGained(evt);
            }

            public void focusLost(FocusEvent evt) {
                IDESettingsPanel.this.hostTextFieldFocusLost(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.ipadx = 200;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 8, 8, 0);
        this.proxySettingPanel.add((Component)this.hostTextField, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 28, 6, 24);
        this.add((Component)this.proxySettingPanel, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.directConnection, (String)NbBundle.getBundle((Class)IDESettingsPanel.class).getString("BTN_directConnection"));
        this.directConnection.setToolTipText(NbBundle.getMessage((Class)IDESettingsPanel.class, (String)"TT_IDESettings_directConnection", (Object[])new Object[0]));
        this.directConnection.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                IDESettingsPanel.this.directConnectionActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 8, 0, 0);
        this.add((Component)this.directConnection, gridBagConstraints);
        this.directConnection.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle((Class)IDESettingsPanel.class).getString("ACD_directConnection"));
        Mnemonics.setLocalizedText((AbstractButton)this.autoDetectProxy, (String)NbBundle.getBundle((Class)IDESettingsPanel.class).getString("BTN_autoDetectProxy"));
        this.autoDetectProxy.setToolTipText(NbBundle.getMessage((Class)IDESettingsPanel.class, (String)"TT_IDESettings_autoDetectProxy", (Object[])new Object[]{detectedProxy == null || detectedProxy.length() == 0 ? NbBundle.getMessage((Class)IDESettingsPanel.class, (String)"MSG_ProxyDialog_ProxyNotFound") : detectedProxy}));
        this.autoDetectProxy.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                IDESettingsPanel.this.autoDetectProxyActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 8, 0, 0);
        this.add((Component)this.autoDetectProxy, gridBagConstraints);
        this.autoDetectProxy.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle((Class)IDESettingsPanel.class).getString("ACD_autoDetectProxy"));
        Mnemonics.setLocalizedText((AbstractButton)this.manualProxy, (String)NbBundle.getBundle((Class)IDESettingsPanel.class).getString("BTN_manualProxy"));
        this.manualProxy.setToolTipText(NbBundle.getMessage((Class)IDESettingsPanel.class, (String)"TT_IDESettings_manualProxy", (Object[])new Object[0]));
        this.manualProxy.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                IDESettingsPanel.this.manualProxyActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 8, 0, 0);
        this.add((Component)this.manualProxy, gridBagConstraints);
        this.manualProxy.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle((Class)IDESettingsPanel.class).getString("ACD_manualProxy"));
    }

    private void hostTextFieldFocusLost(FocusEvent evt) {
        this.hostTextField.select(0, 0);
    }

    private void portTextFieldFocusLost(FocusEvent evt) {
        this.portTextField.select(0, 0);
    }

    private void hostTextFieldFocusGained(FocusEvent evt) {
        this.hostTextField.selectAll();
    }

    private void portTextFieldFocusGained(FocusEvent evt) {
        this.portTextField.selectAll();
    }

    private void manualProxyActionPerformed(ActionEvent evt) {
        if (((JRadioButton)evt.getSource()).isSelected()) {
            this.setProxyType(2);
            this.hostTextField.requestFocus();
        }
    }

    private void autoDetectProxyActionPerformed(ActionEvent evt) {
        if (((JRadioButton)evt.getSource()).isSelected()) {
            this.setProxyType(1);
        }
    }

    private void directConnectionActionPerformed(ActionEvent evt) {
        if (((JRadioButton)evt.getSource()).isSelected()) {
            this.setProxyType(0);
        }
    }

    private void changeWindowMode(ActionEvent evt) {
        this.uiMode = evt.getSource() == this.mdiRadioButton ? 2 : 1;
    }

    public void initFromSettings(WizardDescriptor wd) {
        wd.addPropertyChangeListener((PropertyChangeListener)this);
        if (Boolean.TRUE.equals(wd.getProperty("initializePanel"))) {
            this.initializePanel();
        }
    }

    private void initializePanel() {
        Utilities.attachInitJob((Component)this, (AsyncGUIJob)new AsyncGUIJobImpl());
        this.settings = (IDESettings)IDESettings.findObject((Class)IDESettings.class, (boolean)true);
        this.uiMode = this.settings.getUIMode();
        this.sdiRadioButton.setSelected(this.uiMode == 1);
        this.mdiRadioButton.setSelected(this.uiMode == 2);
        this.browserLabel.setDisplayedMnemonic(this.bundle.getString("CTL_BrowserLabel_mnemonic").charAt(0));
        try {
            this.setProxyType(this.settings.getProxyType());
            this.hostTextField.setText(this.settings.getUserProxyHost());
            this.portTextField.setText(this.settings.getUserProxyPort());
            this.putClientProperty("PostInit", this);
        }
        catch (RuntimeException ex) {
            ErrorManager.getDefault().notify((Throwable)ex);
        }
    }

    private void setProxyType(int proxyType) {
        switch (proxyType) {
            case 0: {
                this.directConnection.setSelected(true);
                this.proxySettingPanel.setEnabled(false);
                this.hostTextField.setEnabled(false);
                this.portTextField.setEnabled(false);
                this.hostLabel.setEnabled(false);
                this.portLabel.setEnabled(false);
                break;
            }
            case 1: {
                this.autoDetectProxy.setSelected(true);
                this.proxySettingPanel.setEnabled(false);
                this.hostTextField.setEnabled(false);
                this.portTextField.setEnabled(false);
                this.hostLabel.setEnabled(false);
                this.portLabel.setEnabled(false);
                break;
            }
            case 2: {
                this.manualProxy.setSelected(true);
                this.proxySettingPanel.setEnabled(true);
                this.hostTextField.setEnabled(true);
                this.portTextField.setEnabled(true);
                this.hostLabel.setEnabled(true);
                this.portLabel.setEnabled(true);
                break;
            }
            default: {
                if (!$assertionsDisabled) {
                    throw new AssertionError((Object)("Unknown proxy type: " + proxyType));
                }
                break;
            }
        }
    }

    private int getProxyType() {
        if (this.directConnection.isSelected()) {
            return 0;
        }
        if (this.autoDetectProxy.isSelected()) {
            return 1;
        }
        if (this.manualProxy.isSelected()) {
            return 2;
        }
        if (!$assertionsDisabled) {
            throw new AssertionError((Object)"Any button must be selected");
        }
        return 1;
    }

    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getSource() instanceof WizardDescriptor && "value".equals(evt.getPropertyName())) {
            WizardDescriptor wd = (WizardDescriptor)evt.getSource();
            if (wd.getValue() == WizardDescriptor.FINISH_OPTION) {
                wd.removePropertyChangeListener((PropertyChangeListener)this);
                IDESettings settings = (IDESettings)IDESettings.findObject((Class)IDESettings.class, (boolean)true);
                settings.setUserProxyHost(this.hostTextField.getText());
                settings.setUserProxyPort(this.portTextField.getText());
                settings.setProxyType(this.getProxyType());
                settings.setUIMode(this.uiMode);
                if (this.editor != null) {
                    try {
                        Object o = this.browserComboBox.getSelectedItem();
                        if (o instanceof String && o != null) {
                            this.editor.setAsText((String)o);
                            settings.setWWWBrowser((HtmlBrowser.Factory)this.editor.getValue());
                        }
                    }
                    catch (RuntimeException ex) {
                        ErrorManager.getDefault().notify((Throwable)ex);
                    }
                }
            }
        }
    }

    private void initAccessibility() {
        this.getAccessibleContext().setAccessibleDescription(this.bundle.getString("ACSD_IDESettingsPanel"));
        this.browserComboBox.getAccessibleContext().setAccessibleDescription(this.helpTextArea.getText());
        this.sdiRadioButton.getAccessibleContext().setAccessibleDescription(this.bundle.getString("ACSD_sdiRadioButton"));
        this.mdiRadioButton.getAccessibleContext().setAccessibleDescription(this.bundle.getString("ACSD_mdiRadioButton"));
    }

    static {
        $assertionsDisabled = !IDESettingsPanel.class.desiredAssertionStatus();
        detectedProxy = System.getProperty("netbeans.system_http_proxy");
    }

    private class AsyncGUIJobImpl
    implements AsyncGUIJob {
        PropertyEditor initEditor;
        ComboBoxModel initComboModel;
        Icon initSdiIcon;
        Icon initMdiIcon;

        private AsyncGUIJobImpl() {
        }

        public void construct() {
            this.initEditor = PropertyEditorManager.findEditor(class$org$openide$awt$HtmlBrowser$Factory == null ? (class$org$openide$awt$HtmlBrowser$Factory = IDESettingsPanel.class$("org.openide.awt.HtmlBrowser$Factory")) : class$org$openide$awt$HtmlBrowser$Factory);
            this.initEditor.setValue(((IDESettings)IDESettings.findObject((Class)(class$org$netbeans$core$IDESettings == null ? (class$org$netbeans$core$IDESettings = IDESettingsPanel.class$("org.netbeans.core.IDESettings")) : class$org$netbeans$core$IDESettings), (boolean)true)).getWWWBrowser());
            this.initComboModel = new DefaultComboBoxModel<String>(this.initEditor.getTags());
            this.initSdiIcon = new ImageIcon(Utilities.loadImage((String)"org/netbeans/core/resources/sdi.gif"));
            this.initMdiIcon = new ImageIcon(Utilities.loadImage((String)"org/netbeans/core/resources/mdi.gif"));
        }

        public void finished() {
            IDESettingsPanel.this.editor = this.initEditor;
            IDESettingsPanel.this.sdiIcon.setIcon(this.initSdiIcon);
            IDESettingsPanel.this.mdiIcon.setIcon(this.initMdiIcon);
            IDESettingsPanel.this.browserComboBox.setModel(this.initComboModel);
            IDESettingsPanel.this.browserComboBox.setSelectedItem(this.initEditor.getAsText());
        }
    }

    private static final class InitData {
        PropertyEditor editor;
        ComboBoxModel comboModel;
        Icon sdiIcon;
        Icon mdiIcon;

        private InitData() {
        }
    }
}

