/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.filesystems;

import java.beans.PropertyVetoException;
import java.io.File;
import java.io.IOException;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import org.openide.ErrorManager;
import org.openide.filesystems.FileChangeAdapter;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileRenameEvent;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.JarFileSystem;
import org.openide.filesystems.Repository;
import org.openide.filesystems.URLMapper;

public class ArchiveURLMapper
extends URLMapper {
    private static final String JAR_PROTOCOL = "jar";
    private static ArchiveURLMapper instance;
    private static Map mountRoots;
    static final /* synthetic */ boolean $assertionsDisabled;

    public URL getURL(FileObject fo, int type) {
        if (!$assertionsDisabled && fo == null) {
            throw new AssertionError();
        }
        if ((type == 1 || type == 0) && fo.isValid()) {
            try {
                FileSystem fs = fo.getFileSystem();
                if (fs instanceof JarFileSystem) {
                    JarFileSystem jfs = (JarFileSystem)fs;
                    File archiveFile = jfs.getJarFile();
                    if (ArchiveURLMapper.isRoot(archiveFile)) {
                        return new URL("jar:" + archiveFile.toURI() + "!/" + fo.getPath() + (fo.isFolder() && !fo.isRoot() ? "/" : ""));
                    }
                }
            }
            catch (IOException e) {
                ErrorManager.getDefault().notify((Throwable)e);
            }
        }
        return null;
    }

    public FileObject[] getFileObjects(URL url) {
        String path;
        int index;
        if (!$assertionsDisabled && url == null) {
            throw new AssertionError();
        }
        String protocol = url.getProtocol();
        if (JAR_PROTOCOL.equals(protocol) && (index = (path = url.getPath()).lastIndexOf(33)) >= 0) {
            try {
                URI archiveFileURI = new URI(path.substring(0, index));
                if (!archiveFileURI.isAbsolute() || archiveFileURI.isOpaque()) {
                    return null;
                }
                FileObject fo = URLMapper.findFileObject((URL)archiveFileURI.toURL());
                if (fo == null || fo.isVirtual()) {
                    return null;
                }
                File archiveFile = FileUtil.toFile((FileObject)fo);
                if (archiveFile == null) {
                    return null;
                }
                String offset = path.length() > index + 2 ? URLDecoder.decode(path.substring(index + 2), "UTF-8") : "";
                JarFileSystem fs = ArchiveURLMapper.getFileSystem(archiveFile);
                FileObject resource = fs.findResource(offset);
                if (resource != null) {
                    return new FileObject[]{resource};
                }
            }
            catch (IOException e) {
                ErrorManager.getDefault().log(16, e.getLocalizedMessage());
            }
            catch (URISyntaxException e) {
                ErrorManager.getDefault().notify((Throwable)e);
            }
        }
        return null;
    }

    public static FileObject getArchiveRoot(FileObject fo) throws IOException {
        if (fo.isVirtual()) {
            return null;
        }
        File file = FileUtil.toFile((FileObject)fo);
        return ArchiveURLMapper.getFileSystem(file).getRoot();
    }

    private static synchronized boolean isRoot(File file) {
        return mountRoots.containsKey(file);
    }

    private static synchronized JarFileSystem getFileSystem(File file) throws IOException {
        Reference reference = (Reference)mountRoots.get(file);
        JarFileSystem jfs = null;
        if (reference == null || (jfs = (JarFileSystem)reference.get()) == null) {
            jfs = ArchiveURLMapper.findJarFileSystemInRepository(file);
            if (jfs == null) {
                try {
                    jfs = new JarFileSystem();
                    File aRoot = FileUtil.normalizeFile((File)file);
                    jfs.setJarFile(aRoot);
                }
                catch (PropertyVetoException pve) {
                    throw new AssertionError((Object)pve);
                }
            }
            mountRoots.put(file, new JFSReference(jfs));
        }
        return jfs;
    }

    private static JarFileSystem findJarFileSystemInRepository(File jarFile) {
        Enumeration en = Repository.getDefault().getFileSystems();
        while (en.hasMoreElements()) {
            JarFileSystem jfs;
            FileSystem fs = (FileSystem)en.nextElement();
            if (!(fs instanceof JarFileSystem) || !jarFile.equals((jfs = (JarFileSystem)fs).getJarFile())) continue;
            return jfs;
        }
        return null;
    }

    static {
        $assertionsDisabled = !ArchiveURLMapper.class.desiredAssertionStatus();
        mountRoots = new HashMap();
    }

    private static class JFSReference
    extends SoftReference {
        private FileChangeListener fcl;

        public JFSReference(JarFileSystem jfs) {
            super(jfs);
            File root = jfs.getJarFile();
            FileObject rootFo = FileUtil.toFileObject((File)root);
            if (rootFo != null) {
                this.fcl = new FileChangeAdapter(this, root){
                    private final /* synthetic */ File val$root;
                    private final /* synthetic */ JFSReference this$0;
                    {
                        this.this$0 = this$0;
                        this.val$root = val$root;
                    }

                    public void fileDeleted(FileEvent fe) {
                        this.this$0.releaseMe(this.val$root);
                    }

                    public void fileRenamed(FileRenameEvent fe) {
                        this.this$0.releaseMe(this.val$root);
                    }
                };
                rootFo.addFileChangeListener(FileUtil.weakFileChangeListener((FileChangeListener)this.fcl, (Object)rootFo));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void releaseMe(File root) {
            JarFileSystem jfs = (JarFileSystem)this.get();
            if (jfs != null) {
                Class clazz = class$org$netbeans$core$filesystems$ArchiveURLMapper == null ? (class$org$netbeans$core$filesystems$ArchiveURLMapper = ArchiveURLMapper.class$("org.netbeans.core.filesystems.ArchiveURLMapper")) : class$org$netbeans$core$filesystems$ArchiveURLMapper;
                synchronized (clazz) {
                    File keyToRemove = root != null ? root : jfs.getJarFile();
                    mountRoots.remove(keyToRemove);
                }
            }
        }
    }
}

