/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core;

import java.awt.event.KeyEvent;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Properties;
import javax.swing.Action;
import javax.swing.KeyStroke;
import javax.swing.text.Keymap;
import org.netbeans.core.NbKeymap;
import org.netbeans.core.NbPlaces;
import org.openide.ErrorManager;
import org.openide.awt.Actions;
import org.openide.cookies.InstanceCookie;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.Repository;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataShadow;
import org.openide.loaders.FolderInstance;
import org.openide.loaders.InstanceDataObject;
import org.openide.loaders.XMLDataObject;
import org.openide.util.Lookup;
import org.openide.util.Mutex;
import org.openide.util.Utilities;
import org.openide.util.actions.SystemAction;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

final class ShortcutsFolder
extends FolderInstance {
    static ShortcutsFolder shortcutsFolder = null;
    public static final String PROPERTIES_FILE = "Shortcuts";
    public static final String DEFAULT_KEYS_FILE = "Default";
    public static final String USER_KEYS_FILE = "UserDefined";
    private static final String KEYS_EXT = "keys";
    private static final String SHORTCUTS_FOLDER = "Shortcuts";
    private static final String XML_BINDING = "Binding";
    private static final String ATTR_BINDING_KEY = "key";
    private static final String ATTR_BINDING_ACTION = "action";
    private static final String KEY_ORIGINAL_FILE_PATH = "originalFilePath";
    static /* synthetic */ Class class$java$lang$ClassLoader;
    static /* synthetic */ Class class$org$openide$cookies$InstanceCookie;

    ShortcutsFolder(DataFolder f) {
        super(f);
        this.recreate();
    }

    protected Object createInstance(InstanceCookie[] cookies) throws IOException, ClassNotFoundException {
        HashMap<KeyStroke, Action> map = new HashMap<KeyStroke, Action>(80);
        for (int i = 0; i < cookies.length; ++i) {
            String keyname = cookies[i].instanceName();
            KeyStroke stroke = Utilities.stringToKey((String)keyname);
            if (stroke == null) {
                ErrorManager.getDefault().getInstance("org.netbeans.core.ShortcutsFolder").log(16, "Warning: unparsable keystroke: " + keyname);
                continue;
            }
            Action action = (Action)cookies[i].instanceCreate();
            map.put(stroke, action);
        }
        Keymap globalMap = (Keymap)Lookup.getDefault().lookup(Keymap.class);
        globalMap.removeBindings();
        if (globalMap instanceof NbKeymap) {
            ((NbKeymap)globalMap).addActionForKeyStrokeMap(map);
        } else {
            Iterator it = map.keySet().iterator();
            while (it.hasNext()) {
                KeyStroke key = (KeyStroke)it.next();
                globalMap.addActionForKeyStroke(key, (Action)map.get(key));
            }
        }
        return null;
    }

    protected InstanceCookie acceptDataObject(final DataObject dob) {
        InstanceCookie ic = super.acceptDataObject(dob);
        if (ic != null) {
            try {
                final Object o = ic.instanceCreate();
                if (o instanceof Action) {
                    if (dob instanceof DataShadow) {
                        Mutex.EVENT.writeAccess(new Runnable(){

                            public void run() {
                                ((Action)o).putValue(ShortcutsFolder.KEY_ORIGINAL_FILE_PATH, ((DataShadow)dob).getOriginal().getPrimaryFile().getPath());
                            }
                        });
                    }
                    KeyActionPair pair = new KeyActionPair(dob.getName(), (Action)o);
                    return pair;
                }
            }
            catch (IOException x) {
                ErrorManager.getDefault().notify(1, (Throwable)x);
            }
            catch (ClassNotFoundException x) {
                ErrorManager.getDefault().notify(1, (Throwable)x);
            }
        }
        return null;
    }

    static String getKeyStrokeName(KeyStroke stroke) {
        Keymap map = (Keymap)Lookup.getDefault().lookup(Keymap.class);
        Action action = map.getAction(stroke);
        if (action != null) {
            return ShortcutsFolder.getKeyText(stroke) + " [" + ShortcutsFolder.getActionBasicName(action) + "]";
        }
        return ShortcutsFolder.getKeyText(stroke);
    }

    private static String getActionBasicName(Action action) {
        String name = (String)action.getValue("Name");
        if (name == null) {
            return "???";
        }
        name = Actions.cutAmpersand((String)name);
        return Utilities.replaceString((String)name, (String)"...", (String)"");
    }

    static String getActionName(Action action) {
        String name = ShortcutsFolder.getActionBasicName(action);
        Keymap map = (Keymap)Lookup.getDefault().lookup(Keymap.class);
        KeyStroke[] strokes = map.getKeyStrokesForAction(action);
        if (strokes.length > 0) {
            name = name + " [";
            for (int i = 0; i < strokes.length; ++i) {
                name = name + ShortcutsFolder.getKeyText(strokes[i]);
                if (i == strokes.length - 1) continue;
                name = name + ", ";
            }
            return name + "]";
        }
        return name;
    }

    static String getKeyText(int keyCode, int modifiers) {
        String modifText = KeyEvent.getKeyModifiersText(modifiers);
        if ("".equals(modifText)) {
            return KeyEvent.getKeyText(keyCode);
        }
        if (keyCode == 18 || keyCode == 65406 || keyCode == 17 || keyCode == 16) {
            return modifText + "+";
        }
        return modifText + "+" + KeyEvent.getKeyText(keyCode);
    }

    static String getKeyText(KeyStroke stroke) {
        if (stroke == null) {
            return "";
        }
        String modifText = KeyEvent.getKeyModifiersText(stroke.getModifiers());
        if ("".equals(modifText)) {
            return KeyEvent.getKeyText(stroke.getKeyCode());
        }
        return modifText + "+" + KeyEvent.getKeyText(stroke.getKeyCode());
    }

    static Document parseKeysFile(URL url) throws SAXException, IOException {
        return XMLDataObject.parse((URL)url, (ErrorHandler)new ErrorHandler(){

            public void error(SAXParseException e) {
            }

            public void warning(SAXParseException e) {
            }

            public void fatalError(SAXParseException e) {
            }
        });
    }

    private static void transformOldFiles() {
        try {
            FileObject propsFO;
            FileObject mainFO;
            FileSystem systemFS = Repository.getDefault().getDefaultFileSystem();
            boolean defaultsUsed = false;
            HashMap<String, FileObject> moduleKeyFiles = new HashMap<String, FileObject>(11);
            FileObject shortcutsFolder = systemFS.getRoot().getFileObject("Shortcuts");
            if (shortcutsFolder == null) {
                shortcutsFolder = FileUtil.createFolder((FileObject)systemFS.getRoot(), (String)"Shortcuts");
            }
            if ((mainFO = shortcutsFolder.getFileObject(USER_KEYS_FILE, KEYS_EXT)) == null) {
                defaultsUsed = true;
                mainFO = shortcutsFolder.getFileObject(DEFAULT_KEYS_FILE, KEYS_EXT);
            }
            FileObject[] files = shortcutsFolder.getChildren();
            for (int i = 0; i < files.length; ++i) {
                String fName = files[i].getName();
                if (!files[i].hasExt(KEYS_EXT) || fName.equals(DEFAULT_KEYS_FILE) || fName.equals(USER_KEYS_FILE)) continue;
                moduleKeyFiles.put(fName, files[i]);
            }
            if (!defaultsUsed && (propsFO = shortcutsFolder.getFileObject("Shortcuts", "properties")) != null) {
                Properties props = new Properties();
                try {
                    props.load(propsFO.getInputStream());
                }
                catch (IOException e) {
                    ErrorManager.getDefault().notify((Throwable)e);
                }
                Enumeration<Object> items = props.keys();
                while (items.hasMoreElements()) {
                    moduleKeyFiles.remove(items.nextElement());
                }
            }
            HashMap allBindings = ShortcutsFolder.processKeysFiles(mainFO, moduleKeyFiles.values());
            ShortcutsFolder.installBindings(allBindings);
        }
        catch (Exception e2) {
            ErrorManager.getDefault().notify((Throwable)e2);
        }
    }

    public static void installBindings(HashMap strokesMap) throws IOException {
        FileObject fo = Repository.getDefault().getDefaultFileSystem().getRoot().getFileObject("Shortcuts");
        DataFolder f = DataFolder.findFolder((FileObject)fo);
        Iterator it = strokesMap.keySet().iterator();
        while (it.hasNext()) {
            Class<?> clazz;
            KeyStroke key = (KeyStroke)it.next();
            Action a = (Action)strokesMap.get(key);
            String name = Utilities.keyToString((KeyStroke)key);
            InstanceDataObject obj = InstanceDataObject.find((DataFolder)f, (String)name, clazz = a.getClass());
            if (obj != null) continue;
            InstanceDataObject.create((DataFolder)f, (String)name, clazz);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static HashMap processKeysFiles(FileObject mainKeysFile, Collection moduleKeysFiles) {
        HashMap bindings = new HashMap(79);
        FileLock lock = null;
        if (mainKeysFile != null) {
            try {
                lock = mainKeysFile.lock();
                ShortcutsFolder.addBindings(ShortcutsFolder.parseKeysFile(mainKeysFile.getURL()), bindings);
                mainKeysFile.delete(lock);
            }
            catch (Exception x) {
                ErrorManager.getDefault().notify((Throwable)x);
            }
            finally {
                lock.releaseLock();
            }
        }
        Iterator it = moduleKeysFiles.iterator();
        while (it.hasNext()) {
            try {
                FileObject fo = (FileObject)it.next();
                lock = fo.lock();
                ShortcutsFolder.addBindings(ShortcutsFolder.parseKeysFile(fo.getURL()), bindings);
                fo.delete(lock);
            }
            catch (Exception x) {
                ErrorManager.getDefault().notify((Throwable)x);
            }
            finally {
                lock.releaseLock();
            }
        }
        return bindings;
    }

    private static void addBindings(Document doc, HashMap map) {
        NodeList nl = doc.getElementsByTagName(XML_BINDING);
        for (int i = 0; i < nl.getLength(); ++i) {
            String act = "<unknown>";
            try {
                String key = nl.item(i).getAttributes().getNamedItem(ATTR_BINDING_KEY).getNodeValue();
                act = nl.item(i).getAttributes().getNamedItem(ATTR_BINDING_ACTION).getNodeValue();
                KeyStroke stroke = Utilities.stringToKey((String)key);
                SystemAction action = SystemAction.get(Class.forName(act, true, (ClassLoader)Lookup.getDefault().lookup(class$java$lang$ClassLoader == null ? ShortcutsFolder.class$("java.lang.ClassLoader") : class$java$lang$ClassLoader)));
                map.put(stroke, action);
                continue;
            }
            catch (ClassNotFoundException cnfe) {
                ErrorManager.getDefault().log(16, "Warning: action " + act + " not found to add key binding for.");
                continue;
            }
            catch (Exception e) {
                ErrorManager.getDefault().notify(1, (Throwable)e);
            }
        }
    }

    public static void initShortcuts() {
        ShortcutsFolder.transformOldFiles();
        NbPlaces.getDefault();
        DataFolder f = NbPlaces.findSessionFolder("Shortcuts");
        shortcutsFolder = new ShortcutsFolder(f);
    }

    public static void refreshGlobalMap() {
        if (shortcutsFolder != null) {
            shortcutsFolder.recreate();
        }
    }

    public static void waitShortcutsFinished() {
        if (shortcutsFolder != null) {
            shortcutsFolder.waitFinished();
        }
    }

    public static void applyChanges(List changes) {
        FileObject fo = Repository.getDefault().getDefaultFileSystem().getRoot().getFileObject("Shortcuts");
        DataFolder f = DataFolder.findFolder((FileObject)fo);
        ListIterator it = changes.listIterator();
        block3: while (it.hasNext()) {
            ChangeRequest r = (ChangeRequest)it.next();
            try {
                Action action = (Action)r.instanceCreate();
                String originalFilePath = (String)action.getValue(KEY_ORIGINAL_FILE_PATH);
                if (originalFilePath == null) {
                    if (r.add) {
                        if (InstanceDataObject.find((DataFolder)f, (String)r.instanceName(), (Class)r.instanceClass()) != null) continue;
                        DataObject actionDO = ShortcutsFolder.findForAction(null, action);
                        if (actionDO != null) {
                            DataShadow shadow = actionDO.createShadow(f);
                            shadow.rename(r.instanceName());
                            continue;
                        }
                        InstanceDataObject.create((DataFolder)f, (String)r.instanceName(), (String)r.instanceCreate().getClass().getName());
                        continue;
                    }
                    String instanceName = r.instanceName();
                    ArrayList<String> arr = new ArrayList<String>();
                    arr.add(instanceName);
                    arr.addAll(Arrays.asList(ShortcutsFolder.getPermutations(instanceName, (Utilities.getOperatingSystem() & 0x1000) != 0)));
                    Iterator iter = arr.iterator();
                    block4: while (iter.hasNext()) {
                        String name = (String)iter.next();
                        DataObject[] ch = f.getChildren();
                        for (int j = 0; j < ch.length; ++j) {
                            if (!ch[j].getName().equals(name)) continue;
                            ch[j].delete();
                            continue block4;
                        }
                    }
                    continue;
                }
                FileObject root = f.getPrimaryFile();
                if (r.add) {
                    FileObject foAdd = root.getFileObject(r.instanceName(), "shadow");
                    if (foAdd == null) {
                        foAdd = FileUtil.createData((FileObject)root, (String)(r.instanceName() + ".shadow"));
                    }
                    foAdd.setAttribute("originalFile", (Object)originalFilePath);
                    continue;
                }
                FileObject foRemove = root.getFileObject(r.instanceName(), "shadow");
                if (foRemove != null) {
                    foRemove.delete();
                }
                String[] permutations = ShortcutsFolder.getPermutations(r.instanceName(), (Utilities.getOperatingSystem() & 0x1000) != 0);
                for (int i = 0; i < permutations.length; ++i) {
                    foRemove = root.getFileObject(permutations[i], "shadow");
                    if (foRemove == null) continue;
                    foRemove.delete();
                    continue block3;
                }
            }
            catch (ClassNotFoundException ex) {
                ErrorManager.getDefault().notify((Throwable)ex);
            }
            catch (IOException ex) {
                ErrorManager.getDefault().notify((Throwable)ex);
            }
        }
    }

    static String[] getPermutations(String name, boolean mac) {
        String[] stringArray;
        String key = mac ? "M" : "C";
        String ctrlWildcard = "D";
        String altKey = mac ? "C" : "A";
        String altWildcard = "O";
        int pos = name.lastIndexOf("-");
        if (pos == -1) {
            return new String[]{name};
        }
        String keyPart = name.substring(pos);
        String modsPart = Utilities.replaceString((String)name.substring(0, pos), (String)"-", (String)"");
        if (modsPart.length() > 1) {
            StringBuffer sb;
            HashSet<String> perms = new HashSet<String>(modsPart.length() * modsPart.length());
            int idx = name.indexOf(key);
            if (idx != -1) {
                sb = new StringBuffer(modsPart);
                sb.replace(idx, idx + 1, ctrlWildcard);
                perms.add(sb.toString() + keyPart);
                ShortcutsFolder.getAllPossibleOrderings(sb.toString(), keyPart, perms);
                ShortcutsFolder.createHyphenatedPermutation(sb.toString().toCharArray(), perms, keyPart);
                idx = name.indexOf(altKey);
                if (idx != -1) {
                    sb.replace(idx, idx + 1, altWildcard);
                    perms.add(sb.toString() + keyPart);
                    ShortcutsFolder.getAllPossibleOrderings(sb.toString(), keyPart, perms);
                    ShortcutsFolder.createHyphenatedPermutation(sb.toString().toCharArray(), perms, keyPart);
                } else {
                    idx = name.indexOf(altWildcard);
                    if (idx != -1) {
                        sb.replace(idx, idx + 1, altKey);
                        perms.add(sb.toString() + keyPart);
                        ShortcutsFolder.getAllPossibleOrderings(sb.toString(), keyPart, perms);
                        ShortcutsFolder.createHyphenatedPermutation(sb.toString().toCharArray(), perms, keyPart);
                    }
                }
            } else {
                idx = name.indexOf(ctrlWildcard);
                if (idx != -1) {
                    sb = new StringBuffer(modsPart);
                    sb.replace(idx, idx + 1, key);
                    perms.add(sb.toString() + keyPart);
                    ShortcutsFolder.getAllPossibleOrderings(sb.toString(), keyPart, perms);
                    ShortcutsFolder.createHyphenatedPermutation(sb.toString().toCharArray(), perms, keyPart);
                    idx = name.indexOf(altKey);
                    if (idx != -1) {
                        sb.replace(idx, idx + 1, altWildcard);
                        perms.add(sb.toString() + keyPart);
                        ShortcutsFolder.getAllPossibleOrderings(sb.toString(), keyPart, perms);
                    } else {
                        idx = name.indexOf(altWildcard);
                        if (idx != -1) {
                            sb.replace(idx, idx + 1, altKey);
                            perms.add(sb.toString() + keyPart);
                            ShortcutsFolder.getAllPossibleOrderings(sb.toString(), keyPart, perms);
                            ShortcutsFolder.createHyphenatedPermutation(sb.toString().toCharArray(), perms, keyPart);
                        }
                    }
                }
            }
            idx = name.indexOf(altKey);
            if (idx != -1) {
                sb = new StringBuffer(modsPart);
                sb.replace(idx, idx + 1, altWildcard);
                perms.add(sb.toString() + keyPart);
                ShortcutsFolder.getAllPossibleOrderings(sb.toString(), keyPart, perms);
                ShortcutsFolder.createHyphenatedPermutation(sb.toString().toCharArray(), perms, keyPart);
            } else {
                sb = new StringBuffer(modsPart);
                idx = name.indexOf(altWildcard);
                if (idx != -1) {
                    sb.replace(idx, idx + 1, altKey);
                    perms.add(sb.toString() + keyPart);
                    ShortcutsFolder.getAllPossibleOrderings(sb.toString(), keyPart, perms);
                    ShortcutsFolder.createHyphenatedPermutation(sb.toString().toCharArray(), perms, keyPart);
                }
            }
            ShortcutsFolder.getAllPossibleOrderings(modsPart, keyPart, perms);
            ShortcutsFolder.createHyphenatedPermutation(modsPart.toCharArray(), perms, keyPart);
            return perms.toArray(new String[perms.size()]);
        }
        if (key.equals(modsPart)) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = ctrlWildcard + keyPart;
        } else if (altKey.equals(modsPart)) {
            String[] stringArray3 = new String[1];
            stringArray = stringArray3;
            stringArray3[0] = altWildcard + keyPart;
        } else if (altWildcard.equals(modsPart)) {
            String[] stringArray4 = new String[1];
            stringArray = stringArray4;
            stringArray4[0] = altKey + keyPart;
        } else {
            stringArray = new String[]{};
        }
        return stringArray;
    }

    static void getAllPossibleOrderings(String s, String toAppend, Collection store) {
        char[] c = s.toCharArray();
        ShortcutsFolder.mutate(c, store, 0, toAppend);
        String[] result = store.toArray(new String[store.size()]);
    }

    private static void mutate(char[] c, Collection l, int n, String toAppend) {
        if (n == c.length) {
            l.add(new String(c) + toAppend);
            ShortcutsFolder.createHyphenatedPermutation(c, l, toAppend);
            return;
        }
        for (int i = 0; i < c.length; ++i) {
            char x = c[i];
            c[i] = c[n];
            c[n] = x;
            if (n >= c.length) continue;
            ShortcutsFolder.mutate(c, l, n + 1, toAppend);
        }
    }

    static void createHyphenatedPermutation(char[] c, Collection l, String toAppend) {
        if (c.length == 1) {
            return;
        }
        StringBuffer sb = new StringBuffer(new String(c));
        for (int i = c.length - 1; i >= 1; --i) {
            sb.insert(i, '-');
        }
        sb.append(toAppend);
        l.add(sb.toString());
    }

    private static DataObject findForAction(DataFolder actionsFolder, Action a) {
        if (actionsFolder == null) {
            actionsFolder = NbPlaces.getDefault().actions();
        }
        DataObject[] actionsChildren = actionsFolder.getChildren();
        for (int i = 0; i < actionsChildren.length; ++i) {
            if (actionsChildren[i] instanceof DataFolder) {
                DataObject obj = ShortcutsFolder.findForAction((DataFolder)actionsChildren[i], a);
                if (obj == null) continue;
                return obj;
            }
            InstanceCookie ic = (InstanceCookie)actionsChildren[i].getCookie(class$org$openide$cookies$InstanceCookie == null ? ShortcutsFolder.class$("org.openide.cookies.InstanceCookie") : class$org$openide$cookies$InstanceCookie);
            if (ic == null) continue;
            Object obj = null;
            try {
                obj = ic.instanceCreate();
            }
            catch (IOException exc) {
            }
            catch (ClassNotFoundException exc) {
                // empty catch block
            }
            if (obj == null || !a.equals(obj)) continue;
            return actionsChildren[i];
        }
        return null;
    }

    static class ChangeRequest
    extends KeyActionPair {
        public boolean add;

        public ChangeRequest(KeyStroke key, Action action, boolean add) {
            super(Utilities.keyToString((KeyStroke)key), action);
            this.add = add;
        }
    }

    private static class KeyActionPair
    implements InstanceCookie {
        private String name;
        private Action action;

        public KeyActionPair(String name, Action action) {
            this.name = name;
            this.action = action;
        }

        public String instanceName() {
            return this.name;
        }

        public Class instanceClass() throws IOException, ClassNotFoundException {
            return this.action.getClass();
        }

        public Object instanceCreate() throws IOException, ClassNotFoundException {
            return this.action;
        }
    }
}

