/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core;

import java.awt.datatransfer.Clipboard;
import java.beans.Introspector;
import java.beans.PropertyEditorManager;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.Authenticator;
import java.text.MessageFormat;
import javax.swing.SwingUtilities;
import org.netbeans.Main;
import org.netbeans.TopSecurityManager;
import org.netbeans.core.AutomountSupport;
import org.netbeans.core.IDESettings;
import org.netbeans.core.LoaderPoolNode;
import org.netbeans.core.NbAuthenticator;
import org.netbeans.core.NbTopManager;
import org.netbeans.core.Splash;
import org.netbeans.core.TopLogging;
import org.netbeans.core.modules.InstalledFileLocatorImpl;
import org.netbeans.core.modules.ModuleSystem;
import org.netbeans.core.perftool.StartLog;
import org.openide.ErrorManager;
import org.openide.awt.StatusDisplayer;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.Repository;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.SharedClassObject;
import org.openide.util.Task;
import org.openide.util.UserCancelException;
import org.openide.util.datatransfer.ExClipboard;

public class NonGui
extends NbTopManager
implements Runnable {
    static final String DIR_MODULES = "modules";
    protected static Class uiClass;
    protected static int uiFontSize;
    private static String homeDir;
    private static String userDir;
    private static String systemDir;
    private static ModuleSystem moduleSystem;
    protected static boolean noLogging;
    protected static boolean noSplash;
    protected static TopLogging logger;
    private static boolean editorsRegistered;
    static /* synthetic */ Class array$Ljava$lang$String;

    static final void clearForTests() {
        homeDir = null;
        userDir = null;
    }

    protected static String getHomeDir() {
        if (homeDir == null) {
            homeDir = System.getProperty("netbeans.home");
        }
        return homeDir;
    }

    protected static String getUserDir() {
        if (userDir == null) {
            userDir = System.getProperty("netbeans.user");
            if ("memory".equals(userDir)) {
                return "memory";
            }
            if (userDir == null) {
                System.err.println(NbBundle.getMessage((Class)NonGui.class, (String)"ERR_no_user_directory"));
                NonGui.doExit(1);
            }
            if (userDir.equals(NonGui.getHomeDir())) {
                System.err.println(NbBundle.getMessage((Class)NonGui.class, (String)"ERR_user_directory_is_home"));
                NonGui.doExit(1);
            }
            userDir = FileUtil.normalizeFile((File)new File(userDir)).getPath();
            System.setProperty("netbeans.user", userDir);
            File systemDirFile = new File(userDir, "config");
            NonGui.makedir(systemDirFile);
            systemDir = systemDirFile.getAbsolutePath();
            NonGui.makedir(new File(userDir, DIR_MODULES));
        }
        return userDir;
    }

    private static void makedir(File f) {
        Object[] arg;
        if (f.isFile()) {
            arg = new Object[]{f};
            System.err.println(new MessageFormat(NonGui.getString("CTL_CannotCreate_text")).format(arg));
            NonGui.doExit(6);
        }
        if (!f.exists() && !f.mkdirs()) {
            arg = new Object[]{f};
            System.err.println(new MessageFormat(NonGui.getString("CTL_CannotCreateSysDir_text")).format(arg));
            NonGui.doExit(7);
        }
    }

    protected static String getLogDir() {
        return new File(new File(NonGui.getUserDir(), "var"), "log").toString();
    }

    protected static String getSystemDir() {
        NonGui.getUserDir();
        return systemDir;
    }

    public boolean isInteractive(int il) {
        return true;
    }

    private static final Class getKlass(String cls) {
        try {
            return Class.forName(cls, false, NonGui.class.getClassLoader());
        }
        catch (ClassNotFoundException e) {
            throw new NoClassDefFoundError(e.getLocalizedMessage());
        }
    }

    public static final void registerPropertyEditors() {
        if (editorsRegistered) {
            return;
        }
        String[] syspesp = PropertyEditorManager.getEditorSearchPath();
        String[] nbpesp = new String[]{"org.netbeans.beaninfo.editors", "org.openide.explorer.propertysheet.editors"};
        String[] allpesp = new String[syspesp.length + nbpesp.length];
        System.arraycopy(nbpesp, 0, allpesp, 0, nbpesp.length);
        System.arraycopy(syspesp, 0, allpesp, nbpesp.length, syspesp.length);
        PropertyEditorManager.setEditorSearchPath(allpesp);
        PropertyEditorManager.registerEditor(Character.TYPE, NonGui.getKlass("org.netbeans.beaninfo.editors.CharEditor"));
        PropertyEditorManager.registerEditor(NonGui.getKlass("[Ljava.lang.String;"), NonGui.getKlass("org.netbeans.beaninfo.editors.StringArrayEditor"));
        PropertyEditorManager.registerEditor(NonGui.getKlass("[Lorg.openide.loaders.DataObject;"), NonGui.getKlass("org.netbeans.beaninfo.editors.DataObjectArrayEditor"));
        PropertyEditorManager.registerEditor(Integer.TYPE, NonGui.getKlass("org.netbeans.beaninfo.editors.IntEditor"));
        PropertyEditorManager.registerEditor(Boolean.TYPE, NonGui.getKlass("org.netbeans.beaninfo.editors.BoolEditor"));
        StartLog.logProgress("PropertyEditors registered");
        editorsRegistered = true;
    }

    static boolean handleImportOfUserDir() {
        class ImportHandler
        implements Runnable {
            private File installed = new File(new File(NonGui.getUserDir(), "var"), "imported");
            private String classname;
            private boolean executedOk;

            ImportHandler() {
            }

            public boolean shouldDoAnImport() {
                this.classname = System.getProperty("netbeans.importclass");
                return this.classname != null && !this.installed.exists();
            }

            public void run() {
                Class clazz = NonGui.getKlass(this.classname);
                try {
                    Method showMethod = clazz.getMethod("main", array$Ljava$lang$String == null ? (array$Ljava$lang$String = NonGui.class$("[Ljava.lang.String;")) : array$Ljava$lang$String);
                    showMethod.invoke(null, new Object[]{new String[0]});
                    this.executedOk = true;
                }
                catch (InvocationTargetException ex) {
                    if (ex.getTargetException() instanceof UserCancelException) {
                        this.executedOk = true;
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                catch (LinkageError e) {
                    e.printStackTrace();
                }
            }

            public boolean canContinue() {
                if (this.shouldDoAnImport()) {
                    try {
                        SwingUtilities.invokeAndWait(this);
                        if (this.executedOk) {
                            this.installed.getParentFile().mkdirs();
                            this.installed.createNewFile();
                            return true;
                        }
                        return false;
                    }
                    catch (IOException ex) {
                        ex.printStackTrace();
                        return true;
                    }
                    catch (InvocationTargetException ex) {
                        return false;
                    }
                    catch (InterruptedException ex) {
                        ex.printStackTrace();
                        return false;
                    }
                }
                return true;
            }
        }
        ImportHandler handler = new ImportHandler();
        return handler.canContinue();
    }

    public void run() {
        StartLog.logStart("TopManager initialization (org.netbeans.core.NonGui.run())");
        InstalledFileLocatorImpl.prepareCache();
        String[] sysbisp = Introspector.getBeanInfoSearchPath();
        String[] nbbisp = new String[]{"org.netbeans.beaninfo"};
        String[] allbisp = new String[sysbisp.length + nbbisp.length];
        System.arraycopy(nbbisp, 0, allbisp, 0, nbbisp.length);
        System.arraycopy(sysbisp, 0, allbisp, nbbisp.length, sysbisp.length);
        Introspector.setBeanInfoSearchPath(allbisp);
        NonGui.registerPropertyEditors();
        StatusDisplayer.getDefault().setStatusText(NonGui.getString("MSG_IDEInit"));
        Repository.getDefault();
        StartLog.logProgress("Repository initialized");
        SharedClassObject.findObject((Class)IDESettings.class, (boolean)true);
        StartLog.logProgress("IDE settings loaded");
        try {
            if (System.getProperty("netbeans.full.hack") == null && System.getProperty("netbeans.close") == null && !NonGui.handleImportOfUserDir()) {
                TopSecurityManager.exit((int)0);
            }
        }
        catch (Exception e) {
            ErrorManager.getDefault().notify((Throwable)e);
        }
        StartLog.logProgress("Upgrade wizard consulted");
        this.showSplash();
        StartLog.logStart("Modules initialization");
        try {
            moduleSystem = new ModuleSystem(Repository.getDefault().getDefaultFileSystem());
        }
        catch (IOException ioe) {
            IllegalStateException ise = new IllegalStateException("Module system cannot be created");
            ErrorManager.getDefault().annotate((Throwable)ise, (Throwable)ioe);
            throw ise;
        }
        StartLog.logProgress("ModuleSystem created");
        moduleSystem.loadBootModules();
        moduleSystem.readList();
        org.netbeans.core.Main.addAndSetSplashMaxSteps(30);
        moduleSystem.restore();
        StartLog.logEnd("Modules initialization");
        Task automount = AutomountSupport.initialize();
        StartLog.logProgress("Automounter fired");
        org.netbeans.core.Main.incrementSplashProgressBar();
        try {
            LoaderPoolNode.load();
        }
        catch (IOException ioe) {
            ErrorManager.getDefault().notify(1, (Throwable)ioe);
        }
        StartLog.logProgress("LoaderPool loaded");
        org.netbeans.core.Main.incrementSplashProgressBar(10);
        LoaderPoolNode.installationFinished();
        StartLog.logProgress("LoaderPool notified");
        org.netbeans.core.Main.incrementSplashProgressBar(10);
        org.netbeans.core.Main.incrementSplashProgressBar(10);
        automount.waitFinished();
        StartLog.logProgress("Automounter done");
        org.netbeans.core.Main.incrementSplashProgressBar(10);
        this.initializeMainWindow();
        StartLog.logProgress("Main window initialized");
        StartLog.logEnd("TopManager initialization (org.netbeans.core.NonGui.run())");
        org.netbeans.core.Main.incrementSplashProgressBar();
        TopSecurityManager secman = new TopSecurityManager();
        System.setSecurityManager((SecurityManager)secman);
        TopSecurityManager.makeSwingUseSpecialClipboard((Clipboard)((ExClipboard)Lookup.getDefault().lookup(ExClipboard.class)));
        Authenticator.setDefault(new NbAuthenticator());
        StartLog.logProgress("Security managers installed");
        org.netbeans.core.Main.incrementSplashProgressBar();
        Main.finishInitialization();
        StartLog.logProgress("Ran any delayed command-line options");
        InstalledFileLocatorImpl.discardCache();
    }

    protected void initializeMainWindow() {
    }

    static String getString(String resName) {
        return NbBundle.getMessage((Class)NonGui.class, (String)resName);
    }

    static String getString(String resName, Object arg1, Object arg2) {
        return NbBundle.getMessage((Class)NonGui.class, (String)resName, (Object)arg1, (Object)arg2);
    }

    static void doExit(int code) {
        TopSecurityManager.exit((int)code);
    }

    public ModuleSystem getModuleSystem() {
        return moduleSystem;
    }

    protected void showSplash() {
    }

    protected Splash.SplashOutput getSplash() {
        return null;
    }

    static {
        uiFontSize = 0;
        noLogging = false;
        noSplash = false;
        editorsRegistered = false;
    }
}

