/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core;

import java.beans.PropertyVetoException;
import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.StringTokenizer;
import org.netbeans.TopSecurityManager;
import org.netbeans.core.NonGui;
import org.netbeans.core.projects.SessionManager;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.Repository;

public final class NbRepository
extends Repository {
    static final String SYSTEM_FOLDER = "config";

    public NbRepository() {
        super(NbRepository.createDefaultFileSystem());
    }

    private static FileSystem createDefaultFileSystem() {
        String systemDir = System.getProperty("system.dir");
        if (systemDir != null) {
            try {
                return SessionManager.getDefault().create(new File(systemDir), null, new File[0]);
            }
            catch (IOException ex) {
                ex.printStackTrace();
                throw new InternalError();
            }
            catch (PropertyVetoException ex) {
                ex.printStackTrace();
                throw new InternalError();
            }
        }
        String homeDir = NonGui.getHomeDir();
        if (homeDir != null) {
            Exception exc;
            File homeDirFile = new File(NonGui.getHomeDir());
            File userDirFile = new File(NonGui.getUserDir());
            if (!homeDirFile.exists()) {
                System.err.println(NonGui.getString("CTL_Netbeanshome_notexists"));
                NbRepository.doExit(2);
            }
            if (!homeDirFile.isDirectory()) {
                System.err.println(NonGui.getString("CTL_Netbeanshome1"));
                NbRepository.doExit(3);
            }
            if (!userDirFile.exists()) {
                System.err.println(NonGui.getString("CTL_Netbeanshome2"));
                NbRepository.doExit(4);
            }
            if (!userDirFile.isDirectory()) {
                System.err.println(NonGui.getString("CTL_Netbeanshome3"));
                NbRepository.doExit(5);
            }
            ArrayList<File> extradirs = new ArrayList<File>();
            String nbdirs = System.getProperty("netbeans.dirs");
            if (nbdirs != null) {
                StringTokenizer tok = new StringTokenizer(nbdirs, File.pathSeparator);
                while (tok.hasMoreTokens()) {
                    File f = new File(tok.nextToken(), SYSTEM_FOLDER);
                    if (!f.isDirectory()) continue;
                    extradirs.add(f);
                }
            }
            try {
                File u = new File(userDirFile, SYSTEM_FOLDER);
                File h = new File(homeDirFile, SYSTEM_FOLDER);
                return SessionManager.getDefault().create(u, h, extradirs.toArray(new File[extradirs.size()]));
            }
            catch (IOException ex) {
                exc = ex;
            }
            catch (PropertyVetoException ex) {
                exc = ex;
            }
            catch (RuntimeException ex) {
                exc = ex;
            }
            exc.printStackTrace();
            Object[] arg = new Object[]{systemDir};
            System.err.println(new MessageFormat(NonGui.getString("CTL_Cannot_mount_systemfs")).format(arg));
            NbRepository.doExit(3);
        }
        try {
            return SessionManager.getDefault().create(null, null, new File[0]);
        }
        catch (IOException ex) {
            ex.printStackTrace();
            throw new InternalError();
        }
        catch (PropertyVetoException ex) {
            ex.printStackTrace();
            throw new InternalError();
        }
    }

    private static void doExit(int value) {
        TopSecurityManager.exit((int)value);
    }
}

