/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core;

import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.WeakHashMap;
import org.netbeans.core.NotifyException;
import org.netbeans.core.TopLogging;
import org.openide.ErrorManager;
import org.openide.util.NbBundle;
import org.xml.sax.SAXParseException;

public final class NbErrorManager
extends ErrorManager {
    private static final Map map = new WeakHashMap(11);
    private static final MessageFormat EXC_HEADER = new MessageFormat("{0}*********** Exception occurred ************ at {1,time,short} on {1,date,medium}", Locale.ENGLISH);
    private PrintStream logWriter;
    private static final Map lastException = new WeakHashMap(27);
    private final int minLogSeverity;
    private final String prefix;
    private final int uniquifier;
    private static final Map uniquifiedIds = new HashMap(20);
    private static Map NESTS;
    static /* synthetic */ Class class$java$lang$Object;

    public NbErrorManager() {
        this(null, NbErrorManager.defaultSeverity(), null);
    }

    NbErrorManager(PrintStream pw) {
        this(null, NbErrorManager.defaultSeverity(), pw);
    }

    private static int defaultSeverity() {
        String dsev = System.getProperty("ErrorManager.minimum");
        if (dsev != null) {
            try {
                return Integer.parseInt(dsev);
            }
            catch (NumberFormatException nfe) {
                nfe.printStackTrace();
            }
        }
        return 2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private NbErrorManager(String pfx, int sev, PrintStream pw) {
        this.prefix = pfx;
        this.minLogSeverity = sev;
        this.logWriter = pw;
        Map map = uniquifiedIds;
        synchronized (map) {
            Integer i = (Integer)uniquifiedIds.get(pfx);
            this.uniquifier = i == null ? 1 : i + 1;
            uniquifiedIds.put(pfx, new Integer(this.uniquifier));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PrintStream getLogWriter() {
        NbErrorManager nbErrorManager = this;
        synchronized (nbErrorManager) {
            if (this.logWriter != null) {
                return this.logWriter;
            }
        }
        PrintStream pw = TopLogging.getLogOutputStream();
        NbErrorManager nbErrorManager2 = this;
        synchronized (nbErrorManager2) {
            if (this.logWriter == null) {
                this.logWriter = pw;
            }
            return this.logWriter;
        }
    }

    public synchronized Throwable annotate(Throwable t, int severity, String message, String localizedMessage, Throwable stackTrace, Date date) {
        ArrayList<Ann> ll;
        Object o = map.get(t);
        if (o == null) {
            ll = new ArrayList<Ann>();
            map.put(t, ll);
        } else {
            ll = (ArrayList<Ann>)o;
        }
        ll.add(0, new Ann(severity, message, localizedMessage, stackTrace, date));
        lastException.put(Thread.currentThread(), new WeakReference<Throwable>(t));
        return t;
    }

    public synchronized Throwable attachAnnotations(Throwable t, ErrorManager.Annotation[] arr) {
        ArrayList<ErrorManager.Annotation> l;
        Object o = map.get(t);
        if (o == null) {
            l = new ArrayList<ErrorManager.Annotation>(arr.length + 5);
            map.put(t, l);
        } else {
            l = (ArrayList<ErrorManager.Annotation>)o;
        }
        l.addAll(0, Arrays.asList(arr));
        lastException.put(Thread.currentThread(), new WeakReference<Throwable>(t));
        return t;
    }

    public boolean isNotifiable(int severity) {
        return this.isLoggable(severity + 1);
    }

    public synchronized void notify(int severity, Throwable t) {
        ErrorManager.Annotation[] ann;
        boolean wantStackTrace;
        Exc ex = this.createExc(t, severity);
        if (!this.isNotifiable(ex.getSeverity())) {
            return;
        }
        boolean bl = wantStackTrace = severity != 256;
        if (wantStackTrace && (ann = this.findAnnotations(t)) != null) {
            for (int i = 0; i < ann.length; ++i) {
                if (!(ann[i] instanceof Ann) || ((Ann)ann[i]).getSeverity() != 256) continue;
                wantStackTrace = false;
                break;
            }
        }
        if (wantStackTrace) {
            PrintStream log = this.getLogWriter();
            if (this.prefix != null) {
                log.print("[" + this.prefix + "] ");
            }
            String level = ex.getSeverity() == 1 ? "INFORMATIONAL " : "";
            log.println(EXC_HEADER.format(new Object[]{level, ex.getDate()}));
            ex.printStackTrace(log);
        }
        if (ex.getSeverity() > 1) {
            NotifyException.notify(ex);
        }
    }

    Exc createExc(Throwable t, int severity) {
        Throwable lastT;
        Reference r;
        ErrorManager.Annotation[] ann = this.findAnnotations(t);
        if (ann == null && (r = (Reference)lastException.get(Thread.currentThread())) != null && (lastT = (Throwable)r.get()) != null) {
            ann = this.findAnnotations(lastT);
        }
        lastException.remove(Thread.currentThread());
        return new Exc(t, severity, ann, this.findAnnotations0(t, true, new HashSet()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public void log(int severity, String s) {
        if (this.isLoggable(severity)) {
            PrintStream log = this.getLogWriter();
            if (this.prefix != null) {
                void var4_4;
                boolean showUniquifier;
                if (this.uniquifier > 1) {
                    showUniquifier = true;
                } else if (this.uniquifier == 1) {
                    Map map = uniquifiedIds;
                    synchronized (map) {
                        int count = (Integer)uniquifiedIds.get(this.prefix);
                        showUniquifier = count > 1;
                    }
                } else {
                    throw new IllegalStateException("prefix != null yet uniquifier == 0");
                }
                if (var4_4 != false) {
                    log.print("[" + this.prefix + " #" + this.uniquifier + "] ");
                } else {
                    log.print("[" + this.prefix + "] ");
                }
            }
            log.println(s);
        }
    }

    public boolean isLoggable(int severity) {
        return severity >= this.minLogSeverity;
    }

    public final ErrorManager getInstance(String name) {
        String pfx = this.prefix == null ? name : this.prefix + '.' + name;
        int sev = this.minLogSeverity;
        String prop = pfx;
        while (prop != null) {
            String value = System.getProperty(prop);
            if (value != null) {
                try {
                    sev = Integer.parseInt(value);
                }
                catch (NumberFormatException nfe) {
                    this.notify(16, nfe);
                }
                break;
            }
            int idx = prop.lastIndexOf(46);
            if (idx == -1) {
                prop = null;
                continue;
            }
            prop = prop.substring(0, idx);
        }
        return new NbErrorManager(pfx, sev, this.logWriter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Throwable extractNestedThrowable(Throwable t) {
        Class clazz = NbErrorManager.class;
        synchronized (clazz) {
            if (NESTS == null) {
                NESTS = new HashMap(50);
                NESTS.put("java.lang.ClassNotFoundException", "getException");
                NESTS.put("java.lang.ExceptionInInitializerError", "getException");
                NESTS.put("java.lang.reflect.InvocationTargetException", "getTargetException");
                NESTS.put("java.lang.reflect.UndeclaredThrowableException", "getUndeclaredThrowable");
                NESTS.put("java.security.PrivilegedActionException", "getException");
                NESTS.put("javax.naming.NamingException", "getRootCause");
                NESTS.put("javax.xml.parsers.FactoryConfigurationError", "getException");
                NESTS.put("javax.xml.transform.TransformerException", "getException");
                NESTS.put("javax.xml.transform.TransformerFactoryConfigurationError", "getException");
                NESTS.put("org.openide.compiler.CompilerGroupException", ".exception");
                NESTS.put("org.openide.src.SourceException$IO", "getReason");
                NESTS.put("org.openide.src.SourceException$Veto", "getReason");
                NESTS.put("org.openide.src.SourceVetoException", "getNestedException");
                NESTS.put("org.openide.util.MutexException", "getException");
                NESTS.put("org.openide.util.io.OperationException", "getException");
                NESTS.put("org.openide.util.io.SafeException", "getException");
                NESTS.put("org.xml.sax.SAXException", "getException");
            }
        }
        for (Class<?> c = t.getClass(); c != (class$java$lang$Object == null ? NbErrorManager.class$("java.lang.Object") : class$java$lang$Object); c = c.getSuperclass()) {
            String getter = (String)NESTS.get(c.getName());
            if (getter == null) continue;
            try {
                if (getter.charAt(0) == '.') {
                    Field f = c.getField(getter.substring(1));
                    return (Throwable)f.get(t);
                }
                Method m = c.getMethod(getter, null);
                return (Throwable)m.invoke((Object)t, null);
            }
            catch (Exception e) {
                System.err.println("From throwable class: " + c.getName());
                e.printStackTrace();
            }
        }
        return null;
    }

    public synchronized ErrorManager.Annotation[] findAnnotations(Throwable t) {
        return this.findAnnotations0(t, false, new HashSet());
    }

    private synchronized ErrorManager.Annotation[] findAnnotations0(Throwable t, boolean recursively, Set alreadyVisited) {
        ErrorManager.Annotation[] arr;
        ArrayList<Ann> l = (ArrayList<Ann>)map.get(t);
        if (t instanceof MissingResourceException) {
            String k;
            l = l == null ? new ArrayList<Ann>(1) : new ArrayList(l);
            MissingResourceException mre = (MissingResourceException)t;
            String cn = mre.getClassName();
            if (cn != null) {
                l.add(new Ann(4096, NbBundle.getMessage((Class)NbErrorManager.class, (String)"EXC_MissingResourceException_class_name", (Object)cn), null, null, null));
            }
            if ((k = mre.getKey()) != null) {
                l.add(new Ann(4096, NbBundle.getMessage((Class)NbErrorManager.class, (String)"EXC_MissingResourceException_key", (Object)k), null, null, null));
            }
            if (l.size() == 0) {
                l = null;
            }
        } else {
            Throwable t2 = NbErrorManager.extractNestedThrowable(t);
            if (t2 != null) {
                l = l == null ? new ArrayList(1) : new ArrayList(l);
                l.add(new Ann(0, null, null, t2, null));
            }
        }
        if (t instanceof SAXParseException) {
            SAXParseException spe = (SAXParseException)t;
            String pubid = spe.getPublicId();
            String sysid = spe.getSystemId();
            if (pubid != null || sysid != null) {
                int col = spe.getColumnNumber();
                int line = spe.getLineNumber();
                String msg = col != -1 || line != -1 ? NbBundle.getMessage((Class)NbErrorManager.class, (String)"EXC_sax_parse_col_line", (Object[])new Object[]{String.valueOf(pubid), String.valueOf(sysid), new Integer(col), new Integer(line)}) : NbBundle.getMessage((Class)NbErrorManager.class, (String)"EXC_sax_parse", (Object)String.valueOf(pubid), (Object)String.valueOf(sysid));
                l = l == null ? new ArrayList(1) : new ArrayList(l);
                l.add(new Ann(0, msg, null, null, null));
            }
        }
        if (recursively && l != null) {
            ArrayList<ErrorManager.Annotation> al = new ArrayList<ErrorManager.Annotation>();
            Iterator i = l.iterator();
            while (i.hasNext()) {
                ErrorManager.Annotation ano = (ErrorManager.Annotation)i.next();
                Throwable t1 = ano.getStackTrace();
                if (t1 == null || alreadyVisited.contains(t1)) continue;
                alreadyVisited.add(t1);
                ErrorManager.Annotation[] tmpAnnoArray = this.findAnnotations0(t1, true, alreadyVisited);
                if (tmpAnnoArray == null || tmpAnnoArray.length <= 0) continue;
                al.addAll(Arrays.asList(tmpAnnoArray));
            }
            l.addAll(al);
        }
        if (l == null) {
            arr = null;
        } else {
            arr = new ErrorManager.Annotation[l.size()];
            l.toArray(arr);
        }
        return arr;
    }

    public String toString() {
        return super.toString() + "<" + this.prefix + "," + this.minLogSeverity + ">";
    }

    static {
        System.setProperty("sun.awt.exception.handler", "org.netbeans.core.NbErrorManager$AWTHandler");
        NESTS = null;
    }

    public static final class AWTHandler {
        public static void handle(Throwable t) {
            if (t.getClass().getName().endsWith(".ExitSecurityException")) {
                return;
            }
            ErrorManager.getDefault().notify(131072, t);
        }
    }

    final class Exc {
        private Throwable t;
        private Date d;
        private ErrorManager.Annotation[] arr;
        private ErrorManager.Annotation[] arrAll;
        private int severity;

        Exc(Throwable t, int severity, ErrorManager.Annotation[] arr, ErrorManager.Annotation[] arrAll) {
            this.t = t;
            this.severity = severity;
            this.arr = arr == null ? new ErrorManager.Annotation[]{} : arr;
            this.arrAll = arrAll == null ? new ErrorManager.Annotation[]{} : arrAll;
        }

        String getMessage() {
            String m = this.t.getMessage();
            if (m != null) {
                return m;
            }
            return (String)this.find(1);
        }

        String getLocalizedMessage() {
            String m = this.t.getLocalizedMessage();
            if (m != null && !m.equals(this.t.getMessage())) {
                return m;
            }
            if (this.arrAll == null) {
                return (String)this.find(2);
            }
            for (int i = 0; i < this.arrAll.length; ++i) {
                String s = this.arrAll[i].getLocalizedMessage();
                if (s == null) continue;
                return s;
            }
            return m;
        }

        boolean isLocalized() {
            String m = this.t.getLocalizedMessage();
            if (m != null && !m.equals(this.t.getMessage())) {
                return true;
            }
            if (this.arrAll == null) {
                return (String)this.find(2) != null;
            }
            for (int i = 0; i < this.arrAll.length; ++i) {
                String s = this.arrAll[i].getLocalizedMessage();
                if (s == null) continue;
                return true;
            }
            return false;
        }

        String getClassName() {
            return (String)this.find(3);
        }

        int getSeverity() {
            if (this.severity != 0) {
                return this.severity;
            }
            ErrorManager.Annotation[] anns = this.arrAll != null ? this.arrAll : this.arr;
            for (int i = 0; i < anns.length; ++i) {
                int s = anns[i].getSeverity();
                if (s <= this.severity) continue;
                this.severity = s;
            }
            if (this.severity == 0) {
                this.severity = this.t instanceof Error ? 65536 : 4096;
            }
            return this.severity;
        }

        Date getDate() {
            if (this.d == null) {
                this.d = (Date)this.find(4);
            }
            return this.d;
        }

        void printStackTrace(PrintStream ps) {
            this.printStackTrace(new PrintWriter(ps, true));
        }

        void printStackTrace(PrintWriter pw) {
            this.printStackTrace(pw, new HashSet(10));
        }

        private void printStackTrace(PrintWriter pw, Set nestingCheck) {
            Throwable thr;
            if (this.t != null && !nestingCheck.add(this.t)) {
                NbErrorManager.this.log(16, "WARNING - ErrorManager detected cyclic exception nesting:");
                Iterator it = nestingCheck.iterator();
                while (it.hasNext()) {
                    Throwable t = (Throwable)it.next();
                    NbErrorManager.this.log(16, "\t" + t);
                    ErrorManager.Annotation[] anns = NbErrorManager.this.findAnnotations(t);
                    if (anns == null) continue;
                    for (int i = 0; i < anns.length; ++i) {
                        Throwable t2 = anns[i].getStackTrace();
                        if (t2 == null) continue;
                        NbErrorManager.this.log(16, "\t=> " + t2);
                    }
                }
                NbErrorManager.this.log(16, "Be sure not to annotate an exception with itself, directly or indirectly.");
                return;
            }
            for (int i = 0; i < this.arr.length; ++i) {
                if (this.arr[i] == null) continue;
                thr = this.arr[i].getStackTrace();
                String annotation = this.arr[i].getLocalizedMessage();
                if (annotation == null) {
                    annotation = this.arr[i].getMessage();
                }
                if (annotation == null || thr != null) continue;
                pw.println("Annotation: " + annotation);
            }
            if (this.t instanceof VirtualMachineError) {
                this.t.printStackTrace(pw);
            } else {
                int i;
                String[] tLines = this.decompose(this.t);
                String[] hereLines = this.decompose(new Throwable());
                int idx = -1;
                for (i = 1; i <= Math.min(tLines.length, hereLines.length); ++i) {
                    if (tLines[tLines.length - i].equals(hereLines[hereLines.length - i])) continue;
                    idx = tLines.length - i;
                    break;
                }
                for (i = 0; i < tLines.length; ++i) {
                    if (i == idx) {
                        pw.print("[catch]");
                        if (tLines[i].charAt(0) == '\t') {
                            pw.print(' ');
                            tLines[i] = tLines[i].substring(1);
                        }
                    }
                    pw.println(tLines[i]);
                }
            }
            for (int i = 0; i < this.arr.length; ++i) {
                if (this.arr[i] == null || (thr = this.arr[i].getStackTrace()) == null) continue;
                ErrorManager.Annotation[] ans = NbErrorManager.this.findAnnotations(thr);
                Exc ex = new Exc(thr, 0, ans, null);
                pw.println("==>");
                ex.printStackTrace(pw, nestingCheck);
            }
        }

        private String[] decompose(Throwable t) {
            StringWriter sw = new StringWriter();
            t.printStackTrace(new PrintWriter(sw));
            StringTokenizer tok = new StringTokenizer(sw.toString(), "\n\r");
            int c = tok.countTokens();
            String[] lines = new String[c];
            for (int i = 0; i < c; ++i) {
                lines[i] = tok.nextToken();
            }
            return lines;
        }

        private Object find(int kind) {
            return this.find(kind, true);
        }

        private Object find(int kind, boolean def) {
            for (int i = 0; i < this.arr.length; ++i) {
                ErrorManager.Annotation a = this.arr[i];
                Object o = null;
                switch (kind) {
                    case 1: {
                        o = a.getMessage();
                        break;
                    }
                    case 2: {
                        o = a.getLocalizedMessage();
                        break;
                    }
                    case 3: {
                        Throwable t = a.getStackTrace();
                        o = t == null ? null : t.getClass().getName();
                        break;
                    }
                    case 4: {
                        o = a.getDate();
                    }
                }
                if (o == null) continue;
                return o;
            }
            if (!def) {
                return null;
            }
            switch (kind) {
                case 1: {
                    return this.t.getMessage();
                }
                case 2: {
                    return this.t.getLocalizedMessage();
                }
                case 3: {
                    return this.t.getClass().getName();
                }
                case 4: {
                    return new Date();
                }
            }
            throw new IllegalArgumentException("Unknown " + new Integer(kind));
        }
    }

    private static final class Ann
    implements ErrorManager.Annotation {
        private int severity;
        private String message;
        private String localizedMessage;
        private Throwable stackTrace;
        private Date date;

        public Ann(int severity, String message, String localizedMessage, Throwable stackTrace, Date date) {
            this.severity = severity;
            this.message = message;
            this.localizedMessage = localizedMessage;
            this.stackTrace = stackTrace;
            this.date = date;
        }

        public String getMessage() {
            return this.message;
        }

        public String getLocalizedMessage() {
            return this.localizedMessage;
        }

        public Throwable getStackTrace() {
            return this.stackTrace;
        }

        public Date getDate() {
            return this.date;
        }

        public int getSeverity() {
            return this.severity;
        }

        public String toString() {
            return "NbEM.Ann[severity=" + this.severity + ",message=" + this.message + ",localizedMessage=" + this.localizedMessage + ",stackTrace=" + this.stackTrace + ",date=" + this.date + "]";
        }
    }
}

