/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core;

import java.beans.IntrospectionException;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.Action;
import javax.swing.event.ChangeEvent;
import org.netbeans.core.modules.ManifestSection;
import org.openide.ErrorManager;
import org.openide.actions.PropertiesAction;
import org.openide.actions.ReorderAction;
import org.openide.actions.ToolsAction;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.Repository;
import org.openide.loaders.DataLoader;
import org.openide.loaders.DataLoaderPool;
import org.openide.loaders.InstanceSupport;
import org.openide.modules.ModuleInfo;
import org.openide.modules.SpecificationVersion;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.BeanNode;
import org.openide.nodes.Children;
import org.openide.nodes.Index;
import org.openide.nodes.Node;
import org.openide.util.Enumerations;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.TopologicalSortException;
import org.openide.util.Utilities;
import org.openide.util.actions.SystemAction;
import org.openide.util.io.NbMarshalledObject;
import org.openide.util.io.NbObjectInputStream;
import org.openide.util.io.NbObjectOutputStream;
import org.openide.util.io.SafeException;

public final class LoaderPoolNode
extends AbstractNode {
    private static final String LOADER_POOL_ICON_BASE = "org/netbeans/core/resources/loaderPool";
    private static LoaderPoolNode loaderPoolNode;
    private static final ErrorManager err;
    private static LoaderChildren myChildren;
    private static List loaders;
    private static Set modifiedLoaders;
    private static Map names2Loaders;
    private static Map repNames2Loaders;
    private static Map installBefores;
    private static Map installAfters;
    private static Object[] loadersArray;
    private static boolean installationFinished;
    private static boolean updatingBatch;
    private static boolean updatingBatchUsed;
    private static final String LOADER_POOL_NAME = "loaders.ser";
    private static NbLoaderPool nbLoaderPool;
    static /* synthetic */ Class class$org$openide$actions$MoveUpAction;
    static /* synthetic */ Class class$org$openide$actions$MoveDownAction;
    static /* synthetic */ Class class$org$openide$nodes$BeanNode;
    static /* synthetic */ Class class$org$netbeans$core$LoaderPoolNode$LoaderPoolItemNode;

    private LoaderPoolNode() {
        super((Children)new LoaderChildren());
        myChildren = (LoaderChildren)this.getChildren();
        this.setName("LoaderPoolNode");
        this.setDisplayName(NbBundle.getMessage((Class)LoaderPoolNode.class, (String)"CTL_LoaderPool"));
        this.setIconBase(LOADER_POOL_ICON_BASE);
        this.getCookieSet().add((Node.Cookie)new Index());
        this.getCookieSet().add((Node.Cookie)new InstanceSupport.Instance((Object)LoaderPoolNode.getNbLoaderPool()));
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(LoaderPoolNode.class);
    }

    public SystemAction[] createActions() {
        return new SystemAction[]{SystemAction.get((Class)ReorderAction.class), null, SystemAction.get((Class)ToolsAction.class), SystemAction.get((Class)PropertiesAction.class)};
    }

    public static synchronized void beginUpdates() {
        updatingBatch = true;
        updatingBatchUsed = false;
    }

    public static synchronized void endUpdates() {
        if (!updatingBatch) {
            throw new IllegalStateException();
        }
        updatingBatch = false;
        if (updatingBatchUsed) {
            updatingBatchUsed = false;
            LoaderPoolNode.resort();
        }
    }

    public static void add(ManifestSection.LoaderSection s) throws Exception {
        DataLoader l = (DataLoader)s.getInstance();
        LoaderPoolNode.doAdd(l, s);
    }

    static synchronized void doAdd(DataLoader l, ManifestSection.LoaderSection s) throws Exception {
        if (err.isLoggable(1) && s != null) {
            List<String> before = s.getInstallBefore() == null ? null : Arrays.asList(s.getInstallBefore());
            List<String> after = s.getInstallAfter() == null ? null : Arrays.asList(s.getInstallAfter());
            err.log("add: " + l + " repclass: " + l.getRepresentationClass().getName() + " before: " + before + " after: " + after);
        }
        Iterator it = loaders.iterator();
        Class<?> c = l.getClass();
        while (it.hasNext()) {
            if (it.next().getClass() != c) continue;
            it.remove();
            break;
        }
        loaders.add(l);
        l.removePropertyChangeListener((PropertyChangeListener)LoaderPoolNode.getNbLoaderPool());
        l.addPropertyChangeListener((PropertyChangeListener)LoaderPoolNode.getNbLoaderPool());
        String cname = c.getName();
        names2Loaders.put(cname, l);
        repNames2Loaders.put(l.getRepresentationClassName(), l);
        if (s != null) {
            String[] ia;
            String[] ib = s.getInstallBefore();
            if (ib != null) {
                installBefores.put(cname, ib);
            }
            if ((ia = s.getInstallAfter()) != null) {
                installAfters.put(cname, ia);
            }
        }
        if (updatingBatch) {
            updatingBatchUsed = true;
        } else {
            LoaderPoolNode.resort();
        }
    }

    private static synchronized void resort() {
        HashMap deps = new HashMap();
        LoaderPoolNode.add2Deps(deps, installBefores, true);
        LoaderPoolNode.add2Deps(deps, installAfters, false);
        if (err.isLoggable(1)) {
            err.log("Before sort: " + loaders);
        }
        try {
            loaders = Utilities.topologicalSort((Collection)loaders, deps);
            if (err.isLoggable(1)) {
                err.log("After sort: " + loaders);
            }
        }
        catch (TopologicalSortException ex) {
            err.notify(1, (Throwable)ex);
            err.log(16, "Contradictory loader ordering: " + deps);
        }
        LoaderPoolNode.update();
    }

    private static void add2Deps(Map deps, Map orderings, boolean before) {
        Iterator it = orderings.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry e = it.next();
            String loaderClassName = (String)e.getKey();
            DataLoader l = (DataLoader)names2Loaders.get(loaderClassName);
            if (l == null) {
                throw new IllegalStateException("No such loader: " + loaderClassName);
            }
            String[] repClassNames = (String[])e.getValue();
            if (repClassNames == null) {
                throw new IllegalStateException("Null Install-" + (before ? "Before" : "After") + " for " + loaderClassName);
            }
            for (int i = 0; i < repClassNames.length; ++i) {
                String repClassName = repClassNames[i];
                DataLoader l2 = (DataLoader)repNames2Loaders.get(repClassName);
                if (l2 != null) {
                    if (before) {
                        LoaderPoolNode.addDep(deps, l, l2);
                        continue;
                    }
                    LoaderPoolNode.addDep(deps, l2, l);
                    continue;
                }
                l2 = (DataLoader)names2Loaders.get(repClassName);
                if (l2 == null) continue;
                LoaderPoolNode.warn(loaderClassName, repClassName, l2.getRepresentationClassName());
            }
        }
    }

    private static void addDep(Map deps, DataLoader a, DataLoader b) {
        LinkedList<DataLoader> l = (LinkedList<DataLoader>)deps.get(a);
        if (l == null) {
            l = new LinkedList<DataLoader>();
            deps.put(a, l);
        }
        if (!l.contains(b)) {
            l.add(b);
        }
    }

    private static void warn(String yourLoader, String otherLoader, String otherRepn) {
        err.log(16, "Warning: a possible error in the manifest containing " + yourLoader + " was found.");
        err.log(16, "The loader specified an Install-{After,Before} on " + otherLoader + ", but this is a DataLoader class.");
        err.log(16, "Probably you wanted " + otherRepn + " which is the loader's representation class.");
    }

    static void installationFinished() {
        installationFinished = true;
        if (myChildren != null) {
            myChildren.update();
        }
    }

    static synchronized boolean isModified(DataLoader l) {
        return modifiedLoaders.contains(l);
    }

    private static synchronized void writePool(ObjectOutputStream oos) throws IOException {
        Object c;
        if (err.isLoggable(1)) {
            err.log("writePool");
        }
        oos.writeObject(new HashMap());
        oos.writeObject(new HashMap());
        Collection modules = Lookup.getDefault().lookup(new Lookup.Template(ModuleInfo.class)).allInstances();
        Iterator it = loaders.iterator();
        while (it.hasNext()) {
            NbMarshalledObject obj;
            DataLoader l = (DataLoader)it.next();
            if (!LoaderPoolNode.isModified(l)) {
                String c2 = l.getClass().getName();
                if (err.isLoggable(1)) {
                    err.log("writing unmodified " + c2);
                }
                oos.writeObject("=" + c2);
                continue;
            }
            try {
                obj = new NbMarshalledObject((Object)l);
            }
            catch (IOException ex) {
                err.notify((Throwable)ex);
                obj = null;
            }
            if (obj == null) continue;
            if (err.isLoggable(1)) {
                err.log("writing modified " + l.getClass().getName());
            }
            c = l.getClass();
            Iterator mit = modules.iterator();
            boolean found = false;
            while (mit.hasNext()) {
                ModuleInfo m = (ModuleInfo)mit.next();
                if (!m.isEnabled() || !m.owns((Class)c)) continue;
                if (err.isLoggable(1)) {
                    err.log("belongs to module: " + m.getCodeNameBase());
                }
                oos.writeObject(m.getCodeNameBase());
                int r = m.getCodeNameRelease();
                oos.writeInt(r);
                SpecificationVersion v = m.getSpecificationVersion();
                if (v != null) {
                    oos.writeObject(v.toString());
                } else {
                    oos.writeObject(null);
                }
                found = true;
                break;
            }
            if (!found && err.isLoggable(1)) {
                err.log("does not belong to any module");
            }
            oos.writeObject(obj);
        }
        if (err.isLoggable(1)) {
            err.log("writing null");
        }
        oos.writeObject(null);
        Enumeration e = LoaderPoolNode.getNbLoaderPool().allLoaders();
        while (e.hasMoreElements()) {
            NbMarshalledObject obj;
            DataLoader l = (DataLoader)e.nextElement();
            if (loaders.contains(l)) continue;
            if (!LoaderPoolNode.isModified(l)) {
                c = l.getClass().getName();
                if (!err.isLoggable(1)) continue;
                err.log("skipping unmodified " + (String)c);
                continue;
            }
            try {
                obj = new NbMarshalledObject((Object)l);
            }
            catch (IOException ex) {
                err.notify((Throwable)ex);
                obj = null;
            }
            if (obj == null) continue;
            if (err.isLoggable(1)) {
                err.log("writing " + l.getClass().getName());
            }
            oos.writeObject(obj);
        }
        if (err.isLoggable(1)) {
            err.log("writing null");
        }
        oos.writeObject(null);
        if (err.isLoggable(1)) {
            err.log("done writing");
        }
    }

    private static synchronized void readPool(ObjectInputStream ois) throws IOException, ClassNotFoundException {
        ois.readObject();
        ois.readObject();
        HashSet classes = new HashSet();
        LinkedList<DataLoader> l = new LinkedList<DataLoader>();
        Exception deserExc = null;
        Iterator mit = Lookup.getDefault().lookup(new Lookup.Template(ModuleInfo.class)).allInstances().iterator();
        HashMap<String, ModuleInfo> modules = new HashMap<String, ModuleInfo>();
        while (mit.hasNext()) {
            ModuleInfo m = (ModuleInfo)mit.next();
            modules.put(m.getCodeNameBase(), m);
        }
        while (true) {
            NbMarshalledObject obj;
            Object o1;
            if ((o1 = ois.readObject()) == null) {
                if (!err.isLoggable(1)) break;
                err.log("reading null");
                break;
            }
            if (o1 instanceof String) {
                SpecificationVersion v;
                String name = (String)o1;
                if (name.length() > 0 && name.charAt(0) == '=') {
                    String cname = name.substring(1);
                    DataLoader dl = (DataLoader)names2Loaders.get(cname);
                    if (dl != null) {
                        if (err.isLoggable(1)) {
                            err.log("reading unmodified " + cname);
                        }
                        l.add(dl);
                        classes.add(dl.getClass());
                        continue;
                    }
                    if (!err.isLoggable(1)) continue;
                    err.log("skipping unmodified nonexistent " + cname);
                    continue;
                }
                int rel = ois.readInt();
                String spec = (String)ois.readObject();
                obj = (NbMarshalledObject)ois.readObject();
                ModuleInfo m = (ModuleInfo)modules.get(name);
                if (m == null) {
                    if (!err.isLoggable(1)) continue;
                    err.log("No known module " + name + ", skipping loader");
                    continue;
                }
                if (!m.isEnabled()) {
                    if (!err.isLoggable(1)) continue;
                    err.log("Module " + name + " is disabled, skipping loader");
                    continue;
                }
                if (m.getCodeNameRelease() < rel) {
                    if (!err.isLoggable(1)) continue;
                    err.log("Module " + name + " is too old (major vers.), skipping loader");
                    continue;
                }
                if (spec != null && ((v = m.getSpecificationVersion()) == null || v.compareTo((Object)new SpecificationVersion(spec)) < 0)) {
                    if (!err.isLoggable(1)) continue;
                    err.log("Module " + name + " is too old (spec. vers.), skipping loader");
                    continue;
                }
                if (err.isLoggable(1)) {
                    err.log("Module " + name + " is OK, will try to restore loader");
                }
            } else {
                obj = (NbMarshalledObject)o1;
            }
            Exception t = null;
            try {
                DataLoader loader = (DataLoader)obj.get();
                if (loader == null) continue;
                Class<?> clazz = loader.getClass();
                if (err.isLoggable(1)) {
                    err.log("reading modified " + clazz.getName());
                }
                l.add(loader);
                classes.add(clazz);
            }
            catch (IOException ex) {
                t = ex;
            }
            catch (ClassNotFoundException ex) {
                t = ex;
            }
            if (t == null) continue;
            ErrorManager.getDefault().annotate((Throwable)t, 16, null, null, null, null);
            if (deserExc == null) {
                deserExc = t;
                continue;
            }
            ErrorManager.getDefault().annotate((Throwable)deserExc, (Throwable)t);
        }
        while (true) {
            NbMarshalledObject obj;
            if ((obj = (NbMarshalledObject)ois.readObject()) == null) {
                if (!err.isLoggable(1)) break;
                err.log("reading null");
                break;
            }
            Exception t = null;
            try {
                DataLoader loader = (DataLoader)obj.get();
                if (err.isLoggable(1)) {
                    err.log("reading " + loader.getClass().getName());
                }
            }
            catch (IOException ex) {
                t = ex;
            }
            catch (ClassNotFoundException ex) {
                t = ex;
            }
            if (t == null) continue;
            ErrorManager.getDefault().annotate((Throwable)t, 16, null, null, null, null);
            if (deserExc == null) {
                deserExc = t;
                continue;
            }
            ErrorManager.getDefault().annotate((Throwable)deserExc, (Throwable)t);
        }
        if (err.isLoggable(1)) {
            err.log("done reading");
        }
        Iterator it = loaders.iterator();
        while (it.hasNext()) {
            DataLoader loader = (DataLoader)it.next();
            if (classes.contains(loader.getClass())) continue;
            l.add(loader);
        }
        if (l.size() > new HashSet(l).size()) {
            throw new IllegalStateException("Duplicates in " + l);
        }
        loaders = l;
        LoaderPoolNode.resort();
        if (deserExc != null) {
            throw new SafeException(deserExc);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void store() throws IOException {
        FileObject ser = LoaderPoolNode.getLoaderPoolStorage(true);
        FileLock lock = ser.lock();
        try {
            NbObjectOutputStream oos = new NbObjectOutputStream(ser.getOutputStream(lock));
            try {
                NbObjectOutputStream.writeSafely((ObjectOutput)oos, (Object)LoaderPoolNode.getNbLoaderPool());
            }
            finally {
                oos.close();
            }
        }
        finally {
            lock.releaseLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void load() throws IOException {
        FileObject ser = LoaderPoolNode.getLoaderPoolStorage(false);
        if (ser != null) {
            NbObjectInputStream ois = new NbObjectInputStream(ser.getInputStream());
            try {
                NbObjectInputStream.readSafely((ObjectInput)ois);
            }
            finally {
                ois.close();
            }
        }
    }

    public static FileObject getLoaderPoolStorage(boolean create) throws IOException {
        FileSystem sfs = Repository.getDefault().getDefaultFileSystem();
        FileObject fo = sfs.findResource(LOADER_POOL_NAME);
        if (fo == null && create) {
            fo = sfs.getRoot().createData(LOADER_POOL_NAME);
        }
        return fo;
    }

    private static synchronized void update() {
        if (err.isLoggable(1)) {
            err.log("update");
        }
        loadersArray = null;
        NbLoaderPool lp = LoaderPoolNode.getNbLoaderPool();
        if (lp != null && installationFinished) {
            lp.superFireChangeEvent();
            if (myChildren != null) {
                myChildren.update();
            }
        }
        if (lp != null) {
            Enumeration e = lp.allLoaders();
            while (e.hasMoreElements()) {
                DataLoader l = (DataLoader)e.nextElement();
                l.removePropertyChangeListener((PropertyChangeListener)lp);
                l.addPropertyChangeListener((PropertyChangeListener)lp);
            }
        }
    }

    public static synchronized boolean remove(DataLoader dl) {
        if (loaders.remove(dl)) {
            if (err.isLoggable(1)) {
                err.log("remove: " + dl);
            }
            String cname = dl.getClass().getName();
            names2Loaders.remove(cname);
            repNames2Loaders.remove(dl.getRepresentationClassName());
            installBefores.remove(cname);
            installAfters.remove(cname);
            dl.removePropertyChangeListener((PropertyChangeListener)LoaderPoolNode.getNbLoaderPool());
            if (updatingBatch) {
                updatingBatchUsed = true;
            } else {
                LoaderPoolNode.resort();
            }
            modifiedLoaders.remove(dl);
            return true;
        }
        return false;
    }

    public static synchronized LoaderPoolNode getLoaderPoolNode() {
        if (loaderPoolNode == null) {
            loaderPoolNode = new LoaderPoolNode();
        }
        return loaderPoolNode;
    }

    public static synchronized NbLoaderPool getNbLoaderPool() {
        if (nbLoaderPool == null) {
            nbLoaderPool = (NbLoaderPool)DataLoaderPool.getDefault();
        }
        return nbLoaderPool;
    }

    static /* synthetic */ Object[] access$202(Object[] x0) {
        loadersArray = x0;
        return x0;
    }

    static {
        err = ErrorManager.getDefault().getInstance("org.netbeans.core.LoaderPoolNode");
        loaders = new ArrayList();
        modifiedLoaders = new HashSet();
        names2Loaders = new HashMap(200);
        repNames2Loaders = new HashMap(200);
        installBefores = new HashMap();
        installAfters = new HashMap();
        installationFinished = false;
        updatingBatch = false;
        updatingBatchUsed = false;
        nbLoaderPool = null;
    }

    private final class Index
    extends Index.Support {
        Index() {
        }

        public Node[] getNodes() {
            Enumeration e = LoaderPoolNode.this.getChildren().nodes();
            ArrayList<LoaderPoolItemNode> l = new ArrayList<LoaderPoolItemNode>();
            while (e.hasMoreElements()) {
                LoaderPoolItemNode node = (LoaderPoolItemNode)((Object)e.nextElement());
                if (node.isSystem) continue;
                l.add(node);
            }
            return l.toArray(new Node[l.size()]);
        }

        public int getNodesCount() {
            return this.getNodes().length;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void reorder(int[] perm) {
            Class clazz = class$org$netbeans$core$LoaderPoolNode == null ? (class$org$netbeans$core$LoaderPoolNode = LoaderPoolNode.class$("org.netbeans.core.LoaderPoolNode")) : class$org$netbeans$core$LoaderPoolNode;
            synchronized (clazz) {
                Object[] target;
                Object[] arr = loaders.toArray();
                if (arr.length == perm.length) {
                    target = new Object[arr.length];
                    for (int i = 0; i < arr.length; ++i) {
                        if (target[perm[i]] != null) {
                            throw new IllegalArgumentException();
                        }
                        target[perm[i]] = arr[i];
                    }
                } else {
                    throw new IllegalArgumentException();
                }
                loaders = new ArrayList<Object>(Arrays.asList(target));
                LoaderPoolNode.update();
            }
        }
    }

    public static final class NbLoaderPool
    extends DataLoaderPool
    implements PropertyChangeListener,
    Runnable {
        private static final long serialVersionUID = -8488524097175567566L;
        private transient RequestProcessor.Task fireTask = RequestProcessor.getDefault().create((Runnable)this);

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected Enumeration loaders() {
            Object[] arr = loadersArray;
            if (arr == null) {
                Class clazz = class$org$netbeans$core$LoaderPoolNode == null ? (class$org$netbeans$core$LoaderPoolNode = LoaderPoolNode.class$("org.netbeans.core.LoaderPoolNode")) : class$org$netbeans$core$LoaderPoolNode;
                synchronized (clazz) {
                    arr = LoaderPoolNode.access$202(loaders.toArray());
                }
            }
            return Enumerations.array((Object[])arr);
        }

        public void propertyChange(PropertyChangeEvent ev) {
            DataLoader l = (DataLoader)ev.getSource();
            String prop = ev.getPropertyName();
            if ("actions".equals(prop) && ev.getNewValue() == null) {
                return;
            }
            modifiedLoaders.add(l);
            if (err.isLoggable(1)) {
                err.log("Got change in " + l.getClass().getName() + "." + prop);
            }
            if ("actions".equals(prop) || "displayName".equals(prop)) {
                return;
            }
            if (installationFinished) {
                this.superFireChangeEvent();
            }
        }

        void superFireChangeEvent() {
            this.fireTask.schedule(1000);
        }

        public void run() {
            super.fireChangeEvent(new ChangeEvent(this));
            if (err.isLoggable(1)) {
                err.log("change event fired");
            }
        }

        private void writeObject(ObjectOutputStream oos) throws IOException {
            LoaderPoolNode.writePool(oos);
        }

        private void readObject(ObjectInputStream ois) throws IOException, ClassNotFoundException {
            LoaderPoolNode.readPool(ois);
        }

        private Object readResolve() {
            return LoaderPoolNode.getNbLoaderPool();
        }
    }

    private static final class LoaderChildren
    extends Children.Keys {
        public LoaderChildren() {
            this.update();
        }

        public void update() {
            LinkedList _loaders = new LinkedList();
            Enumeration e = LoaderPoolNode.getNbLoaderPool().allLoaders();
            while (e.hasMoreElements()) {
                _loaders.add(e.nextElement());
            }
            this.setKeys(_loaders);
        }

        protected Node[] createNodes(Object loader) {
            try {
                return new Node[]{new LoaderPoolItemNode((DataLoader)loader)};
            }
            catch (IntrospectionException e) {
                err.notify((Throwable)e);
                return new Node[0];
            }
        }
    }

    private static class LoaderPoolItemNode
    extends BeanNode {
        boolean isSystem;

        public LoaderPoolItemNode(DataLoader loader) throws IntrospectionException {
            super((Object)loader);
            this.setSynchronizeName(false);
            String displayName = this.getDisplayName();
            this.setName(loader.getClass().getName());
            boolean bl = this.isSystem = !loaders.contains(loader);
            if (this.isSystem) {
                this.setDisplayName(NbBundle.getMessage((Class)(class$org$netbeans$core$LoaderPoolNode == null ? (class$org$netbeans$core$LoaderPoolNode = LoaderPoolNode.class$("org.netbeans.core.LoaderPoolNode")) : class$org$netbeans$core$LoaderPoolNode), (String)"LBL_system_data_loader", (Object)displayName));
            } else {
                this.setDisplayName(displayName);
            }
        }

        public SystemAction[] createActions() {
            if (this.isSystem) {
                return new SystemAction[]{SystemAction.get((Class)(class$org$openide$actions$ToolsAction == null ? (class$org$openide$actions$ToolsAction = LoaderPoolNode.class$("org.openide.actions.ToolsAction")) : class$org$openide$actions$ToolsAction)), SystemAction.get((Class)(class$org$openide$actions$PropertiesAction == null ? (class$org$openide$actions$PropertiesAction = LoaderPoolNode.class$("org.openide.actions.PropertiesAction")) : class$org$openide$actions$PropertiesAction))};
            }
            return new SystemAction[]{SystemAction.get((Class)(class$org$openide$actions$MoveUpAction == null ? (class$org$openide$actions$MoveUpAction = LoaderPoolNode.class$("org.openide.actions.MoveUpAction")) : class$org$openide$actions$MoveUpAction)), SystemAction.get((Class)(class$org$openide$actions$MoveDownAction == null ? (class$org$openide$actions$MoveDownAction = LoaderPoolNode.class$("org.openide.actions.MoveDownAction")) : class$org$openide$actions$MoveDownAction)), null, SystemAction.get((Class)(class$org$openide$actions$ToolsAction == null ? (class$org$openide$actions$ToolsAction = LoaderPoolNode.class$("org.openide.actions.ToolsAction")) : class$org$openide$actions$ToolsAction)), SystemAction.get((Class)(class$org$openide$actions$PropertiesAction == null ? (class$org$openide$actions$PropertiesAction = LoaderPoolNode.class$("org.openide.actions.PropertiesAction")) : class$org$openide$actions$PropertiesAction))};
        }

        public Action getPreferredAction() {
            return SystemAction.get((Class)(class$org$openide$actions$PropertiesAction == null ? (class$org$openide$actions$PropertiesAction = LoaderPoolNode.class$("org.openide.actions.PropertiesAction")) : class$org$openide$actions$PropertiesAction));
        }

        public boolean canDestroy() {
            return false;
        }

        public boolean canCopy() {
            return false;
        }

        public boolean canCut() {
            return false;
        }

        public boolean canRename() {
            return false;
        }

        public HelpCtx getHelpCtx() {
            HelpCtx help = super.getHelpCtx();
            if (help == null || help.getHelpID() == null || help.getHelpID().equals((class$org$openide$nodes$BeanNode == null ? (class$org$openide$nodes$BeanNode = LoaderPoolNode.class$("org.openide.nodes.BeanNode")) : class$org$openide$nodes$BeanNode).getName())) {
                help = new HelpCtx(class$org$netbeans$core$LoaderPoolNode$LoaderPoolItemNode == null ? (class$org$netbeans$core$LoaderPoolNode$LoaderPoolItemNode = LoaderPoolNode.class$("org.netbeans.core.LoaderPoolNode$LoaderPoolItemNode")) : class$org$netbeans$core$LoaderPoolNode$LoaderPoolItemNode);
            }
            return help;
        }
    }
}

