/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core;

import [Lorg.openide.filesystems.FileSystem;;
import java.io.IOException;
import java.io.NotSerializableException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.netbeans.core.AutomountSupport;
import org.netbeans.core.NbPlaces;
import org.openide.ErrorManager;
import org.openide.cookies.InstanceCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.Repository;
import org.openide.filesystems.RepositoryEvent;
import org.openide.filesystems.RepositoryListener;
import org.openide.filesystems.RepositoryReorderedEvent;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.loaders.FolderInstance;
import org.openide.loaders.InstanceDataObject;
import org.openide.util.RequestProcessor;
import org.openide.util.Task;
import org.openide.util.TaskListener;
import org.openide.util.WeakSet;

public class AutomountSupport
extends FolderInstance
implements RepositoryListener,
Runnable {
    private static RequestProcessor RP = new RequestProcessor("Automount");
    private static ThreadLocal VAR = new ThreadLocal();
    private static DblTask defaultTask;
    private static final int DELAY = 1000;
    private static Set createdByMe;
    private static Set sticky;
    private static Set shineAway;
    private static Set errCookies;
    private boolean defaultInstance;
    private static ErrorManager err;
    static /* synthetic */ Class class$org$openide$cookies$InstanceCookie;

    private AutomountSupport(DataObject.Container fld, boolean defaultInstance) {
        super(fld);
        this.defaultInstance = defaultInstance;
    }

    protected Object createInstance(InstanceCookie[] cookies) throws IOException, ClassNotFoundException {
        ArrayList<Object> arr = new ArrayList<Object>();
        for (int i = 0; i < cookies.length; ++i) {
            Object obj;
            try {
                obj = cookies[i].instanceCreate();
            }
            catch (IOException ex) {
                if (!errCookies.add(cookies[i])) continue;
                ErrorManager.getDefault().notify(1, (Throwable)ex);
                continue;
            }
            errCookies.remove(cookies[i]);
            if (obj instanceof FileSystem) {
                arr.add(obj);
                continue;
            }
            if (!(obj instanceof FileSystem[])) continue;
            arr.addAll(Arrays.asList((FileSystem[])obj));
        }
        Object retValue = arr.size() == 1 ? arr.get(0) : arr.toArray(new FileSystem[0]);
        if (this.defaultInstance) {
            AutomountSupport.updateFileSystems(arr);
        }
        return retValue;
    }

    protected Object instanceForCookie(DataObject obj, InstanceCookie cookie) throws IOException, ClassNotFoundException {
        if (errCookies.contains(cookie)) {
            obj.delete();
            return null;
        }
        try {
            return super.instanceForCookie(obj, cookie);
        }
        catch (IOException ioe) {
            ErrorManager.getDefault().notify(1, (Throwable)ioe);
            obj.delete();
            return null;
        }
    }

    protected InstanceCookie acceptContainer(DataObject.Container container) {
        return new AutomountSupport(container, false);
    }

    protected InstanceCookie acceptCookie(InstanceCookie cookie) throws IOException, ClassNotFoundException {
        if (cookie instanceof InstanceCookie.Of) {
            InstanceCookie.Of of = (InstanceCookie.Of)cookie;
            if (of.instanceOf(FileSystem.class) || of.instanceOf(FileSystem;.class)) {
                return cookie;
            }
            return null;
        }
        Class<?> c = cookie.instanceClass();
        if (c.isArray()) {
            c = c.getComponentType();
        }
        if (FileSystem.class.isAssignableFrom(c)) {
            return cookie;
        }
        return null;
    }

    protected Task postCreationTask(Runnable run) {
        return RP.post(run);
    }

    private List getList() {
        Object fsOrFss = null;
        try {
            fsOrFss = this.instanceCreate();
        }
        catch (IOException ex) {
            ErrorManager.getDefault().notify((Throwable)ex);
        }
        catch (ClassNotFoundException ex) {
            ErrorManager.getDefault().notify((Throwable)ex);
        }
        if (fsOrFss == null) {
            return Collections.EMPTY_LIST;
        }
        if (fsOrFss instanceof FileSystem) {
            return Collections.nCopies(1, fsOrFss);
        }
        return Arrays.asList((FileSystem[])fsOrFss);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized Task initialize() {
        if (defaultTask != null) {
            return defaultTask;
        }
        NbPlaces.getDefault();
        DataFolder folder = NbPlaces.findSessionFolder("Mount");
        AutomountSupport auto = new AutomountSupport((DataObject.Container)folder, true);
        RequestProcessor.Task storeTask = RP.create((Runnable)auto);
        storeTask.setPriority(1);
        defaultTask = new DblTask((Task)auto, storeTask);
        Repository rep = Repository.getDefault();
        rep.addRepositoryListener((RepositoryListener)auto);
        AutomountSupport automountSupport = auto;
        synchronized (automountSupport) {
            sticky.addAll(Arrays.asList(rep.toArray()));
            if (sticky.size() > 1) {
                defaultTask.store();
            }
        }
        auto.recreate();
        return defaultTask;
    }

    public void run() {
        try {
            FileSystem fs = Repository.getDefault().getDefaultFileSystem();
            fs.runAtomicAction(new FileSystem.AtomicAction(){

                public void run() {
                    NbPlaces.getDefault();
                    DataFolder df = NbPlaces.findSessionFolder("Mount");
                    List list = AutomountSupport.this.getList();
                    Enumeration en = df.getPrimaryFile().getFolders(true);
                    while (en.hasMoreElements()) {
                        try {
                            DataFolder dfChild = (DataFolder)DataFolder.find((FileObject)((FileObject)en.nextElement()));
                            AutomountSupport.this.checkSaved(list, dfChild, dfChild.getChildren(), false);
                        }
                        catch (DataObjectNotFoundException e) {}
                    }
                    AutomountSupport.this.checkSaved(list, df, df.getChildren(), true);
                }
            });
        }
        catch (IOException ex) {
            throw new IllegalStateException();
        }
    }

    public void fileSystemAdded(RepositoryEvent ev) {
        defaultTask.fs(ev);
    }

    public void fileSystemRemoved(RepositoryEvent ev) {
        defaultTask.fs(ev);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fileSystemPoolReordered(RepositoryReorderedEvent ev) {
        if (VAR.get() == null) {
            if (AutomountSupport.isLog()) {
                AutomountSupport.log("Reorder in repository");
                Repository repository = Repository.getDefault();
                synchronized (repository) {
                    FileSystem[] arr = Repository.getDefault().toArray();
                    for (int i = 0; i < arr.length; ++i) {
                        AutomountSupport.log("   " + i + "th = " + arr[i]);
                    }
                }
            }
            defaultTask.store();
        } else {
            AutomountSupport.log("Repository reordered by AU");
        }
    }

    private static boolean containsFS(FileSystem fs) {
        FileSystem[] arr = Repository.getDefault().toArray();
        for (int i = 0; i < arr.length; ++i) {
            if (arr[i] != fs) continue;
            return true;
        }
        return false;
    }

    private static String escape(String name) throws IOException {
        try {
            Method escape = InstanceDataObject.class.getDeclaredMethod("escapeAndCut", String.class);
            escape.setAccessible(true);
            return (String)escape.invoke(null, (Object[])new String[]{name});
        }
        catch (Exception ex) {
            throw (IOException)ErrorManager.getDefault().annotate((Throwable)new IOException("Escape support failed"), (Throwable)ex);
        }
    }

    public static String computeNewName(String requiredName, DataFolder df) throws IOException {
        if (requiredName == null || requiredName.length() == 0) {
            return null;
        }
        boolean isUsed = true;
        String srcName = requiredName;
        int i = 1;
        while (isUsed) {
            String uniqueName;
            isUsed = false;
            String escaped = AutomountSupport.escape(srcName);
            if (escaped.equals(uniqueName = FileUtil.findFreeFileName((FileObject)df.getPrimaryFile(), (String)escaped, (String)"settings"))) continue;
            isUsed = true;
            srcName = requiredName + "_" + i;
            ++i;
        }
        return srcName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkSaved(List now, DataFolder df, DataObject[] arr, boolean isSaveEnabled) {
        Repository rep;
        Repository repository = rep = Repository.getDefault();
        synchronized (repository) {
            InstanceCookie ic;
            Object obj;
            int i;
            boolean diff;
            List<FileSystem> asList = Arrays.asList(rep.toArray());
            ArrayList<FileSystem> exists = new ArrayList<FileSystem>(asList);
            exists.removeAll(createdByMe);
            exists.removeAll(now);
            ArrayList<Object> order = new ArrayList<Object>(asList.size() * 2);
            order.addAll(Arrays.asList(arr));
            sticky.removeAll(now);
            HashSet<FileSystem> doNotDeleteFileSystems = new HashSet<FileSystem>(asList);
            doNotDeleteFileSystems.retainAll(createdByMe);
            ArrayList<FileSystem> onlyOrder = new ArrayList<FileSystem>(asList);
            onlyOrder.retainAll(now);
            boolean bl = diff = onlyOrder.size() == now.size() && !((Object)onlyOrder).equals(now);
            if (diff) {
                class Cmp
                extends HashMap
                implements Comparator {
                    Cmp() {
                    }

                    public int compare(Object o1, Object o2) {
                        return this.index(o1) - this.index(o2);
                    }

                    private int index(Object o1) {
                        return (Integer)this.get(o1);
                    }
                }
                Cmp cmp = new Cmp();
                i = onlyOrder.size();
                Iterator it = order.iterator();
                while (it.hasNext()) {
                    obj = (DataObject)it.next();
                    ++i;
                    ic = (InstanceCookie)obj.getCookie(class$org$openide$cookies$InstanceCookie == null ? AutomountSupport.class$("org.openide.cookies.InstanceCookie") : class$org$openide$cookies$InstanceCookie);
                    if (ic != null) {
                        try {
                            Object o = ic.instanceCreate();
                            int indx = onlyOrder.indexOf(o);
                            if (indx >= 0) {
                                cmp.put(obj, new Integer(indx));
                                continue;
                            }
                        }
                        catch (ClassNotFoundException ex) {
                            ErrorManager.getDefault().notify(1, (Throwable)ex);
                        }
                        catch (IOException ex) {
                            ErrorManager.getDefault().notify(1, (Throwable)ex);
                        }
                    }
                    cmp.put(obj, new Integer(i));
                }
                Collections.sort(order, cmp);
            }
            Iterator it = exists.iterator();
            if (isSaveEnabled) {
                while (it.hasNext()) {
                    FileSystem fs = (FileSystem)it.next();
                    if (fs.isDefault()) continue;
                    try {
                        InstanceDataObject dobj;
                        String name = AutomountSupport.computeNewName(fs.getDisplayName(), df);
                        try {
                            dobj = InstanceDataObject.create((DataFolder)df, (String)name, (Object)fs, null);
                            createdByMe.add(fs);
                        }
                        catch (NotSerializableException nse) {
                            continue;
                        }
                        if (dobj.instanceCreate() != fs) {
                            StringBuffer sb = new StringBuffer(255);
                            sb.append("This bug is caused by wrong implementation of InstanceDataObject, see ");
                            sb.append("http://www.netbeans.org/issues/show_bug.cgi?id=14557");
                            sb.append("\nSTORING: ");
                            sb.append(fs);
                            sb.append("\nINSTNCE: ");
                            sb.append(dobj.instanceCreate());
                            throw new IllegalStateException(sb.toString());
                        }
                        doNotDeleteFileSystems.add(fs);
                        if (AutomountSupport.isLog()) {
                            AutomountSupport.log(" written to disk: " + fs + " into: " + dobj);
                        }
                        order.add(dobj);
                        sticky.remove(fs);
                        diff = true;
                    }
                    catch (IOException ex) {
                        ErrorManager.getDefault().notify((Throwable)ex);
                    }
                    catch (ClassNotFoundException ex) {
                        ErrorManager.getDefault().notify((Throwable)ex);
                    }
                }
            }
            for (i = 0; i < arr.length; ++i) {
                InstanceCookie ic2 = (InstanceCookie)arr[i].getCookie(class$org$openide$cookies$InstanceCookie == null ? AutomountSupport.class$("org.openide.cookies.InstanceCookie") : class$org$openide$cookies$InstanceCookie);
                if (ic2 == null) continue;
                try {
                    obj = ic2.instanceCreate();
                    if (!(obj instanceof FileSystem) || doNotDeleteFileSystems.contains(obj)) continue;
                    arr[i].delete();
                    createdByMe.retainAll(Arrays.asList(rep.toArray()));
                    if (AutomountSupport.isLog()) {
                        AutomountSupport.log("  deleted from disk: " + obj + " from: " + arr[i]);
                    }
                    order.remove(arr[i]);
                    diff = true;
                    continue;
                }
                catch (ClassNotFoundException ex) {
                    ErrorManager.getDefault().notify((Throwable)ex);
                    continue;
                }
                catch (IOException ex) {
                    ErrorManager.getDefault().notify((Throwable)ex);
                }
            }
            if (diff) {
                try {
                    df.setOrder(order.toArray(new DataObject[0]));
                    if (this.isFinished()) {
                        AutomountSupport.log("I should not be finished");
                        this.waitFinished();
                        AutomountSupport.log("And I am not no longer: " + this.isFinished());
                    }
                    if (AutomountSupport.isLog()) {
                        AutomountSupport.log("Changed order on the disk");
                        Iterator x = order.iterator();
                        int i2 = 0;
                        while (x.hasNext()) {
                            obj = (DataObject)x.next();
                            ic = (InstanceCookie)obj.getCookie(class$org$openide$cookies$InstanceCookie == null ? AutomountSupport.class$("org.openide.cookies.InstanceCookie") : class$org$openide$cookies$InstanceCookie);
                            if (ic == null) continue;
                            AutomountSupport.log("  " + i2++ + " is: " + ic.instanceCreate());
                        }
                    }
                }
                catch (IOException ex) {
                    ErrorManager.getDefault().notify((Throwable)ex);
                }
                catch (ClassNotFoundException ex) {
                    ErrorManager.getDefault().notify((Throwable)ex);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void updateFileSystems(List future) {
        Repository rep;
        Repository repository = rep = Repository.getDefault();
        synchronized (repository) {
            int i;
            List<FileSystem> exists = Arrays.asList(rep.toArray());
            LinkedList<FileSystem> toRemove = new LinkedList<FileSystem>(exists);
            toRemove.removeAll(future);
            toRemove.removeAll(sticky);
            AutomountSupport.log("sticky: " + sticky);
            toRemove.retainAll(createdByMe);
            if (AutomountSupport.isLog()) {
                Iterator it = toRemove.iterator();
                while (it.hasNext()) {
                    FileSystem fs = (FileSystem)it.next();
                    AutomountSupport.log("  r: " + fs + " contains: " + sticky.contains(fs));
                }
            }
            LinkedList toAdd = new LinkedList(future);
            toAdd.removeAll(exists);
            toAdd.removeAll(shineAway);
            if (AutomountSupport.isLog()) {
                Iterator it = toAdd.iterator();
                while (it.hasNext()) {
                    FileSystem fs = (FileSystem)it.next();
                    AutomountSupport.log("  a: " + fs + " contains: " + sticky.contains(fs));
                }
            }
            VAR.set(VAR);
            AutomountSupport.cycleFileSystems(toRemove, false);
            AutomountSupport.cycleFileSystems(toAdd, true);
            VAR.set(null);
            createdByMe.addAll(future);
            createdByMe.retainAll(Arrays.asList(rep.toArray()));
            FileSystem[] arr = rep.toArray();
            LinkedList future1 = new LinkedList(future);
            future1.retainAll(Arrays.asList(arr));
            int[] perm = new int[arr.length];
            int old = future1.size() + 1;
            boolean diff = false;
            for (i = 0; i < arr.length; ++i) {
                if (arr[i].isDefault()) {
                    perm[i] = 0;
                    continue;
                }
                int indx = future1.indexOf(arr[i]);
                indx = indx == -1 ? old++ : ++indx;
                perm[indx] = i;
                diff |= indx != i;
            }
            if (diff) {
                if (AutomountSupport.isLog()) {
                    AutomountSupport.log("Doing reorder");
                    for (i = 0; i < arr.length; ++i) {
                        AutomountSupport.log("  " + i + " <- " + perm[i] + " now: " + arr[i]);
                    }
                    AutomountSupport.log("On disk");
                    Iterator x = future1.iterator();
                    while (x.hasNext()) {
                        AutomountSupport.log("  " + x.next());
                    }
                    AutomountSupport.log("------");
                }
                VAR.set(VAR);
                try {
                    rep.reorder(perm);
                }
                finally {
                    VAR.set(null);
                }
            } else {
                AutomountSupport.log("No reoder");
            }
        }
    }

    private static void cycleFileSystems(Collection fss, boolean add) {
        Repository repository = Repository.getDefault();
        Iterator it = fss.iterator();
        while (it.hasNext()) {
            FileSystem fs = (FileSystem)it.next();
            if (add) {
                FileSystem old = repository.findFileSystem(fs.getSystemName());
                if (old != null && old != fs && sticky.remove(old)) {
                    repository.removeFileSystem(old);
                }
                repository.addFileSystem(fs);
                continue;
            }
            repository.removeFileSystem(fs);
        }
    }

    private static boolean isLog() {
        if (err == null) {
            err = ErrorManager.getDefault().getInstance("org.netbeans.core.AutomountSupport");
        }
        return err.isLoggable(1);
    }

    private static void log(String msg) {
        if (AutomountSupport.isLog()) {
            err.log(msg);
        }
    }

    static /* synthetic */ boolean access$400(FileSystem x0) {
        return AutomountSupport.containsFS(x0);
    }

    static /* synthetic */ Set access$500() {
        return sticky;
    }

    static /* synthetic */ Set access$600() {
        return shineAway;
    }

    static /* synthetic */ DblTask access$700() {
        return defaultTask;
    }

    static {
        createdByMe = new WeakSet();
        sticky = new WeakSet();
        shineAway = new WeakSet();
        errCookies = new WeakSet();
    }

    private static final class DblTask
    extends Task
    implements TaskListener {
        private Task defaultInstance;
        private RequestProcessor.Task storeTask;
        private Task updateTask = Task.EMPTY;
        private boolean isStoring;

        public DblTask(Task defaultInstance, RequestProcessor.Task storeTask) {
            this.defaultInstance = defaultInstance;
            this.storeTask = storeTask;
            defaultInstance.addTaskListener((TaskListener)this);
            storeTask.addTaskListener((TaskListener)this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void store() {
            DblTask dblTask = this;
            synchronized (dblTask) {
                this.storeTask.schedule(1000);
                this.isStoring = true;
            }
            this.notifyRunning();
        }

        private synchronized boolean areBothFinished() {
            boolean t1;
            boolean bl = t1 = !this.isStoring || this.storeTask.isFinished();
            if (!t1) {
                return false;
            }
            boolean t2 = this.defaultInstance.isFinished();
            if (!t2) {
                return false;
            }
            boolean t3 = this.updateTask.isFinished();
            return t3;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void waitFinished() {
            AutomountSupport.log("Entered waitFinished");
            for (int i = 0; i < 2; ++i) {
                do {
                    boolean storing;
                    this.updateTask.waitFinished();
                    this.defaultInstance.waitFinished();
                    DblTask dblTask = this;
                    synchronized (dblTask) {
                        storing = this.isStoring;
                    }
                    if (!storing) continue;
                    this.storeTask.waitFinished();
                } while (!this.areBothFinished());
            }
            AutomountSupport.log("Leaving waitFinished");
        }

        public void taskFinished(Task t) {
            if (this.areBothFinished()) {
                this.notifyFinished();
            }
        }

        public synchronized void fs(RepositoryEvent ev) {
            boolean isNull;
            boolean bl = isNull = VAR.get() == null;
            if (!isNull) {
                AutomountSupport.log("fs: " + ev.getFileSystem() + " added: " + ev.isAdded() + " by AU support");
                return;
            }
            class Run
            implements Runnable {
                public RepositoryEvent ev;
                private final /* synthetic */ DblTask this$0;

                public Run(DblTask this$0, RepositoryEvent ev) {
                    this.this$0 = this$0;
                    this.ev = ev;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    Repository rep;
                    Repository repository = rep = Repository.getDefault();
                    synchronized (repository) {
                        FileSystem fs = this.ev.getFileSystem();
                        boolean c = AutomountSupport.access$400(fs);
                        boolean added = this.ev.isAdded();
                        AutomountSupport.access$200("fs: " + fs + " added: " + added + " contains: " + c);
                        if (added) {
                            if (c) {
                                AutomountSupport.access$500().add(fs);
                                AutomountSupport.access$600().remove(fs);
                                AutomountSupport.access$700().store();
                            }
                        } else if (!c) {
                            AutomountSupport.access$500().remove(fs);
                            AutomountSupport.access$600().add(fs);
                            AutomountSupport.access$700().store();
                        }
                    }
                    this.this$0.removeTaskListener(this.this$0);
                    this.ev = null;
                }
            }
            RequestProcessor.Task task = RP.post((Runnable)new Run(this, ev));
            task.addTaskListener((TaskListener)this);
            this.updateTask = task;
        }
    }
}

