/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.trident.api;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.pushingpixels.trident.api.TimelineEngine;
import org.pushingpixels.trident.api.interpolator.PropertyInterpolator;
import org.pushingpixels.trident.api.interpolator.PropertyInterpolatorSource;
import org.pushingpixels.trident.internal.interpolator.CorePropertyInterpolators;
import org.pushingpixels.trident.internal.swing.AWTPropertyInterpolators;

public class TridentConfig {
    private static TridentConfig config;
    private Set<PropertyInterpolator<?>> propertyInterpolators;
    private PulseSource pulseSource = new DefaultPulseSource();

    private TridentConfig() {
        this.propertyInterpolators = new HashSet();
        this.addPropertyInterpolatorSource(new CorePropertyInterpolators());
        this.addPropertyInterpolatorSource(new AWTPropertyInterpolators());
    }

    public static synchronized TridentConfig getInstance() {
        if (config == null) {
            config = new TridentConfig();
        }
        return config;
    }

    public synchronized Collection<PropertyInterpolator<?>> getPropertyInterpolators() {
        return Collections.unmodifiableSet(this.propertyInterpolators);
    }

    public synchronized <T> PropertyInterpolator<T> getPropertyInterpolator(Collection<T> values) {
        for (PropertyInterpolator<?> interpolator : this.propertyInterpolators) {
            try {
                Class<?> basePropertyClass = interpolator.getBasePropertyClass();
                boolean hasMatch = true;
                for (T value : values) {
                    if (basePropertyClass.isAssignableFrom(value.getClass())) continue;
                    hasMatch = false;
                }
                if (!hasMatch) continue;
                return interpolator;
            }
            catch (NoClassDefFoundError noClassDefFoundError) {
            }
        }
        return null;
    }

    public synchronized void addPropertyInterpolator(PropertyInterpolator<?> pInterpolator) {
        this.propertyInterpolators.add(pInterpolator);
    }

    public synchronized void addPropertyInterpolatorSource(PropertyInterpolatorSource pInterpolatorSource) {
        this.propertyInterpolators.addAll(pInterpolatorSource.getPropertyInterpolators());
    }

    public synchronized void removePropertyInterpolator(PropertyInterpolator<?> pInterpolator) {
        this.propertyInterpolators.remove(pInterpolator);
    }

    public synchronized void setPulseSource(PulseSource pulseSource) {
        TimelineEngine.TridentAnimationThread current = TimelineEngine.getInstance().animatorThread;
        if (current != null && current.isAlive()) {
            throw new IllegalStateException("Cannot replace the pulse source thread once it's running");
        }
        this.pulseSource = pulseSource;
    }

    public synchronized PulseSource getPulseSource() {
        return this.pulseSource;
    }

    private static class DefaultPulseSource
    extends FixedRatePulseSource {
        DefaultPulseSource() {
            super(40);
        }
    }

    public static class FixedRatePulseSource
    implements PulseSource {
        private int msDelay;

        public FixedRatePulseSource(int msDelay) {
            this.msDelay = msDelay;
        }

        @Override
        public void waitUntilNextPulse() {
            try {
                Thread.sleep(this.msDelay);
            }
            catch (InterruptedException ie) {
                ie.printStackTrace();
            }
        }
    }

    public static interface PulseSource {
        public void waitUntilNextPulse();
    }
}

