/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.netty.shaded.io.netty.handler.codec.http.websocketx;

import io.grpc.netty.shaded.io.netty.channel.ChannelFuture;
import io.grpc.netty.shaded.io.netty.channel.ChannelFutureListener;
import io.grpc.netty.shaded.io.netty.channel.ChannelHandlerContext;
import io.grpc.netty.shaded.io.netty.channel.ChannelOutboundHandlerAdapter;
import io.grpc.netty.shaded.io.netty.channel.ChannelPromise;
import io.grpc.netty.shaded.io.netty.handler.codec.http.websocketx.CloseWebSocketFrame;
import io.grpc.netty.shaded.io.netty.handler.codec.http.websocketx.WebSocketCloseStatus;
import io.grpc.netty.shaded.io.netty.handler.codec.http.websocketx.WebSocketHandshakeException;
import io.grpc.netty.shaded.io.netty.util.ReferenceCountUtil;
import io.grpc.netty.shaded.io.netty.util.concurrent.ScheduledFuture;
import io.grpc.netty.shaded.io.netty.util.internal.ObjectUtil;
import java.nio.channels.ClosedChannelException;
import java.util.concurrent.TimeUnit;

final class WebSocketCloseFrameHandler
extends ChannelOutboundHandlerAdapter {
    private final WebSocketCloseStatus closeStatus;
    private final long forceCloseTimeoutMillis;
    private ChannelPromise closeSent;

    WebSocketCloseFrameHandler(WebSocketCloseStatus closeStatus, long forceCloseTimeoutMillis) {
        this.closeStatus = ObjectUtil.checkNotNull(closeStatus, "closeStatus");
        this.forceCloseTimeoutMillis = forceCloseTimeoutMillis;
    }

    @Override
    public void close(final ChannelHandlerContext ctx, final ChannelPromise promise) throws Exception {
        if (!ctx.channel().isActive()) {
            ctx.close(promise);
            return;
        }
        if (this.closeSent == null) {
            this.write(ctx, new CloseWebSocketFrame(this.closeStatus), ctx.newPromise());
        }
        this.flush(ctx);
        this.applyCloseSentTimeout(ctx);
        this.closeSent.addListener(new ChannelFutureListener(){

            @Override
            public void operationComplete(ChannelFuture future) {
                ctx.close(promise);
            }
        });
    }

    @Override
    public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) throws Exception {
        if (this.closeSent != null) {
            ReferenceCountUtil.release(msg);
            promise.setFailure(new ClosedChannelException());
            return;
        }
        if (msg instanceof CloseWebSocketFrame) {
            this.closeSent = promise = promise.unvoid();
        }
        super.write(ctx, msg, promise);
    }

    private void applyCloseSentTimeout(ChannelHandlerContext ctx) {
        if (this.closeSent.isDone() || this.forceCloseTimeoutMillis < 0L) {
            return;
        }
        final ScheduledFuture<?> timeoutTask = ctx.executor().schedule(new Runnable(){

            @Override
            public void run() {
                if (!WebSocketCloseFrameHandler.this.closeSent.isDone()) {
                    WebSocketCloseFrameHandler.this.closeSent.tryFailure(new WebSocketHandshakeException("send close frame timed out"));
                }
            }
        }, this.forceCloseTimeoutMillis, TimeUnit.MILLISECONDS);
        this.closeSent.addListener(new ChannelFutureListener(){

            @Override
            public void operationComplete(ChannelFuture future) {
                timeoutTask.cancel(false);
            }
        });
    }
}

