/*
 * Decompiled with CFR 0.152.
 */
package org.openide.nodes;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.WeakHashMap;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.nodes.NodeAdapter;

final class ChildrenArray
extends NodeAdapter {
    public Children children;
    private Node[] nodes;
    private Map map;

    public Children getChildren() {
        return this.children;
    }

    protected void finalize() {
        this.children.finalizedChildrenArray(this);
    }

    public Node[] nodes() {
        if (this.children == null) {
            return null;
        }
        if (this.nodes == null) {
            this.nodes = this.children.justComputeNodes();
            for (int i = 0; i < this.nodes.length; ++i) {
                this.nodes[i].reassignTo(this.children, this);
            }
            this.children.registerChildrenArray(this, this.nodes.length > 0);
        }
        return this.nodes;
    }

    private synchronized Map getMap() {
        if (this.map == null) {
            this.map = Collections.synchronizedMap(new WeakHashMap(7));
        }
        return this.map;
    }

    public void clear() {
        if (this.nodes != null) {
            this.nodes = null;
            this.children.registerChildrenArray(this, false);
        }
    }

    public void finalizeNodes() {
        Map m = this.map;
        if (m != null) {
            m.remove(null);
        }
    }

    public boolean isInitialized() {
        return this.nodes != null;
    }

    public Collection nodesFor(Children.Info info) {
        Collection nodes = (Collection)this.getMap().get(info);
        if (nodes == null) {
            nodes = info.entry.nodes();
            info.length = nodes.size();
            this.getMap().put(info, nodes);
        }
        return nodes;
    }

    public void useNodes(Children.Info info, Collection list) {
        info.length = list.size();
        this.getMap().put(info, list);
    }

    public String toString() {
        return super.toString() + "  " + this.getChildren();
    }
}

