/*
 * Decompiled with CFR 0.152.
 */
package sqlj.runtime;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.util.Map;
import java.util.Stack;
import sqlj.runtime.ConnectionContext;
import sqlj.runtime.error.RuntimeErrors;
import sqlj.runtime.error.RuntimeRefErrors;
import sqlj.runtime.profile.BatchContext;
import sqlj.runtime.profile.ConnectedProfile;
import sqlj.runtime.profile.RTResultSet;
import sqlj.runtime.profile.RTStatement;

public class ExecutionContext {
    private int m_maxFieldSize = 0;
    private int m_maxRows = 0;
    private int m_queryTimeout = 0;
    private int m_updateCount = 0;
    private SQLWarning m_warnings = null;
    private SQLWarning m_sqljWarnings = null;
    private int m_fetchDirection = 1000;
    private int m_fetchSize = 0;
    private StatementStack m_statementStack = new StatementStack();
    private static int m_uncustomizedWarningOrException = 0;
    public static final int QUERY_COUNT = -1;
    public static final int EXCEPTION_COUNT = -2;
    public static final int ADD_BATCH_COUNT = -3;
    public static final int AUTO_BATCH = 100;
    public static final int EXEC_BATCH_COUNT = -5;
    public static final int NEW_BATCH_COUNT = -6;
    public static final int UNLIMITED_BATCH = -7;
    private boolean m_doBatch = false;
    private int m_batchLimit = -7;
    private BatchContext m_bCtx;
    private int[] m_batchUpdateCounts = null;
    private int m_currentBatchSize = 0;
    private static final boolean DEBUG = false;

    public static void setUncustomizedWarningOrException(String string) {
        m_uncustomizedWarningOrException = Integer.parseInt(string);
    }

    public int getFetchDirection() {
        return this.m_fetchDirection;
    }

    public int getFetchSize() throws SQLException {
        return this.m_fetchSize;
    }

    public void setFetchSize(int n2) throws SQLException {
        if (n2 < 0 || this.getMaxRows() > 0 && n2 > this.getMaxRows()) {
            throw new SQLException(new IllegalArgumentException(n2 + "").getMessage());
        }
        this.m_fetchSize = n2;
    }

    public void setFetchDirection(int n2) throws SQLException {
        if (n2 != 1000 && n2 != 1001 && n2 != 1002) {
            throw new SQLException(new IllegalArgumentException(n2 + "").getMessage());
        }
        this.m_fetchDirection = n2;
    }

    public synchronized void setBatching(boolean bl) {
        this.m_doBatch = bl;
        if (!bl) {
            this.m_currentBatchSize = 0;
            this.m_bCtx = null;
        }
    }

    public synchronized boolean isBatching() {
        return this.m_doBatch;
    }

    public void setBatchLimit(int n2) {
        this.m_batchLimit = n2 < 0 ? -7 : n2;
    }

    public int getBatchLimit() {
        return this.m_batchLimit;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int[] executeBatch() throws SQLException {
        int[] nArray;
        block6: {
            int[] nArray2;
            block5: {
                this.startExec();
                try {
                    if (this.m_bCtx != null) {
                        this.m_batchUpdateCounts = this.m_bCtx.executeBatch();
                        this.m_updateCount = -5;
                        nArray2 = this.m_batchUpdateCounts;
                        Object var3_4 = null;
                        break block5;
                    }
                    this.m_updateCount = -5;
                    nArray = null;
                    break block6;
                }
                catch (Throwable throwable) {
                    Object var3_6 = null;
                    this.endExec();
                    this.m_currentBatchSize = 0;
                    this.m_bCtx = null;
                    throw throwable;
                }
            }
            this.endExec();
            this.m_currentBatchSize = 0;
            this.m_bCtx = null;
            return nArray2;
        }
        Object var3_5 = null;
        this.endExec();
        this.m_currentBatchSize = 0;
        this.m_bCtx = null;
        return nArray;
    }

    public int[] getBatchUpdateCounts() {
        return this.m_batchUpdateCounts;
    }

    private boolean checkIfBatchLimitMet() {
        if (this.m_batchLimit == -7) {
            return false;
        }
        return this.m_batchLimit > 0 && this.m_currentBatchSize >= this.m_batchLimit || this.m_batchLimit == 100 && this.m_currentBatchSize >= 100;
    }

    private void implicitBatchExecute() throws SQLException {
        try {
            this.m_batchUpdateCounts = this.m_bCtx.executeBatch();
            this.m_updateCount = -5;
            Object var2_1 = null;
            this.m_currentBatchSize = 0;
            this.m_bCtx = null;
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            this.m_currentBatchSize = 0;
            this.m_bCtx = null;
            throw throwable;
        }
    }

    public synchronized int getMaxFieldSize() {
        return this.m_maxFieldSize;
    }

    public synchronized void setMaxFieldSize(int n2) {
        this.m_maxFieldSize = n2;
    }

    public synchronized int getMaxRows() {
        return this.m_maxRows;
    }

    public synchronized void setMaxRows(int n2) {
        this.m_maxRows = n2;
    }

    public synchronized int getQueryTimeout() {
        return this.m_queryTimeout;
    }

    public synchronized void setQueryTimeout(int n2) {
        this.m_queryTimeout = n2;
    }

    public synchronized SQLWarning getWarnings() {
        return this.m_warnings;
    }

    public synchronized int getUpdateCount() {
        return this.m_updateCount;
    }

    public void cancel() throws SQLException {
        try {
            if (this.m_bCtx != null && this.m_currentBatchSize >= 1) {
                this.m_bCtx.clearBatch();
            }
            this.m_statementStack.cancelCurrent();
            Object var2_1 = null;
            if (this.m_bCtx != null && this.m_currentBatchSize >= 1) {
                this.m_currentBatchSize = 0;
                this.m_bCtx = null;
            }
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            if (this.m_bCtx != null && this.m_currentBatchSize >= 1) {
                this.m_currentBatchSize = 0;
                this.m_bCtx = null;
            }
            throw throwable;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public RTStatement registerStatement(ConnectionContext connectionContext, Object object, int n2) throws SQLException {
        if (connectionContext.isClosed()) {
            RuntimeRefErrors.raise_CONN_CTX_CLOSED();
        }
        ConnectedProfile connectedProfile = connectionContext.getConnectedProfile(object);
        Map map = connectionContext.getTypeMap();
        RTStatement rTStatement = null;
        if (!connectedProfile.isCustomized()) {
            switch (m_uncustomizedWarningOrException) {
                case 1: {
                    this.m_sqljWarnings = new SQLWarning(RuntimeErrors.UNCUSTOMIZED_text() + connectedProfile.getProfileData().getProfile().getProfileName());
                    break;
                }
                case 2: {
                    RuntimeErrors.raise_UNCUSTOMIZED(connectedProfile.getProfileData().getProfile().getProfileName());
                }
            }
        }
        rTStatement = this.m_statementStack.setStatement(connectedProfile, n2, this.m_bCtx, map);
        boolean bl = true;
        try {
            rTStatement.setMaxRows(this.m_maxRows);
            rTStatement.setMaxFieldSize(this.m_maxFieldSize);
            rTStatement.setQueryTimeout(this.m_queryTimeout);
            rTStatement.setFetchSize(this.m_fetchSize);
            bl = false;
            if (this.m_doBatch) {
                if (rTStatement.isBatchable()) {
                    if (this.m_bCtx == null) {
                        this.m_bCtx = rTStatement.getBatchContext();
                        this.m_currentBatchSize = 1;
                    } else if (rTStatement.isBatchCompatible()) {
                        ++this.m_currentBatchSize;
                    } else {
                        this.implicitBatchExecute();
                        this.m_bCtx = rTStatement.getBatchContext();
                        this.m_currentBatchSize = 1;
                    }
                } else {
                    if (this.m_bCtx != null && this.m_currentBatchSize >= 1) {
                        this.implicitBatchExecute();
                    }
                    this.m_bCtx = null;
                }
            }
            Object var9_8 = null;
            if (!bl) return rTStatement;
        }
        catch (Throwable throwable) {
            Object var9_9 = null;
            if (!bl) throw throwable;
            this.releaseStatement();
            throw throwable;
        }
        this.releaseStatement();
        return rTStatement;
    }

    public int executeUpdate() throws SQLException {
        int n2;
        this.startExec();
        try {
            this.m_updateCount = this.getStatement().executeUpdate();
            if (this.m_doBatch && this.m_bCtx != null) {
                if (this.checkIfBatchLimitMet()) {
                    this.implicitBatchExecute();
                } else {
                    this.m_updateCount = this.m_currentBatchSize == 1 ? -6 : -3;
                }
            }
            n2 = this.m_updateCount;
            Object var3_2 = null;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.endExec();
            throw throwable;
        }
        this.endExec();
        return n2;
    }

    public RTResultSet executeQuery() throws SQLException {
        RTResultSet rTResultSet;
        this.startExec();
        try {
            RTResultSet rTResultSet2 = this.getStatement().executeQuery();
            this.m_updateCount = this.getStatement().getUpdateCount();
            rTResultSet = rTResultSet2;
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.endExec();
            throw throwable;
        }
        this.endExec();
        return rTResultSet;
    }

    public boolean execute() throws SQLException {
        boolean bl;
        this.startExec();
        boolean bl2 = false;
        try {
            bl2 = this.getStatement().execute();
            this.m_updateCount = this.getStatement().getUpdateCount();
            if (this.m_doBatch && this.m_bCtx != null) {
                if (this.checkIfBatchLimitMet()) {
                    this.implicitBatchExecute();
                } else {
                    this.m_updateCount = this.m_currentBatchSize == 1 ? -6 : -3;
                }
            }
            bl = bl2;
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.endExec();
            throw throwable;
        }
        this.endExec();
        return bl;
    }

    public synchronized ResultSet getNextResultSet() throws SQLException {
        StatementFrame statementFrame = this.getStatement();
        if (statementFrame.getStatement() != null) {
            try {
                ResultSet resultSet = statementFrame.getNextResultSet();
                Object var4_3 = null;
                this.m_warnings = statementFrame.getWarnings();
                this.m_updateCount = statementFrame.getUpdateCount();
                return resultSet;
            }
            catch (Throwable throwable) {
                Object var4_4 = null;
                this.m_warnings = statementFrame.getWarnings();
                this.m_updateCount = statementFrame.getUpdateCount();
                throw throwable;
            }
        }
        return null;
    }

    public synchronized ResultSet getNextResultSet(int n2) throws SQLException {
        StatementFrame statementFrame = this.getStatement();
        if (statementFrame.getStatement() != null) {
            try {
                ResultSet resultSet = statementFrame.getNextResultSet(n2);
                Object var5_4 = null;
                this.m_warnings = statementFrame.getWarnings();
                this.m_updateCount = statementFrame.getUpdateCount();
                return resultSet;
            }
            catch (Throwable throwable) {
                Object var5_5 = null;
                this.m_warnings = statementFrame.getWarnings();
                this.m_updateCount = statementFrame.getUpdateCount();
                throw throwable;
            }
        }
        return null;
    }

    public void releaseStatement() throws SQLException {
        StatementFrame statementFrame = this.getStatement();
        try {
            statementFrame.releaseStatement();
            Object var3_2 = null;
            if (this.m_sqljWarnings != null) {
                this.m_warnings = this.m_sqljWarnings;
                this.m_warnings.setNextWarning(statementFrame.getWarnings());
            } else {
                this.m_warnings = statementFrame.getWarnings();
            }
            this.m_sqljWarnings = null;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            if (this.m_sqljWarnings != null) {
                this.m_warnings = this.m_sqljWarnings;
                this.m_warnings.setNextWarning(statementFrame.getWarnings());
            } else {
                this.m_warnings = statementFrame.getWarnings();
            }
            this.m_sqljWarnings = null;
            throw throwable;
        }
    }

    private StatementFrame getStatement() {
        return this.m_statementStack.getStatement();
    }

    private void startExec() {
        this.m_statementStack.pushFrame();
    }

    private void endExec() throws SQLException {
        this.m_statementStack.popFrame();
    }

    private static void testAssertion(boolean bl) {
    }

    static /* synthetic */ void access$200(boolean bl) {
        ExecutionContext.testAssertion(bl);
    }

    static {
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                String string = System.getProperty("sqlj.runtime.uncustomizedWarningOrException", "0");
                m_uncustomizedWarningOrException = Integer.parseInt(string);
                return null;
            }
        });
    }

    private static class StatementFrame {
        RTStatement m_stmt = null;
        private int m_updateCount = 0;
        private SQLWarning m_warnings = null;
        private boolean m_executeResult = false;
        private boolean m_holdStmt = false;
        private StatementStack m_lock;
        private boolean m_pendingResults = false;

        StatementFrame(StatementStack statementStack) {
            this.m_lock = statementStack;
        }

        SQLWarning getWarnings() {
            return this.m_warnings;
        }

        int getUpdateCount() {
            return this.m_updateCount;
        }

        void cancel() throws SQLException {
            this.m_stmt.cancel();
        }

        RTStatement getStatement() {
            return this.m_stmt;
        }

        void setStatement(RTStatement rTStatement) {
            this.m_updateCount = -2;
            this.m_warnings = null;
            this.m_holdStmt = false;
            this.m_executeResult = false;
            this.m_stmt = rTStatement;
            this.m_pendingResults = false;
        }

        int executeUpdate() throws SQLException {
            this.m_updateCount = this.m_stmt.executeUpdate();
            return this.m_updateCount;
        }

        RTResultSet executeQuery() throws SQLException {
            RTResultSet rTResultSet = this.m_stmt.executeRTQuery();
            this.m_updateCount = -1;
            return rTResultSet;
        }

        boolean execute() throws SQLException {
            boolean bl = this.m_stmt.execute();
            while (!bl && this.m_stmt.getUpdateCount() != -1) {
                bl = this.m_stmt.getMoreResults();
            }
            this.m_holdStmt = this.m_executeResult = bl;
            this.m_updateCount = bl ? -1 : 0;
            return bl;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        ResultSet getNextResultSet() throws SQLException {
            if (this.m_stmt == null) {
                return null;
            }
            boolean bl = true;
            try {
                if (this.m_executeResult) {
                    this.m_executeResult = false;
                } else {
                    while (!this.m_stmt.getMoreResults()) {
                        if (this.m_stmt.getUpdateCount() != -1) continue;
                        bl = false;
                        break;
                    }
                }
                if (bl) {
                    ResultSet resultSet = this.m_stmt.getResultSet();
                    this.m_warnings = this.m_stmt.getWarnings();
                    this.m_updateCount = -1;
                    return resultSet;
                }
                this.m_updateCount = 0;
            }
            catch (SQLException sQLException) {
                this.m_holdStmt = false;
                try {
                    try {
                        this.releaseStatement();
                    }
                    catch (SQLException sQLException2) {
                        sQLException.setNextException(sQLException2);
                        Object var5_5 = null;
                        throw sQLException;
                    }
                    Object var5_4 = null;
                    throw sQLException;
                }
                catch (Throwable throwable) {
                    Object var5_6 = null;
                    throw sQLException;
                }
            }
            this.m_holdStmt = false;
            this.releaseStatement();
            return null;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        ResultSet getNextResultSet(int n2) throws SQLException {
            if (this.m_stmt == null) {
                return null;
            }
            boolean bl = true;
            try {
                if (this.m_executeResult) {
                    this.m_executeResult = false;
                } else {
                    while (!this.m_stmt.getMoreResults(n2)) {
                        if (this.m_stmt.getUpdateCount() != -1) continue;
                        bl = false;
                        break;
                    }
                }
                if (bl) {
                    ResultSet resultSet = this.m_stmt.getResultSet();
                    this.m_warnings = this.m_stmt.getWarnings();
                    this.m_updateCount = -1;
                    return resultSet;
                }
            }
            catch (SQLException sQLException) {
                this.m_holdStmt = false;
                this.m_updateCount = -1;
                try {
                    try {
                        this.releaseStatement();
                    }
                    catch (SQLException sQLException2) {
                        sQLException.setNextException(sQLException2);
                        Object var6_6 = null;
                        throw sQLException;
                    }
                    Object var6_5 = null;
                    throw sQLException;
                }
                catch (Throwable throwable) {
                    Object var6_7 = null;
                    throw sQLException;
                }
            }
            this.m_holdStmt = false;
            this.releaseStatement();
            return null;
        }

        void cleanupResults() throws SQLException {
            if (this.m_stmt != null) {
                while (this.getNextResultSet() != null) {
                }
            }
        }

        void releaseStatement() throws SQLException {
            block3: {
                if (!this.m_holdStmt) {
                    this.m_pendingResults = false;
                    RTStatement rTStatement = this.m_stmt;
                    this.m_lock.releaseStatement(this);
                    try {
                        this.m_warnings = rTStatement.getWarnings();
                        Object var3_2 = null;
                    }
                    catch (Throwable throwable) {
                        Object var3_3 = null;
                        rTStatement.executeComplete();
                        throw throwable;
                    }
                    rTStatement.executeComplete();
                    {
                        break block3;
                    }
                }
                this.m_pendingResults = true;
                this.m_warnings = this.m_stmt.getWarnings();
            }
        }
    }

    private static class StatementStack {
        private int m_callDepth = 0;
        private Stack m_statementStack = new Stack();
        private StatementFrame m_stmt = new StatementFrame(this);

        private StatementStack() {
        }

        StatementFrame getStatement() {
            return this.m_stmt;
        }

        synchronized void cancelCurrent() throws SQLException {
            if (this.m_stmt.getStatement() != null) {
                this.m_stmt.cancel();
            } else if (!this.m_statementStack.empty()) {
                ((StatementFrame)this.m_statementStack.peek()).cancel();
            }
        }

        synchronized RTStatement setStatement(ConnectedProfile connectedProfile, int n2, BatchContext batchContext, Map map) throws SQLException {
            if (this.m_statementStack.size() < this.m_callDepth) {
                this.m_statementStack.push(this.m_stmt);
                this.m_stmt = new StatementFrame(this);
            } else {
                this.m_stmt.cleanupResults();
            }
            RTStatement rTStatement = null;
            rTStatement = connectedProfile.getStatement(n2, batchContext, map);
            this.m_stmt.setStatement(rTStatement);
            return rTStatement;
        }

        void pushFrame() {
            ++this.m_callDepth;
        }

        void popFrame() throws SQLException {
            --this.m_callDepth;
            if (this.m_statementStack.size() > this.m_callDepth) {
                this.doPopFrame();
            }
        }

        private synchronized void doPopFrame() throws SQLException {
            this.m_stmt.cleanupResults();
            this.m_stmt = (StatementFrame)this.m_statementStack.pop();
        }

        synchronized void releaseStatement(StatementFrame statementFrame) {
            statementFrame.m_stmt = null;
        }
    }
}

