/*
 * Decompiled with CFR 0.152.
 */
package org.jgraph.layout;

import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.jgraph.JGraph;
import org.jgraph.graph.CellView;
import org.jgraph.graph.GraphConstants;
import org.jgraph.graph.GraphLayoutCache;
import org.jgraph.graph.GraphModel;
import org.jgraph.graph.VertexView;
import org.jgraph.layout.JGraphLayoutAlgorithm;
import org.jgraph.layout.JGraphLayoutSettings;
import org.jgraph.layout.SugiyamaLayoutSettings;

public class SugiyamaLayoutAlgorithm
extends JGraphLayoutAlgorithm {
    public static final String SUGIYAMA_VISITED = "SugiyamaVisited";
    public static final String SUGIYAMA_CELL_WRAPPER = "SugiyamaCellWrapper";
    public static final String SUGIYAMA_SELECTED = "SugiyamaSelected";
    protected int gridAreaSize = Integer.MIN_VALUE;
    List movements = null;
    int movementsCurrentLoop = -1;
    int movementsMax = Integer.MIN_VALUE;
    int iteration = 0;
    protected boolean vertical = true;
    protected Point spacing = new Point(250, 150);
    protected boolean flushToOrigin = false;

    public JGraphLayoutSettings createSettings() {
        return new SugiyamaLayoutSettings(this);
    }

    public String toString() {
        return "Sugiyama";
    }

    public String getHint() {
        return "Ignores selection";
    }

    public void run(JGraph jGraph, Object[] objectArray, Object[] objectArray2) {
        Object object;
        CellView[] cellViewArray = jGraph.getGraphLayoutCache().getMapping(objectArray);
        this.gridAreaSize = Integer.MIN_VALUE;
        Rectangle2D.Double double_ = new Rectangle2D.Double();
        for (int i = 0; i < cellViewArray.length; ++i) {
            if (!(cellViewArray[i] instanceof VertexView) || (object = cellViewArray[i].getBounds()) == null) continue;
            double_.setFrame(0.0, 0.0, Math.max(((RectangularShape)object).getWidth(), ((RectangularShape)double_).getWidth()), Math.max(((RectangularShape)object).getHeight(), ((RectangularShape)double_).getHeight()));
        }
        if (this.spacing.x == 0) {
            this.spacing.x = (int)(2.0 * ((RectangularShape)double_).getWidth());
        }
        if (this.spacing.y == 0) {
            this.spacing.y = (int)(2.0 * ((RectangularShape)double_).getHeight());
        }
        this.markSelected(cellViewArray, true);
        List list = this.searchRoots(jGraph, cellViewArray);
        if (list.size() == 0) {
            return;
        }
        object = this.fillLevels(jGraph, cellViewArray, list);
        this.solveEdgeCrosses(jGraph, (List)object);
        this.moveToBarycenter(jGraph, cellViewArray, (List)object);
        Point point = this.flushToOrigin ? new Point(0, 0) : this.findMinimumAndSpacing(cellViewArray, this.spacing);
        this.drawGraph(jGraph, (List)object, point, this.spacing);
        this.markSelected(cellViewArray, false);
    }

    protected void markSelected(CellView[] cellViewArray, boolean bl) {
        if (bl) {
            for (int i = 0; i < cellViewArray.length; ++i) {
                if (cellViewArray[i] == null) continue;
                cellViewArray[i].getAttributes().put((Object)SUGIYAMA_SELECTED, (Object)Boolean.TRUE);
            }
        } else {
            for (int i = 0; i < cellViewArray.length; ++i) {
                if (cellViewArray[i] == null) continue;
                cellViewArray[i].getAttributes().remove((Object)SUGIYAMA_SELECTED);
            }
        }
    }

    protected boolean isSelected(GraphLayoutCache graphLayoutCache, Object object) {
        CellView cellView = graphLayoutCache.getMapping(object, false);
        return cellView != null && cellView.getAttributes().get((Object)SUGIYAMA_SELECTED) != null;
    }

    protected List searchRoots(JGraph jGraph, CellView[] cellViewArray) {
        VertexView vertexView;
        int n;
        ArrayList<CellView> arrayList = new ArrayList<CellView>(cellViewArray.length);
        ArrayList arrayList2 = new ArrayList();
        for (n = 0; n < cellViewArray.length; ++n) {
            if (!(cellViewArray[n] instanceof VertexView)) continue;
            vertexView = (VertexView)cellViewArray[n];
            vertexView.getAttributes().remove((Object)SUGIYAMA_VISITED);
            arrayList.add(cellViewArray[n]);
        }
        for (n = 0; n < arrayList.size(); ++n) {
            vertexView = (VertexView)arrayList.get(n);
            if (vertexView.getAttributes().get((Object)SUGIYAMA_VISITED) != null) continue;
            this.searchRoots(jGraph, vertexView, arrayList2);
        }
        if (arrayList2.size() == 0) {
            throw new IllegalArgumentException("The Graph is not a DAG. Can't use Sugiyama Algorithm!");
        }
        return arrayList2;
    }

    protected void searchRoots(JGraph jGraph, VertexView vertexView, List list) {
        if (vertexView.getAttributes().get((Object)SUGIYAMA_VISITED) != null) {
            return;
        }
        vertexView.getAttributes().put((Object)SUGIYAMA_VISITED, (Object)Boolean.TRUE);
        GraphModel graphModel = jGraph.getModel();
        GraphLayoutCache graphLayoutCache = jGraph.getGraphLayoutCache();
        Object object = vertexView.getCell();
        int n = graphModel.getChildCount(object);
        for (int i = 0; i < n; ++i) {
            Object object2 = graphModel.getChild(object, i);
            boolean bl = true;
            Iterator iterator = graphModel.edges(object2);
            while (iterator.hasNext()) {
                Object e = iterator.next();
                if (!this.isSelected(graphLayoutCache, e) || graphModel.getTarget(e) != object2) continue;
                Object object3 = graphModel.getSource(e);
                Object object4 = graphModel.getParent(object3);
                CellView cellView = jGraph.getGraphLayoutCache().getMapping(object4, false);
                if (!(cellView instanceof VertexView)) continue;
                this.searchRoots(jGraph, (VertexView)cellView, list);
                bl = false;
            }
            if (!bl) continue;
            list.add(vertexView);
        }
    }

    protected List fillLevels(JGraph jGraph, CellView[] cellViewArray, List list) {
        CellView cellView;
        Vector vector = new Vector();
        for (int i = 0; i < cellViewArray.length; ++i) {
            cellView = cellViewArray[i];
            if (cellView == null) continue;
            cellView.getAttributes().remove((Object)SUGIYAMA_VISITED);
        }
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            cellView = (VertexView)iterator.next();
            this.fillLevels(jGraph, vector, 0, (VertexView)cellView);
        }
        return vector;
    }

    protected void fillLevels(JGraph jGraph, List list, int n, VertexView vertexView) {
        if (vertexView == null) {
            return;
        }
        if (list.size() == n) {
            list.add(n, new ArrayList());
        }
        if (vertexView.getAttributes().get((Object)SUGIYAMA_VISITED) != null) {
            return;
        }
        vertexView.getAttributes().put((Object)SUGIYAMA_VISITED, (Object)Boolean.TRUE);
        ArrayList arrayList = (ArrayList)list.get(n);
        int n2 = arrayList.size();
        CellWrapper cellWrapper = new CellWrapper(n, n2, vertexView);
        arrayList.add(cellWrapper);
        vertexView.getAttributes().put((Object)SUGIYAMA_CELL_WRAPPER, (Object)cellWrapper);
        Object object = vertexView.getCell();
        GraphModel graphModel = jGraph.getModel();
        GraphLayoutCache graphLayoutCache = jGraph.getGraphLayoutCache();
        int n3 = graphModel.getChildCount(object);
        for (int i = 0; i < n3; ++i) {
            Object object2 = graphModel.getChild(object, i);
            Iterator iterator = graphModel.edges(object2);
            while (iterator.hasNext()) {
                Object object3;
                Object object4;
                Object e = iterator.next();
                if (!this.isSelected(graphLayoutCache, e) || object2 != graphModel.getSource(e) || !this.isSelected(graphLayoutCache, object4 = graphModel.getParent(object3 = graphModel.getTarget(e)))) continue;
                VertexView vertexView2 = (VertexView)jGraph.getGraphLayoutCache().getMapping(object4, false);
                this.fillLevels(jGraph, list, n + 1, vertexView2);
            }
        }
        if (arrayList.size() > this.gridAreaSize) {
            this.gridAreaSize = arrayList.size();
        }
    }

    protected Point findMinimumAndSpacing(CellView[] cellViewArray, Point point) {
        try {
            int n = 1000000;
            int n2 = 1000000;
            for (int i = 0; i < cellViewArray.length; ++i) {
                CellView cellView = cellViewArray[i];
                if (cellView == null) continue;
                Rectangle2D rectangle2D = cellView.getBounds();
                Rectangle rectangle = new Rectangle((int)rectangle2D.getX(), (int)rectangle2D.getY(), (int)rectangle2D.getWidth(), (int)rectangle2D.getHeight());
                try {
                    if (rectangle.x < n) {
                        n = rectangle.x;
                    }
                    if (rectangle.y >= n2) continue;
                    n2 = rectangle.y;
                    continue;
                }
                catch (Exception exception) {
                    System.err.println("---------> ERROR in calculateValues.");
                    exception.printStackTrace();
                }
            }
            return new Point(n, n2);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    protected void updateProgress4Movements() {
        this.movements.add(new Integer(this.movementsCurrentLoop));
        ++this.iteration;
        if (this.movementsCurrentLoop > this.movementsMax) {
            this.movementsMax = this.movementsCurrentLoop;
        }
    }

    protected void solveEdgeCrosses(JGraph jGraph, List list) {
        this.movements = new ArrayList(100);
        this.movementsCurrentLoop = -1;
        this.movementsMax = Integer.MIN_VALUE;
        this.iteration = 0;
        while (this.movementsCurrentLoop != 0) {
            int n;
            this.movementsCurrentLoop = 0;
            for (n = 0; n < list.size() - 1; ++n) {
                this.movementsCurrentLoop += this.solveEdgeCrosses(jGraph, true, list, n);
            }
            for (n = list.size() - 1; n >= 1; --n) {
                this.movementsCurrentLoop += this.solveEdgeCrosses(jGraph, false, list, n);
            }
            this.updateProgress4Movements();
        }
    }

    protected int solveEdgeCrosses(JGraph jGraph, boolean bl, List list, int n) {
        List list2 = (List)list.get(n);
        int n2 = 0;
        Object[] objectArray = list2.toArray();
        Collections.sort(list2);
        for (int i = 0; i < objectArray.length; ++i) {
            if (((CellWrapper)objectArray[i]).getEdgeCrossesIndicator() == ((CellWrapper)list2.get(i)).getEdgeCrossesIndicator()) continue;
            ++n2;
        }
        GraphModel graphModel = jGraph.getModel();
        GraphLayoutCache graphLayoutCache = jGraph.getGraphLayoutCache();
        for (int i = list2.size() - 1; i >= 0; --i) {
            CellWrapper cellWrapper = (CellWrapper)list2.get(i);
            VertexView vertexView = cellWrapper.getVertexView();
            Object object = vertexView.getCell();
            int n3 = graphModel.getChildCount(object);
            for (int j = 0; j < n3; ++j) {
                Object object2 = graphModel.getChild(object, j);
                Iterator iterator = graphModel.edges(object2);
                while (iterator.hasNext()) {
                    VertexView vertexView2;
                    Object object3;
                    Object e = iterator.next();
                    if (!this.isSelected(graphLayoutCache, e)) continue;
                    Object object4 = null;
                    if (bl && object2 == graphModel.getSource(e)) {
                        object4 = graphModel.getTarget(e);
                    }
                    if (!bl && object2 == graphModel.getTarget(e)) {
                        object4 = graphModel.getSource(e);
                    }
                    if (object4 == null || !this.isSelected(graphLayoutCache, object3 = graphModel.getParent(object4)) || (vertexView2 = (VertexView)jGraph.getGraphLayoutCache().getMapping(object3, false)) == null) continue;
                    CellWrapper cellWrapper2 = (CellWrapper)vertexView2.getAttributes().get((Object)SUGIYAMA_CELL_WRAPPER);
                    if (bl && cellWrapper2 != null && cellWrapper2.getLevel() > n) {
                        cellWrapper2.addToEdgeCrossesIndicator(cellWrapper.getEdgeCrossesIndicator());
                    }
                    if (bl || cellWrapper2 == null || cellWrapper2.getLevel() >= n) continue;
                    cellWrapper2.addToEdgeCrossesIndicator(cellWrapper.getEdgeCrossesIndicator());
                }
            }
        }
        return n2;
    }

    protected void moveToBarycenter(JGraph jGraph, CellView[] cellViewArray, List list) {
        Object object;
        Object object2;
        GraphModel graphModel = jGraph.getModel();
        GraphLayoutCache graphLayoutCache = jGraph.getGraphLayoutCache();
        for (int i = 0; i < cellViewArray.length; ++i) {
            if (!(cellViewArray[i] instanceof VertexView)) continue;
            object2 = (VertexView)cellViewArray[i];
            CellWrapper cellWrapper = (CellWrapper)object2.getAttributes().get((Object)SUGIYAMA_CELL_WRAPPER);
            object = object2.getCell();
            int n = graphModel.getChildCount(object);
            for (int j = 0; j < n; ++j) {
                Object object3 = graphModel.getChild(object, j);
                Iterator iterator = graphModel.edges(object3);
                while (iterator.hasNext()) {
                    VertexView vertexView;
                    Object object4;
                    Object e = iterator.next();
                    if (!this.isSelected(graphLayoutCache, e)) continue;
                    Object object5 = null;
                    if (object3 == graphModel.getSource(e)) {
                        object5 = graphModel.getTarget(e);
                    } else {
                        if (object3 != graphModel.getTarget(e)) continue;
                        object5 = graphModel.getSource(e);
                    }
                    if (!this.isSelected(graphLayoutCache, object4 = graphModel.getParent(object5)) || (vertexView = (VertexView)jGraph.getGraphLayoutCache().getMapping(object4, false)) == null || vertexView == object2) continue;
                    CellWrapper cellWrapper2 = (CellWrapper)vertexView.getAttributes().get((Object)SUGIYAMA_CELL_WRAPPER);
                    if (cellWrapper == null || cellWrapper2 == null || cellWrapper.level == cellWrapper2.level) continue;
                    ++cellWrapper.priority;
                }
            }
        }
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            object2 = (List)iterator.next();
            int n = 0;
            object = object2.iterator();
            while (object.hasNext()) {
                CellWrapper cellWrapper = (CellWrapper)object.next();
                cellWrapper.setGridPosition(n);
                ++n;
            }
        }
        this.movements.clear();
        this.movementsCurrentLoop = -1;
        this.movementsMax = Integer.MIN_VALUE;
        this.iteration = 0;
        while (this.movementsCurrentLoop != 0) {
            int n;
            this.movementsCurrentLoop = 0;
            for (n = 1; n < list.size(); ++n) {
                this.movementsCurrentLoop += this.moveToBarycenter(jGraph, list, n);
            }
            for (n = list.size() - 1; n >= 0; --n) {
                this.movementsCurrentLoop += this.moveToBarycenter(jGraph, list, n);
            }
            this.updateProgress4Movements();
        }
    }

    protected int moveToBarycenter(JGraph jGraph, List list, int n) {
        int n2 = 0;
        List list2 = (List)list.get(n);
        GraphModel graphModel = jGraph.getModel();
        GraphLayoutCache graphLayoutCache = jGraph.getGraphLayoutCache();
        for (int i = 0; i < list2.size(); ++i) {
            CellWrapper cellWrapper = (CellWrapper)list2.get(i);
            float f = 0.0f;
            float f2 = 0.0f;
            VertexView vertexView = cellWrapper.getVertexView();
            Object object = vertexView.getCell();
            int n3 = graphModel.getChildCount(object);
            for (int j = 0; j < n3; ++j) {
                Object object2 = graphModel.getChild(object, j);
                Iterator iterator = graphModel.edges(object2);
                while (iterator.hasNext()) {
                    CellWrapper cellWrapper2;
                    VertexView vertexView2;
                    Object object3;
                    Object e = iterator.next();
                    if (!this.isSelected(graphLayoutCache, e)) continue;
                    Object object4 = null;
                    if (object2 == graphModel.getSource(e)) {
                        object4 = graphModel.getTarget(e);
                    } else {
                        if (object2 != graphModel.getTarget(e)) continue;
                        object4 = graphModel.getSource(e);
                    }
                    if (!this.isSelected(graphLayoutCache, object3 = graphModel.getParent(object4)) || (vertexView2 = (VertexView)jGraph.getGraphLayoutCache().getMapping(object3, false)) == null || (cellWrapper2 = (CellWrapper)vertexView2.getAttributes().get((Object)SUGIYAMA_CELL_WRAPPER)) == cellWrapper || cellWrapper2 == null || cellWrapper2.getLevel() == n) continue;
                    f += (float)cellWrapper2.getGridPosition();
                    f2 += 1.0f;
                }
            }
            if (!(f2 > 0.0f)) continue;
            float f3 = f / f2;
            int n4 = Math.round(f3);
            boolean bl = n4 > cellWrapper.getGridPosition();
            boolean bl2 = true;
            while (n4 != cellWrapper.getGridPosition() && bl2) {
                int n5 = cellWrapper.getGridPosition();
                bl2 = this.move(bl, list2, i, cellWrapper.getPriority());
                if (!bl2) continue;
                ++n2;
            }
        }
        return n2;
    }

    protected boolean move(boolean bl, List list, int n, int n2) {
        CellWrapper cellWrapper = (CellWrapper)list.get(n);
        boolean bl2 = false;
        int n3 = n + (bl ? 1 : -1);
        int n4 = cellWrapper.getGridPosition() + (bl ? 1 : -1);
        if (0 > n4 || n4 >= this.gridAreaSize) {
            return false;
        }
        if (bl && n == list.size() - 1 || !bl && n == 0) {
            bl2 = true;
        } else {
            CellWrapper cellWrapper2 = (CellWrapper)list.get(n3);
            int n5 = cellWrapper2.getPriority();
            if (cellWrapper2.getGridPosition() == n4) {
                if (n5 >= n2) {
                    return false;
                }
                bl2 = this.move(bl, list, n3, n2);
            } else {
                bl2 = true;
            }
        }
        if (bl2) {
            cellWrapper.setGridPosition(n4);
        }
        return bl2;
    }

    protected void drawGraph(JGraph jGraph, List list, Point point, Point point2) {
        Hashtable hashtable = new Hashtable();
        for (int i = 0; i < list.size(); ++i) {
            List list2 = (List)list.get(i);
            for (int j = 0; j < list2.size(); ++j) {
                CellWrapper cellWrapper = (CellWrapper)list2.get(j);
                VertexView vertexView = cellWrapper.vertexView;
                vertexView.getAttributes().remove((Object)SUGIYAMA_CELL_WRAPPER);
                vertexView.getAttributes().remove((Object)SUGIYAMA_VISITED);
                cellWrapper.vertexView = null;
                if (vertexView == null) continue;
                Rectangle2D rectangle2D = (Rectangle2D)vertexView.getBounds().clone();
                Rectangle rectangle = new Rectangle((int)rectangle2D.getX(), (int)rectangle2D.getY(), (int)rectangle2D.getWidth(), (int)rectangle2D.getHeight());
                rectangle.x = point.x + point2.x * (this.vertical ? cellWrapper.getGridPosition() : i);
                rectangle.y = point.y + point2.y * (this.vertical ? i : cellWrapper.getGridPosition());
                Object object = vertexView.getCell();
                Hashtable hashtable2 = new Hashtable();
                GraphConstants.setBounds(hashtable2, (Rectangle2D)((Rectangle2D)rectangle.clone()));
                hashtable.put(object, hashtable2);
            }
        }
        jGraph.getGraphLayoutCache().edit(hashtable, null, null, null);
    }

    public Point getSpacing() {
        return this.spacing;
    }

    public void setSpacing(Point point) {
        this.spacing = point;
    }

    public boolean isVertical() {
        return this.vertical;
    }

    public void setVertical(boolean bl) {
        this.vertical = bl;
    }

    public final boolean getFlushToOrigin() {
        return this.flushToOrigin;
    }

    public final void setFlushToOrigin(boolean bl) {
        this.flushToOrigin = bl;
    }

    class CellWrapper
    implements Comparable {
        private double edgeCrossesIndicator = 0.0;
        private int additions = 0;
        int level = 0;
        int gridPosition = 0;
        int priority = 0;
        VertexView vertexView = null;

        CellWrapper(int n, double d, VertexView vertexView) {
            this.level = n;
            this.edgeCrossesIndicator = d;
            this.vertexView = vertexView;
            ++this.additions;
        }

        VertexView getVertexView() {
            return this.vertexView;
        }

        void resetEdgeCrossesIndicator() {
            this.edgeCrossesIndicator = 0.0;
            this.additions = 0;
        }

        double getEdgeCrossesIndicator() {
            if (this.additions == 0) {
                return 0.0;
            }
            return this.edgeCrossesIndicator / (double)this.additions;
        }

        void addToEdgeCrossesIndicator(double d) {
            this.edgeCrossesIndicator += d;
            ++this.additions;
        }

        int getLevel() {
            return this.level;
        }

        int getGridPosition() {
            return this.gridPosition;
        }

        void setGridPosition(int n) {
            this.gridPosition = n;
        }

        void incrementPriority() {
            ++this.priority;
        }

        int getPriority() {
            return this.priority;
        }

        public int compareTo(Object object) {
            if (((CellWrapper)object).getEdgeCrossesIndicator() == this.getEdgeCrossesIndicator()) {
                return 0;
            }
            double d = ((CellWrapper)object).getEdgeCrossesIndicator() - this.getEdgeCrossesIndicator();
            return (int)(d * 1000.0);
        }
    }
}

