/*
 * Decompiled with CFR 0.152.
 */
package org.jgraph.layout;

import java.awt.Color;
import java.awt.Rectangle;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import org.jgraph.JGraph;
import org.jgraph.event.GraphModelEvent;
import org.jgraph.event.GraphModelListener;
import org.jgraph.graph.AttributeMap;
import org.jgraph.graph.CellView;
import org.jgraph.graph.EdgeView;
import org.jgraph.graph.GraphConstants;
import org.jgraph.graph.GraphLayoutCache;
import org.jgraph.graph.GraphModel;
import org.jgraph.graph.VertexView;
import org.jgraph.layout.AnnealingLayoutSettings;
import org.jgraph.layout.JGraphLayoutAlgorithm;
import org.jgraph.layout.JGraphLayoutSettings;

public class AnnealingLayoutAlgorithm
extends JGraphLayoutAlgorithm
implements GraphModelListener {
    public static final int COUT_COSTFUNCTION = 6;
    public static final int COSTFUNCTION_EDGE_DISTANCE = 1;
    public static final int COSTFUNCTION_EDGE_CROSSING = 2;
    public static final int COSTFUNCTION_EDGE_LENGTH = 4;
    public static final int COSTFUNCTION_BORDERLINE = 8;
    public static final int COSTFUNCTION_NODE_DISTRIBUTION = 16;
    public static final int COSTFUNCTION_NODE_DISTANCE = 32;
    public static final String KEY_CAPTION = "Annealing Layoutalgorithm Attributes";
    public static final String KEY_POSITION = "Position";
    public static final String KEY_RELATIVES = "Relatives";
    public static final String CF_KEY_EDGE_DISTANCE_RELEVANT_EDGES = "costfunction edge distance key for relevant edges";
    public static final String KEY_CLUSTERED_VERTICES = "Clustered Vertices";
    public static final String KEY_CLUSTER = "Cluster";
    public static final String KEY_IS_CLUSTER = "is Cluster";
    public static final String KEY_CLUSTER_INIT_POSITION = "initial Position of the Cluster";
    protected static final int CONFIG_KEY_RUN = 0;
    protected static final int CONFIG_KEY_LAYOUT_UPDATE = 1;
    private double temperature;
    private double initTemperature = 40.0;
    private double minTemperature = 2.0;
    private double minDistance = 50.0;
    private double tempScaleFactor = 0.95;
    private int maxRounds = 10000;
    protected double[] lambdaList = new double[]{1000.0, 100000.0, 0.02, 2000.0, 150.0, 1000000.0};
    private Rectangle bounds = new Rectangle(0, 0, 1000, 700);
    private boolean computePermutation = true;
    private boolean uphillMovesAllowed = true;
    private boolean isLayoutUpdateEnabled = true;
    private int costFunctionConfig = Integer.parseInt("111110", 2);
    private int round;
    private int triesPerCell = 8;
    protected ArrayList cellList;
    protected ArrayList edgeList;
    protected ArrayList applyCellList;
    private JGraph jgraph;
    protected Properties presetConfig;
    private long time = 0L;
    private boolean isDebugging = false;
    private boolean isRunning = false;
    private int luRecursionDepth = 1;
    private double luPerimeterRadius = 100.0;
    private double luPerimeterRadiusInc = 20.0;
    private String luMethod = "Layout Update Method Perimeter";
    private double equalsNull = 0.05;
    private boolean isClusteringEnabled = true;
    private double clusterMoveScaleFactor = 0.1;
    private double clusteringFactor = 8.0;
    protected boolean isOptimizer = false;

    public AnnealingLayoutAlgorithm() {
        this(false);
        this.setMaximumProgress(100);
    }

    public AnnealingLayoutAlgorithm(boolean bl) {
        this.isOptimizer = bl;
    }

    public String toString() {
        return "Annealing";
    }

    public String getHint() {
        return "Ignores selection";
    }

    public JGraphLayoutSettings createSettings() {
        return new AnnealingLayoutSettings(this, false);
    }

    public void run(JGraph jGraph, Object[] objectArray, Object[] objectArray2) {
        this.isRunning = true;
        this.setAllowedToRun(true);
        this.setProgress(1);
        this.jgraph = jGraph;
        this.cellList = new ArrayList();
        this.edgeList = new ArrayList();
        this.applyCellList = new ArrayList();
        this.getNodes(this.jgraph, objectArray);
        if (this.applyCellList.size() == 0) {
            return;
        }
        if (this.isLayoutUpdateEnabled) {
            this.jgraph.getModel().addGraphModelListener((GraphModelListener)this);
        }
        this.init(true);
        this.run();
        if (this.isAllowedToRun()) {
            this.moveGraphToNW();
            this.applyChanges();
            this.removeTemporaryData();
        }
        this.isRunning = false;
    }

    public void performOptimization(ArrayList arrayList, ArrayList arrayList2, ArrayList arrayList3, Properties properties) {
        this.cellList = arrayList2;
        this.applyCellList = arrayList;
        this.edgeList = arrayList3;
        this.presetConfig = properties;
        this.loadConfiguration(0);
        this.init(false);
        this.run();
    }

    private void loadConfiguration(int n) {
        if (n == 0) {
            this.initTemperature = Double.parseDouble((String)this.presetConfig.get("Start Temperature"));
            this.minTemperature = Double.parseDouble((String)this.presetConfig.get("min. Temperature"));
            this.minDistance = Double.parseDouble((String)this.presetConfig.get("min. Distance"));
            this.tempScaleFactor = Double.parseDouble((String)this.presetConfig.get("Temperature Scalefactor"));
            this.maxRounds = Integer.parseInt((String)this.presetConfig.get("max. Rounds"));
            this.triesPerCell = Integer.parseInt((String)this.presetConfig.get("tries per cell"));
            ArrayList arrayList = (ArrayList)this.presetConfig.get("Lambda");
            this.lambdaList = new double[6];
            for (int i = 0; i < this.lambdaList.length; ++i) {
                this.lambdaList[i] = (Double)arrayList.get(i);
            }
            this.bounds = (Rectangle)this.presetConfig.get("Bounds of resulting graph");
            this.costFunctionConfig = Integer.parseInt((String)this.presetConfig.get("Costfunction Config"), 2);
            this.computePermutation = this.isTrue((String)this.presetConfig.get("should compute per Permutation"));
            this.uphillMovesAllowed = this.isTrue((String)this.presetConfig.get("are Uphill-Moves allowed"));
        } else if (n == 1) {
            this.initTemperature = Double.parseDouble((String)this.presetConfig.get("Layout Update Start Temperature"));
            this.minTemperature = Double.parseDouble((String)this.presetConfig.get("Layout Update min. Temperature"));
            this.minDistance = Double.parseDouble((String)this.presetConfig.get("Layout Update min. Distance"));
            this.tempScaleFactor = Double.parseDouble((String)this.presetConfig.get("Layout Update Temperature Scalefactor"));
            this.maxRounds = Integer.parseInt((String)this.presetConfig.get("Layout Update max. Rounds"));
            this.triesPerCell = Integer.parseInt((String)this.presetConfig.get("Layout Update tries per cell"));
            ArrayList arrayList = (ArrayList)this.presetConfig.get("Layout Update Lambda");
            this.lambdaList = new double[6];
            for (int i = 0; i < this.lambdaList.length; ++i) {
                this.lambdaList[i] = (Double)arrayList.get(i);
            }
            this.bounds = (Rectangle)this.presetConfig.get("Layout Update Bounds of resulting graph");
            this.costFunctionConfig = Integer.parseInt((String)this.presetConfig.get("Layout Update Costfunction Config"), 2);
            this.computePermutation = this.isTrue((String)this.presetConfig.get("Layout Update should compute per Permutation"));
            this.uphillMovesAllowed = this.isTrue((String)this.presetConfig.get("Layout Update are Uphill-Moves allowed"));
            this.luRecursionDepth = Integer.parseInt((String)this.presetConfig.get("Layout Update Method Neighbors depth"));
            this.luPerimeterRadius = Double.parseDouble((String)this.presetConfig.get("Layout Update Method Perimeter radius"));
            this.luPerimeterRadiusInc = Double.parseDouble((String)this.presetConfig.get("Layout Update Method Perimeter radius increase"));
            this.luMethod = (String)this.presetConfig.get("Layout Update Method");
            this.isClusteringEnabled = this.isTrue((String)this.presetConfig.get("Layout Update clustering enabled"));
            this.clusteringFactor = Double.parseDouble((String)this.presetConfig.get("Layout Update clustering factor"));
            this.clusterMoveScaleFactor = Double.parseDouble((String)this.presetConfig.get("Layout Update clustering move scaling factor"));
        }
        this.loadAdditionalConfiguration(n);
    }

    protected void loadAdditionalConfiguration(int n) {
    }

    private boolean isTrue(String string) {
        if (string != null) {
            if ("TRUE".equals(string.toUpperCase())) {
                return true;
            }
            if ("FALSE".equals(string.toUpperCase())) {
                return false;
            }
        }
        return false;
    }

    private void getNodes(JGraph jGraph, Object[] objectArray) {
        int n;
        Object[] objectArray2 = jGraph.getRoots();
        CellView[] cellViewArray = jGraph.getGraphLayoutCache().getMapping(objectArray2, false);
        CellView[] cellViewArray2 = jGraph.getGraphLayoutCache().getMapping(objectArray, false);
        for (n = 0; n < cellViewArray.length; ++n) {
            if (cellViewArray[n] instanceof VertexView) {
                this.cellList.add(cellViewArray[n]);
                this.applyCellList.add(cellViewArray[n]);
                continue;
            }
            if (!(cellViewArray[n] instanceof EdgeView)) continue;
            this.edgeList.add(cellViewArray[n]);
        }
        for (n = 0; n < cellViewArray2.length; ++n) {
            if (!(cellViewArray2[n] instanceof VertexView)) continue;
            this.applyCellList.add(cellViewArray2[n]);
        }
    }

    private void applyChanges() {
        Hashtable hashtable = new Hashtable();
        for (int i = 0; i < this.applyCellList.size(); ++i) {
            CellView cellView = (CellView)this.applyCellList.get(i);
            Point2D.Double double_ = this.getPosition(cellView);
            Rectangle2D rectangle2D = cellView.getBounds();
            rectangle2D.setFrame(double_.getX() - rectangle2D.getWidth() / 2.0, double_.getY() - rectangle2D.getHeight() / 2.0, rectangle2D.getWidth(), rectangle2D.getHeight());
            Object object = ((CellView)this.applyCellList.get(i)).getCell();
            Hashtable hashtable2 = new Hashtable();
            GraphConstants.setBounds(hashtable2, (Rectangle2D)rectangle2D);
            hashtable.put(object, hashtable2);
        }
        this.jgraph.getGraphLayoutCache().edit(hashtable, null, null, null);
    }

    private void removeTemporaryData() {
        for (int i = 0; i < this.applyCellList.size(); ++i) {
            ((CellView)this.applyCellList.get(i)).getAttributes().clear();
        }
    }

    private void init(boolean bl) {
        if (bl) {
            int n;
            for (n = 0; n < this.applyCellList.size(); ++n) {
                if (((CellView)this.applyCellList.get(n)).getAttributes().containsKey((Object)KEY_POSITION)) continue;
                this.setPosition(n, Math.random() * this.bounds.getWidth() + this.bounds.getX(), Math.random() * this.bounds.getHeight() + this.bounds.getY());
            }
            for (n = 0; n < this.cellList.size(); ++n) {
                if (((CellView)this.cellList.get(n)).getAttributes().containsKey((Object)KEY_POSITION)) continue;
                this.setPosition((CellView)this.cellList.get(n), Math.random() * this.bounds.getWidth() + this.bounds.getX(), Math.random() * this.bounds.getHeight() + this.bounds.getY());
            }
        }
        this.temperature = this.initTemperature;
        this.maxRounds = Math.min(100 * this.applyCellList.size(), this.getMaxRoundsByTemperature(this.temperature));
        this.round = 0;
    }

    private void run() {
        while (this.round <= this.maxRounds && this.isAllowedToRun()) {
            this.performRound();
        }
    }

    private void performRound() {
        int n;
        double d;
        Point2D.Double[] doubleArray = this.getConfig();
        double d2 = d = this.getGlobalCosts(this.lambdaList);
        double d3 = d2 * 1.1;
        int[] nArray = new int[this.applyCellList.size()];
        if (!this.computePermutation) {
            for (n = 0; n < this.applyCellList.size(); ++n) {
                nArray[n] = n;
            }
        }
        for (n = 0; n < this.applyCellList.size(); ++n) {
            if (this.computePermutation) {
                nArray = this.createPermutation(this.applyCellList.size());
            }
            double d4 = Math.random() * 2.0 * Math.PI;
            for (int i = 0; i < this.triesPerCell; ++i) {
                double d5 = (double)i * (Math.PI * 2 / (double)this.triesPerCell);
                Point2D.Double double_ = null;
                double_ = this.isCluster((CellView)this.applyCellList.get(n)) ? new Point2D.Double(this.clusterMoveScaleFactor * this.temperature * Math.cos(d5), this.clusterMoveScaleFactor * this.temperature * Math.sin(d5)) : new Point2D.Double(this.temperature * Math.cos(d5 += d4), this.temperature * Math.sin(d5));
                this.setPosition(nArray[n], doubleArray[nArray[n]].x + double_.x, doubleArray[nArray[n]].y + double_.y);
                d3 = this.getGlobalCosts(this.lambdaList);
                if (d3 < d2 || this.getBolzmanBreak(d2, d3) && this.uphillMovesAllowed) {
                    d2 = d3;
                    doubleArray[nArray[n]] = new Point2D.Double(doubleArray[nArray[n]].x + double_.x, doubleArray[nArray[n]].y + double_.y);
                    break;
                }
                this.setPosition(nArray[n], doubleArray[nArray[n]].x, doubleArray[nArray[n]].y);
                this.setProgress((int)((double)(this.round * this.applyCellList.size() * this.triesPerCell + n * this.triesPerCell + i) / (double)(this.maxRounds * this.applyCellList.size() * this.triesPerCell) * 100.0));
                if (!this.isAllowedToRun()) break;
            }
            if (d2 == d * 0.05 || !this.isAllowedToRun()) break;
        }
        this.temperature *= this.tempScaleFactor;
        ++this.round;
    }

    private Point2D.Double[] getConfig() {
        Point2D.Double[] doubleArray = new Point2D.Double[this.applyCellList.size()];
        for (int i = 0; i < this.applyCellList.size(); ++i) {
            Point2D.Double double_ = this.getPosition((CellView)this.applyCellList.get(i));
            doubleArray[i] = new Point2D.Double(double_.x, double_.y);
        }
        return doubleArray;
    }

    private double getGlobalCosts(double[] dArray) {
        double d = 0.0;
        if ((this.costFunctionConfig & 0x20) != 0) {
            d += this.getNodeDistance(dArray[5]);
        }
        if ((this.costFunctionConfig & 0x10) != 0) {
            d += this.getNodeDistribution(dArray[0]);
        }
        if ((this.costFunctionConfig & 8) != 0) {
            d += this.getBorderline(dArray[1]);
        }
        if ((this.costFunctionConfig & 4) != 0) {
            d += this.getEdgeLength(dArray[2]);
        }
        if ((this.costFunctionConfig & 2) != 0) {
            d += this.getEdgeCrossing(1.0, dArray[3]);
        }
        if ((this.costFunctionConfig & 1) != 0) {
            d += this.getEdgeDistance(dArray[4]);
        }
        return d += this.getAdditionalCosts(this.costFunctionConfig, dArray);
    }

    protected double getAdditionalCosts(int n, double[] dArray) {
        return 0.0;
    }

    public int[] createPermutation(int n) {
        int[] nArray = new int[n];
        for (int i = 0; i < nArray.length; ++i) {
            int n2 = (int)(Math.random() * (double)n);
            for (int j = 0; j < i; ++j) {
                if (n2 != nArray[j]) continue;
                n2 = (int)(Math.random() * (double)n);
                j = -1;
            }
            nArray[i] = n2;
        }
        return nArray;
    }

    private boolean getBolzmanBreak(double d, double d2) {
        return Math.random() < Math.pow(Math.E, (d - d2) / this.temperature);
    }

    private int getMaxRoundsByTemperature(double d) {
        return (int)Math.ceil(Math.log(this.minTemperature / d) / Math.log(this.tempScaleFactor));
    }

    private double getNodeDistribution(double d) {
        double d2 = 0.0;
        for (int i = 0; i < this.applyCellList.size(); ++i) {
            for (int j = 0; j < this.cellList.size(); ++j) {
                if (this.applyCellList.get(i) == this.cellList.get(j)) continue;
                double d3 = MathExtensions.getEuclideanDistance(this.getPosition((CellView)this.applyCellList.get(i)), this.getPosition((CellView)this.cellList.get(j)));
                if (Math.abs(d3) < this.equalsNull) {
                    d3 = this.equalsNull;
                }
                d2 += d / (d3 * d3);
            }
        }
        return d2;
    }

    private double getBorderline(double d) {
        double d2 = 0.0;
        for (int i = 0; i < this.applyCellList.size(); ++i) {
            Point2D.Double double_ = this.getPosition((CellView)this.applyCellList.get(i));
            double d3 = double_.y - (double)this.bounds.y;
            double d4 = double_.x - (double)this.bounds.x;
            double d5 = (double)(this.bounds.y + this.bounds.height) - double_.y;
            double d6 = (double)(this.bounds.x + this.bounds.width) - double_.x;
            d2 += d * (1.0 / (d3 * d3) + 1.0 / (d4 * d4) + 1.0 / (d5 * d5) + 1.0 / (d6 * d6));
        }
        return d2;
    }

    private double getEdgeLength(double d) {
        double d2 = 0.0;
        Line2D.Double[] doubleArray = this.getEdgeLines(this.edgeList);
        for (int i = 0; i < doubleArray.length; ++i) {
            Point2D point2D = doubleArray[i].getP1();
            Point2D point2D2 = doubleArray[i].getP2();
            double d3 = point2D.distance(point2D2);
            d2 += d * d3 * d3;
        }
        return d2;
    }

    private double getEdgeCrossing(double d, double d2) {
        int n = 0;
        Line2D.Double[] doubleArray = this.getEdgeLines(this.edgeList);
        for (int i = 0; i < doubleArray.length; ++i) {
            for (int j = i; j < doubleArray.length; ++j) {
                if (j == i || !doubleArray[i].intersectsLine(doubleArray[j]) || doubleArray[i].getP1().getX() == doubleArray[j].getP1().getX() || doubleArray[i].getP1().getY() == doubleArray[j].getP1().getY() || doubleArray[i].getP1().getX() == doubleArray[j].getP2().getX() || doubleArray[i].getP1().getY() == doubleArray[j].getP2().getY() || doubleArray[i].getP2().getX() == doubleArray[j].getP1().getX() || doubleArray[i].getP2().getY() == doubleArray[j].getP1().getY() || doubleArray[i].getP2().getX() == doubleArray[j].getP2().getX() || doubleArray[i].getP2().getY() == doubleArray[j].getP2().getY()) continue;
                ++n;
            }
        }
        return d2 * d * (double)n;
    }

    private double getEdgeDistance(double d) {
        double d2 = 0.0;
        for (int i = 0; i < this.applyCellList.size(); ++i) {
            double d3 = 0.0;
            CellView cellView = (CellView)this.applyCellList.get(i);
            ArrayList arrayList = null;
            if (cellView.getAttributes().containsKey((Object)CF_KEY_EDGE_DISTANCE_RELEVANT_EDGES)) {
                arrayList = (ArrayList)cellView.getAttributes().get((Object)CF_KEY_EDGE_DISTANCE_RELEVANT_EDGES);
            } else {
                arrayList = this.getRelevantEdges(cellView);
                cellView.getAttributes().put((Object)CF_KEY_EDGE_DISTANCE_RELEVANT_EDGES, (Object)arrayList);
            }
            Line2D.Double[] doubleArray = this.getEdgeLines(this.getRelevantEdges(cellView));
            for (int j = 0; j < doubleArray.length; ++j) {
                double d4 = doubleArray[j].ptSegDist(this.getPosition(cellView));
                if (Math.abs(d4) < this.equalsNull) {
                    d4 = this.equalsNull;
                }
                if (d4 != 0.0) {
                    d3 += d / (d4 * d4);
                }
                if (!(d4 < this.minDistance)) continue;
                d3 += d / (this.minDistance * this.minDistance);
            }
            d2 += d3;
        }
        return d2;
    }

    private double getNodeDistance(double d) {
        double d2 = 0.0;
        double d3 = 30.0;
        int n = 0;
        for (int i = 0; i < this.applyCellList.size(); ++i) {
            Point2D.Double double_ = (Point2D.Double)((CellView)this.applyCellList.get(i)).getAttributes().get((Object)KEY_POSITION);
            Rectangle2D rectangle2D = ((CellView)this.applyCellList.get(i)).getBounds();
            for (int j = 0; j < this.cellList.size(); ++j) {
                if (this.applyCellList.get(i) == this.cellList.get(j)) continue;
                Point2D.Double double_2 = (Point2D.Double)((CellView)this.cellList.get(j)).getAttributes().get((Object)KEY_POSITION);
                Rectangle2D rectangle2D2 = ((CellView)this.cellList.get(j)).getBounds();
                double d4 = Math.max(2.0 * d3 + Math.max(rectangle2D.getWidth(), rectangle2D.getHeight()) / 2.0 + Math.max(rectangle2D2.getWidth(), rectangle2D2.getHeight()) / 2.0, this.minDistance);
                double d5 = Math.abs(double_.distance(double_2));
                if (Math.abs(d5) < this.equalsNull) {
                    d5 = this.equalsNull;
                }
                if (!(d5 < d4)) continue;
                d2 += d / (d5 * d5);
                ++n;
            }
        }
        return d2;
    }

    private Line2D.Double[] getEdgeLines(ArrayList arrayList) {
        Line2D.Double[] doubleArray = new Line2D.Double[arrayList.size()];
        for (int i = 0; i < arrayList.size(); ++i) {
            EdgeView edgeView = (EdgeView)arrayList.get(i);
            GraphModel graphModel = this.jgraph.getModel();
            GraphLayoutCache graphLayoutCache = this.jgraph.getGraphLayoutCache();
            CellView cellView = edgeView.getSource().getParentView();
            CellView cellView2 = edgeView.getTarget().getParentView();
            doubleArray[i] = new Line2D.Double(this.getPosition(cellView), this.getPosition(cellView2));
        }
        return doubleArray;
    }

    private ArrayList getRelevantEdges(CellView cellView) {
        ArrayList arrayList = new ArrayList();
        for (int i = 0; i < this.edgeList.size(); ++i) {
            CellView cellView2 = ((EdgeView)this.edgeList.get(i)).getSource().getParentView();
            if (cellView2 != cellView && this.applyCellList.contains(cellView2)) {
                arrayList.add(this.edgeList.get(i));
                continue;
            }
            cellView2 = ((EdgeView)this.edgeList.get(i)).getTarget().getParentView();
            if (cellView2 == cellView || !this.applyCellList.contains(cellView2)) continue;
            arrayList.add(this.edgeList.get(i));
        }
        return arrayList;
    }

    public Point2D.Double getRandomVector(double d) {
        double d2 = Math.random() * Math.PI * 2.0;
        double d3 = Math.random() * d;
        return new Point2D.Double(d3 * Math.cos(d2), d3 * Math.sin(d2));
    }

    private void setPosition(CellView cellView, Point2D.Double double_) {
        this.setAttribute(cellView, KEY_POSITION, double_);
    }

    private void setPosition(int n, double d, double d2) {
        this.setPosition((CellView)this.applyCellList.get(n), d, d2);
    }

    private void setPosition(CellView cellView, double d, double d2) {
        this.setPosition(cellView, new Point2D.Double(d, d2));
    }

    private Point2D.Double getPosition(CellView cellView) {
        return (Point2D.Double)this.getAttribute(cellView, KEY_POSITION);
    }

    private void setAttribute(CellView cellView, String string, Object object) {
        if (cellView.getAttributes() == null) {
            cellView.changeAttributes((Map)new AttributeMap());
        }
        AttributeMap attributeMap = cellView.getAttributes();
        attributeMap.put(string, object);
    }

    private Object getAttribute(CellView cellView, String string) {
        return cellView.getAttributes().get((Object)string);
    }

    private void moveGraphToNW() {
        Point2D.Double double_;
        CellView cellView;
        int n;
        Point2D.Double double_2 = this.getPosition((CellView)this.cellList.get(0));
        double d = double_2.x;
        double d2 = double_2.y;
        double d3 = d;
        double d4 = d2;
        for (n = 0; n < this.cellList.size(); ++n) {
            cellView = (CellView)this.cellList.get(n);
            double_ = this.getPosition((CellView)this.cellList.get(n));
            Rectangle2D rectangle2D = cellView.getAttributes().createRect(cellView.getBounds());
            if (double_.getX() < d) {
                d = double_.getX();
            } else if (double_.getX() + rectangle2D.getWidth() > d3) {
                d3 = double_.getX() + rectangle2D.getWidth();
            }
            if (double_.getY() < d2) {
                d2 = double_.getY();
                continue;
            }
            if (!(double_.getY() + rectangle2D.getHeight() > d4)) continue;
            d4 = double_.getY() + rectangle2D.getHeight();
        }
        d -= 50.0;
        d2 -= 50.0;
        for (n = 0; n < this.cellList.size(); ++n) {
            cellView = (CellView)this.cellList.get(n);
            double_ = this.getPosition(cellView);
            this.setPosition(cellView, new Point2D.Double(double_.x - d, double_.y - d2));
        }
    }

    protected ArrayList getRelativesFrom(ArrayList arrayList, CellView cellView) {
        ArrayList arrayList2 = this.getRelatives(cellView);
        ArrayList arrayList3 = new ArrayList();
        for (int i = 0; i < arrayList2.size(); ++i) {
            if (!arrayList.contains(arrayList2.get(i))) continue;
            arrayList3.add(arrayList2.get(i));
        }
        return arrayList3;
    }

    protected ArrayList getRelatives(CellView cellView) {
        if (cellView.getAttributes().containsKey((Object)KEY_RELATIVES)) {
            return (ArrayList)cellView.getAttributes().get((Object)KEY_RELATIVES);
        }
        ArrayList arrayList = new ArrayList();
        ArrayList<Object> arrayList2 = new ArrayList<Object>();
        VertexView vertexView = (VertexView)cellView;
        if (this.isCluster(cellView)) {
            ArrayList arrayList3 = (ArrayList)vertexView.getAttributes().get((Object)KEY_CLUSTERED_VERTICES);
            for (int i = 0; i < arrayList3.size(); ++i) {
                ArrayList arrayList4 = this.getRelatives((CellView)arrayList3.get(i));
                for (int j = 0; j < arrayList4.size(); ++j) {
                    if (arrayList.contains(arrayList4.get(j)) || arrayList3.contains(arrayList4.get(j))) continue;
                    arrayList.add(arrayList4.get(j));
                }
            }
        } else {
            Object object;
            int n;
            GraphModel graphModel = this.jgraph.getModel();
            GraphLayoutCache graphLayoutCache = this.jgraph.getGraphLayoutCache();
            Object object2 = vertexView.getCell();
            for (n = 0; n < graphModel.getChildCount(object2); ++n) {
                object = graphModel.getChild(object2, n);
                arrayList2.add(object);
            }
            for (n = 0; n < arrayList2.size(); ++n) {
                object = arrayList2.get(n);
                Iterator iterator = graphModel.edges(object);
                while (iterator.hasNext()) {
                    Object e = iterator.next();
                    Object object3 = null;
                    object3 = graphModel.getSource(e) != object ? graphModel.getSource(e) : graphModel.getTarget(e);
                    CellView cellView2 = graphLayoutCache.getMapping(graphModel.getParent(object3), false);
                    arrayList.add(cellView2);
                }
            }
        }
        cellView.getAttributes().put((Object)KEY_RELATIVES, arrayList);
        return arrayList;
    }

    private void arrangeLayoutUpdateInsertPlacement(CellView[] cellViewArray) {
        for (int i = 0; i < this.cellList.size(); ++i) {
            CellView cellView = (CellView)this.cellList.get(i);
            if (cellView.getAttributes().containsKey((Object)KEY_POSITION)) continue;
            Point2D.Double double_ = new Point2D.Double(cellView.getBounds().getCenterX(), cellView.getBounds().getCenterY());
            cellView.getAttributes().put((Object)KEY_POSITION, (Object)double_);
        }
        ArrayList<CellView> arrayList = new ArrayList<CellView>();
        for (int i = 0; i < cellViewArray.length; ++i) {
            arrayList.add(cellViewArray[i]);
        }
        this.arrangeLayoutUpdateInsertedCellsPlacement(arrayList);
    }

    private void arrangeLayoutUpdateInsertedCellsPlacement(ArrayList arrayList) {
        CellView cellView;
        int n;
        ArrayList<CellView> arrayList2 = new ArrayList<CellView>();
        for (n = 0; n < arrayList.size(); ++n) {
            cellView = (CellView)arrayList.get(n);
            if (!(cellView instanceof VertexView)) continue;
            ArrayList arrayList3 = this.getRelativesFrom(this.cellList, cellView);
            if (arrayList3.size() != 0) {
                double d = 0.0;
                double d2 = 0.0;
                for (int i = 0; i < arrayList3.size(); ++i) {
                    Point2D.Double double_ = (Point2D.Double)((CellView)arrayList3.get(i)).getAttributes().get((Object)KEY_POSITION);
                    d += double_.x;
                    d2 += double_.y;
                }
                Point2D.Double double_ = new Point2D.Double(Math.cos(Math.random() * 2.0 * Math.PI) * 10.0, Math.sin(Math.random() * 2.0 * Math.PI) * 10.0);
                cellView.getAttributes().put((Object)KEY_POSITION, (Object)new Point2D.Double(d / (double)arrayList3.size() + double_.x, d2 / (double)arrayList3.size() + double_.y));
                continue;
            }
            arrayList2.add(cellView);
        }
        for (n = 0; n < arrayList.size(); ++n) {
            if (arrayList.get(n) == null || ((CellView)arrayList.get(n)).getAttributes() == null || !((CellView)arrayList.get(n)).getAttributes().containsKey((Object)KEY_POSITION)) continue;
            this.cellList.add(arrayList.get(n));
        }
        if (arrayList2.size() != arrayList.size()) {
            this.arrangeLayoutUpdateInsertedCellsPlacement(arrayList2);
        } else {
            for (n = 0; n < arrayList2.size(); ++n) {
                cellView = (CellView)arrayList2.get(n);
                if (cellView.getAttributes().containsKey((Object)KEY_POSITION)) continue;
                cellView.getAttributes().put((Object)KEY_POSITION, (Object)new Point2D.Double(0.0, 0.0));
            }
        }
        for (n = 0; n < this.cellList.size(); ++n) {
            if (((CellView)this.cellList.get(n)).getAttributes().get((Object)KEY_POSITION) != null) continue;
            System.err.println("WHATCH OUT!!! NODE " + n + " == NULL");
        }
    }

    private void getLayoutUpdateCells(CellView[] cellViewArray) {
        int n;
        int n2;
        for (n2 = 0; n2 < cellViewArray.length; ++n2) {
            if (cellViewArray[n2] instanceof VertexView) {
                if (!this.applyCellList.contains(cellViewArray[n2])) {
                    this.applyCellList.add(cellViewArray[n2]);
                }
                if (this.cellList.contains(cellViewArray[n2])) continue;
                this.cellList.add(cellViewArray[n2]);
                continue;
            }
            if (!(cellViewArray[n2] instanceof EdgeView) || cellViewArray[n2] == null || this.edgeList.contains(cellViewArray[n2])) continue;
            this.edgeList.add(cellViewArray[n2]);
            System.out.println("edge added");
        }
        if ("Layout Update Method Perimeter".equals(this.luMethod)) {
            Object object;
            int n3;
            Point2D.Double double_;
            VertexView vertexView;
            ArrayList<Ellipse2D.Double> arrayList = new ArrayList<Ellipse2D.Double>();
            for (n = 0; n < this.applyCellList.size(); ++n) {
                vertexView = (VertexView)this.applyCellList.get(n);
                double_ = (Point2D.Double)vertexView.getAttributes().get((Object)KEY_POSITION);
                n3 = 0;
                for (int i = 0; i < this.applyCellList.size(); ++i) {
                    Point2D.Double double_2;
                    if (n == i || !(double_.distance(double_2 = (Point2D.Double)(object = (VertexView)this.applyCellList.get(i)).getAttributes().get((Object)KEY_POSITION)) < this.luPerimeterRadius)) continue;
                    ++n3;
                }
                arrayList.add(new Ellipse2D.Double(double_.x - (this.luPerimeterRadius + (double)n3 * this.luPerimeterRadiusInc), double_.y - (this.luPerimeterRadius + (double)n3 * this.luPerimeterRadiusInc), 2.0 * (this.luPerimeterRadius + (double)n3 * this.luPerimeterRadiusInc), 2.0 * (this.luPerimeterRadius + (double)n3 * this.luPerimeterRadiusInc)));
            }
            for (n = 0; n < this.cellList.size(); ++n) {
                vertexView = (VertexView)this.cellList.get(n);
                double_ = (Point2D.Double)vertexView.getAttributes().get((Object)KEY_POSITION);
                for (n3 = 0; n3 < arrayList.size(); ++n3) {
                    Ellipse2D.Double double_3 = (Ellipse2D.Double)arrayList.get(n3);
                    object = new Point2D.Double(double_3.getCenterX(), double_3.getCenterY());
                    double d = double_3.getCenterX() - double_3.getX();
                    if (!(((Point2D)object).distance(double_) < d) || this.applyCellList.contains(vertexView)) continue;
                    this.applyCellList.add(vertexView);
                }
            }
        }
        if (this.luRecursionDepth > 0) {
            n2 = 0;
            for (n = 0; n < cellViewArray.length; ++n) {
                if (!(cellViewArray[n] instanceof VertexView)) continue;
                ++n2;
            }
            VertexView[] vertexViewArray = new VertexView[n2];
            n2 = 0;
            for (int i = 0; i < cellViewArray.length; ++i) {
                if (!(cellViewArray[i] instanceof VertexView)) continue;
                vertexViewArray[n2++] = (VertexView)cellViewArray[i];
            }
            this.addRelativesToList(vertexViewArray, this.luRecursionDepth);
        }
    }

    private void addRelativesToList(VertexView[] vertexViewArray, int n) {
        if (vertexViewArray == null) {
            return;
        }
        if (vertexViewArray.length == 0) {
            return;
        }
        if (n == 0) {
            return;
        }
        for (int i = 0; i < vertexViewArray.length; ++i) {
            ArrayList arrayList = this.getRelatives((CellView)vertexViewArray[i]);
            VertexView[] vertexViewArray2 = new VertexView[arrayList.size()];
            for (int j = 0; j < arrayList.size(); ++j) {
                if (!this.applyCellList.contains(arrayList.get(j))) {
                    this.applyCellList.add(arrayList.get(j));
                }
                if (!this.cellList.contains(arrayList.get(j))) {
                    this.cellList.add(arrayList.get(j));
                }
                vertexViewArray2[j] = (VertexView)arrayList.get(j);
            }
            this.addRelativesToList(vertexViewArray2, n - 1);
        }
    }

    public void graphChanged(GraphModelEvent graphModelEvent) {
        if (!this.isRunning) {
            this.isRunning = true;
            Object[] objectArray = graphModelEvent.getChange().getInserted();
            Object[] objectArray2 = graphModelEvent.getChange().getRemoved();
            if (objectArray != null && objectArray2 == null) {
                if (objectArray.length == 0) {
                    this.isRunning = false;
                    return;
                }
                CellView[] cellViewArray = this.jgraph.getGraphLayoutCache().getMapping(objectArray, false);
                if (cellViewArray.length == 0) {
                    this.isRunning = false;
                    return;
                }
                this.applyCellList.clear();
                this.loadConfiguration(1);
                boolean bl = false;
                for (int i = 0; i < cellViewArray.length; ++i) {
                    if (cellViewArray[i] != null) continue;
                    bl = true;
                    break;
                }
                if (bl) {
                    this.getAllEdges();
                }
                this.arrangeLayoutUpdateInsertPlacement(cellViewArray);
                this.getLayoutUpdateCells(cellViewArray);
                if (this.applyCellList.size() == 0) {
                    this.isRunning = false;
                    return;
                }
                this.round = 0;
                if (this.isClusteringEnabled) {
                    this.clusterGraph();
                }
                this.init(false);
                this.run();
                if (this.isClusteringEnabled) {
                    this.declusterGraph();
                }
                this.applyChanges();
                this.removeTemporaryData();
            } else if (objectArray == null && objectArray2 != null) {
                this.isRunning = true;
                CellView[] cellViewArray = this.jgraph.getGraphLayoutCache().getMapping(objectArray2, false);
                for (int i = 0; i < cellViewArray.length; ++i) {
                    if (cellViewArray[i] instanceof VertexView) {
                        if (this.applyCellList.contains(cellViewArray[i])) {
                            this.applyCellList.remove(cellViewArray[i]);
                        }
                        if (!this.cellList.contains(cellViewArray[i])) continue;
                        this.cellList.remove(cellViewArray[i]);
                        continue;
                    }
                    if (!(cellViewArray[i] instanceof EdgeView)) continue;
                }
            }
            this.isRunning = false;
        }
    }

    private void showCell(CellView cellView, Color color) {
        Hashtable hashtable = new Hashtable();
        Point2D.Double double_ = this.getPosition(cellView);
        Rectangle2D rectangle2D = cellView.getBounds();
        rectangle2D.setFrame(double_.getX() - rectangle2D.getWidth() / 2.0, double_.getY() - rectangle2D.getHeight() / 2.0, rectangle2D.getWidth(), rectangle2D.getHeight());
        Object object = cellView.getCell();
        Hashtable hashtable2 = new Hashtable();
        GraphConstants.setBackground(hashtable2, (Color)color);
        GraphConstants.setBounds(hashtable2, (Rectangle2D)rectangle2D);
        hashtable.put(object, hashtable2);
        this.jgraph.getGraphLayoutCache().edit(hashtable, null, null, null);
    }

    private void colorizeClusters(ArrayList arrayList) {
        Color[] colorArray = new Color[]{Color.black, Color.magenta, Color.yellow, Color.blue, Color.green, Color.gray, Color.cyan, Color.red, Color.darkGray, Color.lightGray, Color.orange, Color.pink};
        for (int i = 0; i < arrayList.size() && i < colorArray.length; ++i) {
            ArrayList arrayList2 = (ArrayList)((VertexView)arrayList.get(i)).getAttributes().get((Object)KEY_CLUSTERED_VERTICES);
            this.showCellList(arrayList2, colorArray[i]);
        }
    }

    private void showCellList(ArrayList arrayList, Color color) {
        Hashtable hashtable = new Hashtable();
        for (int i = 0; i < arrayList.size(); ++i) {
            CellView cellView = (CellView)arrayList.get(i);
            Point2D.Double double_ = this.getPosition(cellView);
            Rectangle2D rectangle2D = cellView.getBounds();
            rectangle2D.setFrame(double_.getX() - rectangle2D.getWidth() / 2.0, double_.getY() - rectangle2D.getHeight() / 2.0, rectangle2D.getWidth(), rectangle2D.getHeight());
            Object object = cellView.getCell();
            Hashtable hashtable2 = new Hashtable();
            GraphConstants.setBackground(hashtable2, (Color)color);
            GraphConstants.setBounds(hashtable2, (Rectangle2D)rectangle2D);
            hashtable.put(object, hashtable2);
        }
        this.jgraph.getGraphLayoutCache().edit(hashtable, null, null, null);
    }

    private void getAllEdges() {
        Object[] objectArray = this.jgraph.getRoots();
        CellView[] cellViewArray = this.jgraph.getGraphLayoutCache().getMapping(objectArray, false);
        for (int i = 0; i < cellViewArray.length; ++i) {
            if (cellViewArray[i] instanceof VertexView) {
                Object object;
                int n;
                VertexView vertexView = (VertexView)cellViewArray[i];
                GraphModel graphModel = this.jgraph.getModel();
                GraphLayoutCache graphLayoutCache = this.jgraph.getGraphLayoutCache();
                Object object2 = vertexView.getCell();
                ArrayList<Object> arrayList = new ArrayList<Object>();
                for (n = 0; n < graphModel.getChildCount(object2); ++n) {
                    object = graphModel.getChild(object2, n);
                    arrayList.add(object);
                }
                for (n = 0; n < arrayList.size(); ++n) {
                    object = arrayList.get(n);
                    Iterator iterator = graphModel.edges(object);
                    while (iterator.hasNext()) {
                        Object e = iterator.next();
                        CellView cellView = graphLayoutCache.getMapping(e, false);
                        if (this.edgeList.contains(cellView) || cellView == null) continue;
                        this.edgeList.add(cellView);
                    }
                }
                continue;
            }
            if (!(cellViewArray[i] instanceof EdgeView) || this.edgeList.contains(cellViewArray[i]) || cellViewArray[i] == null) continue;
            this.edgeList.add(cellViewArray[i]);
        }
    }

    private synchronized void stop(long l) {
        try {
            this.wait(l);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    protected void clusterGraph() {
        int n;
        Point2D.Double double_;
        Point2D.Double double_2;
        VertexView vertexView;
        int n2;
        int n3 = Math.max((int)((double)(this.cellList.size() - this.applyCellList.size()) / this.clusteringFactor), 2);
        if (this.cellList.size() <= 1) {
            System.out.println("cellList.size() <= 1");
            return;
        }
        ArrayList<VertexView> arrayList = new ArrayList<VertexView>();
        ArrayList arrayList2 = new ArrayList();
        for (int i = 0; i < this.cellList.size(); ++i) {
            if (this.applyCellList.contains(this.cellList.get(i))) continue;
            arrayList2.add(this.cellList.get(i));
        }
        VertexView[] vertexViewArray = new VertexView[n3];
        Rectangle rectangle = this.getBoundingBox();
        for (n2 = 0; n2 < vertexViewArray.length; ++n2) {
            vertexViewArray[n2] = new VertexView(null);
            vertexView = vertexViewArray[n2].getAttributes();
            vertexView.put(KEY_IS_CLUSTER, "true");
            vertexView.put(KEY_POSITION, new Point2D.Double(Math.random() * (double)rectangle.width, Math.random() * (double)rectangle.height));
            arrayList.add(vertexViewArray[n2]);
        }
        for (n2 = 0; n2 < arrayList2.size(); ++n2) {
            vertexView = (VertexView)arrayList2.get(n2);
            double_2 = this.getPosition((CellView)vertexView);
            int n4 = 0;
            double_ = this.getPosition((CellView)arrayList.get(0));
            double d = MathExtensions.getEuclideanDistance(double_2, double_);
            for (int i = 1; i < arrayList.size(); ++i) {
                double_ = this.getPosition((CellView)((VertexView)arrayList.get(i)));
                double d2 = MathExtensions.getEuclideanDistance(double_2, double_);
                if (!(d > d2)) continue;
                d = d2;
                n4 = i;
            }
            VertexView vertexView2 = (VertexView)arrayList.get(n4);
            this.moveVerticeToCluster(vertexView, vertexView2);
        }
        n2 = 0;
        do {
            n2 = 0;
            block5: for (n = 0; n < arrayList2.size(); ++n) {
                double_2 = (VertexView)arrayList2.get(n);
                VertexView vertexView3 = (VertexView)double_2.getAttributes().get((Object)KEY_CLUSTER);
                double_ = this.getPosition((CellView)double_2);
                Point2D.Double double_3 = this.getPosition((CellView)vertexView3);
                double d = MathExtensions.getEuclideanDistance(double_, double_3);
                for (int i = 0; i < arrayList.size(); ++i) {
                    double d3;
                    VertexView vertexView4 = (VertexView)arrayList.get(i);
                    if (vertexView4 == vertexView3 || !((d3 = MathExtensions.getEuclideanDistance(double_, double_3 = this.getPosition((CellView)vertexView4))) < d)) continue;
                    this.moveVerticeToCluster((VertexView)double_2, vertexView4);
                    n2 = 1;
                    continue block5;
                }
            }
        } while (n2 != 0);
        for (n = 0; n < arrayList.size(); ++n) {
            if (!((VertexView)arrayList.get(n)).getAttributes().containsKey((Object)KEY_CLUSTERED_VERTICES)) {
                arrayList.remove(n--);
                continue;
            }
            if (((ArrayList)((VertexView)arrayList.get(n)).getAttributes().get((Object)KEY_CLUSTERED_VERTICES)).size() != 0) continue;
            arrayList.remove(n--);
        }
        for (n = 0; n < arrayList2.size(); ++n) {
            this.cellList.remove(arrayList2.get(n));
        }
        for (n = 0; n < arrayList.size(); ++n) {
            this.applyCellList.add(arrayList.get(n));
            this.cellList.add(arrayList.get(n));
        }
        for (n = 0; n < arrayList.size(); ++n) {
            double_2 = (VertexView)arrayList.get(n);
            AttributeMap attributeMap = double_2.getAttributes();
            double_ = (Point2D.Double)attributeMap.get(KEY_POSITION);
            attributeMap.put(KEY_CLUSTER_INIT_POSITION, new Point2D.Double(double_.x, double_.y));
        }
        for (n = 0; n < arrayList.size(); ++n) {
            double_2 = (VertexView)arrayList.get(n);
            double_2.setCachedBounds(this.getBoundingBox((ArrayList)double_2.getAttributes().get((Object)KEY_CLUSTERED_VERTICES)));
        }
    }

    protected void moveVerticeToCluster(VertexView vertexView, VertexView vertexView2) {
        if (!vertexView2.getAttributes().containsKey((Object)KEY_CLUSTERED_VERTICES)) {
            vertexView2.getAttributes().put((Object)KEY_CLUSTERED_VERTICES, new ArrayList());
        }
        ArrayList arrayList = (ArrayList)vertexView2.getAttributes().get((Object)KEY_CLUSTERED_VERTICES);
        arrayList.add(vertexView);
        if (vertexView.getAttributes().containsKey((Object)KEY_CLUSTER)) {
            VertexView vertexView3 = (VertexView)vertexView.getAttributes().get((Object)KEY_CLUSTER);
            ArrayList arrayList2 = (ArrayList)vertexView3.getAttributes().get((Object)KEY_CLUSTERED_VERTICES);
            arrayList2.remove(vertexView);
            this.computeClusterPosition(vertexView3);
        }
        vertexView.getAttributes().put((Object)KEY_CLUSTER, (Object)vertexView2);
        this.computeClusterPosition(vertexView2);
    }

    protected void computeClusterPosition(VertexView vertexView) {
        ArrayList arrayList = (ArrayList)vertexView.getAttributes().get((Object)KEY_CLUSTERED_VERTICES);
        Point2D.Double double_ = this.computeBarycenter(arrayList);
        vertexView.getAttributes().put((Object)KEY_POSITION, (Object)double_);
    }

    protected void declusterGraph() {
        VertexView vertexView;
        int n;
        if (this.cellList.size() <= 1) {
            return;
        }
        ArrayList<VertexView> arrayList = new ArrayList<VertexView>();
        for (n = 0; n < this.cellList.size(); ++n) {
            vertexView = (VertexView)this.cellList.get(n);
            if (!this.isCluster((CellView)vertexView)) continue;
            arrayList.add(vertexView);
        }
        if (arrayList.size() == 0) {
            return;
        }
        for (n = 0; n < arrayList.size(); ++n) {
            this.cellList.remove(arrayList.get(n));
            this.applyCellList.remove(arrayList.get(n));
        }
        for (n = 0; n < arrayList.size(); ++n) {
            vertexView = (VertexView)arrayList.get(n);
            AttributeMap attributeMap = vertexView.getAttributes();
            Point2D.Double double_ = this.getPosition((CellView)vertexView);
            Point2D.Double double_2 = (Point2D.Double)attributeMap.get(KEY_CLUSTER_INIT_POSITION);
            Point2D.Double double_3 = new Point2D.Double(double_.x - double_2.x, double_.y - double_2.y);
            ArrayList arrayList2 = (ArrayList)attributeMap.get(KEY_CLUSTERED_VERTICES);
            for (int i = 0; i < arrayList2.size(); ++i) {
                VertexView vertexView2 = (VertexView)arrayList2.get(i);
                Point2D.Double double_4 = this.getPosition((CellView)vertexView2);
                Point2D.Double double_5 = new Point2D.Double(double_4.x + double_3.x, double_4.y + double_3.y);
                vertexView2.getAttributes().put((Object)KEY_POSITION, (Object)double_5);
                this.cellList.add(vertexView2);
            }
        }
    }

    protected boolean isCluster(CellView cellView) {
        if (cellView.getAttributes().containsKey((Object)KEY_IS_CLUSTER)) {
            if (this.isTrue((String)cellView.getAttributes().get((Object)KEY_IS_CLUSTER))) {
                return true;
            }
            System.err.println("FATAL ERROR: CELL CANNOT CLEARLY BE IDENTIFIED AS A CLUSTER!!!");
            return false;
        }
        return false;
    }

    private Point2D.Double computeBarycenter(ArrayList arrayList) {
        double d = 0.0;
        double d2 = 0.0;
        for (int i = 0; i < arrayList.size(); ++i) {
            CellView cellView = (CellView)arrayList.get(i);
            Point2D.Double double_ = this.getPosition(cellView);
            d += double_.x;
            d2 += double_.y;
        }
        return new Point2D.Double(d / (double)arrayList.size(), d2 / (double)arrayList.size());
    }

    private Rectangle getBoundingBox(ArrayList arrayList) {
        if (arrayList.size() > 0) {
            Point2D.Double double_ = this.getPosition((CellView)((VertexView)arrayList.get(0)));
            Rectangle2D rectangle2D = ((CellView)arrayList.get(0)).getBounds();
            double d = double_.getX();
            double d2 = double_.getX();
            double d3 = double_.getX() + rectangle2D.getWidth();
            double d4 = double_.getX() + rectangle2D.getHeight();
            for (int i = 1; i < arrayList.size(); ++i) {
                double_ = this.getPosition((CellView)((VertexView)arrayList.get(i)));
                rectangle2D = ((CellView)arrayList.get(i)).getBounds();
                if (d > double_.getX()) {
                    d = double_.getX();
                }
                if (d2 > double_.getY()) {
                    d2 = double_.getY();
                }
                if (d3 < double_.getX() + rectangle2D.getWidth()) {
                    d3 = double_.getX() + rectangle2D.getWidth();
                }
                if (!(d4 < double_.getY() + rectangle2D.getHeight())) continue;
                d4 = double_.getY() + rectangle2D.getHeight();
            }
            Rectangle rectangle = new Rectangle((int)d, (int)d2, (int)(d3 - d), (int)(d4 - d2));
            return rectangle;
        }
        return null;
    }

    private Rectangle getBoundingBox() {
        return this.getBoundingBox(this.cellList);
    }

    public boolean isOptimizer() {
        return this.isOptimizer;
    }

    public Properties getPresetConfig() {
        return this.presetConfig;
    }

    public void setPresetConfig(Properties properties) {
        this.presetConfig = properties;
        this.loadConfiguration(0);
    }

    public static abstract class MathExtensions {
        public static double sgn(double d) {
            if (d < 0.0) {
                return -1.0;
            }
            if (d > 0.0) {
                return 1.0;
            }
            return 0.0;
        }

        public static double abs(Point2D.Double double_) {
            return Math.sqrt(MathExtensions.getTransposed(double_, double_));
        }

        public static double abs(double d, double d2) {
            return Math.sqrt(d * d + d2 * d2);
        }

        public static double angleBetween(Point2D.Double double_, Point2D.Double double_2) {
            double d;
            double d2;
            double d3 = MathExtensions.getTransposed(double_, double_2);
            double d4 = d3 / ((d2 = Math.sqrt(MathExtensions.getTransposed(double_, double_))) * (d = Math.sqrt(MathExtensions.getTransposed(double_2, double_2))));
            if (d4 > 1.0) {
                d4 = 1.0;
            }
            if (d4 < -1.0) {
                d4 = -1.0;
            }
            return Math.acos(d4);
        }

        public static double getTransposed(Point2D.Double double_, Point2D.Double double_2) {
            return double_.getX() * double_2.getX() + double_.getY() * double_2.getY();
        }

        public static double getEuclideanDistance(Point2D.Double double_, Point2D.Double double_2) {
            return Math.sqrt((double_.x - double_2.x) * (double_.x - double_2.x) + (double_.y - double_2.y) * (double_.y - double_2.y));
        }

        public static Point2D.Double getNormalizedVector(Point2D.Double double_) {
            double d = MathExtensions.abs(double_);
            return new Point2D.Double(double_.x / d, double_.y / d);
        }
    }
}

