/*
 * Decompiled with CFR 0.152.
 */
package org.jgraph.cellview;

import java.awt.Component;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.image.ImageObserver;
import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;
import javax.swing.Icon;
import javax.swing.ImageIcon;

public abstract class JGraphAbstractIconAnimator {
    private static final Map contexts = new WeakHashMap();
    private final ImageIcon icon;
    private final Component context;
    private final Object key;

    public static boolean isAnimated(Icon icon) {
        String string;
        return icon instanceof ImageIcon && (string = icon.toString()) != null && string.indexOf("animated.gif") != -1;
    }

    public static JGraphAbstractIconAnimator get(Component component, Object object) {
        Map map = (Map)contexts.get(component);
        if (map != null) {
            return (JGraphAbstractIconAnimator)map.get(object);
        }
        return null;
    }

    public JGraphAbstractIconAnimator(final Component component, final Object object, ImageIcon imageIcon) {
        this.context = component;
        this.key = object;
        this.icon = new ImageIcon(imageIcon.getImage());
        this.icon.setImageObserver(new ImageObserver(){

            public boolean imageUpdate(Image image, int n, int n2, int n3, int n4, int n5) {
                if ((n & 0x30) != 0) {
                    JGraphAbstractIconAnimator.this.repaint(component, object);
                }
                return (n & 0xA0) == 0;
            }
        });
        HashMap<Object, JGraphAbstractIconAnimator> hashMap = (HashMap<Object, JGraphAbstractIconAnimator>)contexts.get(component);
        if (hashMap == null) {
            hashMap = new HashMap<Object, JGraphAbstractIconAnimator>();
            contexts.put(component, hashMap);
        }
        hashMap.put(object, this);
    }

    protected void repaint(Component component, Object object) {
        Rectangle rectangle = this.getRepaintRect(component, object);
        if (rectangle != null) {
            component.repaint(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        }
    }

    public abstract Rectangle getRepaintRect(Component var1, Object var2);

    public void stop() {
        this.icon.setImageObserver(null);
        this.icon.getImage().flush();
        Map map = (Map)contexts.get(this.context);
        if (map != null) {
            map.remove(this.key);
            if (map.size() == 0) {
                contexts.remove(this.context);
            }
        }
    }

    public Icon getIcon() {
        return this.icon;
    }
}

