/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.demo.flamingo.svg;

import java.awt.BorderLayout;
import java.awt.Component;
import java.io.File;
import java.util.List;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import javax.swing.filechooser.FileSystemView;
import org.pushingpixels.demo.flamingo.svg.SvgFileViewPanel;
import org.pushingpixels.demo.flamingo.svg.logo.RadianceLogo;
import org.pushingpixels.flamingo.api.bcb.BreadcrumbBarCallBack;
import org.pushingpixels.flamingo.api.bcb.BreadcrumbItem;
import org.pushingpixels.flamingo.api.bcb.core.BreadcrumbFileSelector;
import org.pushingpixels.flamingo.api.common.StringValuePair;
import org.pushingpixels.substance.api.ComponentState;
import org.pushingpixels.substance.api.SubstanceCortex;
import org.pushingpixels.substance.api.SubstanceSkin;
import org.pushingpixels.substance.api.SubstanceSlices;
import org.pushingpixels.substance.api.skin.BusinessSkin;

public class SvgViewer
extends JFrame {
    private BreadcrumbFileSelector bar;
    private SvgFileViewPanel svgFileViewPanel;
    private JSlider iconSizeSlider;
    private int currIconSize;

    public SvgViewer() {
        super("SVG File Viewer");
        this.setIconImage(RadianceLogo.getLogoImage(SubstanceCortex.GlobalScope.getCurrentSkin().getColorScheme(SubstanceSlices.DecorationAreaType.PRIMARY_TITLE_PANE, SubstanceSlices.ColorSchemeAssociationKind.FILL, ComponentState.ENABLED)));
        this.bar = new BreadcrumbFileSelector();
        this.bar.getModel().addPathListener(event -> SwingUtilities.invokeLater(() -> {
            final List newPath = event.getSource().getItems();
            this.svgFileViewPanel.cancelMainWorker();
            System.out.println("New path is ");
            for (BreadcrumbItem item : newPath) {
                System.out.println("\t" + FileSystemView.getFileSystemView().getSystemDisplayName((File)item.getData()));
            }
            if (newPath.size() > 0) {
                SwingWorker<List<StringValuePair<File>>, Void> worker = new SwingWorker<List<StringValuePair<File>>, Void>(){

                    @Override
                    protected List<StringValuePair<File>> doInBackground() {
                        return SvgViewer.this.bar.getCallback().getLeafs(newPath);
                    }

                    @Override
                    protected void done() {
                        try {
                            SvgViewer.this.svgFileViewPanel.setFolder((List)this.get());
                            SvgViewer.this.svgFileViewPanel.setIconDimension(SvgViewer.this.currIconSize);
                        }
                        catch (Exception exc) {
                            exc.printStackTrace();
                        }
                    }
                };
                worker.execute();
            }
        }));
        this.setLayout(new BorderLayout());
        this.add((Component)this.bar, "North");
        int initialSize = 32;
        this.svgFileViewPanel = new SvgFileViewPanel((BreadcrumbBarCallBack<File>)this.bar.getCallback(), initialSize);
        JScrollPane jsp = new JScrollPane((Component)((Object)this.svgFileViewPanel), 22, 32);
        this.add((Component)jsp, "Center");
        this.iconSizeSlider = new JSlider();
        this.iconSizeSlider.setMinimum(16);
        this.iconSizeSlider.setMaximum(128);
        this.iconSizeSlider.setSnapToTicks(true);
        this.iconSizeSlider.setPaintLabels(true);
        this.iconSizeSlider.setPaintTicks(true);
        this.iconSizeSlider.setMajorTickSpacing(32);
        this.iconSizeSlider.setMinorTickSpacing(8);
        this.iconSizeSlider.setValue(initialSize);
        this.currIconSize = initialSize;
        this.iconSizeSlider.addChangeListener(e -> {
            int newValue;
            if (!this.iconSizeSlider.getModel().getValueIsAdjusting() && (newValue = this.iconSizeSlider.getValue()) != this.currIconSize) {
                this.currIconSize = newValue;
                SwingUtilities.invokeLater(() -> this.svgFileViewPanel.setIconDimension(this.currIconSize));
            }
        });
        this.add((Component)this.iconSizeSlider, "South");
    }

    public static void main(String ... args) {
        JFrame.setDefaultLookAndFeelDecorated(true);
        SubstanceCortex.GlobalScope.allowAnimations((SubstanceSlices.AnimationFacet)SubstanceSlices.AnimationFacet.GHOSTING_ICON_ROLLOVER);
        SwingUtilities.invokeLater(() -> {
            SubstanceCortex.GlobalScope.setSkin((SubstanceSkin)new BusinessSkin());
            SvgViewer test = new SvgViewer();
            test.setSize(640, 480);
            test.setLocationRelativeTo(null);
            test.setVisible(true);
            test.setDefaultCloseOperation(3);
        });
    }
}

