/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.demo.flamingo.svg;

import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.lang.reflect.Field;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import org.apache.batik.ext.awt.LinearGradientPaint;
import org.apache.batik.ext.awt.MultipleGradientPaint;
import org.apache.batik.ext.awt.RadialGradientPaint;
import org.apache.batik.ext.awt.geom.ExtendedGeneralPath;
import org.apache.batik.gvt.CompositeGraphicsNode;
import org.apache.batik.gvt.CompositeShapePainter;
import org.apache.batik.gvt.FillShapePainter;
import org.apache.batik.gvt.GraphicsNode;
import org.apache.batik.gvt.ShapeNode;
import org.apache.batik.gvt.ShapePainter;
import org.apache.batik.gvt.StrokeShapePainter;
import org.apache.batik.swing.JSVGCanvas;
import org.apache.batik.swing.gvt.GVTTreeRendererAdapter;
import org.apache.batik.swing.gvt.GVTTreeRendererEvent;
import org.apache.batik.swing.gvt.GVTTreeRendererListener;
import org.apache.batik.swing.svg.GVTTreeBuilderAdapter;
import org.apache.batik.swing.svg.GVTTreeBuilderEvent;
import org.apache.batik.swing.svg.GVTTreeBuilderListener;
import org.apache.batik.swing.svg.SVGDocumentLoaderAdapter;
import org.apache.batik.swing.svg.SVGDocumentLoaderEvent;
import org.apache.batik.swing.svg.SVGDocumentLoaderListener;
import org.pushingpixels.photon.api.transcoder.LanguageRenderer;
import org.pushingpixels.photon.api.transcoder.SvgTranscoder;
import org.pushingpixels.photon.api.transcoder.TranscoderListener;
import org.pushingpixels.photon.api.transcoder.java.JavaLanguageRenderer;

public class SVGApplication {
    JFrame frame;
    JButton button = new JButton("Load...");
    JLabel label = new JLabel();
    JSVGCanvas svgCanvas = new JSVGCanvas();
    String lastDir;

    public static void main(String[] args) {
        JFrame f = new JFrame("Batik");
        SVGApplication app = new SVGApplication(f);
        f.getContentPane().add(app.createComponents());
        f.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                System.exit(0);
            }
        });
        f.setSize(400, 400);
        f.setVisible(true);
    }

    public SVGApplication(JFrame f) {
        this.frame = f;
    }

    public JComponent createComponents() {
        JPanel panel = new JPanel(new BorderLayout());
        JPanel p = new JPanel(new FlowLayout(0));
        p.add(this.button);
        p.add(this.label);
        panel.add("North", p);
        panel.add("Center", (Component)this.svgCanvas);
        this.button.addActionListener(e -> {
            JFileChooser fc = new JFileChooser(this.lastDir);
            int choice = fc.showOpenDialog(panel);
            if (choice == 0) {
                File f = fc.getSelectedFile();
                this.lastDir = f.getParent();
                try {
                    String svgClassName = f.getName().substring(0, f.getName().length() - 4);
                    svgClassName = svgClassName.replace('-', '_');
                    svgClassName = svgClassName.replace(' ', '_');
                    this.svgCanvas.setURI(f.toURI().toURL().toString());
                    String javaClassFilename = f.getParent() + File.separator + svgClassName + ".java";
                    final PrintWriter pw = new PrintWriter(javaClassFilename);
                    SvgTranscoder transcoder = new SvgTranscoder(f.toURI().toURL().toString(), svgClassName, (LanguageRenderer)new JavaLanguageRenderer());
                    transcoder.setListener(new TranscoderListener(){

                        public Writer getWriter() {
                            return pw;
                        }

                        public void finished() {
                            JOptionPane.showMessageDialog(null, "Finished");
                        }
                    });
                    transcoder.transcode(this.getClass().getResourceAsStream("/org/pushingpixels/photon/api/transcoder/java/SvgTranscoderTemplateResizable.templ"));
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                }
            }
        });
        this.svgCanvas.addSVGDocumentLoaderListener((SVGDocumentLoaderListener)new SVGDocumentLoaderAdapter(){

            public void documentLoadingStarted(SVGDocumentLoaderEvent e) {
                SVGApplication.this.label.setText("Document Loading...");
            }

            public void documentLoadingCompleted(SVGDocumentLoaderEvent e) {
                SVGApplication.this.label.setText("Document Loaded.");
            }
        });
        this.svgCanvas.addGVTTreeBuilderListener((GVTTreeBuilderListener)new GVTTreeBuilderAdapter(){

            public void gvtBuildStarted(GVTTreeBuilderEvent e) {
                SVGApplication.this.label.setText("Build Started...");
            }

            private void dumpShape(PrintWriter pw, ExtendedGeneralPath egPath, int offset) {
                float[] coords = new float[6];
                pw.println("shape = new GeneralPath();");
                PathIterator i = egPath.getPathIterator(null);
                while (!i.isDone()) {
                    int type = i.currentSegment(coords);
                    switch (type) {
                        case 3: {
                            pw.println("((GeneralPath)shape).curveTo(" + coords[0] + ", " + coords[1] + ", " + coords[2] + ", " + coords[3] + ", " + coords[4] + ", " + coords[5] + ");");
                            break;
                        }
                        case 2: {
                            pw.println("((GeneralPath)shape).quadTo(" + coords[0] + ", " + coords[1] + ", " + coords[2] + ", " + coords[3] + ");");
                            break;
                        }
                        case 0: {
                            pw.println("((GeneralPath)shape).moveTo(" + coords[0] + ", " + coords[1] + ");");
                            break;
                        }
                        case 1: {
                            pw.println("((GeneralPath)shape).lineTo(" + coords[0] + ", " + coords[1] + ");");
                            break;
                        }
                        case 4: {
                            pw.println("((GeneralPath)shape).closePath();");
                        }
                    }
                    i.next();
                }
            }

            private void dumpShape(PrintWriter pw, Shape shape, int offset) {
                if (shape instanceof ExtendedGeneralPath) {
                    this.dumpShape(pw, (ExtendedGeneralPath)shape, offset);
                    return;
                }
                if (shape instanceof Rectangle2D) {
                    Rectangle2D rect = (Rectangle2D)shape;
                    pw.println("shape = new Rectangle2D.Double(" + rect.getX() + ", " + rect.getY() + ", " + rect.getWidth() + ", " + rect.getHeight() + ");");
                    return;
                }
                if (shape instanceof RoundRectangle2D) {
                    RoundRectangle2D rRect = (RoundRectangle2D)shape;
                    pw.println("shape = new RoundRectangle2D.Double(" + rRect.getX() + ", " + rRect.getY() + ", " + rRect.getWidth() + ", " + rRect.getHeight() + ", " + rRect.getArcWidth() + ", " + rRect.getArcHeight() + ");");
                    return;
                }
                throw new UnsupportedOperationException(shape.getClass().getCanonicalName());
            }

            private void dumpPaint(PrintWriter pw, LinearGradientPaint paint, int offset) {
                Point2D startPoint = paint.getStartPoint();
                Point2D endPoint = paint.getEndPoint();
                float[] fractions = paint.getFractions();
                Color[] colors = paint.getColors();
                MultipleGradientPaint.CycleMethodEnum cycleMethod = paint.getCycleMethod();
                MultipleGradientPaint.ColorSpaceEnum colorSpace = paint.getColorSpace();
                AffineTransform transform = paint.getTransform();
                StringBuffer fractionsRep = new StringBuffer();
                if (fractions == null) {
                    fractionsRep.append("null");
                } else {
                    String sep = "";
                    fractionsRep.append("new float[] {");
                    for (float fraction : fractions) {
                        fractionsRep.append(sep);
                        fractionsRep.append(fraction + "f");
                        sep = ",";
                    }
                    fractionsRep.append("}");
                }
                StringBuffer colorsRep = new StringBuffer();
                if (fractions == null) {
                    colorsRep.append("null");
                } else {
                    String sep = "";
                    colorsRep.append("new Color[] {");
                    for (Color color : colors) {
                        colorsRep.append(sep);
                        colorsRep.append("new Color(" + color.getRed() + ", " + color.getGreen() + ", " + color.getBlue() + ", " + color.getAlpha() + ")");
                        sep = ",";
                    }
                    colorsRep.append("}");
                }
                String cycleMethodRep = null;
                if (cycleMethod == MultipleGradientPaint.NO_CYCLE) {
                    cycleMethodRep = "MultipleGradientPaint.CycleMethod.NO_CYCLE";
                }
                if (cycleMethod == MultipleGradientPaint.REFLECT) {
                    cycleMethodRep = "MultipleGradientPaint.CycleMethod.REFLECT";
                }
                if (cycleMethod == MultipleGradientPaint.REPEAT) {
                    cycleMethodRep = "MultipleGradientPaint.CycleMethod.REPEAT";
                }
                String colorSpaceRep = null;
                if (colorSpace == MultipleGradientPaint.SRGB) {
                    colorSpaceRep = "MultipleGradientPaint.ColorSpaceType.SRGB";
                }
                if (colorSpace == MultipleGradientPaint.LINEAR_RGB) {
                    colorSpaceRep = "MultipleGradientPaint.ColorSpaceType.LINEAR_RGB";
                }
                double[] transfMatrix = new double[6];
                transform.getMatrix(transfMatrix);
                pw.println("paint = new LinearGradientPaint(new Point2D.Double(" + startPoint.getX() + ", " + startPoint.getY() + "), new Point2D.Double(" + endPoint.getX() + ", " + endPoint.getY() + "), " + fractionsRep.toString() + ", " + colorsRep.toString() + ", " + cycleMethodRep + ", " + colorSpaceRep + ", new AffineTransform(" + transfMatrix[0] + "f, " + transfMatrix[1] + "f, " + transfMatrix[2] + "f, " + transfMatrix[3] + "f, " + transfMatrix[4] + "f, " + transfMatrix[5] + "f));");
            }

            private void dumpPaint(PrintWriter pw, RadialGradientPaint paint, int offset) {
                Point2D centerPoint = paint.getCenterPoint();
                float radius = paint.getRadius();
                Point2D focusPoint = paint.getFocusPoint();
                float[] fractions = paint.getFractions();
                Color[] colors = paint.getColors();
                MultipleGradientPaint.CycleMethodEnum cycleMethod = paint.getCycleMethod();
                MultipleGradientPaint.ColorSpaceEnum colorSpace = paint.getColorSpace();
                AffineTransform transform = paint.getTransform();
                StringBuffer fractionsRep = new StringBuffer();
                if (fractions == null) {
                    fractionsRep.append("null");
                } else {
                    String sep = "";
                    fractionsRep.append("new float[] {");
                    for (float fraction : fractions) {
                        fractionsRep.append(sep);
                        fractionsRep.append(fraction + "f");
                        sep = ",";
                    }
                    fractionsRep.append("}");
                }
                StringBuffer colorsRep = new StringBuffer();
                if (fractions == null) {
                    colorsRep.append("null");
                } else {
                    String sep = "";
                    colorsRep.append("new Color[] {");
                    for (Color color : colors) {
                        colorsRep.append(sep);
                        colorsRep.append("new Color(" + color.getRed() + ", " + color.getGreen() + ", " + color.getBlue() + ", " + color.getAlpha() + ")");
                        sep = ",";
                    }
                    colorsRep.append("}");
                }
                String cycleMethodRep = null;
                if (cycleMethod == MultipleGradientPaint.NO_CYCLE) {
                    cycleMethodRep = "MultipleGradientPaint.CycleMethod.NO_CYCLE";
                }
                if (cycleMethod == MultipleGradientPaint.REFLECT) {
                    cycleMethodRep = "MultipleGradientPaint.CycleMethod.REFLECT";
                }
                if (cycleMethod == MultipleGradientPaint.REPEAT) {
                    cycleMethodRep = "MultipleGradientPaint.CycleMethod.REPEAT";
                }
                String colorSpaceRep = null;
                if (colorSpace == MultipleGradientPaint.SRGB) {
                    colorSpaceRep = "MultipleGradientPaint.ColorSpaceType.SRGB";
                }
                if (colorSpace == MultipleGradientPaint.LINEAR_RGB) {
                    colorSpaceRep = "MultipleGradientPaint.ColorSpaceType.LINEAR_RGB";
                }
                double[] transfMatrix = new double[6];
                transform.getMatrix(transfMatrix);
                pw.println("paint = new RadialGradientPaint(new Point2D.Double(" + centerPoint.getX() + ", " + centerPoint.getY() + "), " + radius + "f, new Point2D.Double(" + focusPoint.getX() + ", " + focusPoint.getY() + "), " + fractionsRep.toString() + ", " + colorsRep.toString() + ", " + cycleMethodRep + ", " + colorSpaceRep + ", new AffineTransform(" + transfMatrix[0] + "f, " + transfMatrix[1] + "f, " + transfMatrix[2] + "f, " + transfMatrix[3] + "f, " + transfMatrix[4] + "f, " + transfMatrix[5] + "f));");
            }

            private void dumpPaint(PrintWriter pw, Paint paint, int offset) {
                if (paint instanceof RadialGradientPaint) {
                    this.dumpPaint(pw, (RadialGradientPaint)paint, offset);
                    return;
                }
                if (paint instanceof LinearGradientPaint) {
                    this.dumpPaint(pw, (LinearGradientPaint)paint, offset);
                    return;
                }
                if (paint instanceof Color) {
                    Color c = (Color)paint;
                    pw.println("paint = new Color(" + c.getRed() + ", " + c.getGreen() + ", " + c.getBlue() + ", " + c.getAlpha() + ");");
                    return;
                }
                if (paint == null) {
                    pw.println("No paint");
                    return;
                }
                throw new UnsupportedOperationException(paint.getClass().getCanonicalName());
            }

            private void dumpShapePainter(PrintWriter pw, ShapePainter painter, int offset) {
                if (painter instanceof CompositeShapePainter) {
                    this.dumpCompositeShapePainter(pw, (CompositeShapePainter)painter, offset);
                    return;
                }
                if (painter instanceof FillShapePainter) {
                    this.dumpFillShapePainter(pw, (FillShapePainter)painter, offset);
                    return;
                }
                if (painter instanceof StrokeShapePainter) {
                    this.dumpStrokeShapePainter(pw, (StrokeShapePainter)painter, offset);
                    return;
                }
                throw new UnsupportedOperationException(painter.getClass().getCanonicalName());
            }

            private void dumpCompositeShapePainter(PrintWriter pw, CompositeShapePainter painter, int offset) {
                for (int i = 0; i < painter.getShapePainterCount(); ++i) {
                    this.dumpShapePainter(pw, painter.getShapePainter(i), offset + 1);
                }
            }

            private void dumpFillShapePainter(PrintWriter pw, FillShapePainter painter, int offset) {
                try {
                    Field paintFld = FillShapePainter.class.getDeclaredField("paint");
                    paintFld.setAccessible(true);
                    Paint paint = (Paint)paintFld.get(painter);
                    if (paint == null) {
                        return;
                    }
                    this.dumpPaint(pw, paint, offset + 1);
                }
                catch (Exception exc) {
                    exc.printStackTrace();
                }
                Shape shape = painter.getShape();
                this.dumpShape(pw, shape, offset + 1);
                pw.println("g.setPaint(paint);");
                pw.println("g.fill(shape);");
            }

            private void dumpStrokeShapePainter(PrintWriter pw, StrokeShapePainter painter, int offset) {
                Shape shape = painter.getShape();
                try {
                    Field paintFld = StrokeShapePainter.class.getDeclaredField("paint");
                    paintFld.setAccessible(true);
                    Paint paint = (Paint)paintFld.get(painter);
                    if (paint == null) {
                        return;
                    }
                    this.dumpPaint(pw, paint, offset);
                }
                catch (Exception exc) {
                    exc.printStackTrace();
                }
                try {
                    Field strokeFld = StrokeShapePainter.class.getDeclaredField("stroke");
                    strokeFld.setAccessible(true);
                    Stroke stroke = (Stroke)strokeFld.get(painter);
                    BasicStroke bStroke = (BasicStroke)stroke;
                    float width = bStroke.getLineWidth();
                    int cap = bStroke.getEndCap();
                    int join = bStroke.getLineJoin();
                    float miterlimit = bStroke.getMiterLimit();
                    float[] dash = bStroke.getDashArray();
                    float dash_phase = bStroke.getDashPhase();
                    StringBuffer dashRep = new StringBuffer();
                    if (dash == null) {
                        dashRep.append("null");
                    } else {
                        String sep = "";
                        dashRep.append("new float[] {");
                        for (float _dash : dash) {
                            dashRep.append(sep);
                            dashRep.append(_dash + "f");
                            sep = ",";
                        }
                        dashRep.append("}");
                    }
                    pw.println("stroke = new BasicStroke(" + width + "f," + cap + "," + join + "," + miterlimit + "f," + dashRep + "," + dash_phase + "f);");
                }
                catch (Exception exc) {
                    exc.printStackTrace();
                }
                this.dumpShape(pw, shape, offset + 1);
                pw.println("g.setPaint(paint);");
                pw.println("g.setStroke(stroke);");
                pw.println("g.draw(shape);");
            }

            private void dumpNode(PrintWriter pw, ShapeNode node, String comment) {
                pw.println("// " + comment);
                ShapePainter sPainter = node.getShapePainter();
                this.dumpShapePainter(pw, sPainter, 0);
            }

            private void dumpNode(PrintWriter pw, CompositeGraphicsNode node, String comment) {
                pw.println("// " + comment);
                int count = 0;
                for (Object obj : node.getChildren()) {
                    this.dumpNode(pw, (GraphicsNode)obj, comment + "_" + count);
                    ++count;
                }
            }

            private void dumpNode(PrintWriter pw, GraphicsNode node, String comment) {
                AlphaComposite composite = (AlphaComposite)node.getComposite();
                if (composite != null) {
                    int rule = composite.getRule();
                    float alpha = composite.getAlpha();
                    pw.println("g.setComposite(AlphaComposite.getInstance(" + rule + ", " + alpha + "f));");
                }
                AffineTransform transform = node.getTransform();
                pw.println("AffineTransform defaultTransform_" + comment + " = g.getTransform();");
                if (transform != null) {
                    double[] transfMatrix = new double[6];
                    transform.getMatrix(transfMatrix);
                    pw.println("g.transform(new AffineTransform(" + transfMatrix[0] + "f, " + transfMatrix[1] + "f, " + transfMatrix[2] + "f, " + transfMatrix[3] + "f, " + transfMatrix[4] + "f, " + transfMatrix[5] + "f));");
                }
                try {
                    if (node instanceof ShapeNode) {
                        this.dumpNode(pw, (ShapeNode)node, comment);
                        return;
                    }
                    if (node instanceof CompositeGraphicsNode) {
                        this.dumpNode(pw, (CompositeGraphicsNode)node, comment);
                        return;
                    }
                    throw new UnsupportedOperationException(node.getClass().getCanonicalName());
                }
                finally {
                    pw.println("g.setTransform(defaultTransform_" + comment + ");");
                }
            }

            public void gvtBuildCompleted(GVTTreeBuilderEvent e) {
                SVGApplication.this.label.setText("Build Done.");
                SVGApplication.this.frame.pack();
            }
        });
        this.svgCanvas.addGVTTreeRendererListener((GVTTreeRendererListener)new GVTTreeRendererAdapter(){

            public void gvtRenderingPrepare(GVTTreeRendererEvent e) {
                SVGApplication.this.label.setText("Rendering Started...");
            }

            public void gvtRenderingCompleted(GVTTreeRendererEvent e) {
                SVGApplication.this.label.setText("");
            }
        });
        return panel;
    }
}

