/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.demo.flamingo.ribbon;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import org.pushingpixels.flamingo.api.ribbon.JRibbonBand;
import org.pushingpixels.neon.api.icon.ResizableIcon;

public class SimpleResizableIcon
implements ResizableIcon {
    private int currWidth;
    private int currHeight;
    private JRibbonBand.PresentationPriority priority;

    public SimpleResizableIcon(JRibbonBand.PresentationPriority priority, int startWidth, int startHeight) {
        this.priority = priority;
        this.currWidth = startWidth;
        this.currHeight = startHeight;
    }

    public void setDimension(Dimension newDimension) {
        this.currWidth = newDimension.width;
        this.currHeight = newDimension.height;
    }

    public int getIconHeight() {
        return this.currHeight;
    }

    public int getIconWidth() {
        return this.currWidth;
    }

    public void paintIcon(Component c, Graphics g, int x, int y) {
        Graphics2D graphics = (Graphics2D)g.create();
        graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        int rx = this.currWidth / 3;
        int ry = this.currHeight / 3;
        int cx = x + this.currWidth / 2 - 1;
        int cy = y + this.currHeight / 2 - 1;
        Color color = null;
        switch (this.priority) {
            case TOP: {
                color = new Color(0, 0, 128);
                break;
            }
            case MEDIUM: {
                color = Color.blue;
                break;
            }
            case LOW: {
                color = new Color(128, 128, 255);
            }
        }
        graphics.setColor(color);
        graphics.fillOval(cx - rx, cy - ry, 2 * rx, 2 * ry);
        graphics.setColor(color.darker());
        graphics.drawOval(cx - rx, cy - ry, 2 * rx, 2 * ry);
        graphics.drawRect(x, y, this.currWidth - 2, this.currHeight - 2);
        graphics.dispose();
    }

    public static class FactoryTop
    implements ResizableIcon.Factory {
        public ResizableIcon createNewIcon() {
            return new SimpleResizableIcon(JRibbonBand.PresentationPriority.TOP, 16, 16);
        }
    }
}

