/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.demo.flamingo.group;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.image.BufferedImage;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JTextPane;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.text.DefaultCaret;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import org.pushingpixels.demo.flamingo.svg.tango.transcoded.Format_justify_center;
import org.pushingpixels.demo.flamingo.svg.tango.transcoded.Format_justify_fill;
import org.pushingpixels.demo.flamingo.svg.tango.transcoded.Format_justify_left;
import org.pushingpixels.demo.flamingo.svg.tango.transcoded.Format_justify_right;
import org.pushingpixels.flamingo.api.common.JCommandButtonStrip;
import org.pushingpixels.flamingo.api.common.model.Command;
import org.pushingpixels.flamingo.api.common.model.CommandGroup;
import org.pushingpixels.flamingo.api.common.model.CommandStripPresentationModel;
import org.pushingpixels.flamingo.api.common.model.CommandToggleGroupModel;
import org.pushingpixels.flamingo.api.common.projection.CommandStripProjection;
import org.pushingpixels.substance.api.SubstanceCortex;
import org.pushingpixels.substance.api.SubstanceSkin;
import org.pushingpixels.substance.api.skin.MarinerSkin;

public class ToggleButtonGroupDemo {
    private static void setAlignment(JTextPane textPane, int alignment) {
        SimpleAttributeSet attrSet = new SimpleAttributeSet();
        StyleConstants.setAlignment(attrSet, alignment);
        textPane.getStyledDocument().setParagraphAttributes(0, textPane.getStyledDocument().getLength(), attrSet, false);
    }

    public static void main(String ... args) {
        SwingUtilities.invokeLater(() -> {
            SubstanceCortex.GlobalScope.setSkin((SubstanceSkin)new MarinerSkin());
            JFrame frame = new JFrame("Text alignment demo");
            frame.setLayout(new BorderLayout());
            JTextPane textPane = new JTextPane();
            textPane.setText("Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum.");
            textPane.setEditable(true);
            textPane.setBorder(new EmptyBorder(12, 12, 12, 12));
            textPane.setCaret(new DefaultCaret(){

                @Override
                public void setSelectionVisible(boolean visible) {
                    super.setSelectionVisible(true);
                }
            });
            frame.add((Component)textPane, "Center");
            JPanel styleButtonPanel = new JPanel(new FlowLayout());
            frame.add((Component)styleButtonPanel, "After");
            CommandToggleGroupModel justifyToggleGroup = new CommandToggleGroupModel();
            Command commandAlignLeft = ((Command.Builder)((Command.Builder)((Command.Builder)Command.builder().setIconFactory(Format_justify_left.factory())).setAction(event -> ToggleButtonGroupDemo.setAlignment(textPane, 0))).inToggleGroupAsSelected(justifyToggleGroup)).build();
            Command commandAlignCenter = ((Command.Builder)((Command.Builder)((Command.Builder)Command.builder().setIconFactory(Format_justify_center.factory())).setAction(event -> ToggleButtonGroupDemo.setAlignment(textPane, 1))).inToggleGroup(justifyToggleGroup)).build();
            Command commandAlignRight = ((Command.Builder)((Command.Builder)((Command.Builder)Command.builder().setIconFactory(Format_justify_right.factory())).setAction(event -> ToggleButtonGroupDemo.setAlignment(textPane, 2))).inToggleGroup(justifyToggleGroup)).build();
            Command commandAlignFill = ((Command.Builder)((Command.Builder)((Command.Builder)Command.builder().setIconFactory(Format_justify_fill.factory())).setAction(event -> ToggleButtonGroupDemo.setAlignment(textPane, 3))).inToggleGroup(justifyToggleGroup)).build();
            CommandStripProjection commandStripProjection = new CommandStripProjection(new CommandGroup(new Command[]{commandAlignLeft, commandAlignCenter, commandAlignRight, commandAlignFill}), CommandStripPresentationModel.builder().setOrientation(CommandStripPresentationModel.StripOrientation.VERTICAL).setHorizontalGapScaleFactor(0.8).setVerticalGapScaleFactor(1.4).build());
            JCommandButtonStrip commandButtonStrip = (JCommandButtonStrip)commandStripProjection.buildComponent();
            styleButtonPanel.add((Component)commandButtonStrip);
            frame.setIconImage(new BufferedImage(1, 1, 6));
            frame.setSize(new Dimension(600, 300));
            frame.setLocationRelativeTo(null);
            frame.setDefaultCloseOperation(3);
            frame.setVisible(true);
        });
    }
}

