/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.demo.flamingo.group;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.image.BufferedImage;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JTextPane;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.text.DefaultCaret;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import org.pushingpixels.demo.flamingo.svg.tango.transcoded.Format_text_bold;
import org.pushingpixels.demo.flamingo.svg.tango.transcoded.Format_text_italic;
import org.pushingpixels.demo.flamingo.svg.tango.transcoded.Format_text_strikethrough;
import org.pushingpixels.demo.flamingo.svg.tango.transcoded.Format_text_underline;
import org.pushingpixels.flamingo.api.common.JCommandButtonStrip;
import org.pushingpixels.flamingo.api.common.RichTooltip;
import org.pushingpixels.flamingo.api.common.model.Command;
import org.pushingpixels.flamingo.api.common.model.CommandGroup;
import org.pushingpixels.flamingo.api.common.model.CommandStripPresentationModel;
import org.pushingpixels.flamingo.api.common.projection.CommandStripProjection;
import org.pushingpixels.substance.api.SubstanceCortex;
import org.pushingpixels.substance.api.SubstanceSkin;
import org.pushingpixels.substance.api.skin.MarinerSkin;

public class ButtonGroupDemo {
    private static boolean hasStyleInSelection(JTextPane textPane, Object style) {
        for (int index = textPane.getSelectionStart(); index < textPane.getSelectionEnd(); ++index) {
            Object attr = textPane.getStyledDocument().getCharacterElement(index).getAttributes().getAttribute(style);
            if (!(attr instanceof Boolean) || !((Boolean)attr).booleanValue()) continue;
            return true;
        }
        return false;
    }

    private static void toggleStyleInSelection(JTextPane textPane, Object style) {
        SimpleAttributeSet attrSet = new SimpleAttributeSet();
        attrSet.addAttribute(style, !ButtonGroupDemo.hasStyleInSelection(textPane, style));
        textPane.getStyledDocument().setCharacterAttributes(textPane.getSelectionStart(), textPane.getSelectionEnd() - textPane.getSelectionStart(), attrSet, false);
    }

    public static void main(String ... args) {
        SwingUtilities.invokeLater(() -> {
            SubstanceCortex.GlobalScope.setSkin((SubstanceSkin)new MarinerSkin());
            JFrame frame = new JFrame("Text styling demo");
            frame.setLayout(new BorderLayout());
            JTextPane textPane = new JTextPane();
            textPane.setText("Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum.");
            textPane.setEditable(true);
            textPane.setBorder(new EmptyBorder(12, 12, 12, 12));
            textPane.setCaret(new DefaultCaret(){

                @Override
                public void setSelectionVisible(boolean visible) {
                    super.setSelectionVisible(true);
                }
            });
            frame.add((Component)textPane, "Center");
            JPanel styleButtonPanel = new JPanel(new FlowLayout());
            frame.add((Component)styleButtonPanel, "After");
            ResourceBundle resourceBundle = ResourceBundle.getBundle("org.pushingpixels.demo.flamingo.resource.Resources", Locale.getDefault());
            Command commandBold = ((Command.Builder)((Command.Builder)((Command.Builder)((Command.Builder)((Command.Builder)Command.builder().setIconFactory(Format_text_bold.factory())).setAction(event -> {
                ButtonGroupDemo.toggleStyleInSelection(textPane, StyleConstants.CharacterConstants.Bold);
                event.getCommand().setToggleSelected(ButtonGroupDemo.hasStyleInSelection(textPane, StyleConstants.CharacterConstants.Bold));
            })).setToggle()).setActionEnabled(false)).setActionRichTooltip(RichTooltip.builder().setTitle(resourceBundle.getString("FontBold.tooltip.textActionTitle")).addDescriptionSection(resourceBundle.getString("FontBold.tooltip.textActionParagraph1")).build())).build();
            Command commandItalic = ((Command.Builder)((Command.Builder)((Command.Builder)((Command.Builder)((Command.Builder)Command.builder().setIconFactory(Format_text_italic.factory())).setAction(event -> {
                ButtonGroupDemo.toggleStyleInSelection(textPane, StyleConstants.CharacterConstants.Italic);
                event.getCommand().setToggleSelected(ButtonGroupDemo.hasStyleInSelection(textPane, StyleConstants.CharacterConstants.Italic));
            })).setToggle()).setActionEnabled(false)).setActionRichTooltip(RichTooltip.builder().setTitle(resourceBundle.getString("FontItalic.tooltip.textActionTitle")).addDescriptionSection(resourceBundle.getString("FontItalic.tooltip.textActionParagraph1")).build())).build();
            Command commandUnderline = ((Command.Builder)((Command.Builder)((Command.Builder)((Command.Builder)((Command.Builder)Command.builder().setIconFactory(Format_text_underline.factory())).setAction(event -> {
                ButtonGroupDemo.toggleStyleInSelection(textPane, StyleConstants.CharacterConstants.Underline);
                event.getCommand().setToggleSelected(ButtonGroupDemo.hasStyleInSelection(textPane, StyleConstants.CharacterConstants.Underline));
            })).setToggle()).setActionEnabled(false)).setActionRichTooltip(RichTooltip.builder().setTitle(resourceBundle.getString("FontUnderline.tooltip.textActionTitle")).addDescriptionSection(resourceBundle.getString("FontUnderline.tooltip.textActionParagraph1")).build())).build();
            Command commandStrikethrough = ((Command.Builder)((Command.Builder)((Command.Builder)((Command.Builder)((Command.Builder)Command.builder().setIconFactory(Format_text_strikethrough.factory())).setAction(event -> {
                ButtonGroupDemo.toggleStyleInSelection(textPane, StyleConstants.CharacterConstants.StrikeThrough);
                event.getCommand().setToggleSelected(ButtonGroupDemo.hasStyleInSelection(textPane, StyleConstants.CharacterConstants.StrikeThrough));
            })).setToggle()).setActionEnabled(false)).setActionRichTooltip(RichTooltip.builder().setTitle(resourceBundle.getString("FontStrikethrough.tooltip.textActionTitle")).addDescriptionSection(resourceBundle.getString("FontStrikethrough.tooltip.textActionParagraph1")).build())).build();
            textPane.addCaretListener(e -> {
                boolean hasSelection = textPane.getSelectionEnd() - textPane.getSelectionStart() > 0;
                commandBold.setActionEnabled(hasSelection);
                commandItalic.setActionEnabled(hasSelection);
                commandUnderline.setActionEnabled(hasSelection);
                commandStrikethrough.setActionEnabled(hasSelection);
                commandBold.setToggleSelected(ButtonGroupDemo.hasStyleInSelection(textPane, StyleConstants.CharacterConstants.Bold));
                commandItalic.setToggleSelected(ButtonGroupDemo.hasStyleInSelection(textPane, StyleConstants.CharacterConstants.Italic));
                commandUnderline.setToggleSelected(ButtonGroupDemo.hasStyleInSelection(textPane, StyleConstants.CharacterConstants.Underline));
                commandStrikethrough.setToggleSelected(ButtonGroupDemo.hasStyleInSelection(textPane, StyleConstants.CharacterConstants.StrikeThrough));
            });
            CommandStripProjection commandStripProjection = new CommandStripProjection(new CommandGroup(new Command[]{commandBold, commandItalic, commandUnderline, commandStrikethrough}), CommandStripPresentationModel.builder().setOrientation(CommandStripPresentationModel.StripOrientation.VERTICAL).setHorizontalGapScaleFactor(0.8).setVerticalGapScaleFactor(1.4).build());
            JCommandButtonStrip commandButtonStrip = (JCommandButtonStrip)commandStripProjection.buildComponent();
            styleButtonPanel.add((Component)commandButtonStrip);
            frame.setIconImage(new BufferedImage(1, 1, 6));
            frame.setSize(new Dimension(600, 300));
            frame.setLocationRelativeTo(null);
            frame.setDefaultCloseOperation(3);
            frame.setVisible(true);
        });
    }
}

