/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.demo.flamingo.common;

import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.FlowLayout;
import java.awt.Window;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import org.pushingpixels.demo.flamingo.LocaleSwitcher;
import org.pushingpixels.demo.flamingo.common.QuickStylesPanel;
import org.pushingpixels.demo.flamingo.svg.logo.RadianceLogo;
import org.pushingpixels.flamingo.api.common.model.CommandPanelContentModel;
import org.pushingpixels.flamingo.api.common.model.CommandPanelPresentationModel;
import org.pushingpixels.flamingo.api.common.projection.CommandPanelProjection;
import org.pushingpixels.substance.api.ComponentState;
import org.pushingpixels.substance.api.SubstanceCortex;
import org.pushingpixels.substance.api.SubstanceSkin;
import org.pushingpixels.substance.api.SubstanceSlices;
import org.pushingpixels.substance.api.skin.BusinessSkin;

public class TestCommandButtonPanel
extends JFrame {
    private ResourceBundle resourceBundle;
    private Locale currLocale;
    private JScrollPane scroller;
    private CommandPanelContentModel panelContentModel;
    private CommandPanelPresentationModel panelPresentationModel;

    private TestCommandButtonPanel() {
        super("Command button panel test");
        this.setIconImage(RadianceLogo.getLogoImage(SubstanceCortex.GlobalScope.getCurrentSkin().getColorScheme(SubstanceSlices.DecorationAreaType.PRIMARY_TITLE_PANE, SubstanceSlices.ColorSchemeAssociationKind.FILL, ComponentState.ENABLED)));
        this.currLocale = Locale.getDefault();
        this.resourceBundle = ResourceBundle.getBundle("org.pushingpixels.demo.flamingo.resource.Resources", this.currLocale);
        this.panelContentModel = QuickStylesPanel.getQuickStylesContentModel(this.resourceBundle, this.currLocale);
        this.panelPresentationModel = QuickStylesPanel.getQuickStylesPresentationModel();
        JComponent buttonPanel = new CommandPanelProjection(this.panelContentModel, this.panelPresentationModel).buildComponent();
        this.scroller = new JScrollPane(buttonPanel);
        this.add((Component)this.scroller, "Center");
        JPanel controlPanel = new JPanel(new FlowLayout(2));
        JCheckBox toShowGroupLabels = new JCheckBox("show group labels");
        toShowGroupLabels.setSelected(this.panelPresentationModel.isToShowGroupLabels());
        toShowGroupLabels.addActionListener(e -> {
            this.panelPresentationModel.setToShowGroupLabels(toShowGroupLabels.isSelected());
            this.scroller.revalidate();
        });
        controlPanel.add(toShowGroupLabels);
        JCheckBox isRowFillLayout = new JCheckBox("use row fill layout");
        isRowFillLayout.setSelected(this.panelPresentationModel.getLayoutKind() == CommandPanelPresentationModel.LayoutKind.ROW_FILL);
        isRowFillLayout.addActionListener(e -> this.panelPresentationModel.setLayoutKind(isRowFillLayout.isSelected() ? CommandPanelPresentationModel.LayoutKind.ROW_FILL : CommandPanelPresentationModel.LayoutKind.COLUMN_FILL));
        controlPanel.add(isRowFillLayout);
        JComboBox<LocaleSwitcher.LocaleInfo> localeSwitcher = LocaleSwitcher.getLocaleSwitcher(selected -> {
            this.currLocale = selected;
            this.resourceBundle = ResourceBundle.getBundle("org.pushingpixels.demo.flamingo.resource.Resources", this.currLocale);
            QuickStylesPanel.updatePanelContentModel(this.panelContentModel, this.resourceBundle, this.currLocale);
            Window window = SwingUtilities.getWindowAncestor(buttonPanel);
            window.applyComponentOrientation(ComponentOrientation.getOrientation(this.currLocale));
            SwingUtilities.updateComponentTreeUI(window);
        });
        controlPanel.add(localeSwitcher);
        this.add((Component)controlPanel, "South");
        this.setSize(500, 300);
        this.setDefaultCloseOperation(3);
        this.setLocationRelativeTo(null);
    }

    public static void main(String[] args) {
        SwingUtilities.invokeLater(() -> {
            JFrame.setDefaultLookAndFeelDecorated(true);
            SubstanceCortex.GlobalScope.setSkin((SubstanceSkin)new BusinessSkin());
            new TestCommandButtonPanel().setVisible(true);
        });
    }
}

