/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.demo.flamingo.common;

import com.jgoodies.forms.builder.FormBuilder;
import com.jgoodies.forms.factories.Paddings;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.FlowLayout;
import java.awt.Window;
import java.util.Locale;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import org.pushingpixels.demo.flamingo.LocaleSwitcher;
import org.pushingpixels.demo.flamingo.svg.logo.RadianceLogo;
import org.pushingpixels.demo.flamingo.svg.tango.transcoded.Format_justify_center;
import org.pushingpixels.demo.flamingo.svg.tango.transcoded.Format_justify_left;
import org.pushingpixels.demo.flamingo.svg.tango.transcoded.Format_justify_right;
import org.pushingpixels.demo.flamingo.svg.tango.transcoded.Format_text_bold;
import org.pushingpixels.demo.flamingo.svg.tango.transcoded.Format_text_italic;
import org.pushingpixels.demo.flamingo.svg.tango.transcoded.Format_text_strikethrough;
import org.pushingpixels.demo.flamingo.svg.tango.transcoded.Format_text_underline;
import org.pushingpixels.flamingo.api.common.CommandButtonPresentationState;
import org.pushingpixels.flamingo.api.common.model.Command;
import org.pushingpixels.flamingo.api.common.model.CommandGroup;
import org.pushingpixels.flamingo.api.common.model.CommandStripPresentationModel;
import org.pushingpixels.flamingo.api.common.projection.CommandStripProjection;
import org.pushingpixels.substance.api.ComponentState;
import org.pushingpixels.substance.api.SubstanceCortex;
import org.pushingpixels.substance.api.SubstanceSkin;
import org.pushingpixels.substance.api.SubstanceSlices;
import org.pushingpixels.substance.api.skin.BusinessSkin;

public class TestButtonStripVertical
extends JFrame {
    private Locale currLocale;
    private JPanel buttonPanel;

    private TestButtonStripVertical() {
        super("Tests for vertical buttons strips");
        this.setIconImage(RadianceLogo.getLogoImage(SubstanceCortex.GlobalScope.getCurrentSkin().getColorScheme(SubstanceSlices.DecorationAreaType.PRIMARY_TITLE_PANE, SubstanceSlices.ColorSchemeAssociationKind.FILL, ComponentState.ENABLED)));
        this.buttonPanel = this.getButtonPanel();
        this.add((Component)this.buttonPanel, "Center");
        JPanel controlPanel = new JPanel(new FlowLayout(1));
        JComboBox<LocaleSwitcher.LocaleInfo> localeSwitcher = LocaleSwitcher.getLocaleSwitcher(selected -> {
            this.currLocale = selected;
            this.remove(this.buttonPanel);
            this.buttonPanel = this.getButtonPanel();
            this.add((Component)this.buttonPanel, "Center");
            Window window = SwingUtilities.getWindowAncestor(this.buttonPanel);
            window.applyComponentOrientation(ComponentOrientation.getOrientation(this.currLocale));
            SwingUtilities.updateComponentTreeUI(window);
        });
        controlPanel.add(localeSwitcher);
        this.add((Component)controlPanel, "South");
        this.pack();
        this.setLocationRelativeTo(null);
        this.setDefaultCloseOperation(2);
    }

    private JPanel getButtonPanel() {
        FormBuilder builder = FormBuilder.create().columns("center:pref, 4dlu, center:pref, 4dlu, center:pref, 4dlu, center:pref, 4dlu, center:pref, 4dlu, center:pref", new Object[0]).rows("p, $lg, p, $lg, p", new Object[0]).padding((EmptyBorder)Paddings.DIALOG);
        builder.add("h1.0-v0.5", new Object[0]).xy(1, 1);
        builder.add("h1.0-v0.75", new Object[0]).xy(3, 1);
        builder.add("h1.0-v1.0", new Object[0]).xy(5, 1);
        builder.add("h0.5-v0.75", new Object[0]).xy(7, 1);
        builder.add("h0.75-v0.75", new Object[0]).xy(9, 1);
        builder.add("h1.0-v0.75", new Object[0]).xy(11, 1);
        builder.add((Component)this.getStrip1(1.0, 0.5)).xy(1, 3).add((Component)this.getStrip1(1.0, 0.75)).xy(3, 3).add((Component)this.getStrip1(1.0, 1.0)).xy(5, 3);
        builder.add((Component)this.getStrip1(0.5, 0.75)).xy(7, 3).add((Component)this.getStrip1(0.75, 0.75)).xy(9, 3).add((Component)this.getStrip1(1.0, 0.75)).xy(11, 3);
        builder.add((Component)this.getStrip2(1.0, 0.5)).xy(1, 5).add((Component)this.getStrip2(1.0, 0.75)).xy(3, 5).add((Component)this.getStrip2(1.0, 1.0)).xy(5, 5);
        builder.add((Component)this.getStrip2(0.5, 0.75)).xy(7, 5).add((Component)this.getStrip2(0.75, 0.75)).xy(9, 5).add((Component)this.getStrip2(1.0, 0.75)).xy(11, 5);
        return builder.build();
    }

    private JComponent getStrip1(double hgapScaleFactor, double vgapScaleFactor) {
        return new CommandStripProjection(new CommandGroup(new Command[]{((Command.Builder)Command.builder().setIconFactory(Format_justify_left.factory())).build(), ((Command.Builder)Command.builder().setIconFactory(Format_justify_center.factory())).build(), ((Command.Builder)Command.builder().setIconFactory(Format_justify_right.factory())).build()}), CommandStripPresentationModel.builder().setCommandPresentationState(CommandButtonPresentationState.SMALL).setOrientation(CommandStripPresentationModel.StripOrientation.VERTICAL).setHorizontalGapScaleFactor(hgapScaleFactor).setVerticalGapScaleFactor(vgapScaleFactor).build()).buildComponent();
    }

    private JComponent getStrip2(double hgapScaleFactor, double vgapScaleFactor) {
        return new CommandStripProjection(new CommandGroup(new Command[]{((Command.Builder)Command.builder().setIconFactory(Format_text_bold.factory())).build(), ((Command.Builder)Command.builder().setIconFactory(Format_text_italic.factory())).build(), ((Command.Builder)Command.builder().setIconFactory(Format_text_underline.factory())).build(), ((Command.Builder)Command.builder().setIconFactory(Format_text_strikethrough.factory())).build()}), CommandStripPresentationModel.builder().setCommandPresentationState(CommandButtonPresentationState.SMALL).setOrientation(CommandStripPresentationModel.StripOrientation.VERTICAL).setHorizontalGapScaleFactor(hgapScaleFactor).setVerticalGapScaleFactor(vgapScaleFactor).build()).buildComponent();
    }

    public static void main(String[] args) {
        SwingUtilities.invokeLater(() -> {
            JFrame.setDefaultLookAndFeelDecorated(true);
            SubstanceCortex.GlobalScope.setSkin((SubstanceSkin)new BusinessSkin());
            new TestButtonStripVertical().setVisible(true);
        });
    }
}

