/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.demo.flamingo.bcb;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.io.File;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import org.pushingpixels.demo.flamingo.ExplorerFileViewPanel;
import org.pushingpixels.demo.flamingo.svg.logo.RadianceLogo;
import org.pushingpixels.flamingo.api.bcb.BreadcrumbItem;
import org.pushingpixels.flamingo.api.bcb.core.BreadcrumbFileSelector;
import org.pushingpixels.flamingo.api.common.CommandButtonPresentationState;
import org.pushingpixels.flamingo.api.common.StringValuePair;
import org.pushingpixels.substance.api.ComponentState;
import org.pushingpixels.substance.api.SubstanceCortex;
import org.pushingpixels.substance.api.SubstanceSkin;
import org.pushingpixels.substance.api.SubstanceSlices;
import org.pushingpixels.substance.api.skin.BusinessSkin;

public class BreadCrumbTest
extends JFrame {
    protected BreadcrumbFileSelector bar = new BreadcrumbFileSelector();
    private ExplorerFileViewPanel<File> filePanel;

    private BreadCrumbTest() {
        super("BreadCrumb test");
        this.bar.getModel().addPathListener(event -> SwingUtilities.invokeLater(() -> {
            final List newPath = event.getSource().getItems();
            System.out.println("New path is ");
            for (BreadcrumbItem item : newPath) {
                System.out.println("\t" + ((File)item.getData()).getAbsolutePath());
            }
            if (newPath.size() > 0) {
                SwingWorker<List<StringValuePair<File>>, Void> worker = new SwingWorker<List<StringValuePair<File>>, Void>(){

                    @Override
                    protected List<StringValuePair<File>> doInBackground() {
                        return BreadCrumbTest.this.bar.getCallback().getLeafs(newPath);
                    }

                    @Override
                    protected void done() {
                        try {
                            List leafs = (List)this.get();
                            BreadCrumbTest.this.filePanel.setFolder(leafs);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                };
                worker.execute();
            }
        }));
        this.setLayout(new BorderLayout());
        SubstanceCortex.ComponentOrParentChainScope.setDecorationType((JComponent)this.bar, (SubstanceSlices.DecorationAreaType)SubstanceSlices.DecorationAreaType.HEADER);
        this.add((Component)this.bar, "North");
        this.filePanel = new ExplorerFileViewPanel(this.bar, CommandButtonPresentationState.MEDIUM);
        JScrollPane fileListScrollPane = new JScrollPane((Component)((Object)this.filePanel));
        this.add((Component)fileListScrollPane, "Center");
        JPanel controls = new JPanel(new FlowLayout(2));
        JButton setPath = new JButton("Select and set path...");
        setPath.addActionListener(e -> SwingUtilities.invokeLater(() -> {
            JFileChooser folderChooser = new JFileChooser();
            folderChooser.setFileSelectionMode(1);
            if (folderChooser.showOpenDialog(this) == 0) {
                File selected = folderChooser.getSelectedFile();
                this.bar.setPath(selected);
            }
        }));
        controls.add(setPath);
        this.add((Component)controls, "South");
    }

    public static void main(String ... args) {
        SwingUtilities.invokeLater(() -> {
            JFrame.setDefaultLookAndFeelDecorated(true);
            SubstanceCortex.GlobalScope.setSkin((SubstanceSkin)new BusinessSkin());
            BreadCrumbTest test = new BreadCrumbTest();
            test.setIconImage(RadianceLogo.getLogoImage(SubstanceCortex.GlobalScope.getCurrentSkin().getColorScheme(SubstanceSlices.DecorationAreaType.PRIMARY_TITLE_PANE, SubstanceSlices.ColorSchemeAssociationKind.FILL, ComponentState.ENABLED)));
            test.setSize(550, 385);
            test.setLocationRelativeTo(null);
            test.setVisible(true);
            test.setDefaultCloseOperation(3);
        });
    }
}

