/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.demo.flamingo;

import java.util.Locale;
import javax.swing.JComboBox;
import javax.swing.SwingUtilities;

public class LocaleSwitcher {
    public static JComboBox<LocaleInfo> getLocaleSwitcher(LocaleCallback callback) {
        LocaleInfo[] locales = new LocaleInfo[]{new LocaleInfo(new Locale("en", "US"), "English"), new LocaleInfo(new Locale("iw", "IL"), "Hebrew")};
        JComboBox<LocaleInfo> result = new JComboBox<LocaleInfo>(locales);
        result.setSelectedIndex(0);
        result.addActionListener(e -> SwingUtilities.invokeLater(() -> {
            LocaleInfo selected = (LocaleInfo)result.getSelectedItem();
            callback.onLocaleSelected(selected.locale);
        }));
        return result;
    }

    public static interface LocaleCallback {
        public void onLocaleSelected(Locale var1);
    }

    public static class LocaleInfo {
        Locale locale;
        String displayName;

        public LocaleInfo(Locale locale, String displayName) {
            this.locale = locale;
            this.displayName = displayName;
        }

        public String toString() {
            return this.displayName;
        }
    }
}

