/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.demo.flamingo;

import java.awt.Dimension;
import java.io.File;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.filechooser.FileSystemView;
import org.pushingpixels.demo.flamingo.IconWrapperResizableIcon;
import org.pushingpixels.flamingo.api.bcb.JBreadcrumbBar;
import org.pushingpixels.flamingo.api.common.AbstractFileViewPanel;
import org.pushingpixels.flamingo.api.common.CommandButtonPresentationState;
import org.pushingpixels.flamingo.api.common.StringValuePair;
import org.pushingpixels.flamingo.api.common.icon.IcoWrapperResizableIcon;
import org.pushingpixels.flamingo.api.common.icon.ImageWrapperResizableIcon;
import org.pushingpixels.flamingo.api.common.model.Command;
import org.pushingpixels.neon.api.icon.ResizableIcon;
import org.pushingpixels.photon.api.icon.SvgBatikResizableIcon;

public class ExplorerFileViewPanel<T>
extends AbstractFileViewPanel<T> {
    private JBreadcrumbBar<T> bar;
    private static Map<String, ResizableIcon> iconMapping = new HashMap<String, ResizableIcon>();
    private boolean useNativeIcons;

    public ExplorerFileViewPanel(JBreadcrumbBar<T> bar, CommandButtonPresentationState startingState) {
        super(startingState);
        this.bar = bar;
        this.useNativeIcons = false;
    }

    public void setUseNativeIcons(boolean useNativeIcons) {
        this.useNativeIcons = useNativeIcons;
    }

    protected boolean toShowFile(StringValuePair<T> pair) {
        return true;
    }

    protected ResizableIcon getResizableIcon(AbstractFileViewPanel.Leaf leaf, InputStream stream, CommandButtonPresentationState state, Dimension dimension) {
        int prefSize = state.getPreferredIconSize();
        if (prefSize > 0) {
            dimension = new Dimension(prefSize, prefSize);
        }
        if (this.useNativeIcons) {
            Icon delegate;
            Object sourceProp = leaf.getLeafProp("source");
            if (sourceProp instanceof File && (delegate = FileSystemView.getFileSystemView().getSystemIcon((File)sourceProp)) != null) {
                return new IconWrapperResizableIcon(delegate);
            }
            return null;
        }
        String name = leaf.getLeafName();
        int lastPointIndex = name.lastIndexOf(46);
        String ext = "*";
        if (lastPointIndex >= 0) {
            ext = name.substring(lastPointIndex + 1);
        }
        if ((ext = ext.toLowerCase()).compareTo("jpg") == 0 || ext.compareTo("jpeg") == 0 || ext.compareTo("gif") == 0 || ext.compareTo("png") == 0 || ext.compareTo("bmp") == 0) {
            return ImageWrapperResizableIcon.getIcon((InputStream)stream, (Dimension)dimension);
        }
        if (ext.compareTo("svg") == 0) {
            return SvgBatikResizableIcon.getSvgIcon((InputStream)stream, (Dimension)dimension);
        }
        if (ext.compareTo("svgz") == 0) {
            return SvgBatikResizableIcon.getSvgzIcon((InputStream)stream, (Dimension)dimension);
        }
        if (ext.compareTo("ico") == 0) {
            return IcoWrapperResizableIcon.getIcon((InputStream)stream, (Dimension)dimension);
        }
        ResizableIcon icon = iconMapping.get(ext);
        if (icon == null) {
            try {
                String className = "org.pushingpixels.demo.flamingo.svg.filetypes.transcoded.ext_" + ext;
                Class<?> transcodedClass = Class.forName(className);
                if (transcodedClass != null) {
                    Method of = transcodedClass.getDeclaredMethod("of", Integer.TYPE, Integer.TYPE);
                    icon = (ResizableIcon)of.invoke(null, prefSize, prefSize);
                    iconMapping.put(ext, icon);
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return icon;
    }

    protected void configureCommand(AbstractFileViewPanel.Leaf leaf, Command command, ResizableIcon icon) {
        String filename = leaf.getLeafName();
        String ext = "Generic";
        int lastDot = filename.lastIndexOf(46);
        if (lastDot >= 0) {
            ext = filename.substring(lastDot + 1).toUpperCase();
        }
        command.setExtraText(ext + " file");
    }

    protected InputStream getLeafContent(T leaf) {
        return this.bar.getCallback().getLeafContent(leaf);
    }
}

