/*
 * Decompiled with CFR 0.152.
 */
package javax.wbem.cim;

class StringUtil {
    private StringUtil() {
    }

    public static String quote(String inp) {
        StringBuffer sb = new StringBuffer(inp.length());
        sb.append('\"');
        sb.append(StringUtil.escape(inp));
        sb.append('\"');
        return sb.toString();
    }

    public static String escape(String str) {
        int size = str.length();
        StringBuffer sb = new StringBuffer(size);
        block11: for (int i = 0; i < size; ++i) {
            char ch = str.charAt(i);
            switch (ch) {
                case '\u0000': {
                    continue block11;
                }
                case '\n': {
                    sb.append("\\n");
                    continue block11;
                }
                case '\t': {
                    sb.append("\\t");
                    continue block11;
                }
                case '\b': {
                    sb.append("\\b");
                    continue block11;
                }
                case '\r': {
                    sb.append("\\r");
                    continue block11;
                }
                case '\f': {
                    sb.append("\\f");
                    continue block11;
                }
                case '\\': {
                    sb.append("\\\\");
                    continue block11;
                }
                case '\'': {
                    sb.append("\\'");
                    continue block11;
                }
                case '\"': {
                    sb.append("\\\"");
                    continue block11;
                }
                default: {
                    ch = str.charAt(i);
                    if (ch < ' ' || ch > '~') {
                        String s = Integer.toString(ch, 16);
                        sb.append("\\x" + "0000".substring(s.length() - 4) + s);
                        continue block11;
                    }
                    sb.append(ch);
                }
            }
        }
        return sb.toString();
    }

    public static String unescapeString(String inp) {
        StringBuffer sb = new StringBuffer();
        int size = inp.length();
        block9: for (int i = 0; i < size; ++i) {
            char ch = inp.charAt(i);
            if (ch == '\\') {
                if (++i >= size) {
                    throw new IllegalArgumentException("String ended with an escape, but there was no subsequent character to escape");
                }
                ch = inp.charAt(i);
                switch (ch) {
                    case 'n': {
                        sb.append('\n');
                        continue block9;
                    }
                    case 't': {
                        sb.append('\t');
                        continue block9;
                    }
                    case 'b': {
                        sb.append('\b');
                        continue block9;
                    }
                    case 'r': {
                        sb.append('\r');
                        continue block9;
                    }
                    case 'f': {
                        sb.append('\f');
                        continue block9;
                    }
                    case '\"': 
                    case '\'': 
                    case '\\': {
                        sb.append(ch);
                        continue block9;
                    }
                    case 'X': 
                    case 'x': {
                        sb.append("\\x");
                        continue block9;
                    }
                    default: {
                        throw new IllegalArgumentException("Invalid escape sequence '" + ch + "' (valid sequences are  \\b  \\t  \\n  \\f  \\r  \\\"  \\'  \\\\ \\x0000 \\X0000 )");
                    }
                }
            }
            sb.append(ch);
        }
        return sb.toString();
    }

    public static String unquote(String value) {
        if (value.startsWith("\"")) {
            if (value.endsWith("\"")) {
                value = StringUtil.unescapeString(value.substring(1, value.length() - 1));
            } else {
                throw new IllegalArgumentException("String literal " + value + " is not properly closed by a double quote.");
            }
        }
        return value;
    }
}

