/*
 * Decompiled with CFR 0.152.
 */
package org.openide.text;

import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;
import javax.swing.text.Position;
import org.openide.util.WeakListeners;

class BackwardPosition
implements Position,
DocumentListener {
    private int offset;

    private BackwardPosition(int offset) {
        this.offset = offset;
    }

    public static Position create(Document doc, int offset) {
        BackwardPosition p = new BackwardPosition(offset);
        doc.addDocumentListener(WeakListeners.document(p, doc));
        return p;
    }

    public int getOffset() {
        return this.offset;
    }

    public void insertUpdate(DocumentEvent e) {
        if (e.getOffset() < this.offset) {
            this.offset += e.getLength();
        }
    }

    public void removeUpdate(DocumentEvent e) {
        int o = e.getOffset();
        if (o < this.offset) {
            this.offset -= e.getLength();
            if (this.offset < o) {
                this.offset = o;
            }
        }
    }

    public void changedUpdate(DocumentEvent e) {
    }
}

