/*
 * Decompiled with CFR 0.152.
 */
package org.openide.nodes;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.JPopupMenu;
import org.openide.ErrorManager;
import org.openide.nodes.FilterNode;
import org.openide.nodes.Node;
import org.openide.nodes.NodeListener;
import org.openide.nodes.NodeNotFoundException;
import org.openide.util.Enumerations;
import org.openide.util.Lookup;
import org.openide.util.Utilities;
import org.openide.util.WeakListeners;
import org.openide.util.actions.SystemAction;
import org.openide.util.lookup.Lookups;
import org.openide.util.lookup.ProxyLookup;

public final class NodeOp {
    private static SystemAction[] defaultActions;

    private NodeOp() {
    }

    public static SystemAction[] getDefaultActions() {
        if (defaultActions == null) {
            defaultActions = NodeOp.createFromNames(new String[]{"Tools", "Properties"});
        }
        return defaultActions;
    }

    public static void setDefaultActions(SystemAction[] def) {
        throw new SecurityException();
    }

    public static JPopupMenu findContextMenu(Node[] nodes) {
        return NodeOp.findContextMenuImpl(nodes, null);
    }

    static JPopupMenu findContextMenuImpl(Node[] nodes, ActionMap actionMap) {
        Action[] arr = NodeOp.findActions(nodes);
        ArrayList<Lookup> allLookups = new ArrayList<Lookup>();
        for (int i = 0; i < nodes.length; ++i) {
            allLookups.add(nodes[i].getLookup());
        }
        if (actionMap != null) {
            allLookups.add(Lookups.singleton(actionMap));
        }
        ProxyLookup lookup = new ProxyLookup(allLookups.toArray(new Lookup[allLookups.size()]));
        return Utilities.actionsToPopup(arr, lookup);
    }

    public static Action[] findActions(Node[] nodes) {
        int i;
        HashSet<Action> counted;
        HashMap<Action, Integer> actions = new HashMap<Action, Integer>();
        Action[][] actionsByNode = new Action[nodes.length][];
        for (int n = 0; n < nodes.length; ++n) {
            actionsByNode[n] = nodes[n].getActions(false);
            if (actionsByNode[n] == null) {
                actionsByNode[n] = defaultActions;
            }
            counted = new HashSet();
            for (i = 0; i < actionsByNode[n].length; ++i) {
                if (actionsByNode[n][i] == null || counted.contains(actionsByNode[n][i])) continue;
                counted.add(actionsByNode[n][i]);
                Integer cntInt = (Integer)actions.get(actionsByNode[n][i]);
                int cnt = cntInt == null ? 0 : cntInt;
                actions.put(actionsByNode[n][i], new Integer(cnt + 1));
            }
        }
        if (!actions.isEmpty()) {
            ArrayList<Action> result = new ArrayList<Action>();
            counted = new HashSet<Action>();
            for (i = 0; i < actionsByNode[0].length; ++i) {
                Action action = actionsByNode[0][i];
                if (action != null) {
                    int cnt;
                    if (counted.contains(action)) continue;
                    counted.add(action);
                    Integer cntInt = (Integer)actions.get(action);
                    int n = cnt = cntInt == null ? 0 : cntInt;
                    if (cnt != nodes.length) continue;
                    result.add(action);
                    continue;
                }
                result.add(null);
            }
            return result.toArray(new Action[result.size()]);
        }
        return new Action[0];
    }

    public static boolean isSon(Node parent, Node son) {
        return son.getParentNode() == parent;
    }

    public static String[] createPath(Node node, Node parent) {
        LinkedList<String> ar = new LinkedList<String>();
        while (node != null && node != parent) {
            if (node.getName() == null) {
                boolean isFilter = false;
                if (node instanceof FilterNode) {
                    isFilter = true;
                }
                throw new IllegalArgumentException("Node:" + node.getClass() + "[" + node.getDisplayName() + "]" + (isFilter ? " of original:" + ((FilterNode)node).getOriginal().getClass() : "") + " gets null name!");
            }
            ar.addFirst(node.getName());
            node = node.getParentNode();
        }
        String[] res = new String[ar.size()];
        ar.toArray(res);
        return res;
    }

    public static Node findChild(Node node, String name) {
        return node.getChildren().findChild(name);
    }

    public static Node findPath(Node start, Enumeration names) throws NodeNotFoundException {
        int depth = 0;
        while (names.hasMoreElements()) {
            String name = (String)names.nextElement();
            Node next = NodeOp.findChild(start, name);
            if (next == null) {
                throw new NodeNotFoundException(start, name, depth);
            }
            start = next;
            ++depth;
        }
        return start;
    }

    public static Node findPath(Node start, String[] names) throws NodeNotFoundException {
        return NodeOp.findPath(start, Enumerations.array(names));
    }

    public static Node findRoot(Node node) {
        Node parent;
        while ((parent = node.getParentNode()) != null) {
            node = parent;
        }
        return node;
    }

    public static int[] computePermutation(Node[] arr1, Node[] arr2) throws IllegalArgumentException {
        if (arr1.length != arr2.length) {
            int max = Math.max(arr1.length, arr2.length);
            StringBuffer sb = new StringBuffer();
            for (int i = 0; i < max; ++i) {
                sb.append(i + " ");
                if (i < arr1.length) {
                    sb.append(arr1[i].getName());
                } else {
                    sb.append("---");
                }
                sb.append(" = ");
                if (i < arr2.length) {
                    sb.append(arr2[i].getName());
                } else {
                    sb.append("---");
                }
                sb.append('\n');
            }
            throw new IllegalArgumentException(sb.toString());
        }
        HashMap<Node, Integer> map = new HashMap<Node, Integer>();
        for (int i = 0; i < arr2.length; ++i) {
            map.put(arr2[i], new Integer(i));
        }
        int[] perm = new int[arr1.length];
        int diff = 0;
        for (int i = 0; i < arr1.length; ++i) {
            Integer newPos = (Integer)map.get(arr1[i]);
            if (newPos == null) {
                throw new IllegalArgumentException("Missing permutation index " + i);
            }
            perm[i] = newPos;
            if (perm[i] == i) continue;
            ++diff;
        }
        return diff == 0 ? null : perm;
    }

    public static Node.Handle[] toHandles(Node[] nodes) {
        LinkedList<Node.Handle> ll = new LinkedList<Node.Handle>();
        for (int i = 0; i < nodes.length; ++i) {
            Node.Handle h = nodes[i].getHandle();
            if (h == null) continue;
            ll.add(h);
        }
        return ll.toArray(new Node.Handle[ll.size()]);
    }

    public static Node[] fromHandles(Node.Handle[] handles) throws IOException {
        Node[] arr = new Node[handles.length];
        for (int i = 0; i < handles.length; ++i) {
            arr[i] = handles[i].getNode();
        }
        return arr;
    }

    public static NodeListener weakNodeListener(NodeListener l, Object source) {
        return (NodeListener)WeakListeners.create(NodeListener.class, l, source);
    }

    static SystemAction[] createFromNames(String[] arr) {
        ErrorManager err = (ErrorManager)Lookup.getDefault().lookup(ErrorManager.class);
        LinkedList<SystemAction> ll = new LinkedList<SystemAction>();
        for (int i = 0; i < arr.length; ++i) {
            if (arr[i] == null) {
                ll.add(null);
                continue;
            }
            String name = "org.openide.actions." + arr[i] + "Action";
            try {
                Class<?> c = Class.forName(name);
                ll.add(SystemAction.get(c));
                continue;
            }
            catch (ClassNotFoundException ex) {
                if (err == null) continue;
                err.log(1, "NodeOp.java: Missing class " + name);
            }
        }
        return ll.toArray(new SystemAction[ll.size()]);
    }

    static void exception(Throwable ex) {
        ErrorManager.getDefault().notify(1, ex);
    }

    static void warning(Throwable ex) {
        ErrorManager.getDefault().notify(16, ex);
    }
}

