/*
 * Decompiled with CFR 0.152.
 */
package org.openide.filesystems;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.openide.filesystems.ExternalUtil;
import org.openide.filesystems.FileAttributeEvent;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileRenameEvent;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.ListenerList;
import org.openide.filesystems.MultiFileObject;
import org.openide.filesystems.Repository;
import org.openide.filesystems.URLMapper;
import org.openide.util.Enumerations;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

abstract class AbstractFolder
extends FileObject {
    private static final AbstractFolder[] EMPTY_ARRAY = new AbstractFolder[0];
    private static final char EXT_SEP = '.';
    private static final HashMap EMPTY = new HashMap(0);
    private FileSystem system;
    protected String name;
    protected final AbstractFolder parent;
    boolean validFlag;
    private final AbstractFolder validRoot;
    private String[] children;
    private HashMap map;
    private ListenerList listeners;
    static /* synthetic */ Class class$org$openide$filesystems$AbstractFolder;

    public AbstractFolder(FileSystem fs, AbstractFolder parent, String name) {
        this.system = fs;
        this.parent = parent;
        this.name = name;
        this.validFlag = true;
        this.validRoot = parent != null ? (AbstractFolder)fs.getRoot() : null;
    }

    public final String getName() {
        int i = this.name.lastIndexOf(46);
        return i <= 0 ? this.name : this.name.substring(0, i);
    }

    public final String getExt() {
        int i = this.name.lastIndexOf(46) + 1;
        return i <= 1 || i == this.name.length() ? "" : this.name.substring(i);
    }

    public final String getNameExt() {
        return this.name;
    }

    final boolean isHasExtOverride() {
        return true;
    }

    boolean hasExtOverride(String ext) {
        if (ext == null) {
            return false;
        }
        if (this.name.length() - ext.length() <= 1) {
            return false;
        }
        boolean ret = this.name.endsWith(ext);
        if (!ret) {
            return false;
        }
        return this.name.charAt(this.name.length() - ext.length() - 1) == '.';
    }

    public final FileSystem getFileSystem() {
        return this.system;
    }

    public final boolean isRoot() {
        return this.parent == null;
    }

    public final boolean isValid() {
        if (this.parent == null) {
            return this.validFlag;
        }
        boolean isValidRoot = this.getFileSystem().getRoot() == this.validRoot;
        return this.validFlag && isValidRoot;
    }

    public final FileObject getParent() {
        return this.parent;
    }

    public final synchronized FileObject[] getChildren() {
        this.check();
        if (this.children == null) {
            return new FileObject[0];
        }
        int size = this.children.length;
        ArrayList<AbstractFolder> aList = new ArrayList<AbstractFolder>();
        for (int i = 0; i < size; ++i) {
            AbstractFolder f = this.getChild(this.children[i]);
            if (f == null) continue;
            aList.add(f);
        }
        return aList.toArray(new FileObject[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final FileObject find(Enumeration en) {
        AbstractFolder fo;
        for (fo = this; fo != null && en.hasMoreElements(); fo = fo.getChild((String)en.nextElement())) {
            AbstractFolder abstractFolder = fo;
            synchronized (abstractFolder) {
                fo.check();
                continue;
            }
        }
        return fo;
    }

    final FileObject findIfExists(Enumeration en) {
        Reference r = this.findRefIfExists(en);
        return r == null ? null : (FileObject)r.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final Reference findRefIfExists(Enumeration en) {
        String name;
        for (AbstractFolder fo = this; fo != null && en.hasMoreElements(); fo = fo.getChild(name)) {
            if (fo.map == null) {
                return null;
            }
            AbstractFolder abstractFolder = fo;
            synchronized (abstractFolder) {
                name = (String)en.nextElement();
                if (!en.hasMoreElements()) {
                    return (Reference)fo.map.get(name);
                }
                continue;
            }
        }
        return null;
    }

    protected final AbstractFolder getChild(String name) {
        return this.getChild(name, true);
    }

    private final AbstractFolder getChild(String name, boolean onlyValid) {
        AbstractFolder fo;
        Reference r = (Reference)this.map.get(name);
        if (r == null) {
            if (Utilities.getOperatingSystem() == 16384) {
                r = Character.isLowerCase(name.charAt(0)) ? (Reference)this.map.get(name.toUpperCase()) : (Reference)this.map.get(name.toLowerCase());
                if (r == null) {
                    return null;
                }
            } else {
                return null;
            }
        }
        if ((fo = (AbstractFolder)r.get()) == null) {
            fo = this.createFile(name);
            if (fo != null && fo.isValid()) {
                this.map.put(name, fo != null ? this.createReference(fo) : null);
            } else if (onlyValid) {
                fo = null;
            }
        }
        return fo;
    }

    final String[] getChildrenArray() {
        return this.children;
    }

    protected Reference createReference(FileObject fo) {
        return new WeakReference<FileObject>(fo);
    }

    final synchronized AbstractFolder[] subfiles() {
        if (this.map == null) {
            return EMPTY_ARRAY;
        }
        Iterator it = this.map.values().iterator();
        ArrayList<AbstractFolder> ll = new ArrayList<AbstractFolder>(this.map.size() + 2);
        while (it.hasNext()) {
            AbstractFolder fo;
            Reference r = (Reference)it.next();
            if (r == null || (fo = (AbstractFolder)r.get()) == null) continue;
            ll.add(fo);
        }
        return ll.toArray(EMPTY_ARRAY);
    }

    final boolean isInitialized() {
        return this.map != null;
    }

    final Enumeration existingSubFiles(boolean rec) {
        if (!rec) {
            return Enumerations.array(this.subfiles());
        }
        class P
        implements Enumerations.Processor {
            P() {
            }

            public Object process(Object o, Collection toAdd) {
                AbstractFolder af = (AbstractFolder)o;
                toAdd.addAll(Arrays.asList(af.subfiles()));
                return o;
            }
        }
        return Enumerations.queue(Enumerations.singleton(this), new P());
    }

    abstract void setAttribute(String var1, Object var2, boolean var3) throws IOException;

    public final synchronized FileObject getFileObject(String name, String ext) {
        this.check();
        if (ext == null || ext.equals("")) {
            return this.getChild(name);
        }
        StringBuffer sb = new StringBuffer(name.length() + 1 + (ext == null ? 0 : ext.length()));
        sb.append(name).append('.').append(ext);
        return this.getChild(sb.toString());
    }

    public void refresh(boolean expected) {
        if (!this.isInitialized() && this.isFolder()) {
            return;
        }
        this.refresh(null, null, true, expected);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addFileChangeListener(FileChangeListener fcl) {
        AbstractFolder[] abstractFolderArray = EMPTY_ARRAY;
        synchronized (EMPTY_ARRAY) {
            if (this.listeners == null) {
                this.listeners = new ListenerList(FileChangeListener.class);
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            this.listeners.add(fcl);
            return;
        }
    }

    public final void removeFileChangeListener(FileChangeListener fcl) {
        if (this.listeners != null) {
            this.listeners.remove(fcl);
        }
    }

    protected final void fileDeleted0(FileEvent fileevent) {
        super.fireFileDeletedEvent(this.listeners(), fileevent);
        if (fileevent.getFile().equals(this) && this.parent != null) {
            FileEvent ev = new FileEvent((FileObject)this.parent, fileevent.getFile(), fileevent.isExpected());
            this.parent.fileDeleted0(ev);
        }
    }

    protected final void fileCreated0(FileEvent fileevent, boolean isData) {
        this.dispatchEvent(this.listeners(), fileevent);
        if (fileevent.getFile().equals(this) && this.parent != null) {
            FileEvent ev = new FileEvent((FileObject)this.parent, fileevent.getFile(), fileevent.isExpected());
            this.parent.fileCreated0(ev, isData);
        }
    }

    protected final void fileCreated0(FileObject src, FileObject file, boolean expected) {
        this.fileCreated0(new FileEvent(src, file, expected), false);
    }

    protected final void fileChanged0(FileEvent fileevent) {
        super.fireFileChangedEvent(this.listeners(), fileevent);
        if (fileevent.getFile().equals(this) && this.parent != null) {
            FileEvent ev = new FileEvent((FileObject)this.parent, fileevent.getFile(), fileevent.isExpected());
            this.parent.fileChanged0(ev);
        }
    }

    final void fileChanged1(FileEvent fileevent) {
        super.fireFileChangedEvent(this.listeners(), fileevent);
    }

    protected final void fileRenamed0(FileRenameEvent filerenameevent) {
        super.fireFileRenamedEvent(this.listeners(), filerenameevent);
        if (filerenameevent.getFile().equals(this) && this.parent != null) {
            FileRenameEvent ev = new FileRenameEvent(this.parent, filerenameevent.getFile(), filerenameevent.getName(), filerenameevent.getExt(), filerenameevent.isExpected());
            this.parent.fileRenamed0(ev);
        }
    }

    protected final void fileAttributeChanged0(FileAttributeEvent fileattributeevent) {
        super.fireFileAttributeChangedEvent(this.listeners(), fileattributeevent);
        if (fileattributeevent.getFile().equals(this) && this.parent != null) {
            FileAttributeEvent ev = new FileAttributeEvent(this.parent, fileattributeevent.getFile(), fileattributeevent.getName(), fileattributeevent.getOldValue(), fileattributeevent.getNewValue(), fileattributeevent.isExpected());
            this.parent.fileAttributeChanged0(ev);
        }
    }

    protected final boolean hasListeners() {
        boolean fsHas = this.getFileSystem().getFCLSupport().hasListeners();
        boolean repHas = false;
        Repository rep = this.getFileSystem().getRepository();
        if (rep != null) {
            repHas = rep.getFCLSupport().hasListeners();
        }
        return this.listeners != null && this.listeners.getAllListeners().length != 0 || repHas || fsHas;
    }

    protected final boolean hasAtLeastOneListeners() {
        return this.hasListeners() || this.parent != null && this.parent.hasListeners();
    }

    private final Enumeration listeners() {
        if (this.listeners == null) {
            return Enumerations.empty();
        }
        return Enumerations.removeNulls(Enumerations.array(this.listeners.getAllListeners()));
    }

    private final void check() {
        if (this.map == null) {
            this.refresh(null, null, false, false);
            if (this.map == null) {
                this.map = EMPTY;
                if (this.children == null) {
                    this.children = new String[0];
                }
            }
        }
    }

    protected final void refresh(String added, String removed) {
        this.refresh(added, removed, false);
    }

    protected final void refresh(String added, String removed, boolean reuseChildren) {
        if (reuseChildren && removed != null) {
            String[] nc = new String[this.children.length];
            System.arraycopy(this.children, 0, nc, 0, this.children.length);
            int i = nc.length;
            while (--i >= 0) {
                if (!removed.equals(nc[i])) continue;
                nc[i] = null;
                break;
            }
            this.refresh(added, removed, true, false, nc);
        } else {
            this.refresh(added, removed, true, false, null);
        }
    }

    protected abstract String[] list();

    protected abstract AbstractFolder createFile(String var1);

    protected void refresh(String added, String removed, boolean fire, boolean expected) {
        this.refresh(added, removed, fire, expected, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void registerChild(String name) {
        AbstractFolder abstractFolder = this;
        synchronized (abstractFolder) {
            WeakReference<Object> o;
            if (this.map == null) {
                this.check();
            }
            if ((o = this.map.put(name, new WeakReference<Object>(null))) != null) {
                this.map.put(name, o);
            } else {
                String[] newChildren = new String[this.children.length + 1];
                System.arraycopy(this.children, 0, newChildren, 0, this.children.length);
                newChildren[this.children.length] = name;
                this.children = newChildren;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void refreshFolder(String added, String removed, boolean fire, boolean expected, String[] list) {
        try {
            Map removedPairs;
            HashSet<String> addedNames;
            this.getFileSystem().beginAtomicAction();
            String[] newChildren = this.getNewChildren(list);
            AbstractFolder abstractFolder = this;
            synchronized (abstractFolder) {
                block22: {
                    if (this.children != null || newChildren != null) break block22;
                    return;
                }
                int initialCapacity = newChildren != null ? newChildren.length * 4 / 3 + 1 : 0;
                HashMap<String, WeakReference<Object>> newMap = new HashMap<String, WeakReference<Object>>(initialCapacity);
                addedNames = new HashSet<String>(initialCapacity);
                if (newChildren != null) {
                    Reference removedRef = this.map != null ? this.map.get(removed) : null;
                    for (int i = 0; i < newChildren.length; ++i) {
                        String child = newChildren[i];
                        Reference foRef = null;
                        if (this.map != null) {
                            foRef = (WeakReference<Object>)this.map.remove(child);
                            if (foRef != null && added != null && removed != null && child.equals(removed)) {
                                foRef = null;
                            }
                            if (added != null && removed != null && child.equals(added)) {
                                foRef = removedRef;
                            }
                            if (foRef != null && added == null && removed != null && child.equals(removed)) {
                                foRef = null;
                            }
                        }
                        if (foRef == null) {
                            if (!child.equals(added)) {
                                addedNames.add(child);
                            }
                            foRef = new WeakReference<Object>(null);
                        }
                        newMap.put(child, (WeakReference<Object>)foRef);
                    }
                }
                removedPairs = this.map != null ? this.dereferenceValues(this.map) : null;
                this.map = newMap;
                this.children = newChildren;
            }
            if (fire && addedNames != null && this.hasAtLeastOneListeners()) {
                this.filesCreated(addedNames, expected);
            }
            if (fire && removedPairs != null) {
                if (removed != null) {
                    removedPairs.remove(removed);
                }
                this.filesDeleted(removedPairs, expected);
            }
            if (fire && added == null && removed == null && !this.getFileSystem().isReadOnly() && !(this instanceof MultiFileObject)) {
                HashSet<String> nameFilter = new HashSet<String>();
                if (addedNames != null) {
                    nameFilter.addAll(addedNames);
                }
                if (removedPairs != null) {
                    nameFilter.addAll(removedPairs.keySet());
                }
                this.refreshChildren(this.existingSubFiles(false), nameFilter, expected);
            }
        }
        finally {
            this.getFileSystem().finishAtomicAction();
        }
    }

    private void refreshChildren(Enumeration subfiles, Collection nameFilter, boolean expected) {
        while (subfiles.hasMoreElements()) {
            AbstractFolder child = (AbstractFolder)subfiles.nextElement();
            if (!child.isData() || nameFilter.contains(child.getNameExt())) continue;
            child.refresh(expected);
        }
    }

    private void filesDeleted(Map removedToFire, boolean expected) {
        Iterator it = removedToFire.values().iterator();
        while (it.hasNext()) {
            AbstractFolder fo = (AbstractFolder)it.next();
            fo.validFlag = false;
            if (!this.hasAtLeastOneListeners() && !fo.hasAtLeastOneListeners()) continue;
            FileEvent ev = new FileEvent((FileObject)fo, (FileObject)fo, expected);
            fo.fileDeleted0(ev);
        }
    }

    private void filesCreated(Set addedToFire, boolean expected) {
        Iterator it = addedToFire.iterator();
        while (it.hasNext()) {
            AbstractFolder fo = this.getChild((String)it.next());
            if (fo == null) continue;
            this.fileCreated0(this, fo, expected);
        }
    }

    private Map dereferenceValues(Map map) {
        HashMap<String, AbstractFolder> retVal = new HashMap<String, AbstractFolder>(map.size());
        Iterator it = map.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            String name = (String)entry.getKey();
            AbstractFolder child = this.getChild(name, false);
            if (child == null) continue;
            retVal.put(name, child);
        }
        return retVal;
    }

    private String[] getNewChildren(String[] list) {
        String[] newChildren;
        String[] stringArray = newChildren = list != null ? list : this.list();
        if (this.isRoot() && newChildren == null) {
            newChildren = new String[]{};
        }
        if (newChildren != null) {
            newChildren = AbstractFolder.stripNulls(newChildren);
        }
        return newChildren;
    }

    private static String[] stripNulls(String[] children) {
        String[] newChildren = children;
        ArrayList<String> childrenList = new ArrayList<String>(Arrays.asList(newChildren));
        Iterator iterator = childrenList.iterator();
        while (iterator.hasNext()) {
            Object child = iterator.next();
            if (child != null) continue;
            iterator.remove();
        }
        if (childrenList.size() != newChildren.length) {
            newChildren = childrenList.toArray(new String[childrenList.size()]);
        }
        return newChildren;
    }

    protected void refresh(String added, String removed, boolean fire, boolean expected, String[] list) {
        if (this.isFolder()) {
            this.refreshFolder(added, removed, fire, expected, list);
        }
    }

    protected void outputStreamClosed(boolean fireFileChanged) {
        if (fireFileChanged) {
            this.fileChanged0(new FileEvent(this));
        }
    }

    public final Object writeReplace() {
        return new Replace(this);
    }

    public final void delete(FileLock lock) throws IOException {
        if (this.isFolder()) {
            FileObject[] fos = this.getChildren();
            for (int i = 0; i < fos.length; ++i) {
                FileObject fo = fos[i];
                FileLock foLock = fo.lock();
                try {
                    fo.delete(foLock);
                    continue;
                }
                catch (IOException iex) {
                    String message = NbBundle.getMessage(this.getClass(), "EXC_CannotDelete", this.getPath(), fo.getFileSystem().getDisplayName());
                    ExternalUtil.annotate((Throwable)iex, message);
                    throw iex;
                }
                finally {
                    foLock.releaseLock();
                }
            }
        }
        this.handleDelete(lock);
    }

    abstract void handleDelete(FileLock var1) throws IOException;

    public boolean canWrite() {
        return !this.isReadOnly();
    }

    private static final class Replace
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private transient FileObject f;
        private String fsname;
        private String path;
        private URL url;
        static final /* synthetic */ boolean $assertionsDisabled;

        public Replace(FileObject f) {
            this.f = f;
        }

        private void writeObject(ObjectOutputStream oos) throws IOException {
            this.fsname = this.f.getFileSystem().getSystemName();
            this.path = this.f.getPath();
            this.url = this.f.getURL();
            if (!$assertionsDisabled && this.url == null) {
                throw new AssertionError((Object)("No URL for " + this.path));
            }
            oos.defaultWriteObject();
        }

        private void readObject(ObjectInputStream ois) throws IOException, ClassNotFoundException {
            ois.defaultReadObject();
            if (!$assertionsDisabled && this.fsname == null) {
                throw new AssertionError((Object)"Should always have a non-null fsname here");
            }
            FileSystem fs = Repository.getDefault().findFileSystem(this.fsname);
            if (fs != null) {
                if (!$assertionsDisabled && this.path == null) {
                    throw new AssertionError((Object)"Should always have a non-null path here");
                }
                this.f = fs.findResource(this.path);
            }
            if (this.f == null) {
                if (!$assertionsDisabled && this.url == null) {
                    throw new AssertionError((Object)"Should always have a non-null URL here");
                }
                FileObject[] fos = URLMapper.findFileObjects(this.url);
                if (fos.length >= 1) {
                    this.f = fos[0];
                } else {
                    throw new FileNotFoundException("Could not restore: " + this.url);
                }
            }
        }

        public Object readResolve() {
            if (!$assertionsDisabled && this.f == null) {
                throw new AssertionError((Object)("Did not read " + this.url));
            }
            return this.f;
        }

        static {
            $assertionsDisabled = !(class$org$openide$filesystems$AbstractFolder == null ? (class$org$openide$filesystems$AbstractFolder = AbstractFolder.class$("org.openide.filesystems.AbstractFolder")) : class$org$openide$filesystems$AbstractFolder).desiredAssertionStatus();
        }
    }
}

