/*
 * Decompiled with CFR 0.152.
 */
package org.openide.awt;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.openide.util.Lookup;

public abstract class StatusDisplayer {
    private static StatusDisplayer INSTANCE = null;

    public static synchronized StatusDisplayer getDefault() {
        if (INSTANCE == null && (INSTANCE = (StatusDisplayer)Lookup.getDefault().lookup(StatusDisplayer.class)) == null) {
            INSTANCE = new Trivial();
        }
        return INSTANCE;
    }

    protected StatusDisplayer() {
    }

    public abstract String getStatusText();

    public abstract void setStatusText(String var1);

    public abstract void addChangeListener(ChangeListener var1);

    public abstract void removeChangeListener(ChangeListener var1);

    private static final class Trivial
    extends StatusDisplayer {
        private List listeners = null;
        private String text = "";

        private Trivial() {
        }

        public synchronized String getStatusText() {
            return this.text;
        }

        public synchronized void setStatusText(String text) {
            if (text.equals(this.text)) {
                return;
            }
            this.text = text;
            if (text.length() > 0) {
                System.err.println("(" + text + ")");
            }
            this.fireChange();
        }

        public synchronized void addChangeListener(ChangeListener l) {
            if (this.listeners == null) {
                this.listeners = new ArrayList();
            }
            this.listeners.add(l);
        }

        public synchronized void removeChangeListener(ChangeListener l) {
            if (this.listeners != null) {
                this.listeners.remove(l);
            }
        }

        protected final void fireChange() {
            if (this.listeners != null && !this.listeners.isEmpty()) {
                ChangeEvent ev = new ChangeEvent(this);
                Iterator it = this.listeners.iterator();
                while (it.hasNext()) {
                    ((ChangeListener)it.next()).stateChanged(ev);
                }
            }
        }
    }
}

