/*
 * Decompiled with CFR 0.152.
 */
package javax.wbem.client.adapter.http;

import java.io.IOException;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.util.Enumeration;
import javax.wbem.cim.CIMException;
import javax.wbem.client.CIMListener;
import javax.wbem.client.ClientProperties;
import javax.wbem.client.adapter.http.HttpEventRequestHandler;
import javax.wbem.client.adapter.http.transport.HttpServerEndpoint;
import javax.wbem.client.adapter.http.transport.ServerEndpointListener;

class HttpEventListener {
    private String servername;
    private String serverIP;
    private int port;
    private HttpServerEndpoint serverEndPoint;
    private ServerEndpointListener listener = null;
    private final String LOOPBACK_ADDRESS = "127.0.0.1";
    private static String localIP = null;
    CIMListener clientListener;

    HttpEventListener(CIMListener clientListener) throws Exception {
        this(clientListener, 0);
    }

    HttpEventListener(CIMListener clientListener, int port) throws Exception {
        try {
            this.servername = InetAddress.getLocalHost().getHostName();
        }
        catch (Exception ex) {
            this.servername = "??";
        }
        try {
            this.serverEndPoint = new HttpServerEndpoint(this.servername, port);
        }
        catch (Exception ex) {
            throw new CIMException("XMLERROR", "HttpServerEndpoint", ex);
        }
        this.serverIP = this.getLocalIPAddress();
        this.clientListener = clientListener;
        this.start();
    }

    private synchronized void start() throws Exception {
        try {
            HttpEventRequestHandler handler = new HttpEventRequestHandler(this.clientListener);
            this.listener = this.serverEndPoint.listen(handler);
            this.port = this.listener.getLocalPort();
        }
        catch (IOException e) {
            this.listener = null;
            throw e;
        }
    }

    void stop() {
        if (this.listener != null) {
            this.listener.close();
        }
    }

    String getHost() {
        return this.servername;
    }

    void setHost(String host) {
        this.servername = host;
    }

    String getHostIP() {
        return this.serverIP;
    }

    void setHostIP(String hostIP) {
        this.serverIP = hostIP;
    }

    int getPort() {
        return this.port;
    }

    void setPort(int port) {
        this.port = port;
    }

    private String getLocalIPAddress() {
        if (localIP != null) {
            return localIP;
        }
        try {
            if (System.getProperty("java.net.preferIPv4Stack") == null) {
                String preferIPv4 = ClientProperties.getProperty("java.net.preferIPv4Stack") == null ? "true" : ClientProperties.getProperty("java.net.preferIPv4Stack");
                System.setProperty("java.net.preferIPv4Stack", preferIPv4);
            }
            Enumeration<NetworkInterface> e = NetworkInterface.getNetworkInterfaces();
            while (e.hasMoreElements()) {
                NetworkInterface ni = e.nextElement();
                Enumeration<InetAddress> e1 = ni.getInetAddresses();
                while (e1.hasMoreElements()) {
                    InetAddress inetAddress = e1.nextElement();
                    String address = inetAddress.getHostAddress();
                    if (address == null || address.trim().length() == 0 || address.equalsIgnoreCase("127.0.0.1")) continue;
                    localIP = address;
                    return address;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        localIP = "127.0.0.1";
        return localIP;
    }
}

