/*
 * Decompiled with CFR 0.152.
 */
package javax.wbem.client.adapter.http;

import java.io.IOException;
import java.io.InputStream;
import java.util.Hashtable;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class DtdResolver
implements EntityResolver {
    Hashtable idHash = new Hashtable();

    public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
        InputSource in = null;
        DtdClReference ref = (DtdClReference)this.idHash.get(publicId);
        if (ref != null) {
            String filename = ref.getDtdFilename();
            ClassLoader cl = ref.getClassLoader();
            InputStream is = cl.getResourceAsStream(filename);
            if (is != null) {
                in = new InputSource(is);
            }
        }
        return in;
    }

    public void registerCatalogEntry(String publicID, String dtdName, ClassLoader loader) {
        DtdClReference ref = new DtdClReference();
        ref.setDtdFilename(dtdName);
        ref.setClassLoader(loader);
        this.idHash.put(publicID, ref);
    }

    private class DtdClReference {
        public String dtdFilename = null;
        public ClassLoader classLoader = null;

        private DtdClReference() {
        }

        public String getDtdFilename() {
            return this.dtdFilename;
        }

        public void setDtdFilename(String dtdFilename) {
            this.dtdFilename = dtdFilename;
        }

        public ClassLoader getClassLoader() {
            return this.classLoader;
        }

        public void setClassLoader(ClassLoader classLoader) {
            this.classLoader = classLoader;
        }
    }
}

