/*
 * Decompiled with CFR 0.152.
 */
package javax.wbem.client;

import java.security.Principal;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.wbem.cim.CIMArgument;
import javax.wbem.cim.CIMClass;
import javax.wbem.cim.CIMException;
import javax.wbem.cim.CIMInstance;
import javax.wbem.cim.CIMNameSpace;
import javax.wbem.cim.CIMObjectPath;
import javax.wbem.cim.CIMQualifierType;
import javax.wbem.cim.CIMValue;
import javax.wbem.client.BatchCIMClient;
import javax.wbem.client.BatchHandle;
import javax.wbem.client.BatchResult;
import javax.wbem.client.CIMClientAPI;
import javax.wbem.client.CIMClientFactory;
import javax.wbem.client.CIMEvent;
import javax.wbem.client.CIMListener;
import javax.wbem.client.CIMOMHandle;
import javax.wbem.client.CIMOperation;
import javax.wbem.client.CIMSecurityException;
import javax.wbem.client.Debug;
import javax.wbem.security.ClientSecurityContext;
import javax.wbem.security.ClientSecurityFactory;

public class CIMClient
implements CIMOMHandle {
    private String version;
    private CIMClientAPI api;
    private CIMNameSpace emptyNameSpace;
    private CIMNameSpace nameSpace;
    protected Hashtable subIdListenerMap;
    private ClientSecurityContext csc = null;
    private static String protocol;
    private boolean listenerset = false;
    public static final String WQL = "WQL";
    public static final String CIM_XML = "cim-xml";
    public static final String CIM_RMI = "cim-rmi";
    private ClientListener clientListener = new ClientListener();

    public CIMClient(CIMNameSpace name, Principal principal, Object credential) throws CIMException {
        this(name, principal, credential, CIM_XML);
    }

    public CIMClient(CIMNameSpace name, Principal principal, Object credential, String protocol) throws CIMException {
        this.initTrace();
        this.setProtocol(protocol);
        this.version = "1";
        if (name == null) {
            name = new CIMNameSpace();
        }
        if (principal == null) {
            throw new CIMSecurityException("NO_SUCH_PRINCIPAL");
        }
        String str = principal.getName();
        if (str == null || str.trim().length() == 0) {
            throw new CIMSecurityException("NO_SUCH_PRINCIPAL");
        }
        if (credential == null) {
            throw new CIMSecurityException("INVALID_CREDENTIAL");
        }
        name.setNameSpace("/" + name.getNameSpace());
        this.nameSpace = name;
        this.emptyNameSpace = new CIMNameSpace("", "");
        try {
            if (this.nameSpace.getScheme() != null) {
                String p = this.nameSpace.getScheme();
                if (p.equalsIgnoreCase("http") || p.equalsIgnoreCase("https")) {
                    p = CIM_XML;
                }
                if (p.equalsIgnoreCase("rmi")) {
                    p = CIM_RMI;
                }
                this.setProtocol(p);
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        int debug = 0;
        try {
            String dbg = System.getProperty("wbem.debug.xml", "0");
            if (!dbg.equals("0")) {
                debug = new Integer(dbg);
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        this.api = CIMClientFactory.getClientAPI(this.version, this.nameSpace, this.getProtocol(), debug, this.clientListener);
        this.setProtocol(this.api.getProtocol());
        this.csc = ClientSecurityFactory.createClientSecurity(this.nameSpace, principal, credential, null, this.getProtocol());
        this.api.initSecurityContext(this.version, this.csc);
    }

    public synchronized void createNameSpace(CIMNameSpace ns) throws CIMException {
        this.api.createNameSpace(this.version, this.checkNameSpace(ns), ns);
    }

    public synchronized void close() throws CIMException {
        this.api.close(this.version);
    }

    public synchronized void deleteNameSpace(CIMNameSpace ns) throws CIMException {
        this.api.deleteNameSpace(this.version, this.checkNameSpace(ns), ns);
    }

    public synchronized void deleteClass(CIMObjectPath path) throws CIMException {
        this.api.deleteClass(this.version, this.checkNameSpace(path), path);
    }

    public synchronized void deleteInstance(CIMObjectPath path) throws CIMException {
        this.api.deleteInstance(this.version, this.checkNameSpace(path), path);
    }

    public synchronized void deleteQualifierType(CIMObjectPath path) throws CIMException {
        this.api.deleteQualifierType(this.version, this.checkNameSpace(path), path);
    }

    public synchronized Enumeration enumNameSpace(CIMObjectPath path, boolean deep) throws CIMException {
        return this.api.enumNameSpace(this.version, this.checkNameSpace(path), path, deep).elements();
    }

    public Enumeration enumerateClasses(CIMObjectPath path) throws CIMException {
        return this.enumerateClasses(path, false, true, true, false);
    }

    public Enumeration enumerateClasses(CIMObjectPath path, boolean deep) throws CIMException {
        return this.enumerateClasses(path, deep, true, true, false);
    }

    public Enumeration enumerateClasses(CIMObjectPath path, boolean deep, boolean localOnly) throws CIMException {
        return this.enumerateClasses(path, deep, localOnly, true, false);
    }

    public Enumeration enumerateClasses(CIMObjectPath path, boolean deep, boolean localOnly, boolean includeQualifiers) throws CIMException {
        return this.enumerateClasses(path, deep, localOnly, includeQualifiers, false);
    }

    public synchronized Enumeration enumerateClasses(CIMObjectPath path, boolean deep, boolean localOnly, boolean includeQualifiers, boolean includeClassOrigin) throws CIMException {
        Vector v = this.api.enumerateClasses(this.version, this.checkNameSpace(path), path, deep, localOnly, includeQualifiers, includeClassOrigin);
        return v.elements();
    }

    public Enumeration enumerateClassNames(CIMObjectPath path) throws CIMException {
        return this.enumerateClassNames(path, false);
    }

    public synchronized Enumeration enumerateClassNames(CIMObjectPath path, boolean deep) throws CIMException {
        return this.api.enumerateClassNames(this.version, this.checkNameSpace(path), path, deep).elements();
    }

    public synchronized Enumeration enumerateInstanceNames(CIMObjectPath path) throws CIMException {
        return this.api.enumerateInstanceNames(this.version, this.checkNameSpace(path), path).elements();
    }

    public Enumeration enumerateInstances(CIMObjectPath path) throws CIMException {
        return this.enumerateInstances(path, true, true, false, false, null);
    }

    public Enumeration enumerateInstances(CIMObjectPath path, boolean deep) throws CIMException {
        return this.enumerateInstances(path, deep, true, false, false, null);
    }

    public Enumeration enumerateInstances(CIMObjectPath path, boolean deep, boolean localOnly) throws CIMException {
        return this.enumerateInstances(path, deep, localOnly, false, false, null);
    }

    public Enumeration enumerateInstances(CIMObjectPath path, boolean deep, boolean localOnly, boolean includeQualifiers) throws CIMException {
        return this.enumerateInstances(path, deep, localOnly, includeQualifiers, false, null);
    }

    public Enumeration enumerateInstances(CIMObjectPath path, boolean deep, boolean localOnly, boolean includeQualifiers, boolean includeClassOrigin) throws CIMException {
        return this.enumerateInstances(path, deep, localOnly, includeQualifiers, includeClassOrigin, null);
    }

    public synchronized Enumeration enumerateInstances(CIMObjectPath path, boolean deep, boolean localOnly, boolean includeQualifiers, boolean includeClassOrigin, String[] propertyList) throws CIMException {
        Vector v = this.api.enumerateInstances(this.version, this.checkNameSpace(path), path, deep, localOnly, includeQualifiers, includeClassOrigin, propertyList);
        return v.elements();
    }

    public synchronized Enumeration enumQualifierTypes(CIMObjectPath path) throws CIMException {
        Vector v = this.api.enumQualifierTypes(this.version, this.checkNameSpace(path), path);
        return v.elements();
    }

    public CIMClass getClass(CIMObjectPath name) throws CIMException {
        return this.getClass(name, true, true, false, null);
    }

    public CIMClass getClass(CIMObjectPath name, boolean localOnly) throws CIMException {
        return this.getClass(name, localOnly, true, false, null);
    }

    public CIMClass getClass(CIMObjectPath name, boolean localOnly, boolean includeQualifiers) throws CIMException {
        return this.getClass(name, localOnly, includeQualifiers, false, null);
    }

    public CIMClass getClass(CIMObjectPath name, boolean localOnly, boolean includeQualifiers, boolean includeClassOrigin) throws CIMException {
        return this.getClass(name, localOnly, includeQualifiers, includeClassOrigin, null);
    }

    public synchronized CIMClass getClass(CIMObjectPath name, boolean localOnly, boolean includeQualifiers, boolean includeClassOrigin, String[] propertyList) throws CIMException {
        return this.api.getClass(this.version, this.checkNameSpace(name), name, localOnly, includeQualifiers, includeClassOrigin, propertyList);
    }

    public CIMInstance getInstance(CIMObjectPath name) throws CIMException {
        return this.getInstance(name, true, false, false, null);
    }

    public CIMInstance getInstance(CIMObjectPath name, boolean localOnly) throws CIMException {
        return this.getInstance(name, localOnly, false, false, null);
    }

    public CIMInstance getInstance(CIMObjectPath name, boolean localOnly, boolean includeQualifiers) throws CIMException {
        return this.getInstance(name, localOnly, includeQualifiers, false, null);
    }

    public CIMInstance getInstance(CIMObjectPath name, boolean localOnly, boolean includeQualifiers, boolean includeClassOrigin) throws CIMException {
        return this.getInstance(name, localOnly, includeQualifiers, includeClassOrigin, null);
    }

    public synchronized CIMInstance getInstance(CIMObjectPath name, boolean localOnly, boolean includeQualifiers, boolean includeClassOrigin, String[] propertyList) throws CIMException {
        return this.api.getInstance(this.version, this.checkNameSpace(name), name, localOnly, includeQualifiers, includeClassOrigin, propertyList);
    }

    public CIMValue invokeMethod(CIMObjectPath name, String methodName, CIMArgument[] inArgs, CIMArgument[] outArgs) throws CIMException {
        return this.api.invokeMethod(this.version, this.checkNameSpace(name), name, methodName, inArgs, outArgs);
    }

    public synchronized CIMQualifierType getQualifierType(CIMObjectPath name) throws CIMException {
        return this.api.getQualifierType(this.version, this.checkNameSpace(name), name);
    }

    public synchronized void createQualifierType(CIMObjectPath name, CIMQualifierType qt) throws CIMException {
        this.api.createQualifierType(this.version, this.checkNameSpace(name), name, qt);
    }

    public synchronized void setQualifierType(CIMObjectPath name, CIMQualifierType qt) throws CIMException {
        this.api.setQualifierType(this.version, this.checkNameSpace(name), name, qt);
    }

    public synchronized void createClass(CIMObjectPath name, CIMClass cc) throws CIMException {
        this.api.createClass(this.version, this.checkNameSpace(name), name, cc);
    }

    public synchronized void setClass(CIMObjectPath name, CIMClass cc) throws CIMException {
        this.api.setClass(this.version, this.checkNameSpace(name), name, cc);
    }

    public synchronized CIMObjectPath createInstance(CIMObjectPath name, CIMInstance ci) throws CIMException {
        return this.api.createInstance(this.version, this.checkNameSpace(name), name, ci);
    }

    public synchronized void setInstance(CIMObjectPath name, CIMInstance ci) throws CIMException {
        this.api.setInstance(this.version, this.checkNameSpace(name), name, ci, true, null);
    }

    public void setInstance(CIMObjectPath name, CIMInstance ci, boolean includeQualifiers, String[] propertyList) throws CIMException {
        this.api.setInstance(this.version, this.checkNameSpace(name), name, ci, includeQualifiers, propertyList);
    }

    public synchronized CIMValue getProperty(CIMObjectPath name, String propertyName) throws CIMException {
        return this.api.getProperty(this.version, this.checkNameSpace(name), name, propertyName);
    }

    public synchronized void setProperty(CIMObjectPath name, String propertyName, CIMValue newValue) throws CIMException {
        this.api.setProperty(this.version, this.checkNameSpace(name), name, propertyName, newValue);
    }

    public synchronized void setProperty(CIMObjectPath name, String propertyName) throws CIMException {
        this.setProperty(name, propertyName, null);
    }

    public synchronized Enumeration execQuery(CIMObjectPath path, String query, String ql) throws CIMException {
        if (ql == null || ql.length() == 0) {
            ql = WQL;
        }
        Vector v = this.api.execQuery(this.version, this.checkNameSpace(path), path, query, ql);
        return v.elements();
    }

    public Enumeration associators(CIMObjectPath objectName) throws CIMException {
        return this.associators(objectName, null, null, null, null, true, true, null);
    }

    public Enumeration associators(CIMObjectPath objectName, String assocClass, String resultClass, String role, String resultRole, boolean includeQualifiers, boolean includeClassOrigin, String[] propertyList) throws CIMException {
        Vector v = this.api.associators(this.version, this.checkNameSpace(objectName), objectName, assocClass, resultClass, role, resultRole, includeQualifiers, includeClassOrigin, propertyList);
        return v.elements();
    }

    public Enumeration associatorNames(CIMObjectPath objectName) throws CIMException {
        return this.associatorNames(objectName, null, null, null, null);
    }

    public Enumeration associatorNames(CIMObjectPath objectName, String assocClass, String resultClass, String role, String resultRole) throws CIMException {
        return this.api.associatorNames(this.version, this.checkNameSpace(objectName), objectName, assocClass, resultClass, role, resultRole).elements();
    }

    public Enumeration references(CIMObjectPath objectName, String resultClass, String role, boolean includeQualifiers, boolean includeClassOrigin, String[] propertyList) throws CIMException {
        Vector v = this.api.references(this.version, this.checkNameSpace(objectName), objectName, resultClass, role, includeQualifiers, includeClassOrigin, propertyList);
        return v.elements();
    }

    public Enumeration references(CIMObjectPath objectName) throws CIMException {
        return this.references(objectName, null, null, true, true, null);
    }

    public Enumeration referenceNames(CIMObjectPath objectName, String resultClass, String role) throws CIMException {
        return this.api.referenceNames(this.version, this.checkNameSpace(objectName), objectName, resultClass, role).elements();
    }

    public Enumeration referenceNames(CIMObjectPath objectName) throws CIMException {
        return this.referenceNames(objectName, null, null);
    }

    public void addCIMListener(CIMListener l) throws CIMException {
        this.addCIMListener(l, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addCIMListener(CIMListener l, int p) throws CIMException {
        if (protocol != null && !this.listenerset) {
            CIMClient cIMClient = this;
            synchronized (cIMClient) {
                if (!this.listenerset) {
                    this.api.setListener(this.version, p);
                    this.listenerset = true;
                }
            }
        } else if (this.listenerset && p != 0) {
            throw new CIMException("CIM_ERR_FAILED");
        }
        this.clientListener.addCIMListener(l);
    }

    public void removeCIMListener(CIMListener l) throws CIMException {
        this.clientListener.removeCIMListener(l);
    }

    public CIMInstance getIndicationHandler(CIMListener cl) throws CIMException {
        return this.api.getIndicationHandler(cl);
    }

    public CIMInstance getIndicationListener(CIMListener cl) throws CIMException {
        return this.api.getIndicationListener(cl);
    }

    protected void finalize() {
    }

    private void initTrace() {
        String level = System.getProperty("wbem.debug.level");
        String device = System.getProperty("wbem.debug.device");
        if (device != null && device.equalsIgnoreCase("file")) {
            device = "wbem_client";
        }
        Debug.traceOpen(level, device);
        Debug.trace1("Starting CIMClient version 1.0.0 11/01/04:10:48");
    }

    private String getProtocol() {
        return protocol;
    }

    private void setProtocol(String protocol) {
        CIMClient.protocol = protocol;
    }

    public BatchResult performBatchOperations(BatchHandle bc) throws CIMException {
        CIMOperation[] oplist = null;
        try {
            oplist = ((BatchCIMClient)bc).getOperationList();
        }
        catch (Exception ex) {
            throw new CIMException("CIM_ERR_INVALID_PARAMETER", (Object)ex);
        }
        if (oplist != null && oplist.length > 0) {
            for (int i = 0; i < oplist.length; ++i) {
                oplist[i].setNameSpace(this.checkNameSpace(oplist[i].getTargetNS()));
            }
            Vector v = this.api.performOperations(this.version, oplist);
            if (v == null || oplist.length != v.size()) {
                throw new CIMException("CIM_ERR_FAILED");
            }
            Object[] arr = new Object[v.size()];
            for (int i = 0; i < v.size(); ++i) {
                oplist[i].setResult(v.elementAt(i));
                arr[i] = oplist[i].getResult();
            }
            BatchResult br = new BatchResult(arr);
            return br;
        }
        throw new CIMException("CIM_ERR_INVALID_PARAMETER");
    }

    protected CIMNameSpace getNameSpace() {
        return this.nameSpace;
    }

    private CIMNameSpace checkNameSpace(CIMObjectPath path) {
        if (path != null && path.getNameSpace() != null && path.getNameSpace().startsWith("/")) {
            return this.emptyNameSpace;
        }
        return this.nameSpace;
    }

    private CIMNameSpace checkNameSpace(CIMNameSpace inNs) {
        if (inNs != null && inNs.getNameSpace() != null && inNs.getNameSpace().startsWith("/")) {
            return this.emptyNameSpace;
        }
        return this.nameSpace;
    }

    private class ClientListener
    implements CIMListener {
        private List listenerList = new ArrayList();

        private ClientListener() {
        }

        public void addCIMListener(CIMListener l) {
            if (l == null) {
                return;
            }
            if (!this.listenerList.contains(l)) {
                this.listenerList.add(l);
            }
        }

        public void removeCIMListener(CIMListener l) {
            this.listenerList.remove(l);
        }

        public void indicationOccured(CIMEvent e) {
            new IndicationDeliverer(e).start();
        }

        private class IndicationDeliverer
        extends Thread {
            CIMEvent e;

            IndicationDeliverer(CIMEvent e) {
                this.e = e;
            }

            public void run() {
                ArrayList l = new ArrayList(ClientListener.this.listenerList);
                Iterator i = l.iterator();
                while (i.hasNext()) {
                    CIMListener listener = (CIMListener)i.next();
                    listener.indicationOccured(this.e);
                }
            }
        }
    }
}

