/*
 * Decompiled with CFR 0.152.
 */
package javax.wbem.cim;

import java.io.Serializable;
import java.util.Vector;
import javax.wbem.cim.CIMDataType;
import javax.wbem.cim.CIMObjectPath;
import javax.wbem.cim.MOFFormatter;

public class CIMValue
implements Serializable {
    static final long serialVersionUID = 200L;
    private CIMDataType dataType = null;
    private Vector valueVector = null;
    private Object value = null;
    private boolean isArrayVal = false;
    public static final CIMValue TRUE = new CIMValue(Boolean.valueOf("true"));
    public static final CIMValue FALSE = new CIMValue(Boolean.valueOf("false"));

    private void initialize(Object o) {
        if (o instanceof Vector) {
            Vector v = (Vector)o;
            if (v == null) {
                throw new NullPointerException();
            }
            this.isArrayVal = true;
            int type = CIMDataType.findType(v);
            if (type != 30) {
                this.initialize(v, new CIMDataType(type));
            } else {
                this.valueVector = (Vector)v.clone();
            }
        } else {
            int type = CIMDataType.findType(o);
            if (type != 30) {
                if (o instanceof CIMObjectPath) {
                    this.initialize(o, new CIMDataType(((CIMObjectPath)o).getObjectName()));
                } else {
                    this.initialize(o, new CIMDataType(type));
                }
            }
        }
    }

    private void initialize(Object o, CIMDataType dt) {
        int dtType;
        if (dt.isArrayType()) {
            throw new IllegalArgumentException();
        }
        if (o == null) {
            this.dataType = dt;
            return;
        }
        int type = CIMDataType.findType(o);
        if (type != (dtType = dt.getType())) {
            throw new IllegalArgumentException();
        }
        this.value = o;
        this.dataType = dt;
    }

    private void initialize(Vector v, CIMDataType dt) {
        if (!dt.isArrayType()) {
            throw new IllegalArgumentException();
        }
        if (v == null) {
            this.dataType = dt;
            return;
        }
        int dtType = dt.getType();
        this.valueVector = new Vector();
        for (int i = 0; i < v.size(); ++i) {
            Object o = v.elementAt(i);
            if (o != null) {
                int type = CIMDataType.findType(o);
                if ((type = CIMDataType.findArrayType(type)) != dtType) {
                    throw new IllegalArgumentException();
                }
            }
            this.valueVector.addElement(o);
        }
        this.dataType = dt;
    }

    public CIMValue(Object o, CIMDataType dt) {
        this.initialize(o, dt);
    }

    public CIMValue(Vector v, CIMDataType dt) {
        this.isArrayVal = true;
        this.initialize(v, dt);
    }

    public CIMValue(Object o) {
        this.initialize(o);
    }

    public boolean isArrayValue() {
        return this.isArrayVal;
    }

    public boolean isNull() {
        return this.dataType == null;
    }

    public boolean isNullValue() {
        return this.isNull();
    }

    public String toMOF() {
        MOFFormatter mf = new MOFFormatter();
        return mf.toString(this);
    }

    public String toString() {
        return this.toMOF();
    }

    public boolean contains(Object obj) {
        if (this.isArrayValue()) {
            return this.valueVector.contains(obj);
        }
        if (this.value == null && obj == null) {
            return true;
        }
        return obj.equals(this.value);
    }

    public boolean isEmpty() {
        return this.value == null && this.valueVector == null && this.dataType != null;
    }

    public int size() {
        if (this.isArrayValue()) {
            return this.valueVector.size();
        }
        return -1;
    }

    public Object getValue() {
        if (this.isEmpty()) {
            return null;
        }
        if (!this.isArrayValue()) {
            return this.value;
        }
        return this.valueVector.clone();
    }

    public CIMDataType getType() {
        return this.dataType;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CIMValue)) {
            return false;
        }
        CIMValue cv = (CIMValue)obj;
        if (this.dataType == null ? cv.dataType != null : !this.dataType.equals(cv.dataType)) {
            return false;
        }
        if (this.value != null) {
            return this.value.equals(cv.value);
        }
        if (this.valueVector != null) {
            if (cv.valueVector == null) {
                return false;
            }
            if (this.valueVector.size() != cv.valueVector.size()) {
                return false;
            }
            for (int i = 0; i < this.valueVector.size(); ++i) {
                Object o = this.valueVector.elementAt(i);
                if (o.equals(cv.valueVector.elementAt(i))) continue;
                return false;
            }
            return true;
        }
        return cv.valueVector == null;
    }
}

